  <?php
    $subtotal = WC()->cart->get_subtotal();
    $tip_percent = get_theme_option_repeater_values('tip_percent');
    ?>

  <div class="space-y-4">
      <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
          <?php echo __('LÄGG TILL DRICKS', 'tusenrosor'); ?>
      </h3>
      <div class="text-sm leading-[165%]">
          <label class="p-4 bg-white border border-[#EBEBEB] woocommerce-form__label woocommerce-form__label-for-checkbox checkbox 
		flex items-center space-x-3 cursor-pointer duration-400 hover:opacity-65" for="wctip-enable">
              <input type="checkbox" id="wctip-enable" name="wctip_enable" value="yes">
              <span>
                  <?php echo __('Visa ditt stöd genom att ge dricks till din florist som binder din bukett', 'tusenrosor'); ?>
              </span>
          </label>
          <div id="wctip-box" class="hidden p-4 text-sm leading-[165%] bg-(--theme-white) border border-[#EBEBEB] border-t-0 space-y-3">
              <!-- Percentage buttons -->
              <?php if (!empty($tip_percent)) { ?>
                  <div class="flex space-x-2">
                      <?php foreach ($tip_percent as $percentval) {
                            $percent = $percentval['percent'];
                            if ($percent) {
                                $percentConvert = (float)$percent / 100;
                                if ($percentConvert > 0) {
                        ?>
                                  <button type="button"
                                      data-percent="5"
                                      class="bg-white wctip-percent-btn flex-1 border border-gray-300 rounded-lg p-3 text-center text-sm text-gray-700 cursor-pointer" data-amount="<?php echo round((float)(WC()->cart->get_subtotal() * $percentConvert)); ?>">
                                      <?php echo $percent; ?>%
                                      <span class="block text-xs text-gray-500">(<?php echo wc_price(WC()->cart->get_subtotal() * $percentConvert); ?>)</span>
                                  </button>
                      <?php }
                            }
                        } ?>
                  </div>
              <?php } ?>
              <!-- Custom input -->
              <div class="flex items-center space-x-2">
                  <a href="javascript:void(0)"
                      type="button"
                      class="wctip-minus bg-white px-3 py-2 border border-gray-300 text-gray-700">
                      -
                  </a>

                  <input
                      id="wctip-amount"
                      name="wctip_amount"
                      type="number"
                      min="0"
                      class="focus:border-(--theme-color) w-full border border-[#3030301F] rounded-0 p-2 min-h-9 bg-transparent outline-none shadow-none [-moz-appearance:textfield] [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none"
                      value="0">

                  <a href="javascript:void(0)"
                      type="button"
                      class="wctip-plus bg-white px-3 py-2 border border-gray-300 text-gray-700">
                      +
                  </a>

                  <a href="javascript:void(0)"
                      disabled
                      type="button"
                      id="wctip-update"
                      class="uppercase min-h-12 px-3 p-1 min-w-32 text-white bg-(--theme-dark) flex items-center justify-center text-sm cursor-pointer hover:opacity-65 duration-400 disabled:opacity-30 disabled:cursor-default">
                      <?php echo __('UPPDATERA', 'tusenrosor'); ?>
                  </a>
              </div>
              <div>
                  <p>Tack, det uppskattas.</p>
              </div>
          </div>
      </div>
  </div>

  <div id="remember-me-section" class="mt-6">
      <h2 class="flex items-center space-x-3"> <?php echo __('Kom ihåg mig', 'tusenrosor'); ?></h2>
      <!-- Checkbox -->
      <div class="mt-4">
          <div class="bg-gray-50 border border-[#EBEBEB] rounded-lg block w-full">
              <label class="text-sm text-gray-600 p-4 block">
                  <input type="checkbox" id="remember-enable" class="h-4 w-4 text-black rounded border-gray-300 focus:ring-black">


                  <span class="text-sm text-gray-600">
                      <?php echo __('Spara min information för snabbare betalning med ett Shop-konto', 'tusenrosor'); ?>

                  </span>

              </label>

              <!-- Phone field (hidden until checked) -->
              <div id="remember-phone-wrapper" class="hidden border border-[#EBEBEB] p-4 text-sm leading-[165%] bg-(--theme-white)">
                  <label class="block">
                      <span class="text-sm text-gray-700"> <?php echo __('Mobilnummer', 'tusenrosor'); ?></span>
                      <input
                          type="text"
                          id="remember-phone"
                          name="remember_phone"
                          placeholder="+46"
                          class="mt-1 bg-white block w-full border border-gray-300 rounded-lg p-3 text-gray-800 focus:ring-black focus:border-black">
                  </label>

                  <!-- Error text (hidden by default) -->
                  <p id="remember-error" class="text-red-600 text-sm mt-1 hidden">
                      <?php echo __('Ange telefonnummer matchar inte förväntat mönster.', 'tusenrosor'); ?>

                  </p>
              </div>
          </div>
      </div>
  </div>

  <script>
      jQuery(function($) {

          // Save tip via custom AJAX
          function saveTip(value = 0) {
              let amount = value > 0 ? value : parseFloat($("#wctip-amount").val());
              if (amount > 0) {
                  $('.checkout_total').addClass('animate-pulse');
                  $.ajax({
                      type: "POST",
                      url: wc_checkout_params.ajax_url,
                      data: {
                          action: "save_tip_amount",
                          tip_enable: $("#wctip-enable").is(":checked") ? 1 : 0,
                          tip_amount: amount
                      },
                      success: function() {
                          $(document.body).trigger("wc_fragment_refresh");
                          $('.checkout_total').removeClass('animate-pulse');
                      }
                  });
              }

          }

          // 1️⃣ Checkbox ONLY opens/closes box — no saving here
          $(document).on("change", "#wctip-enable", function() {
              if ($(this).is(":checked")) {
                  $("#wctip-box").removeClass("hidden");
              } else {
                  $("#wctip-box").addClass("hidden");
              }
          });

          // 2️⃣ Percentage buttons — set amount + save
          $(document).on("click", ".wctip-percent-btn", function() {

              $(".wctip-percent-btn").removeClass("bg-black text-white border-black");
              $(this).addClass("bg-black text-white border-black");

              let btnamount = $(this).data("amount");


              saveTip(btnamount); // Apply immediately
          });

          // 3️⃣ Minus button — update amount only
          $(document).on("click", ".wctip-minus", function() {
              let v = parseInt($("#wctip-amount").val()) || 0;
              $("#wctip-amount").val(Math.max(0, v - 1));
          });

          // 3️⃣ Plus button — update amount only
          $(document).on("click", ".wctip-plus", function() {
              let v = parseInt($("#wctip-amount").val()) || 0;
              $("#wctip-amount").val(v + 1);
          });

          // 4️⃣ Uppdatera button — save custom amount
          $(document).on("click", "#wctip-update", function() {
              let amount = parseInt($("#wctip-amount").val()) || 0;
              saveTip(amount);
          });
          $(document).on("change", "#remember-enable", function() {
              if ($(this).is(":checked")) {
                  $("#remember-phone-wrapper").removeClass("hidden");
              } else {
                  $("#remember-phone-wrapper").addClass("hidden");
                  $("#remember-error").addClass("hidden");
              }
          });

          // Optional: live validation (but NO checkout errors)
          $(document).on("input", "#remember-phone", function() {
              let phone = $(this).val().trim();
              let isValid = /^(\+46)[0-9]{6,12}$/.test(phone);

              if (!isValid && phone.length > 0) {
                  $("#remember-error").removeClass("hidden");
                  $(this).addClass("border-red-500");
              } else {
                  $("#remember-error").addClass("hidden");
                  $(this).removeClass("border-red-500");
              }
          });
      });
  </script>