<?php do_action('woocommerce_before_checkout_form', $checkout); ?>
<div class="space-y-4">
    <div class="border border-[#EBEBEB] px-4 text-sm leading-[165%] divide-y divide-[#EBEBEB]">
        <div class="group py-3.5 flex items-center justify-between space-x-2">
            <div class="flex items-center space-x-1">
                <div class="min-w-[85px]"><?php esc_html_e('Kontakt:', 'tusenrosor'); ?></div>
                <div class="line-clamp-1 billing_email"><?php echo esc_html(WC()->customer->get_billing_email() ?: ''); ?></div>
            </div>
            <a class="underline hover:opacity-65 duration-400 goToStep1" href="#">
                <?php esc_html_e('Ändra', 'tusenrosor'); ?>
            </a>
        </div>
        <div class="group py-3.5 flex items-center justify-between space-x-2">
            <div class="flex items-center space-x-1">
                <div class="min-w-[85px]"><?php esc_html_e('Skicka till:', 'tusenrosor'); ?></div>
                <div class="line-clamp-1 billing_address">

                </div>
            </div>
            <a class="underline hover:opacity-65 duration-400 goToStep1" href="#">
                <?php esc_html_e('Ändra', 'tusenrosor'); ?>
            </a>
        </div>
    </div>
</div>
<form name="checkout" method="post" class="checkout woocommerce-checkout md:space-y-8 space-y-6" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data" aria-label="<?php echo esc_attr__('Checkout', 'woocommerce'); ?>">
    <div class="border border-[#EBEBEB] p-4 text-sm leading-[165%] bg-(--theme-white)">
        <?php if ($checkout->get_checkout_fields()) : ?>

            <?php do_action('woocommerce_checkout_before_customer_details');
            ?>

            <div class="col2-set space-y-5" id="customer_details">
                <div class="col-1">
                    <?php do_action('woocommerce_checkout_billing'); ?>
                </div>

                <div class="col-2 ff space-y-5">
                    <?php do_action('woocommerce_checkout_shipping'); ?>
                </div>
            </div>

            <?php do_action('woocommerce_checkout_after_customer_details'); ?>

        <?php endif; ?>

        <?php //do_action('woocommerce_checkout_before_order_review_heading'); 
        ?>
        <!-- 
    <h3 id="order_review_heading"><?php //esc_html_e('Your order', 'woocommerce');
                                    ?></h3> -->
    </div>
<?php    include(get_template_directory() . '/woocommerce/checkout/tip.php');
    ?> 

    <div id="order_review" class="space-y-4 woocommerce-checkout-review-order">
        <?php do_action('woocommerce_checkout_before_order_review'); ?>
        <div class="text-sm leading-[165%] space-y-4">

            <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
                <?php echo esc_html(__('Betalning', 'woocommerce')); ?>
            </h3>
            <?php do_action('woocommerce_checkout_order_review');
            ?>

        </div>
    </div>

    <?php do_action('woocommerce_checkout_after_order_review'); ?>

</form>

<?php do_action('woocommerce_after_checkout_form', $checkout); ?>
<style>
    .woocommerce-form-coupon-toggle {
        display: none;
    }
</style>
<style>
    .shop_table.woocommerce-checkout-review-order-table {
        display: none;
    }
</style>