<?php
// Get WooCommerce country
$country = WC()->customer->get_billing_country() ?: 'SE';

// Zones mapping
$zones = [
    'ZONE1' => ['DK', 'DE', 'NO', 'FI', 'NL', 'PL'],
    'ZONE2' => ['ES', 'GB'],
];

// Determine which key to use
if (in_array($country, $zones['ZONE1'], true)) {
    $country_key = 'ZONE1';
} elseif (in_array($country, $zones['ZONE2'], true)) {
    $country_key = 'ZONE2';
} else {
    $country_key = 'SE'; // default Sweden
}

// Load config (from our new function)
$all_methods = function_exists('tusenrosor_get_shipping_methods_config')
    ? tusenrosor_get_shipping_methods_config()
    : [];

$methods = $all_methods[$country_key] ?? [];

// === Calculate default delivery date ===
// For Sweden, default = +3 business days
$today = new DateTime();
$defaultDate = clone $today;
$businessDaysAdded = 0;
while ($businessDaysAdded < 3) {
    $defaultDate->modify('+1 day');
    if (!in_array($defaultDate->format('N'), [6, 7], true)) {
        $businessDaysAdded++;
    }
}
$default_date_str = $defaultDate->format('Y-m-d');
?>
<div class="space-y-4">
    <div class="border border-[#EBEBEB] px-4 text-sm leading-[165%] divide-y divide-[#EBEBEB]">
        <div class="group py-3.5 flex items-center justify-between space-x-2">
            <div class="flex items-center space-x-1">
                <div class="min-w-[85px]"><?php esc_html_e('Kontakt:', 'tusenrosor'); ?></div>
                <div class="line-clamp-1 billing_email"><?php echo esc_html(WC()->customer->get_billing_email() ?: ''); ?></div>
            </div>
            <a class="underline hover:opacity-65 duration-400 goToStep1" href="#">
                <?php esc_html_e('Ändra', 'tusenrosor'); ?>
            </a>
        </div>
        <div class="group py-3.5 flex items-center justify-between space-x-2">
            <div class="flex items-center space-x-1">
                <div class="min-w-[85px]"><?php esc_html_e('Skicka till:', 'tusenrosor'); ?></div>
                <div class="line-clamp-1 billing_address">

                </div>
            </div>
            <a class="underline hover:opacity-65 duration-400 goToStep1" href="#">
                <?php esc_html_e('Ändra', 'tusenrosor'); ?>
            </a>
        </div>
    </div>
</div>

<div class="space-y-4 tusenrosor-shipping-section" id="shippingSection" data-default-date="<?php echo esc_attr($default_date_str); ?>">

    <!-- 📅 Calendar -->
    <div class="space-y-4 calendar-section">
        <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
            <?php esc_html_e('Planera din leverans', 'tusenrosor'); ?>
        </h3>
        <div class="tusenrosor-datepicker calendar-block" data-disable-auto-init="true" data-date="<?php echo esc_attr($default_date_str); ?>"></div>
    </div>

    <!-- 🚚 Delivery Methods -->
    <div class="space-y-4 delivery-options-section">
        <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
            <?php esc_html_e('Din kontaktinformation', 'tusenrosor');
            ?>
        </h3>

        <div class="flex flex-col w-full ds">
            <?php

            if (empty($methods)) {
                echo '<p class="text-sm text-(--sub-text)">';
                esc_html_e('Inga leveransalternativ tillgängliga för ditt land just nu.', 'tusenrosor');
                echo '</p>';
            } else {
                $i = 1;

                foreach ($methods as $method) :
                    $method_name = esc_html($method['name'] ?? '');
                    $desc        = esc_html($method['desc'] ?? '');
                    $price       = floatval($method['price'] ?? 0);
                    $input_id    = 'delivery_method_' . $i;
                    $checked     = $i === 1 ? 'checked' : '';
            ?>
                    <label
                        class="delivery-item w-full border border-[#EBEBEB] px-4 py-3.5 flex justify-between cursor-pointer duration-400 has-[input:checked]:border-(--theme-color) has-[input:checked]:bg-(--theme-white) text-sm leading-[165%] space-x-3"
                        for="<?php echo esc_attr($input_id); ?>"
                        data-method="<?php echo esc_attr($method_name); ?>"
                        data-price="<?php echo esc_attr($price); ?>"
                        data-selecteddate="<?php echo esc_attr($default_date_str); ?>"
                        data-businessdays="3">
                        <div class="flex items-start space-x-3">
                            <input
                                class="mt-0.5 tusenRadio delivery-radio"
                                type="radio"
                                name="deliveryOptions"
                                id="<?php echo esc_attr($input_id); ?>"
                                <?php echo $checked; ?>>
                            <div class="flex flex-col">
                                <h5 class="method-name"><?php echo $method_name; ?></h5>
                                <div class="delivery-range text-(--sub-text)"><?php echo $desc; ?></div>
                            </div>
                        </div>
                        <div class="text-end">
                            <p class="delivery-price uppercase mb-[7px]">
                                <?php echo $price > 0 ? esc_html(number_format($price, 2)) . ' ' . get_woocommerce_currency_symbol() : esc_html__('GRATIS', 'tusenrosor'); ?>
                            </p>
                            <div class="flex items-center space-x-2 justify-end">
                                <div class="delivery-date text-(--sub-text) text-[10px]">
                                    <?php echo esc_html($default_date_str); ?>
                                </div>
                                <div for="telefon"
                                    class="h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer group relative">

                                    <div class="absolute left-1/2 -translate-x-1/2 z-10 invisible inline-block px-3 py-1.5 text-[10px] font-normal text-white transition-opacity duration-400 bg-[#121212] rounded-sm opacity-0 tooltip leading-[160%] max-w-[148px] min-w-[148px] w-full text-center group-hover:visible group-hover:opacity-100 bottom-7">
                                        <?php echo esc_html(__('Om vi behöver kontakta dig angående din beställning', 'tusenrosor')); ?>
                                        <div class="tooltip-arrow -bottom-1.5 absolute left-1/2 -translate-x-1/2">
                                            <svg width="12" height="6" viewBox="0 0 12 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M6 0H12L7.41421 4.58579C6.63317 5.36683 5.36684 5.36684 4.58579 4.58579L0 0H6Z" fill="#121212" />
                                            </svg>
                                        </div>
                                    </div>

                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <mask id="mask0_6077_37090" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20">
                                            <path d="M0 0H20V20H0V0Z" fill="white" />
                                            <path d="M19.25 0.75V19.25H0.75V0.75H19.25Z" stroke="white" stroke-width="1.5" />
                                        </mask>
                                        <g mask="url(#mask0_6077_37090)">
                                            <path d="M10.0017 17.8572C14.3411 17.8572 17.8588 14.3394 17.8588 10C17.8588 5.66065 14.3411 2.14288 10.0017 2.14288C5.66229 2.14288 2.14453 5.66065 2.14453 10C2.14453 14.3394 5.66229 17.8572 10.0017 17.8572Z" stroke="#787878" stroke-width="1.5" />
                                            <path d="M9.98828 14.6286H10.0169V14.6572H9.98828V14.6286Z" stroke="#787878" stroke-width="1.5" stroke-linejoin="round" />
                                            <path d="M7.85938 7.50003C7.8595 7.13693 7.95189 6.77982 8.12787 6.46222C8.30384 6.14461 8.55764 5.87694 8.86543 5.68431C9.17322 5.49169 9.52491 5.38043 9.88748 5.36099C10.2501 5.34154 10.6116 5.41455 10.9383 5.57315C11.2649 5.73176 11.5458 5.97076 11.7548 6.26772C11.9637 6.56468 12.0938 6.90986 12.1327 7.27086C12.1717 7.63186 12.1183 7.99684 11.9775 8.33154C11.8367 8.66624 11.6132 8.95967 11.3279 9.18431C10.7079 9.67145 10.0022 10.2829 10.0022 11.0715" stroke="#787878" stroke-width="1.5" stroke-linecap="round" />
                                        </g>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </label>
            <?php
                    $i++;
                endforeach;
            }
            ?>
        </div>
    </div>

    <!-- Continue Button -->
    <button class="goToStep3 w-full min-h-12 px-4 p-1 text-sm text-[#FFFFFF] bg-(--theme-dark) border border-(--theme-dark) duration-400 hover:opacity-65 cursor-pointer uppercase font-medium tracking-[18%]">
        <?php esc_html_e('Fortsätt till betalning', 'tusenrosor'); ?>
    </button>

    <div class="text-center">
        <a href="#" class="goToStep1 flex items-center justify-center space-x-2 text-xs leading-[165%] hover:opacity-65 duration-400">
            <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.60709 8.57145L3.28852 5.25287C3.25526 5.2197 3.22887 5.18029 3.21087 5.1369C3.19286 5.09351 3.18359 5.04699 3.18359 5.00002C3.18359 4.95304 3.19286 4.90653 3.21087 4.86314C3.22887 4.81975 3.25526 4.78034 3.28852 4.74716L6.60709 1.42859" stroke="#303030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
            <span><?php esc_html_e('Tillbaka till information', 'tusenrosor'); ?></span>
        </a>
    </div>
</div>