<?php
$current_user = wp_get_current_user();
?>
<div class="space-y-3.5">
    <div class="uppercase text-xs leading-[165%] text-center">
        <?php echo esc_html(__('Snabbkassa', 'tusenrosor')); ?>
    </div>
    <div class="flex space-x-3">
        <a
            href="#"
            class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-black">
            <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-1.svg" alt="Express Checkout">
        </a>
        <a
            href="#"
            class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-[#FFC439]">
            <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-2.svg" alt="Express Checkout">
        </a>
        <a
            href="#"
            class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-(--theme-dark)">
            <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-3.svg" alt="Express Checkout">
        </a>
    </div>
</div>
<div class="flex items-center justify-center w-full">
    <div class="grow border-t border-[#EBEBEB]"></div>
    <div class="px-4 uppercase text-xs leading-[165%] text-center text-(--sub-text)">
        <?php echo esc_html(__('ELLER', 'tusenrosor')); ?>
    </div>
    <div class="grow border-t border-[#EBEBEB]"></div>
</div>
<div class="md:space-y-8 space-y-6">
    <div class="space-y-4">
        <div class="space-x-3 flex items-center justify-between">
            <div class="space-y-1.5">
                <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
                    <?php echo esc_html(__('Kontakt', 'tusenrosor')); ?>
                </h3>
                <div class="max-w-[360px] md:text-sm text-[10px] leading-[165%] text-(--sub-text)">
                    <?php echo esc_html(__('Vi kommer att använda denna e-postadress för att skicka information och uppdateringar om din beställning.', 'woocommerce')) ?>
                </div>
            </div>
            <?php if (! is_user_logged_in()) : ?>
                <a class="underline text-sm leading-[165%] text-nowrap duration-400 hover:opacity-65" href="<?php echo esc_url(wc_get_page_permalink('myaccount') . '?redirect_to=' . urlencode(wc_get_checkout_url())); ?>">
                    <?php echo esc_html(__('Logga in', 'tusenrosor')); ?>
                </a>
            <?php endif; ?>
        </div>
        <div class="relative">
            <label
                class="leading-[165%] cursor-pointer text-(--sub-text) text-[10px] absolute left-4 top-1.5"
                for="checkout-e-post">
                <?php echo esc_html(__('E-post', 'tusenrosor')); ?>
            </label>
            <input
                id="checkout-e-post"
                name=""
                value="<?php echo $current_user->user_email; ?>"
                placeholder="johnsmith@gmail.com"
                type="text"
                class="w-full border border-[#EBEBEB] min-h-12 px-4 pb-1 pt-4.5 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--theme-color) text-(--theme-color)">
        </div>
        <label class="flex items-center space-x-3 cursor-pointer">
            <input class="tusenCheckbox" type="checkbox" name="" id="">
            <span class="text-sm leading-[165%] font-normal duration-400 hover:opacity-65">
                <?php echo esc_html(__('Skicka mig nyheter och erbjudanden', 'tusenrosor')); ?>
            </span>
        </label>
    </div>
    <div class="space-y-4">
        <div class="space-y-1.5">
            <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
                <?php echo esc_html(__('Kontakt', 'tusenrosor')); ?>
            </h3>
            <div class="md:text-sm text-[10px] leading-[165%] text-(--sub-text)">
                <?php echo esc_html(__('Ange adressen dit du vill att din beställning ska levereras.', 'tusenrosor')); ?>

            </div>
        </div>
        <div class="space-y-4 billingform wc-no-js">

            <?php do_action('woocommerce_checkout_billing'); ?>
        </div>
    </div>
    <button
        class="goToStep2 w-full min-h-12 px-4 p-1 text-sm text-[#FFFFFF] bg-(--theme-dark) border border-(--theme-dark) duration-400 hover:opacity-65 cursor-pointer uppercase font-medium tracking-[18%]">
        <?php echo esc_html(__('Fortsätt till leverans', 'tusenrosor')); ?>
    </button>
</div>