<?php
// Ensure WooCommerce cart is loaded
if (function_exists('WC') && WC()->cart) :
    $cart           = WC()->cart;
    $cart_count     = $cart->get_cart_contents_count();
    $cart_subtotal  = $cart->get_cart_subtotal(); // formatted
    $cart_total     = WC()->cart->get_total(); // formatted
    $discount_total = $cart->get_discount_total(); // raw number
    $has_discount   = $discount_total > 0;

    // ✅ Get dynamic shipping info from cookie/session
    $cookie_name = 'tusenrosor_shipping_info';
    $shipping_label = esc_html__('Frakt', 'tusenrosor');
    $shipping_price = 0;
    $shipping_html  = esc_html__('GRATIS', 'tusenrosor');

    if (!empty($_COOKIE[$cookie_name])) {
        $info = json_decode(stripslashes($_COOKIE[$cookie_name]), true);
        if (!empty($info)) {
            //  print_r($info);
            $method = sanitize_text_field($info['method'] ?? '');
            $date   = sanitize_text_field($info['selectedDate'] ?? '');
            $price  = floatval($info['price'] ?? 0);

            if ($method || $date) {
                $timestamp = strtotime($date);
                $shipping_label = sprintf('%s (%s)', esc_html($method), esc_html(date('Y-m-d', $timestamp)));
                //echo   $shipping_label = sprintf('%s (%s)', esc_html($method), esc_html(date('Y-m-d', $date)));
            }

            if ($price > 0) {
                $shipping_price = $price;
                $shipping_html  = wc_price($price);
            } else {
                $shipping_price = 0;
                $shipping_html  = $shipping_html;
            }
        }
    }
    $session_data = WC()->session->get('tusenrosor_shipping_info');
    if (!empty($session_data) && isset(WC()->session)) {

        //print_r($session_data);
        if (!empty($session_data)) {
            $method = sanitize_text_field($session_data['method'] ?? '');
            $date   = sanitize_text_field($session_data['selectedDate'] ?? '');
            $price  = floatval($session_data['price'] ?? 0);

            if ($method || $date) {
                $shipping_label = sprintf('%s (%s)', esc_html($method), esc_html($date));
            }

            if ($price > 0) {
                $shipping_price = $price;
                $shipping_html  = wc_price($price);
            } else {
                $shipping_price = 0;
                $shipping_html  = $shipping_html;
            }
        }
    }
    $tipamount = WC()->session->get("tip_amount");
?>
    <div class="drawer-footer space-y-5 font-normal leading-[165%] text-(--theme-color)" id="checkoutTotalsSection">
        <div class="flex items-stretch space-x-2 w-full">
            <input
                name="coupon_code"
                id=""
                type="text"
                placeholder="Rabattkod eller presentkort"
                class="w-full border border-[#EBEBEB] min-h-12 px-4 py-1 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white">
            <button
                disabled
                class="uppercase couponBtn min-h-12 px-3 p-1 min-w-32 text-white bg-(--theme-dark) flex items-center justify-center text-sm cursor-pointer hover:opacity-65 duration-400 disabled:opacity-30 disabled:cursor-default">
                <?php echo esc_html(__('Använd', 'tusenrosor')); ?>
            </button>
        </div>
        <div class="Woomessage"></div>

        <div role="status" class="checkout_total space-y-3 text-sm 
        [&.animate-pulse_>div]:bg-gray-200
        [&.animate-pulse_>div]:dark:bg-gray-300
        [&.animate-pulse_>div]:w-full
        [&.animate-pulse_>div]:text-transparent
        ">
            <div class="flex justify-between items-center space-x-1">
                <p>
                    <?php
                    /* translators: %d = number of items */
                    printf(esc_html__('Delsumma · %d artiklar', 'tusenrosor'), $cart_count);
                    ?>
                </p>
                <span><?php echo wp_kses_post($cart_subtotal); ?></span>
            </div>
            <?php if ($has_discount) : ?>
                <div class="flex justify-between items-center space-x-1">
                    <p>
                        <?php esc_html_e('Rabatt', 'tusenrosor'); ?>
                    </p>
                    <div class="flex items-center space-x-2">
                        <span>-<?php echo wc_price($discount_total); ?></span>
                        <button
                            type="button"
                            class="remove-coupon text-[10px] text-(--sub-text) underline hover:text-(--theme-maroon) duration-300"
                            data-nonce="<?php echo esc_attr(wp_create_nonce('remove_coupon')); ?>"
                            data-coupon="<?php echo esc_attr(WC()->cart->get_applied_coupons()[0] ?? ''); ?>">
                            <?php esc_html_e('Ta bort', 'tusenrosor'); ?>
                        </button>
                    </div>
                </div>
            <?php endif; ?>
            <div class="flex justify-between items-center space-x-1 shipping_method">
                <p>
                    <?php echo esc_html($shipping_label); ?>
                </p>
                <span><?php echo wp_kses_post($shipping_html); ?></span>
            </div>
            <?php if ($tipamount) { ?>
                <div class="flex justify-between items-center space-x-1 shipping_method">
                    <p>
                        <?php echo esc_html(__('Tip', 'woocommerece')); ?>
                    </p>
                    <span><?php echo wc_price($tipamount); ?></span>
                </div>
            <?php } ?>
        </div>
        <div role="status" class="checkout_total 
        [&.animate-pulse_>div]:bg-gray-200
        [&.animate-pulse_>div]:dark:bg-gray-300
        [&.animate-pulse_>div]:w-full
        [&.animate-pulse_>div]:text-transparent
        ">
            <div class="flex justify-between items-center space-x-1 text-lg">
                <div>
                    <?php echo esc_html(__('Totalt', 'tusenrosor')); ?>
                </div>
                <div class="space-x-2 flex items-center">
                    <div>
                        <?php echo wp_kses_post($cart_total); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>




<?php endif; ?>