<div 
class="w-full [&>.cartItem:first-child]:pt-0 <?php echo WC()->cart->is_empty() ? 'h-full' : ''; ?>" 
id="<?php if (!isset($checkoutpage)) echo esc_attr($wrapper_id ?? 'cartItems'); ?>">
    <?php if (WC()->cart->is_empty()) : ?>
        <div class="flex items-center justify-center h-full">
            <p class="text-center text-(--sub-text)">
                <?php echo esc_html(__('Din varukorg är tom.', 'woocommerce')) ?>
            </p>
        </div>
    <?php else : ?>
        <?php
        // Build a lookup of gift items by their linked parent product
        $gift_map = [];
        foreach (WC()->cart->get_cart() as $gift_key => $gift_item) {
            if (!empty($gift_item['is_gift']) && !empty($gift_item['linked_to'])) {
                $gift_map[intval($gift_item['linked_to'])] = [
                    'key'  => $gift_key,
                    'data' => $gift_item,
                ];
            }
        }

        // Loop through main products only
        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item):
            if (!empty($cart_item['is_gift'])) continue; // skip gift lines

            $_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
            if (!$_product || !$_product->exists()) continue;
            $comment = isset($cart_item['comment']) ? $cart_item['comment'] : '';
            $product_id   = $_product->get_id();
            $product_name = $_product->get_name();
            $product_link = $_product->is_visible() ? $_product->get_permalink() : '';
            $thumbnail    = $_product->get_image('woocommerce_thumbnail');
            $thumbnail_id = $_product->get_image_id();
            $thumbnail_url = wp_get_attachment_url($thumbnail_id);
            $quantity     = $cart_item['quantity'];
            $price        = wc_price($_product->get_price());
            $color = '';
            $box   = '';

            // Get variation attributes from cart item or product
            if (!empty($cart_item['variation']) && is_array($cart_item['variation'])) {
                $color = $cart_item['variation']['attribute_pa_color'] ?? '';
                $box   = $cart_item['variation']['attribute_pa_box'] ?? '';
            } else {
                $color = $_product->get_attribute('pa_color');
                $box   = $_product->get_attribute('pa_box');
            }

            // Convert slugs to readable names
            $color_term = $color ? get_term_by('slug', $color, 'pa_color') : false;
            $box_term   = $box ? get_term_by('slug', $box, 'pa_box') : false;

            $color_name = $color_term ? $color_term->name : '';
            $box_name   = $box_term ? $box_term->name : '';
        ?>
            <div class="cartItem flex space-x-4 md:space-x-6 w-full py-6 border-b border-[#EBEBEB]" data-key="<?php echo esc_attr($cart_item_key); ?>">
                <!-- Product Image -->
                <div>
                    <div class="relative">
                        <div class="px-1 absolute z-10 -top-2.5 -right-2.5 w-auto min-w-5 h-5 bg-(--theme-color) rounded-full flex justify-center items-center text-[10px] font-normal leading-[165%] text-(--theme-white)">
                            <?php echo esc_html($quantity); ?>
                        </div>
                        <a href="<?php echo esc_url($product_link); ?>" class="w-[74px] h-[74px] min-w-[74px] md:w-[122px] md:min-w-[122px] md:h-[122px] border border-[#EBEBEB] inline-block duration-400 hover:opacity-65 in-[.sideDrawer]:border-0">
                            <img
                                class="w-full h-full object-cover object-center bg-(--theme-white)"
                                src="<?php echo esc_url($thumbnail_url); ?>"
                                alt="Cart Product Image" />
                        </a>
                    </div>
                </div>

                <!-- Product Info -->
                <div class="w-full font-normal leading-[165%] space-y-3">
                    <div class="text-sm space-y-2">
                        <div class="space-y-1">
                            <a href="<?php echo esc_url($product_link); ?>" class="inline-block duration-400 hover:opacity-65 w-full">
                                <h2><?php echo esc_html($product_name); ?></h2>
                            </a>
                            <div class="text-(--sub-text) flex space-x-3">
                                <div><?php echo wp_kses_post($price); ?></div>
                            </div>
                        </div>
                        <div class="text-[10px] text-(--sub-text) uppercase">
                            <?php echo $color_name; ?><?php if ($box_name) echo ' / ' . $box_name; ?>
                        </div>
                    </div>
                    <?php if (!isset($checkoutpage)) { ?>
                        <div class="flex items-center space-x-4">
                            <div class="flex items-stretch text-(--theme-color) border border-[#F4F4F4] w-[104px] min-w-[104px] text-center">
                                <button class="qty-dec flex items-center justify-center border-0 outline-0 bg-transparent p-1 min-w-8 duration-400 cursor-pointer hover:opacity-65 text-(--theme-dark)">
                                    <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0 5H10" stroke="currentColor" />
                                    </svg>
                                </button>
                                <input type="number" value="<?php echo esc_attr($quantity); ?>" min="1" class="qty-input hidden-input-arrow text-[13px] w-full outline-none border-none bg-transparent h-full min-h-9 text-center px-0.5" />
                                <button class="qty-inc flex items-center justify-center border-0 outline-0 bg-transparent p-1 min-w-8 duration-400 cursor-pointer hover:opacity-65 text-(--theme-dark)">
                                    <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5 0V10M0 5H10" stroke="currentColor" />
                                    </svg>
                                </button>
                            </div>
                            <a href="<?php echo esc_url(wc_get_cart_remove_url($cart_item_key)); ?>" class="remove-main remove-main-cart-product text-xs text-(--theme-color) underline duration-400 hover:opacity-65 inline-block" data-cart_item_key="<?php echo esc_attr($cart_item_key); ?>">
                                <?php echo esc_html(__('Ta bort', 'tusenrosor')); ?>
                            </a>
                        </div>
                    <?php } ?>

                    <?php
                    // 🎁 Display linked gift product (if exists)
                    if (isset($gift_map[$product_id])):
                        $gift_item = $gift_map[$product_id]['data'];
                        $_gift = $gift_item['data'];
                    ?>
                        <div class="space-y-3">
                            <div class="relative w-full">
                                <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                                    <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect width="12" height="12" rx="6" fill="currentColor" />
                                        <path d="M6 3V9M3 6H9" stroke="white" />
                                    </svg>
                                </a>
                                <div class="flex items-stretch leading-0 w-full">
                                    <img class="w-11.5 min-w-11.5 min-h-11.5 object-cover object-center" src="<?php echo esc_url($_gift->get_image_id() ? wp_get_attachment_image_url($_gift->get_image_id(), 'woocommerce_thumbnail') : get_template_directory_uri() . '/assets/images/products-img/blog9.webp'); ?>" alt="<?php echo esc_attr($_gift->get_name()); ?>">
                                    <div class="w-full flex items-center justify-between space-x-3 ps-3 py-[5px] bg-(--theme-white)">
                                        <div class="w-full leading-[165%] flex flex-col">
                                            <p class="text-xs text-(--theme-color) line-clamp-1"><?php echo esc_html($_gift->get_name()); ?></p>
                                            <div class="text-[10px] text-(--sub-text) leading-[165%]"> <?php echo wc_price(0) ?> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if ($comment) { ?>
                                <div class="relative w-full cursor-pointer CartMeddelandeOpenBtn" data-cartkey="<?php echo $cart_item_key;?>">
                                    <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect width="12" height="12" rx="6" fill="currentColor"></rect>
                                            <path d="M6 3V9M3 6H9" stroke="white"></path>
                                        </svg>
                                    </a>

                                    <div class="leading-[165%] w-full text-xs text-(--theme-color) [&amp;_strong]:font-bold [&amp;_strong]:text-(--sub-text)">
                                        <strong> <?php echo esc_html(__('Meddelande', 'woocommerce')) ?>:</strong> <span class="com_<?php echo $cart_item_key;?>"><?php echo $comment; ?></span>
                                        <!-- <a href="#" class="text-xs text-(--theme-color) underline duration-400 hover:opacity-65 inline-block">
                                             <?php echo esc_html(__('Ändra', 'woocommerce')) ?> </a> -->
                                    </div>

                                </div>
                            <?php } ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>