<?php
add_action('wp_enqueue_scripts', function () {
    // Make sure WooCommerce is active first
    if (class_exists('WooCommerce')) {
        // Dequeue WooCommerce Blocks CSS
        wp_dequeue_style('wc-blocks-style');
        wp_deregister_style('wc-blocks-style');
    }
}, 100);



function tusenrosor_encoderit_scripts()
{
     wp_dequeue_style( 'wp-block-library' );
    wp_deregister_style( 'wp-block-library' );

    // (Optional) Also remove theme styles and global styles
    wp_dequeue_style( 'wp-block-library-theme' );
    wp_deregister_style( 'wp-block-library-theme' );

    wp_dequeue_style( 'global-styles' ); // wp_global_styles
    wp_deregister_style( 'global-styles' );
    // style
    wp_enqueue_style('tusenrosor-encoderit-style', get_stylesheet_uri(), array(), _S_VERSION);
    wp_style_add_data('tusenrosor-encoderit-style', 'rtl', 'replace');
    wp_enqueue_style("tusenrosor-style", get_template_directory_uri() . "/assets/styles/tusenrosor-tailwind.css", false, false);
     wp_enqueue_style("custom-style", get_template_directory_uri() . "/assets/styles/tusenrosor-custom.css", false, false);
    //wp_enqueue_style("web-custom-style", get_template_directory_uri() . "/assets/styles/custom.css", false, false);
    // style

    wp_enqueue_script('tusenrosor-encoderit-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
    wp_enqueue_script('custom_js', get_template_directory_uri() . '/assets/js/custom-script.js', array('jquery'), '', true);

    wp_enqueue_script('flowbite', get_template_directory_uri() . '/node_modules/flowbite/dist/flowbite.js', array(), '1.7.0', true);
    wp_enqueue_script('tusenrosor-contact-us-js', get_template_directory_uri() . '/assets/js/contact-us.js', array('jquery'), _S_VERSION, true);

    // Localize (make texts translatable for JS)

    wp_localize_script(

        'tusenrosor-contact-us-js',

        'contactUSParam',

        array(

            'ajax_url' => admin_url('admin-ajax.php'),
            'sending' => __('Skickar...', 'tusenrosor'),
            'robotAlert' => __('Vänligen bekräfta att du inte är en robot.', 'tusenrosor'),
            'server_error' => __('Serverfel. Försök igen.', 'tusenrosor'),
            'send_button' => __('Skicka', 'tusenrosor')
        )

    );
    //main js functionality
    wp_enqueue_script('tusenrosor-main-js', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), _S_VERSION, true);

    wp_localize_script(

        'tusenrosor-main-js',

        'param',

        array(

            'ajax_url' => admin_url('admin-ajax.php'),
            'site_url' => site_url(),
            'nonce' => wp_create_nonce('ajax-nonce'),
            'shop_url' => wc_get_page_permalink('shop'),
            'not_found_product_text' => esc_html(__('Inga produkter hittades.', 'tusenrosor'))
        )

    );

    //shop filter
    if (is_shop() || is_product_taxonomy()) {
        wp_enqueue_script(
            'tusenrosor-shop-filters',
            get_template_directory_uri() . '/assets/js/shop-filters.js',
            ['jquery'],
            '1.0',
            true
        );

        wp_localize_script('tusenrosor-shop-filters', 'ShopAjax', [
            'ajaxurl' => admin_url('admin-ajax.php'),
        ]);
    }
    if (is_product()) {
        wp_enqueue_script('reviews-ajax', get_template_directory_uri() . '/assets/js/reviews-ajax.js', ['jquery'], '1.0', true);
        wp_localize_script('reviews-ajax', 'reviewsAjax', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'view_more_text' => esc_html(__('Visa mer', 'tusenrosor')),
            'loading_text' => esc_html(__('Laddar...', 'tusenrosor')),
            'nonce'    => wp_create_nonce('load_more_reviews')
        ]);
    }
    wp_enqueue_script(
        'sidecart-js',
        get_template_directory_uri() . '/assets/js/sidecart.js',
        ['jquery'],
        '1.0',
        true
    );

    // ensure WooCommerce vars exist
    wp_localize_script('sidecart-js', 'wc_cart_params', [
        'ajax_url' => admin_url('admin-ajax.php'),
    ]);
}
add_action('wp_enqueue_scripts', 'tusenrosor_encoderit_scripts');
