<?php
if (!isset($args['post'])) return;
$post = $args['post'];

// 🔹 Fetch custom meta fields
$author_data = get_field('author_data', $post->ID);

$name     = $author_data['name'];
$country  = $author_data['address'];
$rating   = (int) $author_data['rating'];
$rating   = $rating > 0 ? $rating : 5; // Default to 5 if empty

// 🔹 Fetch title and description (optional)
$title       = get_the_title($post->ID);
$description = wp_trim_words(get_the_content(null, false, $post->ID));
?>

<div
    class="w-full md:w-[calc(50%_-_12px)] xl:w-[calc(25%_-_12px)] md:m-1.5 md:bg-[var(--bg2)] last:pb-0 py-4 md:!p-6 md:space-y-6 border-y border-[#F4F4F4] last:border-y-0 md:border-0 flex md:flex-col flex-row items-start duration-400 hover:opacity-65">

    <!-- Mobile initials -->
    <div class="md:hidden text-xs uppercase font-bold flex items-center justify-center rounded-full h-10 w-10 min-w-10 bg-[#DCDCDC] mr-3">
        <?php echo esc_html(strtoupper(substr($name, 0, 2))); ?>
    </div>

    <div class="relative space-y-6 w-full">
        <div class="md:static absolute top-0 right-0">
            <!-- Desktop icon -->
            <svg class="md:block hidden" width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M17 0.162932L16.6144 3.23136C15.6717 3.16538 14.9433 3.34135 14.4291 3.75927C13.9149 4.17719 13.5721 4.76008 13.4008 5.50794C13.2294 6.2558 13.1972 7.10265 13.3043 8.04847H17V16H9.89792V7.38859C9.89792 4.79307 10.4978 2.83544 11.6975 1.51568C12.9187 0.173932 14.6862 -0.276986 17 0.162932ZM7.10208 0.162932L6.71645 3.23136C5.77379 3.16538 5.04537 3.34135 4.53119 3.75927C4.01701 4.17719 3.67423 4.76008 3.50284 5.50794C3.33144 6.2558 3.29931 7.10265 3.40643 8.04847H7.10208V16H0V7.38859C0 4.79307 0.599874 2.83544 1.79962 1.51568C3.02079 0.173932 4.78828 -0.276986 7.10208 0.162932Z" fill="#E5E5E5" />
            </svg>
            <!-- Mobile icon -->
            <svg class="md:hidden" width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.53674e-07 0.122199L0.294896 2.42352C1.01575 2.37403 1.57278 2.50601 1.96597 2.81945C2.35917 3.13289 2.6213 3.57006 2.75236 4.13096C2.88343 4.69185 2.908 5.32699 2.82609 6.03635H9.53674e-07V12H5.431V5.54145C5.431 3.59481 4.97227 2.12658 4.05482 1.13676C3.12098 0.130449 1.76938 -0.207739 9.53674e-07 0.122199ZM7.569 0.122199L7.86389 2.42352C8.58475 2.37403 9.14178 2.50601 9.53497 2.81945C9.92817 3.13289 10.1903 3.57006 10.3214 4.13096C10.4524 4.69185 10.477 5.32699 10.3951 6.03635H7.569V12H13V5.54145C13 3.59481 12.5413 2.12658 11.6238 1.13676C10.69 0.130449 9.33837 -0.207739 7.569 0.122199Z" fill="#E5E5E5" />
            </svg>
        </div>

        <div class="space-y-1.5 md:space-y-2 text-sm font-normal leading-[165%]">
            <!-- Mobile stars -->
            <div class="mt-[3px] md:hidden ml-auto flex items-center space-x-[1.5px] min-w-[86px]">
                <?php for ($i = 0; $i < $rating; $i++): ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/home-page/trustpilotStarWithBg.svg" alt="Star" class="w-4 h-4 object-contain">
                <?php endfor; ?>
            </div>

            <h3 class="font-bold"><?php echo esc_html($title); ?></h3>

            <div class="line-clamp-3 md:line-clamp-5">
                <?php echo esc_html($description); ?>
            </div>
        </div>
    </div>

    <!-- Desktop bottom area -->
    <div class="hidden space-x-3 w-full md:flex items-center leading-[165%] mt-auto">
        <div class="text-xs uppercase font-bold flex items-center justify-center rounded-full h-10 w-10 min-w-10 bg-[#DCDCDC]">
            <?php echo esc_html(strtoupper(substr($name, 0, 2))); ?>
        </div>
        <div class="w-full">
            <h4 class="text-sm font-bold"><?php echo esc_html($name); ?></h4>
            <p class="text-[10px] leading-[165%]"><?php echo esc_html($country); ?></p>
        </div>
        <div class="ml-auto flex items-center space-x-[1.5px] min-w-[86px]">
            <?php for ($i = 0; $i < $rating; $i++): ?>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/home-page/trustpilotStarWithBg.svg" alt="Star" class="w-4 h-4 object-contain">
            <?php endfor; ?>
        </div>
    </div>
</div>