  <?php

    if (!isset($args['post'])) return;
    $post = $args['post'];
    $post_id = $post->ID;

    // 🔹 Dynamic fields
    $title       = get_the_title($post_id);
    $excerpt     = wp_trim_words(get_the_excerpt($post_id), 25);
    $date        = get_the_date('M j, Y', $post_id);
    $permalink   = get_permalink($post_id);
    $thumbnail_id  = get_post_thumbnail_id($post_id);
    $thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'medium_large') : wp_get_attachment_url(get_placeholder_imageId());
    ?>
  <a
      href="<?php echo $permalink;?>"
      class="w-full flex items-stretch space-x-[5px] duration-400 hover:opacity-65">

      <img
          class="w-[60px] min-w-[60px] h-[60px] object-cover object-center"
          src="<?php echo $thumbnail_url; ?>"
          alt="<?php echo esc_html($title); ?>" />
      <div class="w-full flex items-center p-[7px] text-sm font-normal leading-[165%]">
          <span class="line-clamp-2" title="<?php echo esc_html($title); ?>">
              <?php echo esc_html($title); ?>
          </span>
      </div>
  </a>