<?php
/*
Template Name: Single Track Order
Description: A custom Single Track Order Page template
*/
get_header();

?>
<main>
    <section class="section-padding">
        <div class="container">
            <div class="max-w-[800px] mx-auto">
                <div class="space-y-6 md:space-y-8">
                    <div class="">
                        <div class="p-4 md:p-6 flex justify-between items-center font-normal leading-[140%] text-(--white) bg-(--theme-dark)">
                            <div class="space-y-2">
                                <h2 class="text-xl md:text-[28px] tracking-[18%] uppercase">
                                    <?php echo esc_html(__('#68274', 'tusenrosor')); ?>
                                </h2>
                                <div class="flex items-center text-xs md:text-sm leading-[165%] space-x-2">
                                    <span>
                                        <?php echo esc_html(__('Pågående', 'tusenrosor')); ?>
                                    </span>
                                    <svg width="4" height="4" viewBox="0 0 4 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.88969 3.77C0.859688 3.77 0.00968753 2.94 0.00968753 1.89C-0.000312418 0.840003 0.839688 3.21865e-06 1.88969 3.21865e-06C2.93969 3.21865e-06 3.77969 0.840003 3.77969 1.89C3.77969 2.94 2.91969 3.77 1.88969 3.77Z" fill="white" />
                                    </svg>
                                    <span>
                                        <?php echo esc_html(__('11 juni, 2025', 'tusenrosor')); ?>
                                    </span>
                                </div>
                            </div>
                            <h4 class="text-xl md:text-[28px] tracking-[18%] uppercase">
                                <?php echo esc_html(__('6,207 kr', 'tusenrosor')); ?>
                            </h4>
                        </div>

                        <div class="p-4 md:p-6 border border-t-0 border-[#EBEBEB]">
                            <div class="space-y-6 sm:space-y-7 text-base leading-[160%] font-medium ">
                                <!-- Step 1 -->
                                <div class=" flex items-start space-x-3">
                                    <div class="relative">
                                        <div class="absolute left-6 -bottom-5 w-0.5 h-4 bg-(--theme-dark)"></div>
                                        <div class="flex justify-center items-center w-12 min-w-12 h-12 bg-(--theme-dark) rounded-full">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/order/Instance-1.svg" alt="Instance">
                                        </div>
                                    </div>
                                    <div>
                                        <h4 class="text-(--theme-dark)">
                                            <?php echo esc_html(__('Beställning mottagen', 'tusenrosor')); ?>
                                        </h4>
                                        <p class="text-sm font-normal leading-[165%] text-(--sub-text)">
                                            <?php echo esc_html(__('Din beställning har lagts framgångsrikt och vi förbereder den för behandling.', 'tusenrosor')); ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Step 2 -->
                                <div class="flex items-start space-x-3">
                                    <div class="relative">
                                        <div class="absolute left-6 -bottom-5 w-0.5 h-4 bg-(--theme-dark) opacity-30"></div>
                                        <div class="flex justify-center items-center w-12 min-w-12 h-12 border border-dashed rounded-full">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/order/Instance-2.svg" alt="Instance">
                                        </div>
                                    </div>
                                    <div>
                                        <h4 class="text-(--theme-dark)">Packning</h4>
                                        <p class="text-sm font-normal leading-[165%] text-(--sub-text)">
                                            <?php echo esc_html(__('Vårt team packar dina varor noggrant för att säkerställa att de anländer i perfekt skick.', 'tusenrosor')); ?>
                                        </p>
                                    </div>
                                </div>

                                <!-- Step 3 -->
                                <div class="flex items-center space-x-3 text-(--theme-dark) opacity-30">
                                    <div class="relative">
                                        <div class="absolute left-6 -bottom-5 w-0.5 h-4 bg-(--theme-dark)"></div>
                                        <div class="flex justify-center items-center w-12 min-w-12 h-12 border border-dashed rounded-full">
                                            <img class="w-6 min-w-6 h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/order/Instance-3.svg" alt="Instance">
                                        </div>
                                    </div>
                                    <div>
                                        <h4 class="text-(--theme-dark)">
                                            <?php echo esc_html(__('På väg', 'tusenrosor')); ?>
                                        </h4>
                                    </div>
                                </div>

                                <!-- Step 4 -->
                                <div class="flex items-center space-x-3 text-(--theme-dark) opacity-30">
                                    <div class="flex justify-center items-center w-12 min-w-12 h-12 border border-dashed rounded-full">
                                        <img class="w-6 min-w-6 h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/order/Instance-4.svg" alt="Instance">
                                    </div>
                                    <h4 class="text-(--theme-dark)">
                                        <?php echo esc_html(__('Levererad', 'tusenrosor')); ?>
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="">
                        <div class="p-4 md:p-6 border border-b-0 border-[#EBEBEB]">
                            <h2 class="text-base md:text-lg font-normal leading-[140%] tracking-[18%] text-(--theme-color) uppercase">
                                <?php echo esc_html(__('ORDERDETALJER', 'tusenrosor')); ?>
                            </h2>
                        </div>
                        <div class="p-4 md:p-6 border border-[#EBEBEB] space-y-5">

                            <div class="w-full [&>.cartItem:first-child]:pt-0">
                                <!-- Include product single cart -->

                                <?php
                                $cart_products = [
                                    [
                                        'img'       => 'product-1.webp',
                                        'title'     => __('Rosor är utan tvekan en av världens mest älskade blommor | Classic box', 'tusenrosor'),
                                        'price'     => __('1,919 kr', 'tusenrosor'),
                                        'optional'  => true,
                                    ],
                                    [
                                        'img'       => 'product-2.webp',
                                        'title'     => __('Evighetsrosor i hjärtformad ask | Limited edition', 'tusenrosor'),
                                        'price'     => __('1,299 kr', 'tusenrosor'),
                                        'optional'  => false,
                                    ],
                                    [
                                        'img'       => 'product-3.webp',
                                        'title'     => __('Vita rosor i svart box | Classic box', 'tusenrosor'),
                                        'price'     => __('1,599 kr', 'tusenrosor'),
                                        'optional'  => true,
                                    ],
                                    [
                                        'img'       => 'product-4.webp',
                                        'title'     => __('24k guld evighetsrosor | Classic box', 'tusenrosor'),
                                        'price'     => __('2,369 kr', 'tusenrosor'),
                                        'optional'  => true,
                                    ],
                                ];
                                ?>

                                <?php foreach ($cart_products as $product): ?>
                                    <?php require get_template_directory() . '/inc/tusenrosor-loops/small-product-loop.php'; ?>
                                <?php endforeach; ?>
                            </div>


                            <!-- Include subtotal-totalt-part -->
                            <?php
                            require get_template_directory() . '/inc/common-sections/subtotal-totalt-part.php';
                            ?>
                        </div>
                    </div>

                    <div class="">
                        <div class="p-4 md:p-6 border border-b-0 border-[#EBEBEB]">
                            <h2 class="text-base md:text-lg font-normal leading-[140%] tracking-[18%] text-(--theme-color) uppercase">
                                <?php echo esc_html(__('BESTÄLLNINGSDETALJER', 'tusenrosor')); ?>
                            </h2>
                        </div>
                        <div class="p-4 md:p-6 border border-[#EBEBEB] space-y-3 md:space-y-[13px] text-sm font-normal leading-[165%] text-(--theme-color)">
                            <div class="flex justify-between space-x-3 w-full">
                                <div class="w-full space-y-[18px]">
                                    <div class="space-y-1.5">
                                        <span class="text-xs text-(--sub-text)">
                                            <?php echo esc_html(__('Kontaktinformation', 'tusenrosor')); ?></span>
                                        <p>
                                            <?php echo esc_html(__('johnsmith@gmail.com', 'tusenrosor')); ?></p>
                                    </div>
                                    <div class="space-y-1.5">
                                        <span class="text-xs text-(--sub-text)">
                                            <?php echo esc_html(__('Leveransadress', 'tusenrosor')); ?></span>
                                        <p>
                                            <?php echo esc_html(__('John Smith', 'tusenrosor')); ?>
                                        </p>
                                        <p>
                                            <?php echo esc_html(__('1234 Street, 5th Floor, Stockholm, Sweden', 'tusenrosor')); ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="w-full space-y-[18px]">
                                    <div class="space-y-1.5">
                                        <span class="text-xs text-(--sub-text)"><?php echo esc_html(__('Betalningsmetod', 'tusenrosor')); ?></span>
                                        <p class="flex space-x-1.5">
                                            <img class="w-[38px] min-w-[38px] h-6 object-cover object-center bg-(--theme-white)" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/visa.png" alt="cart-image">
                                            <span>
                                                <?php echo esc_html(__('Visa ****4444', 'tusenrosor')); ?>
                                            </span>
                                        </p>
                                    </div>
                                    <div class="space-y-1.5">
                                        <span class="text-xs text-(--sub-text)">
                                            <?php echo esc_html(__('Faktureringsadress', 'tusenrosor')); ?>
                                        </span>
                                        <p>
                                            <?php echo esc_html(__('John Smith', 'tusenrosor')); ?>
                                        </p>
                                        <p>
                                            <?php echo esc_html(__('1234 Street, 5th Floor, Stockholm, Sweden', 'tusenrosor')); ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="space-y-1.5">
                                <span class="text-xs text-(--sub-text)">
                                    <?php echo esc_html(__('Leveranssätt', 'tusenrosor')); ?>
                                </span>
                                <p>
                                    <?php echo esc_html(__('PostNord Standardleverans – 2025-08-29 GRATIS', 'tusenrosor')); ?>
                                </p>
                                <p class="text-(--sub-text)">
                                    <?php echo esc_html(__('8 till 9 arbetsdagar', 'tusenrosor')); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<?php
get_footer();
