<?php
/*
Template Name: Page Track Order
Description: A custom Track Order Page template
*/
$bannerimage = get_template_directory_uri() . '/assets/images/track-order-banner.webp';
 $permitToShow=false;$error='';
   if (isset($_POST['order_id']) || isset($_POST['email'])) {
       if (!($_POST['order_id']) || !($_POST['email'])) {
       $error=__('Invalid request','tusenrosor');
       }
    $order_id = sanitize_text_field($_POST['order_id']);
    $email = sanitize_email($_POST['email']);

    // Get the WooCommerce order
    $order = wc_get_order($order_id);

    // Check if order exists and if the email matches
    if (!$order || $order->get_billing_email() !== $email) {
        // If no order is found or email doesn't match, return the error HTML
        $error='<div class="orderTracking alert woocommerce-error"> <div class="orderTrackingContain">'.__('Ingen beställning hittades för detta ID och e-post.','tusenrosor').'</div></div>';
    }
    if(!empty($order)){
        $permitToShow=true;
    }
   }
      get_header();
   if(!$permitToShow){
 
   
 
?>
<main>

    <section class="bg-cover bg-no-repeat bg-position-[45%_center] md:bg-position-[center_18%] lg:bg-position-[center_25%] xl:bg-center"
    style="background-image: url('<?php echo $bannerimage; ?>');">
        <div
            class="bg-black/50 min-h-[500px] md:min-h-[600px] flex items-center justify-center p-4 md:p-8 lg:p-12">
            <div class="w-full max-w-[343px] md:max-w-[704px] lg:max-w-[800px] text-white space-y-6 md:space-y-9">
                <div class="space-y-3 md:space-y-5 text-center">
                    <h1 class="text-[#F7F4F4] tracking-[18%] text-lg md:text-2xl lg:text-[32px] font-normal leading-[140%] lg:leading-[130%] text-shadow-[0_2px_3px_#3030304D]">
                       <?php echo get_the_title();?>
                    </h1>
                    <h6 class="text-sm leading-[165%] text-shadow-[0_2px_3px_#3030304D]">
                 
                              <?php the_content();?>
                    </h6>
                    <?php if($error) echo $error;?>
                </div>
                <form method="post" action="<?php echo get_permalink()?>">
                    <div class="trackOrderForm items-center flex flex-col md:flex-row md:space-x-4 space-y-4 md:space-y-0">
                        <div class="w-full flex-1">
                            <input 
                            class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-white leading-[165%] outline-0 focus:border-white duration-400 placeholder:text-white  no-autofill-transparent" 
                            type="text" 
                            placeholder="Order ID" 
                            id="" 
                            name="order_id" 
                            value="<?php if(isset($_POST['order_id'])) echo $_POST['order_id'];?>" 
                            required="">
                        </div>
                        <div class="relative w-full flex-1">
                            <input 
                            class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-white leading-[165%] outline-0 focus:border-white duration-400 placeholder:text-white no-autofill-transparent" 
                            type="email" 
                            placeholder="Faktureringsmejl" 
                            id="faktureringsmejl" 
                            name="email" 
                            value="<?php if(isset($_POST['email'])) echo $_POST['email'];?>" 
                            required="">
                            <label for="faktureringsmejl" class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2.5 5.83332L10 9.99999L17.5 5.83332M2.5 4.16666H17.5V15.8333H2.5V4.16666Z" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                </svg>
                            </label>
                        </div>
                        <div class="min-w-[107px]">
                            <button 
                            class="text-sm text-(--theme-dark) bg-white font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center cursor-pointer"
                            type="submit"
                            >
                                <?php echo esc_html(__('SPÅRA','woocommerece'));?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>


</main>
<?php } else{ ?> 
    <div class="section-padding">
        <div class="container">
    <?php    include(get_template_directory() . '/woocommerce/myaccount/view-order.php');
    ?> 
    </div></div>
		<?php		 } ?>
<?php
get_footer();
