<?php
/*
Template Name: Home Page
Description: A custom home page template
*/
get_header();

$hero_section = get_field('hero_banner');
$shop_by_color = get_field('shop_by_color');
$page_id = get_the_ID();
$banner_bottom_section = get_theme_option_repeater_values('banner_bottom_section', $page_id);
$favoriter_evighetsrosor = get_field('favoriter_evighetsrosor');
$blommor_banner_section = get_field('blommor_banner_section');
$favoriter_torkade = get_field('favoriter_torkade');
$testimonial = get_field('testimonial');
$more_than_just_flowers = get_field('more_than_just_flowers');
$gift_product = get_field('gift_product');
$handla_efter_kollektion = get_field('handla_efter_kollektion');
$blog_section = get_field('blog_section');
$fanga_rosens = get_field('fanga_rosens');

?>
<main>
    <?php if ($hero_section['banner']) {
        $bannerimage = wp_get_attachment_image_url($hero_section['banner'], 'full');
    ?>
        <section class="relative">
            <div class="h-[480px] md:h-[672px]">
                <?php echo wp_get_attachment_image($hero_section['banner'], 'full', false, [
                    'class' => 'object-[35%_center] md:object-[30%_center] lg:object-center object-cover w-full h-full',
                    'alt' => 'Banner Image'
                ]);
                ?>

            </div>
            <div class="absolute inset-0 bg-black/30">
                <div class="h-full flex items-end px-4 py-8 md:p-8 lg:p-12">
                    <div class="w-full max-w-[305px] md:max-w-[470px] lg:max-w-[732px] text-white uppercase">
                        <?php if ($hero_section['title_1']) { ?>
                            <h6 class="text-xs tracking-[2.16px] leading-[20.4px] mb-3 md:mb-5">
                                <?php echo $hero_section['title_1']; ?>
                            </h6>
                        <?php } ?>
                        <?php if ($hero_section['title_2']) { ?>
                            <h1
                                class="text-[#F7F4F4] tracking-[18%] text-lg md:text-2xl lg:text-[32px] font-normal mb-6 md:mb-8 leading-[140%] lg:leading-[130%] text-shadow-[0_2px_3px_#3030304D]">
                                <?php echo $hero_section['title_2']; ?>
                            </h1>
                        <?php } ?>
                        <?php if (!empty($hero_section['button_link'])) {
                            $button = $hero_section['button_link'];
                        ?>
                            <a class="text-sm shadow-[0_2px_3px_#3030304D] inline-block font-medium tracking-[18%] leading-[22px] px-6.5 py-3 border duration-400 hover:opacity-65"
                                href="<?php echo $button['url'] ?>">
                                <?php echo $button['title'] ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>

    <!-- require grid slider section -->
    <?php
    if (!empty($banner_bottom_section)) {
        require get_template_directory() . '/inc/common-sections/second-grid-slider-section.php';
    }
    ?>

    <section class="section-padding">
        <div class="container">
            <div class="mb-8 md:mb-12">
                <?php if ($shop_by_color['title']) { ?>
                    <h3 class="text-center uppercase text-base md:text-2xl font-normal tracking-[18%] leading-[140%] mb-5">
                        <?php echo $shop_by_color['title']; ?>
                    </h3>
                <?php } ?>
                <div class="flex flex-wrap items-center justify-center gap-5">
                    <?php

                    if (!empty($shop_by_color['color'])) {
                        $shop_page_url = wc_get_page_permalink('shop');
                        foreach ($shop_by_color['color'] as $colorid) :
                            $image_id = get_term_meta($colorid, 'term_image_id', true);
                            $term = get_term($colorid, 'pa_color');
                    ?>
                            <a href="<?php echo  $shop_page_url . '?pa_color=' . $term->slug; ?>"
                                class="min-w-13 duration-400 hover:opacity-65 flex flex-col items-center justify-center">

                                <?php echo wp_get_attachment_image($image_id, 'full', false, [
                                    'class' => 'max-w-9 w-full h-9 mb-1 mx-auto object-contain',
                                    'alt' => 'Cat Image'
                                ]);
                                ?>

                                <span class="text-xs block font-normal leading-[165%]">
                                    <?php echo $term->name; ?>
                                </span>
                            </a>
                        <?php endforeach; ?>
                    <?php } ?>
                </div>
            </div>

            <?php if (!empty($favoriter_evighetsrosor)) { ?>
                <div>
                    <h2
                        class="uppercase text-center text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%] mb-6 md:mb-9">
                        <?php echo $favoriter_evighetsrosor['title'] ?>
                    </h2>
                    <div class="-m-1.5">
                        <div class="flex flex-wrap justify-center">
                            <?php

                            ?>

                            <?php
                            $products = $favoriter_evighetsrosor['products'];
                            $view_all_link = $favoriter_evighetsrosor['view_all_link'];
                            if (!empty($products)) {
                                foreach ($products as $product_id) : ?>
                                    <?php
                                    $product = wc_get_product($product_id);
                                    if (! $product || ! $product->is_visible()) {
                                        continue;
                                    }

                                    // Make the product available to wc_get_template_part()
                                    global $product;
                                    $product = wc_get_product($product_id);

                                    // Load WooCommerce default content-product.php
                                    wc_get_template_part('content', 'product');
                                    ?>
                                <?php endforeach; ?>
                            <?php } ?>
                        </div>
                    </div>
                    <?php if (!empty($view_all_link)) { ?>
                        <div class="text-center mt-6 md:mt-9">
                            <a href="<?php echo $view_all_link['url']; ?>"
                                class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                                <?php echo $view_all_link['title']; ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

            <?php } ?>
        </div>
    </section>

    <?php if (!empty($blommor_banner_section)) {
        $bannerimage = wp_get_attachment_image_url($blommor_banner_section['banner'], 'full');
    ?>
        <section class="bg-cover bg-no-repeat bg-position-[45%_center] md:bg-position-[center_18%] lg:bg-position-[center_25%] xl:bg-center bg-fixed"
            style="background-image: url('<?php echo $bannerimage; ?>');">
            <div
                class="bg-[linear-gradient(0deg,rgba(0,0,0,0.2),rgba(0,0,0,0.2)),linear-gradient(180deg,rgba(0,0,0,0)_0%,rgba(0,0,0,0.6)_100%)] md:bg-[linear-gradient(0deg,rgba(0,0,0,0.2),rgba(0,0,0,0.2)),linear-gradient(180deg,rgba(0,0,0,0.3)_0%,rgba(0,0,0,0)_100%)] h-[400px] md:h-[580px] flex items-end md:items-start p-4 md:p-8 lg:p-12">
                <div class="w-full max-w-[250px] md:max-w-[400px] lg:max-w-[640px] text-white uppercase">
                    <?php if ($blommor_banner_section['title_1']) { ?>
                        <h6 class="text-xs tracking-[2.16px] leading-[20.4px] mb-3 md:mb-5 text-shadow-[0_2px_3px_#3030304D]">
                            <?php echo $blommor_banner_section['title_1']; ?>
                        </h6>
                    <?php } ?>
                    <?php if ($blommor_banner_section['title_1']) { ?>
                        <h2
                            class="text-[#F7F4F4] tracking-[18%] text-lg md:text-2xl lg:text-[32px] font-normal leading-[140%] lg:leading-[130%] text-shadow-[0_2px_3px_#3030304D]">
                            <?php echo $blommor_banner_section['title_2']; ?>
                        </h2>
                    <?php } ?>
                </div>
            </div>
        </section>
    <?php } ?>

    <?php if (!empty($favoriter_torkade)) { ?>
        <section class="favoritSection section-padding">
            <div class="container">
                <?php if ($favoriter_torkade['title']) { ?>
                    <h2
                        class="uppercase text-center text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%] mb-6 md:mb-9">
                        <?php echo $favoriter_torkade['title']; ?>
                    </h2>
                <?php } ?>
                <div class="-m-1.5">
                    <div class="flex lg:flex-wrap lg:justify-center overflow-x-auto hide-scrollbar scrollSlider">
                        <?php
                        $products = $favoriter_torkade['products'];
                        $view_all_link = $favoriter_torkade['view_all_link'];
                        if (!empty($products)) {
                            foreach ($products as $product_id) : ?>
                                <?php
                                $product = wc_get_product($product_id);
                                if (! $product || ! $product->is_visible()) {
                                    continue;
                                }

                                // Make the product available to wc_get_template_part()
                                global $product;
                                $product = wc_get_product($product_id);

                                // Load WooCommerce default content-product.php
                                wc_get_template_part('content', 'product');
                                ?>
                            <?php endforeach; ?>
                        <?php } ?>
                    </div>
                </div>
                <?php if (!empty($view_all_link)) { ?>
                    <div class="text-center mt-6 md:mt-9">
                        <a href="<?php if (isset($view_all_link['url'])) echo $view_all_link['url'] ?>"
                            class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                            <?php if (isset($view_all_link['title'])) echo $view_all_link['title'] ?>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </section>
    <?php } ?>

    <!-- Include trustpilot section -->
    <?php
    if (!empty($testimonial)) {
        require get_template_directory() . '/inc/common-sections/trustpilot-section.php';
    }
    ?>
    <?php if (!empty($more_than_just_flowers)) { ?>
        <section class="section-padding">
            <div class="container">
                <div class="max-w-[1200px] mx-auto">
                    <div class="flex flex-wrap flex-col-reverse lg:flex-row lg:items-center lg:space-x-15">
                        <div class="w-full lg:w-[calc(64.58%-60px)] uppercase">
                            <?php if (isset($more_than_just_flowers['title']) && $more_than_just_flowers['title']) { ?>
                                <p class="font-normal text-xs tracking-[2.16px] leading-[20.4px] mb-3 md:mb-5">
                                    <?php echo $more_than_just_flowers['title']; ?>
                                </p>
                            <?php } ?>
                            <?php if (isset($more_than_just_flowers['title_2']) && $more_than_just_flowers['title_2']) { ?>
                                <h2
                                    class="tracking-[18%] text-lg md:text-2xl lg:text-[32px] font-normal mb-3 md:mb-5 leading-[140%] lg:leading-[130%]">
                                    <?php echo $more_than_just_flowers['title_2']; ?>
                                </h2>
                            <?php } ?>
                            <div class="text-sm normal-case leading-[165%] mb-6 md:mb-9">
                                <?php if (isset($more_than_just_flowers['description']) && $more_than_just_flowers['description']) { ?>
                                    <p>
                                        <?php echo $more_than_just_flowers['description']; ?>
                                    </p>
                                <?php } ?>
                            </div>
                            <?php if (!empty($more_than_just_flowers['button_link'])) {
                                $botton = $more_than_just_flowers['button_link'];
                            ?>
                                <a href=" <?php echo $botton['url']; ?>"
                                    class="inline-block text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                                    <?php echo $botton['title']; ?>
                                </a>
                            <?php } ?>
                        </div>
                        <?php if (isset($more_than_just_flowers['image']) && $more_than_just_flowers['image']) { ?>
                            <div class="w-full lg:w-[35.42%] mb-8 md:mb-15 lg:mb-0">

                                <?php echo wp_get_attachment_image($more_than_just_flowers['image'], 'full', false, [
                                    'class' => 'w-full h-auto object-contain',
                                    'alt' => 'Image'
                                ]);
                                ?>
                            </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
    <?php if (isset($more_than_just_flowers['bottom_banner']) && $more_than_just_flowers['bottom_banner']) {
        $bannerimg = wp_get_attachment_image_url($more_than_just_flowers['bottom_banner'], 'full');
    ?>
        <section class="bg-cover bg-no-repeat bg-center bg-fixed" style="background-image: url('<?php echo $bannerimg; ?>');">
            <div class="bg-black/20 h-[150px] sm:h-[310px] lg:h-[480px] xl:h-[580px] p-4">
                <!-- 📌 There is no text in this section. -->
            </div>
        </section>
    <?php } ?>
    <?php if (!empty($gift_product) && !empty($gift_product['gift_product'])) { ?>
        <section class="favoritSection section-padding">
            <div class="container">
                <?php if ($gift_product['title']) { ?>
                    <h2
                        class="uppercase text-center text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%] mb-6 md:mb-9">
                        <?php echo $gift_product['title']; ?>
                    </h2>
                <?php } ?>
                <div class="-m-1.5">
                    <div class="flex lg:flex-wrap lg:justify-center overflow-x-auto hide-scrollbar scrollSlider">
                        <?php
                        $giftsProducts = $gift_product['gift_product'];
                        $button = $gift_product['button_link'];
                        if (!empty($giftsProducts)) {
                            foreach ($giftsProducts as $product_id) : ?>
                                <?php
                                $product = wc_get_product($product_id);
                                if (! $product || ! $product->is_visible()) {
                                    continue;
                                }

                                // Make the product available to wc_get_template_part()
                                global $product;
                                $product = wc_get_product($product_id);

                                // Load WooCommerce default content-product.php
                                wc_get_template_part('content', 'product');
                                ?>
                            <?php endforeach; ?>
                        <?php } ?>
                    </div>
                </div>
                <?php if (!empty($button)) { ?>
                    <div class="text-center mt-6 md:mt-9">
                        <a href="<?php echo $button['url']; ?>"
                            class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                            <?php echo $button['title']; ?>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </section>
    <?php } ?>

    <!-- Include collections section -->
    <?php
    if (!empty($handla_efter_kollektion)) {
        require get_template_directory() . '/inc/common-sections/collections-section.php';
    }
    ?>
    <?php if (!empty($blog_section)) { ?>
        <section class="homeBlogs section-padding">
            <div class="container">
                <div class="max-w-[1200px] mx-auto">
                    <div class="text-center mb-6 md:mb-9">
                        <?php if ($blog_section['title']) { ?>
                            <h2 class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                                <?php echo $blog_section['title']; ?>
                            </h2>
                        <?php } ?>
                    </div>
                    <div class="lg:-m-6">
                        <div class="flex flex-wrap justify-center">
                            <?php
                            $bloggs = $blog_section['blogs'];
                            $view_link = $blog_section['view_link'];
                            //   print_r($blog_section);
                            if (!empty($bloggs)) {
                                foreach ($bloggs as $blog) :

                                    $post = get_post($blog);
                                    get_template_part('template-parts/blog-grid', null, ['post' => $post]);
                                endforeach;
                            }
                            ?>
                        </div>
                    </div>
                    <?php if (!empty($view_link) && isset($view_link['title'])) { ?>
                        <div class="text-center mt-6 md:mt-9">
                            <a href="<?php echo $view_link['url'] ?>"
                                class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                                <?php echo $view_link['title'] ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
    <?php } ?>
    <?php if (!empty($fanga_rosens)) {

    ?>
        <section class="bg-(--theme-white)  section-padding">
            <div class="container">
                <div class="mb-6 md:mb-9">
                    <h2 class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                        <?php if (isset($fanga_rosens['title'])) echo $fanga_rosens['title']; ?>
                    </h2>
                </div>
                <div
                    class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-3 md:gap-8 lg:gap-12 text-sm font-normal leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400">
                    <?php if (isset($fanga_rosens['column_1']) && $fanga_rosens['column_1']) { ?>
                        <div class="">
                            <?php echo $fanga_rosens['column_1']; ?>
                        </div>
                    <?php } ?>
                    <?php if (isset($fanga_rosens['column_2']) && $fanga_rosens['column_2']) { ?>
                        <div class="">
                            <?php echo $fanga_rosens['column_2']; ?>
                        </div>
                    <?php } ?>
                    <?php if (isset($fanga_rosens['column_3']) && $fanga_rosens['column_3']) { ?>
                        <div class="">
                            <?php echo $fanga_rosens['column_3']; ?>
                        </div>
                    <?php } ?>
                    <?php if (isset($fanga_rosens['column_4']) && $fanga_rosens['column_4']) { ?>
                        <div class="">
                            <?php echo $fanga_rosens['column_4']; ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
    <?php } ?>


</main>
<?php
get_footer();
