<?php
/*
Template Name: FAQ Page
Description: A custom about page template
*/
get_header();
?>

<main>
    <!-- Include breadcrumbs section -->

    <?php
    require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php';
    ?>

    <section class="md:pb-15 pb-12 md:pt-11 pt-8">
        <div class="sticky top-15 bg-white py-4 mb-4 md:mb-8">
            <div class="container">
                <div class="max-w-[800px] mx-auto">
                    <div class="relative">
                        <button id="faqDropdownButton"
                            class="md:hidden! w-full font-normal rounded-0 text-sm px-4 py-1 flex items-center min-h-12 border border-[#EBEBEB] cursor-pointer"
                            type="button">
                            <span class="faqMobilebtnText"></span>

                            <svg class="ms-auto" width="11" height="6" viewBox="0 0 11 6" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.19922 1L5.19922 5L9.19922 1" stroke="currentColor" stroke="#787878"
                                    stroke-linecap="square" />
                            </svg>
                        </button>

                        <!-- Dropdown menu -->
                        <div id="faqDropdown" class="z-10 hidden shadow-sm w-full md:shadow-none bg-white
                            md:block! md:static! md:transform-none! md:bg-transparent dropdownDiv">

                            <div class="md:-m-2">
                                <div class="flex justify-center items-center flex-wrap
                                    

                                    [&_a]:border-b [&_a:last-child]:border-b-0 
                                    [&_a]:md:border! [&_a]:border-[#EBEBEB] 

                                    [&_a]:hover:bg-(--theme-dark) [&_a]:hover:text-white [&_a]:hover:border-(--theme-color)
                                
                                    [&_a.active]:bg-(--theme-dark) [&_a.active]:text-white [&_a.active]:border-(--theme-color)
                                ">
                                    <?php
                                    $faqs = get_taxonomy_terms('faq-category', $hide_empty = true);
                                    ?>

                                    <?php
                                    if (!empty($faqs)) {
                                        $key = 1;
                                        $term_id = '';
                                        foreach ($faqs as $faq) :
                                            if ($key == '1') {
                                                $class = 'active';
                                                $term_id = $faq->term_id;
                                            } else {
                                                $class = '';
                                            }
                                    ?>
                                            <a href="#faq<?php echo esc_html($faq->term_id); ?>"
                                                class="<?php echo esc_html($class); ?> md:m-2 py-1 min-h-8 px-5 text-xs font-light tracking-[18%] leading-[165%] uppercase flex items-center duration-400 w-full md:w-auto"
                                                onclick="showhideDiv(this,'showhideclass',<?php echo esc_html($faq->term_id); ?>)"
                                                data-btntext="<?php echo esc_html($faq->name); ?>">
                                                <?php echo esc_html($faq->name); ?>
                                            </a>
                                    <?php $key++;
                                        endforeach;
                                    } ?>
                                </div>
                            </div>

                        </div>
                    </div>



                </div>
            </div>
        </div>
        <div class="container">
            <div class="max-w-[800px] mx-auto">
                <?php
                if (!empty($faqs)) {
                    $key = 1;
                    $term_id = '';
                    $default_term = '';
                    foreach ($faqs as $faq) :
                        $term_id = $faq->term_id;
                        if ($key == '1') {
                            $class = 'active';
                            $activeCat = $term_id;
                            $default_term = $faq->name;
                        } else {
                            $class = '';
                            $activeCat = '';
                        }
                        $args = [
                            'post_type' => 'faq',
                            'posts_per_page' => -1,
                            'taxonomy' => 'faq-category',
                            'taxonomy_terms' => [$term_id],

                        ];
                        $faqSections = get_filtered_posts($args);

                ?>

                        <div
                            class="faq-wrapper space-y-12 showhideclass showhideclass<?php echo $term_id; ?> <?php if (!$activeCat) echo 'hidden'; ?>">
                            <?php require get_template_directory() . '/inc/common-sections/faq-list.php';
                            // Include the accordion item template
                            wp_reset_postdata();
                            ?>
                        </div>
                <?php $key++;
                    endforeach;
                } ?>
            </div>
        </div>
    </section>

    <?php
    wp_reset_postdata();
    $banner_section = get_field('banner_section');


    if (!empty($banner_section)) {
        $button = $banner_section['button'];
        $banner = get_image_url_by_id($banner_section['banner']);
    ?>
        <section class=" section-padding border-t border-[#EBEBEB]">
            <!-- instead of container/px-4 md:px-8 lg:px-12 -->
            <div class="container">
                <div class="bg-cover bg-no-repeat bg-center" style="background-image: url('<?php echo $banner; ?>');">
                    <div class="bg-black/30 min-h-[357px] p-4 flex items-center justify-center">
                        <div class="w-full text-white text-center space-y-6 md:space-y-8 tracking-[18%] font-medium">
                            <div
                                class="space-y-5 text-sm leading-[165%] text-shadow-[0_2px_3px_#3030304D] max-w-[400px] lg:max-w-[640px] mx-auto">
                                <h2
                                    class="tracking-[18%] text-lg md:text-2xl lg:text-[32px] leading-[140%] font-normal uppercase">
                                    <?php echo esc_html($banner_section['title']) ?>
                                </h2>
                                <?php if ($banner_section['subtitle']) { ?>
                                    <p>
                                        <?php echo esc_html($banner_section['subtitle']) ?>
                                    </p>
                                <?php } ?>
                            </div>
                            <?php if (!empty($button)) {

                            ?>
                                <a href="<?php echo esc_url($button['url']); ?>"
                                    class="uppercase text-sm shadow-[0_2px_3px_#3030304D] inline-block tracking-[18%] leading-[22px] px-6.5 py-3 border border-white duration-400 hover:opacity-65 bg-white text-(--theme-color)">
                                    <?php echo ($button['title']); ?>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
</main>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var default_term = `<?php echo $default_term; ?>`;
        jQuery('.faqMobilebtnText').text(default_term);
    });
</script>

<?php
get_footer();
