<?php
/*
Template Name: Contact Us
Description: A custom blog page template
*/
get_header();

?>

<main>
    <?php
    require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php';
    $left_side_information = get_field('left_side_information');
    $form_section = get_field('form_section');
    $social_links = get_theme_option_repeater_values('social_links', get_the_ID());
    $collection_section_title = get_field('collection_section_title');
    ?>

    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <section class="section-padding">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="flex flex-wrap lg:space-x-[5%] lg:space-y-0 md:space-y-12 space-y-8">
                    <div class="w-full lg:w-[47.5%]">
                        <div class="space-y-8 lg:space-y-17 text-[12.8px] leading-[23.1px]">
                            <div class="space-y-5">
                                <?php if (!empty($left_side_information['title'])) { ?>
                                    <h2 class="text-lg md:text-2xl font-normal tracking-[18%] leading-[140%] uppercase">
                                        <?php echo $left_side_information['title']; ?>
                                    </h2>
                                <?php } ?>
                                <div class="space-y-5">
                                    <?php if (!empty($left_side_information['description'])) { ?>
                                        <?php echo $left_side_information['description']; ?>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="grid grid-cols-[150px_auto] gap-y-3 md:gap-y-4 gap-x-3 [&_a]:hover:underline [&_a]:hover:opacity-65 [&_a]:duration-400">
                                <?php if (!empty($left_side_information['address'])) { ?>
                                    <p><?php echo esc_html(__('Besöks- & postadress:', 'tusenrosor')); ?></p>
                                    <p> <?php echo $left_side_information['address']; ?></p>
                                <?php } ?>
                                <?php if (!empty($left_side_information['phone'])) { ?>
                                    <p><?php echo esc_html(__('Org. Nr:', 'tusenrosor')); ?></p>
                                    <a href="tel:<?php echo $left_side_information['phone']; ?>">
                                        <?php echo $left_side_information['phone']; ?>
                                    </a>
                                <?php } ?>
                                <?php if (!empty($left_side_information['email'])) { ?>
                                    <p><?php echo esc_html(__('Mejla oss på:', 'tusenrosor')); ?></p>
                                    <a href="mailto:?php echo $left_side_information['email']; ?>">
                                        <?php echo $left_side_information['email']; ?>
                                    </a>
                                <?php } ?>
                                <?php if (!empty($social_links)) { ?>
                                    <p>Sociala medier:</p>
                                    <div class="flex items-center space-x-3">
                                        <?php
                                        $socials = $social_links;

                                        ?>

                                        <?php foreach ($socials as $social) : ?>

                                            <a href="<?php echo $social['link'] ?>" target="_blank" class="w-4 h-4">

                                                <?php echo wp_get_attachment_image($social['image'], 'full', false, [
                                                    'class' => 'w-full max-w-4 h-full object-contain text-[7px] leading-[10px] text-center flex items-center justify-center',
                                                    'alt' => 'Social Icon'
                                                ]);
                                                ?>
                                            </a>

                                        <?php endforeach; ?>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>

                    <div class="w-full lg:w-[47.5%] space-y-9">
                        <div class="space-y-5 text-[12.8px] leading-[23.1px]">
                            <?php if (!empty($form_section['title'])) { ?>
                                <h2 class="text-lg md:text-2xl font-normal tracking-[18%] leading-[140%] uppercase">
                                    <?php echo $form_section['title'] ?>
                                </h2>
                            <?php } ?>
                            <?php if (!empty($form_section['description'])) { ?>
                                <div class="space-y-5">
                                    <?php echo $form_section['description'] ?>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="text-sm font-normal leading-[165%]">
                            <form method="post" class="space-y-4" id="custom_contact_form">
                                <?php wp_nonce_field('sv_contact_form', 'sv_contact_nonce'); ?>
                                <input type="hidden" name="action" value="custom_contact_form">
                                <div class="flex space-x-4">
                                    <div class="w-full">
                                        <label for="name" class="form-label w-full hidden">
                                            <?php echo esc_html__('Namn', 'tusenrosor'); ?>
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input
                                            type="text"
                                            class="w-full border border-[#EBEBEB] min-h-12 px-4 py-1 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)"
                                            id="name"
                                            name="name"
                                            placeholder="<?php echo esc_attr__('Namn', 'tusenrosor'); ?>"
                                            required>
                                    </div>
                                    <div class="w-full">
                                        <label for="email" class="form-label hidden">
                                            <?php echo esc_html__('E-postadress', 'tusenrosor'); ?> <span
                                                class="text-danger">*</span>
                                        </label>
                                        <input
                                            type="email"
                                            class="w-full border border-[#EBEBEB] min-h-12 px-4 py-1 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)"
                                            id="email"
                                            name="email"
                                            placeholder="<?php echo esc_attr__('E-post', 'tusenrosor'); ?>"
                                            required>
                                    </div>
                                </div>

                                <div class="w-full">
                                    <label for="phone" class="form-label hidden">
                                        <?php echo esc_html__('Telefon', 'tusenrosor'); ?>
                                    </label>
                                    <input
                                        type="tel"
                                        class="w-full border border-[#EBEBEB] min-h-12 px-4 py-1 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)"
                                        id="phone"
                                        name="phone"
                                        placeholder="<?php echo esc_attr__('Telefonnummer', 'tusenrosor'); ?>">
                                </div>

                                <div class="w-full flex flex-col">
                                    <label for="message" class="w-full hidden">
                                        <?php echo esc_html__('Meddelande', 'tusenrosor'); ?> <span
                                            class="text-danger">*</span>
                                    </label>
                                    <textarea
                                        class="w-full border border-[#EBEBEB] min-h-29 px-4 py-[9.5px] lg:py-[11.5px] text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"
                                        id="message"
                                        name="message"
                                        placeholder="<?php echo esc_attr__('Meddelande', 'tusenrosor'); ?>"
                                        required></textarea>
                                </div>
                                <div class="w-full">
                                    <?php if (defined('ICL_LANGUAGE_CODE')): ?>
                                        <input type="hidden" name="lang" value="<?php echo esc_attr(ICL_LANGUAGE_CODE); ?>">
                                    <?php else: ?>
                                        <input type="hidden" name="lang" value="sv">
                                    <?php endif; ?>
                                    <?php if (get_theme_option_data('google_key')) { ?>
                                        <div class="g-recaptcha" data-sitekey="<?php echo get_theme_option_data('google_key'); ?>"></div>
                                    <?php } ?>
                                </div>
                                <button
                                    type="submit"
                                    class="w-full min-h-12 px-4 p-1 text-sm text-[#FFFFFF] bg-(--theme-dark) border border-(--theme-dark) duration-400 hover:opacity-65 cursor-pointer uppercase font-medium tracking-[18%]">
                                    <?php echo esc_html__('Skicka Meddelande', 'tusenrosor'); ?>
                                </button>
                            </form>
                            <div id="contact_submit_message_print w-full"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php if (!empty(get_field('collections'))) { ?>
        <section class="noGapCollections section-padding border-t border-[#EBEBEB] !pb-0">
            <div class="text-center mb-6 md:mb-9">
                <?php if ($collection_section_title) { ?>
                    <h2 class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                        <?php echo $collection_section_title; ?>
                    </h2>
                <?php } ?>
            </div>

            <div class="flex flex-wrap lg:flex-nowrap">
                <?php
                $collections = get_field('collections');
                //print_r($collections);
                ?>

                <?php foreach ($collections as $collection) : ?>
                    <?php
                    require get_template_directory() . '/template-parts/collection.php';
                    ?>
                <?php endforeach; ?>

            </div>

        </section>
    <?php } ?>

</main>
<?php
get_footer();
