<?php
/*
Template Name: Collection Page
Description: A custom Collection Page template
*/
get_header();
?>
<main>
    <!-- Include breadcrumbs section -->

    <?php
    require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php';
    ?>


    <section class="kollektionGrid section-padding">
        <div class="container">
            <div class="-m-1 md:-m-3">
                <div class="flex flex-wrap justify-center">


                    <?php
                    $parent_cats = get_terms([
                        'taxonomy'   => 'product_cat',
                        'parent'     => 0,        // ✅ only top-level
                        'hide_empty' => false,    // change to true if you only want categories that have products
                    ]);
                    foreach ($parent_cats as $collection) : ?>
                        <?php
                        require get_template_directory() . '/template-parts/collection.php';
                        ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>


</main>
<?php
get_footer();
