<?php
/*
Template Name: Page Checkout Information
Description: A custom checkout information page template
*/
get_header('checkout');
?>

<main>
    <section class="flex lg:flex-row flex-col-reverse items-stretch overflow-hidden">
        <div class="lg:min-h-screen px-4 py-8 lg:px-8 lg:py-12 w-full lg:w-[51.3%]">
            <div class="max-w-[486px] lg:mr-0 mx-auto">
                <div class="hidden lg:block w-full lg:mb-12">
                    <?php
                    require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
                    ?>
                </div>
                <div class="md:space-y-12 space-y-8">
                    <div class="space-y-5">
                        <div class="space-y-3.5">
                            <div class="uppercase text-xs leading-[165%] text-center">
                                Snabbkassa
                            </div>
                            <div class="flex space-x-3">
                                <a
                                    href="#"
                                    class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-black">
                                    <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-1.svg" alt="Express Checkout">
                                </a>
                                <a
                                    href="#"
                                    class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-[#FFC439]">
                                    <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-2.svg" alt="Express Checkout">
                                </a>
                                <a
                                    href="#"
                                    class="flex-1 basis-auto w-full min-h-12 p-1 px-3 flex items-center justify-center cursor-pointer duration-400 hover:opacity-65 bg-(--theme-dark)">
                                    <img class="max-h-6 object-contain object-center" src="<?php echo get_template_directory_uri(); ?>/assets/images/payment-card/expressCheckout-3.svg" alt="Express Checkout">
                                </a>
                            </div>
                        </div>
                        <div class="flex items-center justify-center w-full">
                            <div class="grow border-t border-[#EBEBEB]"></div>
                            <div class="px-4 uppercase text-xs leading-[165%] text-center text-(--sub-text)">
                                ELLER
                            </div>
                            <div class="grow border-t border-[#EBEBEB]"></div>
                        </div>
                        <div class="md:space-y-8 space-y-6">
                            <div class="space-y-4">
                                <div class="space-x-3 flex items-center justify-between">
                                    <div class="space-y-1.5">
                                        <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
                                            <?php echo esc_html(__('Kontakt', 'tusenrosor')); ?>
                                        </h3>
                                        <div class="max-w-[360px] md:text-sm text-[10px] leading-[165%] text-(--sub-text)">
                                            Vi kommer att använda denna e-postadress för att skicka information och uppdateringar om din beställning.
                                        </div>
                                    </div>
                                    <a class="underline text-sm leading-[165%] text-nowrap duration-400 hover:opacity-65" href="<?php echo site_url('my-account'); ?>">
                                        <?php echo esc_html(__('Logga in', 'tusenrosor')); ?>
                                    </a>
                                </div>
                                <div class="relative">
                                    <label
                                        class="leading-[165%] cursor-pointer text-(--sub-text) text-[10px] absolute left-4 top-1.5"
                                        for="checkout-e-post">
                                        <?php echo esc_html(__('E-post', 'tusenrosor')); ?>
                                    </label>
                                    <input
                                        id="checkout-e-post"
                                        name=""
                                        value=""
                                        placeholder="johnsmith@gmail.com"
                                        type="text"
                                        class="w-full border border-[#EBEBEB] min-h-12 px-4 pb-1 pt-4.5 text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--theme-color) text-(--theme-color)">
                                </div>
                                <label class="flex items-center space-x-3 cursor-pointer">
                                    <input class="tusenCheckbox" type="checkbox" name="" id="">
                                    <span class="text-sm leading-[165%] font-normal duration-400 hover:opacity-65">
                                        <?php echo esc_html(__('Skicka mig nyheter och erbjudanden', 'tusenrosor')); ?>
                                    </span>
                                </label>
                            </div>
                            <div class="space-y-4">
                                <div class="space-y-1.5">
                                    <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
                                        <?php echo esc_html(__('Kontakt', 'tusenrosor')); ?>
                                    </h3>
                                    <div class="md:text-sm text-[10px] leading-[165%] text-(--sub-text)">
                                        Ange adressen dit du vill att din beställning ska levereras.
                                    </div>
                                </div>
                                <div class="space-y-4">
                                    <div class="relative w-full">
                                        <label
                                            class="text-(--sub-text) text-[10px] absolute left-4 top-1.5"
                                            for="cardType">
                                            <?php echo esc_html(__('Land/Region', 'tusenrosor')); ?>
                                        </label>
                                        <select
                                            id="cardType"
                                            class="appearance-none focus:border-(--theme-color) duration-400 px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] bg-no-repeat bg-position-[right_16px_center] bg-size-[10px_6px] cursor-pointer outline-0"
                                            style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/selectArrow.svg')">
                                            <option selected>Sverige</option>
                                            <option value="1">Option 1</option>
                                            <option value="2">Option 2</option>
                                            <option value="3">Option 3</option>
                                        </select>
                                    </div>
                                    <div class="flex space-x-4">
                                        <div class="flex-1 basis-auto w-full">
                                            <input
                                                type="text"
                                                name=""
                                                id=""
                                                placeholder="Förnamn"
                                                class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)">
                                        </div>
                                        <div class="flex-1 basis-auto w-full">
                                            <input
                                                type="text"
                                                name=""
                                                id=""
                                                placeholder="Efternamn"
                                                class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)">
                                        </div>
                                    </div>
                                    <div class="relative w-full">
                                        <input
                                            type="text"
                                            name=""
                                            id=""
                                            placeholder="Företag (valfritt)"
                                            class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)">

                                    </div>
                                    <div class="relative w-full">
                                        <input
                                            type="search"
                                            name=""
                                            id=""
                                            placeholder="Adress"
                                            class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) appearance-none">

                                        <button
                                            class="absolute right-4 top-1/2 -translate-y-1/2 h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.918 12.5L17.0846 16.6667M8.7513 14.1667C5.52964 14.1667 2.91797 11.555 2.91797 8.33333C2.91797 5.11167 5.52964 2.5 8.7513 2.5C11.973 2.5 14.5846 5.11167 14.5846 8.33333C14.5846 11.555 11.973 14.1667 8.7513 14.1667Z" stroke="#787878" stroke-width="1.5" stroke-linecap="round" />
                                            </svg>

                                        </button>
                                    </div>
                                    <div class="relative w-full">
                                        <input
                                            type="text"
                                            name=""
                                            id=""
                                            placeholder="Lägenhet, våning, etc. (valfritt)"
                                            class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)">
                                    </div>
                                    <div class="flex space-x-4">
                                        <div class="flex-1 basis-auto w-full">
                                            <input
                                                type="number"
                                                name=""
                                                id=""
                                                placeholder="Postnummer"
                                                class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) appearance-none">
                                        </div>
                                        <div class="flex-1 basis-auto w-full">
                                            <input
                                                type="text"
                                                name=""
                                                id=""
                                                placeholder="Stad"
                                                class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) appearance-none">
                                        </div>
                                    </div>
                                    <div class="relative w-full">
                                        <input
                                            type="number"
                                            name=""
                                            id="telefon"
                                            placeholder="Telefon"
                                            class="px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) appearance-none">

                                        <label
                                            data-tooltip-target="telefonTooltip"
                                            for="telefon"
                                            class="absolute right-4 top-1/2 -translate-y-1/2 h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
                                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <mask id="mask0_6077_37090" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20">
                                                    <path d="M0 0H20V20H0V0Z" fill="white" />
                                                    <path d="M19.25 0.75V19.25H0.75V0.75H19.25Z" stroke="white" stroke-width="1.5" />
                                                </mask>
                                                <g mask="url(#mask0_6077_37090)">
                                                    <path d="M10.0017 17.8572C14.3411 17.8572 17.8588 14.3394 17.8588 10C17.8588 5.66065 14.3411 2.14288 10.0017 2.14288C5.66229 2.14288 2.14453 5.66065 2.14453 10C2.14453 14.3394 5.66229 17.8572 10.0017 17.8572Z" stroke="#787878" stroke-width="1.5" />
                                                    <path d="M9.98828 14.6286H10.0169V14.6572H9.98828V14.6286Z" stroke="#787878" stroke-width="1.5" stroke-linejoin="round" />
                                                    <path d="M7.85938 7.50003C7.8595 7.13693 7.95189 6.77982 8.12787 6.46222C8.30384 6.14461 8.55764 5.87694 8.86543 5.68431C9.17322 5.49169 9.52491 5.38043 9.88748 5.36099C10.2501 5.34154 10.6116 5.41455 10.9383 5.57315C11.2649 5.73176 11.5458 5.97076 11.7548 6.26772C11.9637 6.56468 12.0938 6.90986 12.1327 7.27086C12.1717 7.63186 12.1183 7.99684 11.9775 8.33154C11.8367 8.66624 11.6132 8.95967 11.3279 9.18431C10.7079 9.67145 10.0022 10.2829 10.0022 11.0715" stroke="#787878" stroke-width="1.5" stroke-linecap="round" />
                                                </g>
                                            </svg>
                                        </label>
                                        <div id="telefonTooltip" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-1.5 text-[10px] font-normal text-white transition-opacity duration-400 bg-[#121212] rounded-sm opacity-0 tooltip leading-[160%] max-w-[148px] w-full text-center">
                                            <?php echo esc_html(__('Om vi behöver kontakta dig angående din beställning', 'tusenrosor')); ?>
                                            <div class="tooltip-arrow -bottom-1.5" data-popper-arrow>
                                                <svg width="12" height="6" viewBox="0 0 12 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6 0H12L7.41421 4.58579C6.63317 5.36683 5.36684 5.36684 4.58579 4.58579L0 0H6Z" fill="#121212" />
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button
                                class="w-full min-h-12 px-4 p-1 text-sm text-[#FFFFFF] bg-(--theme-dark) border border-(--theme-dark) duration-400 hover:opacity-65 cursor-pointer uppercase font-medium tracking-[18%]">
                                <?php echo esc_html(__('Fortsätt till leverans', 'tusenrosor')); ?>
                            </button>
                        </div>
                    </div>

                    <!-- Include small footer -->
                    <?php
                    require get_template_directory() . '/inc/common-sections/checkout-small-footer.php';
                    ?>
                </div>
            </div>
        </div>
        <div id="dinOrder"
            data-accordion="collapse"
            data-active-classes="border-b border-[#EBEBEB]"
            class="w-full lg:w-[48.7%] bg-(--bg2) lg:min-h-screen">
            <h2 id="dinOrderHeading-1" class="lg:hidden">
                <button type="button"
                    class="w-full p-4 md:py-6 rtl:text-right cursor-pointer bg-(--bg2) text-(--theme-dark)!"
                    data-accordion-target="#dinOrderBody-1" aria-expanded="false" aria-controls="dinOrderBody-1">
                    <div class="flex items-center justify-between max-w-[486px] mx-auto">
                        <div class="flex items-center justify-between space-x-2 text-(--theme-dark)">
                            <span class="font-medium text-sm leading-[165%]">
                                Din order
                            </span>
                            <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0 duration-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5" />
                            </svg>
                        </div>
                        <div class="text-lg leading-[140%] tracking-[18%] font-normal">
                            3780 kr
                        </div>
                    </div>

                </button>
            </h2>
            <div
                id="dinOrderBody-1" aria-labelledby="dinOrderHeading-1"
                class="w-full px-4 py-8 lg:px-8 lg:py-12 hidden lg:block">
                <div class="max-w-[486px] lg:max-w-[450px] mx-auto lg:ml-0 w-full">
                    <div class="[&>.cartItem:first-child]:pt-0">
                        <!-- Include product single cart -->

                        <?php
                        $cart_products = [
                            [
                                'img'       => 'product-1.webp',
                                'title'     => __('Rosor är utan tvekan en av världens mest älskade blommor | Classic box', 'tusenrosor'),
                                'price'     => __('1,919 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                            [
                                'img'       => 'product-2.webp',
                                'title'     => __('Evighetsrosor i hjärtformad ask | Limited edition', 'tusenrosor'),
                                'price'     => __('1,299 kr', 'tusenrosor'),
                                'optional'  => false,
                            ],
                            [
                                'img'       => 'product-3.webp',
                                'title'     => __('Vita rosor i svart box | Classic box', 'tusenrosor'),
                                'price'     => __('1,599 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                            [
                                'img'       => 'product-4.webp',
                                'title'     => __('24k guld evighetsrosor | Classic box', 'tusenrosor'),
                                'price'     => __('2,369 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                        ];
                        ?>

                        <?php foreach ($cart_products as $product): ?>
                            <?php require get_template_directory() . '/inc/tusenrosor-loops/small-product-loop.php'; ?>
                        <?php endforeach; ?>
                    </div>
                    <div class="pt-5">
                        <!-- Include subtotal-totalt-part -->
                        <?php
                        require get_template_directory() . '/inc/common-sections/subtotal-totalt-part.php';
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="px-4 py-8 lg:px-8 lg:py-12 w-full lg:hidden">
            <?php
            require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
            ?>
        </div>
    </section>
</main>

<?php
get_footer('checkout');
