<?php
/*
Template Name: Blog Page
Description: A custom blog page template
*/
get_header();
$post_id = get_the_ID();
$thumbnail_id  = get_post_thumbnail_id($post_id);
$thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'full') : '';
if (!$thumbnail_url) {
    $thumbnail_url = get_template_directory_uri() . '/assets/images/contactUs/contactUsBanner.webp';
}
$paged  = (get_query_var('paged')) ? get_query_var('paged') : 1;
$search = isset($_GET['search']) ? sanitize_text_field($_GET['search']) : '';

//  WP_Query for blog posts
$args = [
    'post_type'      => 'post',
    'posts_per_page' => 9,
    'paged'          => $paged,
    's'              => $search,
];
$query = new WP_Query($args);
?>
<main>
    <section class="py-8 md:py-12">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="bg-cover bg-no-repeat bg-center" style="background-image: url('<?php echo  $thumbnail_url; ?>');">
                    <div class="bg-black/30 min-h-[250px] md:min-h-[400px] p-4 flex items-center justify-center">
                        <div class="w-full max-w-[600px] mx-auto text-white">
                            <div class="text-center mb-8">
                                <h1 class="uppercase tracking-[18%] text-xl md:text-[32px] font-normal leading-[140%] lg:leading-[130%] text-shadow-[0_2px_3px_#3030304D]">
                                    <?php echo get_the_title(); ?>
                                </h1>
                            </div>
                            <form class="flex justify-center space-x-4 w-full" action="<?php echo esc_url(get_permalink()); ?>" autocomplete="off">
                                <input
                                    name="search"
                                    value="<?php if (isset($_GET['search'])) echo $_GET['search']; ?>"
                                    id=""
                                    autocomplete="off"
                                    type="text"
                                    placeholder="Sök i bloggen..."
                                    class="px-4 py-1 w-full placeholder-white focus:outline-none border border-[#ebebeb] text-sm leading-[165%] font-normal text-white min-h-12" />
                                <button
                                    type="submit"
                                    class="p-1 px-2 text-sm font-medium tracking-[18%] leading-[21.45px] uppercase text-(--theme-dark) border-0 bg-white cursor-pointer min-h-12 min-w-[89px] duration-400 hover:opacity-65">
                                    <?php echo esc_html(__('SÖK', 'tusenrosor')); ?>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding pt-0!">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="sm:-m-4 lg:-m-6">
                    <div class="flex flex-wrap justify-center">

                        <?php if ($query->have_posts()) : ?>
                            <?php while ($query->have_posts()) : $query->the_post(); ?>
                                <?php
                                $post = get_post(get_the_ID());
                                get_template_part('template-parts/blog-grid', null, ['post' => $post]);
                                ?>
                            <?php endwhile; ?>
                        <?php else : ?>
                            <p class="text-center py-6"><?php esc_html_e('Inga inlägg hittades.', 'tusenrosor'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="text-center mt-6 md:mt-9">
                    <div class="tusenrosorPagination mx-auto">
                        <?php
                        $pagination = paginate_links([
                            'total'   => $query->max_num_pages,
                            'current' => $paged,
                            'prev_text' => '←',
                            'next_text' => '→',
                            'type'   => 'array',
                        ]);

                        if ($pagination) :
                            echo '<ul class="page-numbers">';
                            foreach ($pagination as $page_link) {
                                echo '<li>' . $page_link . '</li>';
                            }
                            echo '</ul>';
                        endif;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>


</main>
<?php
get_footer();
