<?php
/*
Template Name: About Page
Description: A custom about page template
*/
get_header();
$gallery_images = get_theme_option_repeater_values('gallery_images', get_the_ID());
$aboutRightInfos = get_theme_option_repeater_values('top_right_side_content', get_the_ID());
$aboutSimpleInfos = get_theme_option_repeater_values('bottom_icon_section', get_the_ID());
?>

<main class="aboutPage">
    <!-- Include breadcrumbs section -->

    <?php
    require get_template_directory() . '/inc/common-sections/breadcrumbs-section.php';
    ?>


    <section class="section-padding">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="flex flex-col-reverse md:flex-row justify-between space-y-reverse space-y-8 md:space-y-0 md:space-x-8">
                    <div class="w-full md:flex-1">
                        <div
                            class="columns-2 md:columns-1 lg:columns-2 gap-x-4  
                            [&_img]:aspect-square  
                            [&_img:first-child]:aspect-[0.666] 
                            [&_img:nth-child(2)]:aspect-[0.75]
                            [&_img:nth-child(3)]:aspect-[1.333]
                            [&_img:nth-child(4)]:aspect-[0.666]
                            ">


                            <?php
                            if (!empty($gallery_images)) {
                                foreach ($gallery_images as $galleryid) :
                                    //print_r($gallery_images);
                            ?>
                                    <?php echo wp_get_attachment_image($galleryid['image'], 'full', false, [
                                        'class' => 'mb-4 w-full h-auto object-cover object-center bg-[#CEC0B5] object-contain',
                                        'alt' => 'Gallery Image'
                                    ]);
                                    ?>

                            <?php endforeach;
                            }

                            ?>

                        </div>
                    </div>

                    <div class="w-full md:w-[500px] border-l border-[#EBEBEB] [&_.group:first-child]:bg-(--theme-white) [&_.group:first-child]:border-(--theme-color)">



                        <?php
                        if (!empty($aboutRightInfos)) {
                            foreach ($aboutRightInfos as $rightInfo) : ?>

                                <div class="group p-6 md:p-8 space-y-4 md:space-y-5 font-normal tracking-[18%]
                            border-l-[3px] border-transparent duration-400  
                            hover:bg-(--theme-white) hover:border-(--theme-color)
                            ">
                                    <div class="space-y-4 uppercase">
                                        <h2 class="text-lg md:text-2xl leading-[140%]">
                                            <?php echo esc_html($rightInfo['title']); ?>
                                        </h2>
                                        <div class="flex items-center space-x-3.5">
                                            <span class="w-6 md:w-12 h-px bg-(--theme-color) inline-block">
                                            </span>
                                            <h3 class="leading-[165%] text-xs md:text-sm text-[#6A6A6A]">
                                                <?php echo esc_html($rightInfo['subtitle']); ?>
                                            </h3>
                                        </div>
                                    </div>
                                    <div class="text-sm space-y-5 tracking-normal leading-[165%]">
                                        <?php echo nl2br($rightInfo['description']); ?>
                                    </div>
                                </div>

                        <?php endforeach;
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="hidden section-padding">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="flex flex-col-reverse md:flex-row justify-between space-y-reverse space-y-8 md:space-y-0 md:space-x-8">
                    <div class="w-full md:flex-1">
                        <div class="grid grid-cols-2 md:grid-cols-1 lg:grid-cols-2 gap-4">

                            <div class="flex flex-col gap-4">
                                <img
                                    src="<?php echo get_template_directory_uri(); ?>/assets/images/about/1.webp"
                                    alt="woman with roses"
                                    class="w-full h-auto object-cover object-center aspect-[0.666]">
                                <img
                                    src="<?php echo get_template_directory_uri(); ?>/assets/images/about/2.webp"
                                    alt="woman with roses"
                                    class="w-full h-auto object-cover object-center aspect-[0.75]">
                            </div>

                            <div class="flex flex-col gap-4">
                                <img
                                    src="<?php echo get_template_directory_uri(); ?>/assets/images/about/3.webp"
                                    alt="roses boxes"
                                    class="w-full h-auto object-cover object-center bg-[#CEC0B5] aspect-[1.333]">

                                <img
                                    src="<?php echo get_template_directory_uri(); ?>/assets/images/about/4.webp"
                                    alt="two women with roses"
                                    class="w-full h-auto object-cover object-center aspect-[0.666]">
                            </div>

                        </div>
                    </div>

                    <div class="w-full md:w-[500px] border-l border-[#EBEBEB]">

                        <!-- VÅR HISTORIA -->
                        <div class="p-6 md:p-8 bg-[#F7F4F4] border-l-[3px] border-[#303030]">
                            <h2 class="text-lg md:text-2xl text-(--theme-color) font-normal tracking-[0.18em] leading-[140%] uppercase mb-4">VÅR HISTORIA</h2>
                            <div class="flex items-center gap-3.5 mb-4 md:mb-5">
                                <span class="w-6 md:w-12 h-px bg-(--theme-color)"></span>
                                <h3 class="text-xs md:text-sm text-[#6A6A6A] font-normal tracking-[0.18em] leading-[165%] uppercase">
                                    Grundades 2020, för evig skönhet
                                </h3>
                            </div>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%] mb-5">
                                Tusen Rosor startade 2020 med visionen att göra rosor tillgängliga för människor i hela Europa – rosor som bevarar sin skönhet under lång tid.
                                Via vår webbshop erbjuder vi exklusiva evighetsrosor, omsorgsfullt utvalda och konserverade för att behålla sitt naturliga uttryck.
                            </p>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%]">
                                Ambitionen har alltid varit att förena hantverk, estetik och hållbarhet. Varje blomma är mer än en ros – den är en symbol för kärlek och minnen som varar.
                            </p>
                        </div>

                        <!-- VEM VI ÄR -->
                        <div class="p-6 md:p-8">
                            <h2 class="text-lg md:text-2xl text-(--theme-color) font-normal tracking-[0.18em] leading-[140%] uppercase mb-4">VEM VI ÄR</h2>
                            <div class="flex items-center gap-3.5 mb-4 md:mb-5">
                                <span class="w-6 md:w-12 h-px bg-(--theme-color)"></span>
                                <h3 class="text-xs md:text-sm text-[#6A6A6A] font-normal tracking-[0.18em] leading-[165%] uppercase">
                                    Team med känsla för kvalitet
                                </h3>
                            </div>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%] mb-5">
                                Bakom Tusen Rosor finns ett team som förenar passion för skönhet, elegans och omtanke. Vi vill skapa en upplevelse där varje kund känner sig trygg, inspirerad och uppskattad genom mötet med våra produkter.
                            </p>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%]">
                                Vårt sortiment består av handplockade evighetsrosor som bevarar sin naturliga skönhet i flera år utan skötsel. Med fokus på detaljer strävar vi alltid efter att överträffa förväntningar och göra varje ögonblick minnesvärt.
                            </p>
                        </div>

                        <!-- VÅRT UPPRDRAG -->
                        <div class="p-6 md:p-8">
                            <h2 class="text-lg md:text-2xl text-(--theme-color) font-normal tracking-[0.18em] leading-[140%] uppercase mb-4">VÅRT UPPRDRAG</h2>
                            <div class="flex items-center gap-3.5 mb-4 md:mb-5">
                                <span class="w-6 md:w-12 h-px bg-(--theme-color)"></span>
                                <h3 class="text-xs md:text-sm text-[#6A6A6A] font-normal tracking-[0.18em] leading-[165%] uppercase">
                                    Team med känsla för kvalitet
                                </h3>
                            </div>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%] mb-5">
                                Vi vill förnya synen på blomstergåvor genom att erbjuda lyxiga och hållbara produkter. Evighetsrosor är mer än en gåva – de symboliserar kärlek, uppskattning och ett medvetet uttryck av omtanke.
                            </p>
                            <p class="text-sm text-(--theme-color) font-normal leading-[165%]">
                                Med respekt för naturen väljer vi lösningar som minskar miljöpåverkan. Vårt mål är att förena elegans med hållbarhet, så att varje kund kan njuta av tidlös skönhet med omsorg om framtida generationer.
                            </p>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding border-t border-[#EBEBEB]">
        <div class="container">
            <div class="max-w-[1200px] mx-auto">
                <div class="flex flex-col md:flex-row md:space-x-12 space-y-8 md:space-y-0">


                    <?php
                    if (!empty($aboutSimpleInfos)) {
                        foreach ($aboutSimpleInfos as $simpleInfo) : ?>
                            <div class="w-full md:flex-1 font-normal">
                                <div class="bg-(--theme-white) h-15 w-15 min-w-15 mb-6 md:mb-8 flex items-center justify-center">
                                    <?php echo wp_get_attachment_image($simpleInfo['icon'], 'full', false, [
                                        'class' => 'w-6 h-6 object-contain',
                                        'alt' => 'Tusenrosor Icon'
                                    ]);
                                    ?>
                                </div>
                                <h3 class="text-base md:text-xl tracking-[18%] leading-[140%] uppercase mb-3.5">
                                    <?php echo esc_html($simpleInfo['title']); ?>
                                </h3>
                                <p class="text-sm leading-[165%]">
                                    <?php echo nl2br($simpleInfo['description']); ?>
                                </p>
                            </div>
                    <?php
                        endforeach;
                    }
                    ?>

                </div>
            </div>
        </div>
    </section>



    <!-- Include collections section -->
    <?php
    $handla_efter_kollektion['collections'] = get_field('collections');
    if (!empty($handla_efter_kollektion['collections'])) {
        require get_template_directory() . '/inc/common-sections/collections-section.php';
    }
    ?>


    <!-- Include trustpilot section -->
    <?php
    $testimonial = get_field('testimonial');
    //print_r($testimonial);
    if (!empty($testimonial)) {
        require get_template_directory() . '/inc/common-sections/trustpilot-section.php';
    }
    ?>

</main>

<?php
get_footer();
