<div id="sideCartDrawer" class="sideDrawer fixed top-0 right-0 z-40 h-screen transition-transform translate-x-full bg-white w-full max-w-[375px] md:max-w-[514px] duration-400 flex flex-col" tabindex="-1" aria-labelledby="drawer-right-label">
    <div class="drawer-header px-4 py-5 md:px-8 md:py-4.5 border-b border-[#EBEBEB] flex justify-between items-center">
        <h5 class="uppercase text-base md:text-lg text-(--theme-color) font-normal leading-[140%]">
            Vagn
        </h5>
        <button class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative" type="button" data-drawer-hide="sideCartDrawer" aria-controls="sideCartDrawer">
            <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
            </svg>
            <span class="sr-only">Close menu</span>
        </button>
    </div>
    <div class="drawer-body p-4 md:p-8 overflow-y-auto grow">
        <div class="w-full [&>.cartItem:first-child]:pt-0">
            <?php
            $cart_products = [
                [
                    'img'       => 'product-1.webp',
                    'title'     => __('Rosor är utan tvekan en av världens mest älskade blommor | Classic box', 'tusenrosor'),
                    'price'     => __('1,919 kr', 'tusenrosor'),
                    'optional'  => true,
                ],
                [
                    'img'       => 'product-2.webp',
                    'title'     => __('Evighetsrosor i hjärtformad ask | Limited edition', 'tusenrosor'),
                    'price'     => __('1,299 kr', 'tusenrosor'),
                    'optional'  => false,
                ],
                [
                    'img'       => 'product-3.webp',
                    'title'     => __('Vita rosor i svart box | Classic box', 'tusenrosor'),
                    'price'     => __('1,599 kr', 'tusenrosor'),
                    'optional'  => true,
                ],
                [
                    'img'       => 'product-4.webp',
                    'title'     => __('24k guld evighetsrosor | Classic box', 'tusenrosor'),
                    'price'     => __('2,369 kr', 'tusenrosor'),
                    'optional'  => true,
                ],
            ];
            ?>

            <?php foreach ($cart_products as $product): ?>
                <?php require get_template_directory() . '/inc/tusenrosor-loops/small-product-loop.php'; ?>
            <?php endforeach; ?>
        </div>

    </div>
    <div class="drawer-footer p-4 md:p-8 border-t border-[#EBEBEB]">

        <div id="defaultShow" class="space-y-4">
            <div class="leading-[165%] space-y-0.5">
                <button
                    class="orderNoteBtn cursor-pointer text-sm underline duration-400 hover:opacity-65 border-0 bg-transparent p-0">
                    Lägg till ordernotering
                </button>
                <div class="text-xs text-(--sub-text)">
                    Skatter och frakt beräknas i kassan
                </div>
            </div>
            <div class="flex items-stretch space-x-2 leading-[165%]">
                <input
                    name=""
                    class="px-4 py-3 w-full border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)"
                    type="text">
                <button class="text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer min-w-32">
                    Använd
                </button>
            </div>
            <div class="w-full">
                <button class="text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-full">
                    Till kassan • <span>6,207</span> kr
                </button>
            </div>
        </div>

        <div id="orderNoteContainer" class="space-y-4 hidden">
            <label class="text-sm leading-[165%] inline-block w-full" for="orderNote">
                Ordernotering
            </label>
            <textarea
                name=""
                id="orderNote"
                placeholder="Hur kan vi hjälpa dig?"
                class="px-4 py-3 w-full border border-[#EBEBEB] min-h-29 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"></textarea>
            <button class="noteSaveBtn text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-full">
                Spara notering
            </button>
        </div>

    </div>
</div>






<div id="meddelandeModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-[682px] max-h-full duration-400">
        <!-- Modal content -->
        <div class="relative bg-white w-full">
            <div class="flex items-center justify-between p-4 md:py-4.5 md:px-8 border-b border-[#EBEBEB]">
                <h3 class="font-normal uppercase text-base md:text-lg leading-[140%]">
                    Meddelande
                </h3>
                <button type="button" class="duration-400 hover:opacity-65 cursor-pointer bg-transparent text-sm w-6 h-6 ms-auto inline-flex justify-center items-center" data-modal-hide="meddelandeModal">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M4.28516 4.28572L11.9994 12M11.9994 12L19.7137 19.7143M11.9994 12L19.7137 4.28572M11.9994 12L4.28516 19.7143" stroke="#303030" stroke-width="1.5" stroke-linecap="round" />
                    </svg>
                </button>
            </div>
            <div class="p-4 md:py-6 md:px-8">
                <div class="px-4 py-3 text-sm leading-[165%] min-h-[185px] md:min-h-[162px] border border-[#EBEBEB]">
                    Rosor är utan tvekan en av världens mest älskade blommor. De har prytt våra trädgårdar, hem och högtider i århundraden, och de har blivit symboler för kärlek, passion, vänskap och hopp.
                </div>
            </div>
            <div class="flex items-center p-4 md:p-8 pt-0! space-x-4">
                <button
                    data-modal-hide="meddelandeModal"
                    class="noteSaveBtn text-sm bg-white font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-1/2 border border-[#EBEBEB]">
                    avbryt
                </button>
                <button
                    data-modal-hide="meddelandeModal"
                    class="noteSaveBtn text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-1/2 border border-(--theme-dark)">
                    Spara
                </button>
            </div>
        </div>
    </div>
</div>



<script>
    jQuery(document).ready(function($) {
        $('.orderNoteBtn').on('click', function() {
            $('#defaultShow').addClass('hidden');
            $('#orderNoteContainer').removeClass('hidden');
        });

        $('.noteSaveBtn').on('click', function() {
            $('#orderNoteContainer').addClass('hidden');
            $('#defaultShow').removeClass('hidden');
        });
    });
</script>