<?php
$menu_items = wc_get_account_menu_items();
$current_url = wc_get_account_endpoint_url(get_query_var('pagename'));
$current_endpoint = WC()->query->get_current_endpoint();
$current_user = wp_get_current_user();
if (empty($current_endpoint)) {
    $current_endpoint = 'orders';
}
$theme_uri = get_template_directory_uri() . '/assets/images/order/';

// SVGs
$svg_icons = [
    'orders' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.99707 1.75C11.792 1.75 13.2471 3.20507 13.2471 5V5.08301H14.9971L15.1406 5.09668C15.4659 5.15969 15.7186 5.43362 15.7451 5.77539L16.5781 16.6084C16.5941 16.8166 16.5227 17.0225 16.3809 17.1758C16.239 17.329 16.0398 17.4159 15.8311 17.416H4.16406C3.95523 17.416 3.75619 17.329 3.61426 17.1758C3.4724 17.0225 3.4 16.8166 3.41602 16.6084L4.25 5.77539L4.27441 5.63379C4.36229 5.31443 4.65434 5.08315 4.99707 5.08301H6.74707V5C6.74707 3.20516 8.20226 1.75013 9.99707 1.75ZM4.97461 15.916H15.0205L14.3037 6.58301H13.2471V7.5C13.2471 7.91421 12.9113 8.25 12.4971 8.25C12.083 8.24987 11.7471 7.91413 11.7471 7.5V6.58301H8.24707V7.5C8.24707 7.91421 7.91128 8.25 7.49707 8.25C7.08297 8.24987 6.74707 7.91413 6.74707 7.5V6.58301H5.69141L4.97461 15.916ZM9.99707 3.25C9.03068 3.25013 8.24707 4.03358 8.24707 5V5.08301H11.7471V5C11.7471 4.0335 10.9636 3.25 9.99707 3.25Z" fill="currentColor"/></svg>',

    'edit-address' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.99844 11.1917C11.4344 11.1917 12.5984 10.0276 12.5984 8.59167C12.5984 7.15573 11.4344 5.99167 9.99844 5.99167C8.5625 5.99167 7.39844 7.15573 7.39844 8.59167C7.39844 10.0276 8.5625 11.1917 9.99844 11.1917Z" stroke="currentColor" stroke-width="1.5"/>
<path d="M3.0148 7.075C4.65646 -0.141667 15.3481 -0.133334 16.9815 7.08333C17.9398 11.3167 15.3065 14.9 12.9981 17.1167C11.3231 18.7333 8.67313 18.7333 6.9898 17.1167C4.6898 14.9 2.05646 11.3083 3.0148 7.075Z" stroke="currentColor" stroke-width="1.5"/>
</svg>
',
    'edit-account' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.1221 11.75C15.0497 11.75 16.5808 13.3472 16.5811 15.2773V16.667C16.5809 17.0809 16.245 17.4168 15.8311 17.417H4.16406C3.75004 17.4169 3.41424 17.081 3.41406 16.667V15.2773C3.41429 13.3474 4.94468 11.7503 6.87207 11.75H13.1221ZM6.87207 13.25C5.80866 13.2503 4.91429 14.1398 4.91406 15.2773V15.917H15.0811V15.2773C15.0808 14.1396 14.1857 13.25 13.1221 13.25H6.87207ZM9.99707 1.74902C12.2518 1.74925 14.0807 3.57733 14.0811 5.83203C14.0811 8.08705 12.252 9.91578 9.99707 9.91602C7.74206 9.91584 5.91406 8.08709 5.91406 5.83203C5.91444 3.57729 7.74229 1.7492 9.99707 1.74902ZM9.99707 3.24902C8.57071 3.2492 7.41444 4.40572 7.41406 5.83203C7.41406 7.25866 8.57048 8.41584 9.99707 8.41602C11.4236 8.41578 12.5811 7.25862 12.5811 5.83203C12.5807 4.40576 11.4234 3.24925 9.99707 3.24902Z" fill="currentColor"/>
</svg>
',
];

// Default SVG for undefined endpoints
$default_svg = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 300 300">
  <path d="M0 0 C1.4422419 -0.00856522 1.4422419 -0.00856522 2.91362 -0.01730347 C3.95683914 -0.01842133 5.00005829 -0.01953918 6.07489014 -0.02069092 C7.18282425 -0.02565582 8.29075836 -0.03062073 9.43226624 -0.03573608 C13.09537377 -0.05033361 16.75843799 -0.05715581 20.42156982 -0.06268311 C22.97119142 -0.06843663 25.520813 -0.07419434 28.07043457 -0.07995605 C32.73391113 -0.08911766 37.39737473 -0.09542068 42.06085801 -0.09845281 C48.90640619 -0.10292921 55.75175427 -0.12046279 62.59724164 -0.1494534 C68.54259746 -0.17375042 74.48790393 -0.18140079 80.43331146 -0.18312836 C82.95460855 -0.18614983 85.4759049 -0.19416121 87.99716949 -0.20731354 C91.5297397 -0.22442569 95.0618262 -0.22248082 98.59442139 -0.21600342 C99.62954361 -0.2252182 100.66466583 -0.23443298 101.7311554 -0.243927 C109.20716657 -0.20112667 115.8765548 0.63841632 121.90594482 5.32794189 C128.79188202 14.18128972 128.59263796 21.92983879 128.34344482 32.64044189 C128.32334977 34.14562647 128.3051043 35.65083694 128.28875732 37.15606689 C128.24499781 40.81806926 128.17613698 44.47908767 128.09344482 48.14044189 C124.94763059 48.16932704 121.80185014 48.18720112 118.65594482 48.20294189 C117.75811279 48.2113208 116.86028076 48.21969971 115.9352417 48.22833252 C114.65423584 48.2331665 114.65423584 48.2331665 113.34735107 48.23809814 C112.5565918 48.24333496 111.76583252 48.24857178 110.95111084 48.25396729 C109.09344482 48.14044189 109.09344482 48.14044189 108.09344482 47.14044189 C108.09344482 38.23044189 108.09344482 29.32044189 108.09344482 20.14044189 C71.46344482 20.14044189 34.83344482 20.14044189 -2.90655518 20.14044189 C-2.90655518 94.06044189 -2.90655518 167.98044189 -2.90655518 244.14044189 C33.72344482 244.14044189 70.35344482 244.14044189 108.09344482 244.14044189 C108.09344482 234.90044189 108.09344482 225.66044189 108.09344482 216.14044189 C114.69344482 216.14044189 121.29344482 216.14044189 128.09344482 216.14044189 C128.16261908 220.5701565 128.22225611 224.99796942 128.25823975 229.42779541 C128.27325204 230.93209206 128.29366836 232.4363455 128.31976318 233.94049072 C128.35648298 236.11271885 128.37324644 238.2843644 128.38641357 240.45684814 C128.40212402 241.76081543 128.41783447 243.06478271 128.434021 244.40826416 C127.81776002 251.16151256 125.29531588 255.68169527 120.09344482 260.14044189 C115.29315262 263.50064644 110.96899409 264.26020476 105.18688965 264.28088379 C104.22539505 264.28659393 103.26390045 264.29230408 102.27326965 264.29818726 C101.23005051 264.29930511 100.18683136 264.30042297 99.11199951 264.30157471 C98.0040654 264.30653961 96.89613129 264.31150452 95.75462341 264.31661987 C92.09151588 264.3312174 88.42845166 264.3380396 84.76531982 264.34356689 C82.21569823 264.34932042 79.66607665 264.35507813 77.11645508 264.36083984 C72.45297852 264.37000145 67.78951492 264.37630447 63.12603164 264.3793366 C56.28048346 264.383813 49.43513538 264.40134658 42.58964801 264.43033719 C36.64429219 264.45463421 30.69898572 264.46228458 24.75357819 264.46401215 C22.2322811 264.46703362 19.71098475 264.475045 17.18972015 264.48819733 C13.65714995 264.50530948 10.12506344 264.50336461 6.59246826 264.49688721 C5.55734604 264.50610199 4.52222382 264.51531677 3.45573425 264.52481079 C-4.02027692 264.48201046 -10.68966515 263.64246747 -16.71905518 258.95294189 C-21.88091521 252.31626471 -23.49946495 246.76839847 -23.40776062 238.41789246 C-23.41329502 237.46861187 -23.41882941 236.51933128 -23.42453152 235.54128462 C-23.43809117 232.37606871 -23.423194 229.21164773 -23.40826416 226.04644775 C-23.412049 223.77093675 -23.4175504 221.49542805 -23.42463684 219.21992493 C-23.43858622 213.05060573 -23.42742539 206.88156559 -23.41092563 200.71226192 C-23.39706533 194.25330691 -23.40353627 187.79436795 -23.40705872 181.33540344 C-23.40975986 170.49033468 -23.39638064 159.64539375 -23.37310791 148.800354 C-23.34918334 137.6502471 -23.3421066 126.50028665 -23.3526001 115.35015869 C-23.36523572 101.89983527 -23.36271126 88.44962644 -23.34694099 74.9993 C-23.34118394 69.86667867 -23.34126168 64.73410635 -23.34600639 59.6014843 C-23.35077966 53.55790366 -23.34065969 47.51452561 -23.31905174 41.47098351 C-23.31348877 39.25343255 -23.31301407 37.0358621 -23.31800461 34.81830978 C-23.32396366 31.79065116 -23.31143995 28.76361066 -23.29423523 25.73600769 C-23.30024527 24.85915453 -23.30625532 23.98230138 -23.31244749 23.07887691 C-23.24299668 16.35467889 -22.04208519 11.61316086 -17.53155518 6.39044189 C-11.93803397 1.59599514 -7.30881276 0.02613913 0 0 Z" fill="currentColor" transform="translate(59.90655517578125,17.85955810546875)"/>
  <path d="M0 0 C3.85308766 1.57523746 6.44743914 4.17747444 9.31933594 7.09228516 C9.83685928 7.60951645 10.35438263 8.12674774 10.8875885 8.65965271 C12.59130289 10.36475671 14.28782978 12.07682768 15.984375 13.7890625 C17.16649407 14.974913 18.34905645 16.16032174 19.53204346 17.3453064 C22.64028728 20.46117638 25.74247737 23.58300634 28.84344482 26.70611572 C32.01048502 29.89363619 35.18321387 33.0754832 38.35546875 36.2578125 C44.57589403 42.49966976 50.78993537 48.74783485 57 55 C55.42476254 58.85308766 52.82252556 61.44743914 49.90771484 64.31933594 C49.39048355 64.83685928 48.87325226 65.35438263 48.34034729 65.8875885 C46.63524329 67.59130289 44.92317232 69.28782978 43.2109375 70.984375 C42.025087 72.16649407 40.83967826 73.34905645 39.6546936 74.53204346 C36.53882362 77.64028728 33.41699366 80.74247737 30.29388428 83.84344482 C27.10636381 87.01048502 23.9245168 90.18321387 20.7421875 93.35546875 C14.50033024 99.57589403 8.25216515 105.78993537 2 112 C-1.85027991 110.21799313 -4.2799142 107.92324595 -7.25 104.875 C-8.14203125 103.96492188 -9.0340625 103.05484375 -9.953125 102.1171875 C-10.62859375 101.41851562 -11.3040625 100.71984375 -12 100 C-10.70280076 97.14220983 -9.3363174 95.08991464 -7.11083984 92.88378906 C-6.5303891 92.30348938 -5.94993835 91.7231897 -5.35189819 91.12530518 C-4.72788116 90.51161072 -4.10386414 89.89791626 -3.4609375 89.265625 C-2.82008209 88.62759949 -2.17922668 87.98957397 -1.51895142 87.33221436 C0.52437821 85.30005931 2.57455982 83.27497782 4.625 81.25 C6.0134786 79.8715547 7.4015049 78.49265364 8.7890625 77.11328125 C12.18748697 73.73688106 15.59207254 70.36680712 19 67 C17.99640489 66.99365209 17.99640489 66.99365209 16.97253513 66.98717594 C0.71569084 66.88400863 -15.54110688 66.77539206 -31.7978735 66.66066074 C-39.65942312 66.60531058 -47.52097727 66.5518257 -55.38256836 66.50268555 C-62.23228322 66.45986561 -69.08196442 66.41359325 -75.93162733 66.36312145 C-79.56067418 66.33650278 -83.18971427 66.31164936 -86.81879997 66.29092598 C-90.86354423 66.2677645 -94.90819354 66.23689742 -98.95288086 66.20532227 C-100.16488159 66.1995668 -101.37688232 66.19381134 -102.62561035 66.18788147 C-103.72082504 66.17809265 -104.81603973 66.16830383 -105.94444275 66.15821838 C-106.90218566 66.15176583 -107.85992857 66.14531328 -108.84669399 66.1386652 C-111 66 -111 66 -112 65 C-112.0983721 63.66956375 -112.13078592 62.33406656 -112.1328125 61 C-112.13410156 60.195625 -112.13539062 59.39125 -112.13671875 58.5625 C-112.13285156 57.716875 -112.12898438 56.87125 -112.125 56 C-112.12886719 55.154375 -112.13273437 54.30875 -112.13671875 53.4375 C-112.13542969 52.633125 -112.13414063 51.82875 -112.1328125 51 C-112.13168457 50.2575 -112.13055664 49.515 -112.12939453 48.75 C-112 47 -112 47 -111 46 C-109.31747421 45.89165136 -107.6304153 45.85314043 -105.94444275 45.84178162 C-104.30162071 45.82709839 -104.30162071 45.82709839 -102.62561035 45.81211853 C-101.41360962 45.80636307 -100.20160889 45.8006076 -98.95288086 45.79467773 C-97.68477066 45.78477814 -96.41666046 45.77487854 -95.11012268 45.76467896 C-91.62271019 45.73756697 -88.13528407 45.71659162 -84.64782405 45.69667697 C-81.00693558 45.67485609 -77.36608939 45.6474484 -73.72523499 45.62062073 C-66.82626095 45.57064095 -59.92726352 45.52572181 -53.0282436 45.48259836 C-45.17586312 45.43327105 -37.32352506 45.37833627 -29.47118556 45.32291877 C-13.31416134 45.20901763 2.84290164 45.10293675 19 45 C8.77 34.77 -1.46 24.54 -12 14 C-9.99006295 9.98012591 -8.06153611 7.85483005 -4.875 4.75 C-3.96492188 3.85796875 -3.05484375 2.9659375 -2.1171875 2.046875 C-1.06917969 1.03367187 -1.06917969 1.03367187 0 0 Z" fill="currentColor" transform="translate(205,94)"/>
</svg>';
?>

<section class="pt-12 lg:pt-[60px] pb-6 md:pb-8">
    <div class="container">
        <div class="max-w-[800px] mx-auto">
            <div class="">
                <div class="space-y-8">
                    <div class="flex items-center space-x-4">
                        <div class="w-20 max-w-20 min-w-20 h-20 rounded-full overflow-hidden">
                            <img class="w-full object-contain object-center bg-[#EBEBEB]" src="https://placehold.co/400x400?text=<?php echo get_initials($current_user->display_name); ?>" alt="User Profile">
                        </div>
                        <div class="space-y-1.5 leading-[165%]">
                            <h4 class="text-xl text-(--theme-color) font-bold">
                                <?php echo esc_html($current_user->display_name); ?>
                            </h4>
                            <p class="text-sm text-(--sub-text) font-normal">
                                <?php echo esc_html($current_user->user_email); ?>
                            </p>
                        </div>
                    </div>


                    <div class="scrollSlider usersOrderTabs flex items-center md:space-x-4 space-x-3 overflow-x-auto hide-scrollbar text-sm font-normal leading-[165%]">
                        <?php foreach ($menu_items as $endpoint => $label): ?>
                            <?php
                            $is_active = ($endpoint === $current_endpoint);
                            $icon_svg  = isset($svg_icons[$endpoint]) ? $svg_icons[$endpoint] : $default_svg;
                            ?>
                            <div role="presentation">
                                <a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>"
                                    class="border border-[#EBEBEB] text-(--theme-dark)
                       hover:text-white hover:bg-(--theme-dark) hover:border-(--theme-dark)
                       [&.active]:bg-(--theme-dark) [&.active]:text-white [&.active]:border-(--theme-color)
                       flex items-center py-[6.5px] pl-3.5 pr-4 whitespace-nowrap cursor-pointer duration-400 space-x-2.5
                       bg-white <?php echo $is_active ? 'active' : ''; ?>">
                                    <?php echo $icon_svg; ?>
                                    <span class="text-sm leading-[165%]"><?php echo esc_html($label); ?></span>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>