<div id="meddelandeModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-60 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
    <div class="relative p-4 w-full max-w-[682px] max-h-full duration-400">
        <div class="relative bg-white w-full z-60">
            <div class="flex items-center justify-between p-4 md:py-4.5 md:px-8 border-b border-[#EBEBEB]">
                <h3 class="font-normal uppercase text-base md:text-lg leading-[140%]">
                    <?php echo esc_html(__('Meddelande', 'tusenrosor')) ?>
                </h3>
                <button type="button" class="modalClose duration-400 hover:opacity-65 cursor-pointer bg-transparent text-sm w-6 h-6 ms-auto inline-flex justify-center items-center">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M4.28516 4.28572L11.9994 12M11.9994 12L19.7137 19.7143M11.9994 12L19.7137 4.28572M11.9994 12L4.28516 19.7143" stroke="#303030" stroke-width="1.5" stroke-linecap="round" />
                    </svg>
                </button>
            </div>
            <div class="p-4 md:py-6 md:px-8">
                <textarea
                    class="w-full px-4 py-3 text-base lg:text-sm min-h-[185px] md:min-h-[162px] border border-[#EBEBEB] text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"
                    name=""
                    id="MeddelandeField"></textarea>
            </div>
            <div class="flex items-center p-4 md:p-8 pt-0! space-x-4">
                <button class="modalClose text-sm bg-white font-medium tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-1/2 border border-[#EBEBEB] hover:border-(--theme-color)">
                    <?php echo esc_html(__('avbryt', 'tusenrosor')) ?>
                </button>
                <button class="saveMedalande text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-1/2 border border-(--theme-dark)">
                    <?php echo esc_html(__('Spara', 'tusenrosor')) ?>
                </button>
              
            </div>
            <div class="medalandemessage"></div>
        </div>
    </div>
</div>
<script>
    jQuery(document).ready(function($) {
        const $body = $("body");
        const $modal = $("#meddelandeModal");
        let currentCartKey = null;
        var ajax_url='<?php echo admin_url('admin-ajax.php');?>';
        // ===================================================
        // 🟢 Open Modal (delegated)
        // ===================================================
        $(document).on("click", ".CartMeddelandeOpenBtn", function() {
            // Show modal
            $modal.removeClass("hidden").addClass("flex");
                currentCartKey = $(this).data("cartkey");
                const existingComment = $(".com_" + currentCartKey).text().trim();

                // Reset textarea each time
                $("#MeddelandeField").val(existingComment || "");
            // ✅ Lock body scroll only if not already locked
            if (!$body.hasClass("overflow-hidden")) {
                $body.addClass("overflow-hidden");
                $body.attr("data-modal-scroll-lock", "true"); // mark that we added it
            }

            // ✅ Always add our custom backdrop
            if (!$("#customModalBackdrop").length) {
                const $backdrop = $('<div id="customModalBackdrop" class="bg-gray-900/50 dark:bg-gray-900/80 fixed inset-0 z-55"></div>');
                $body.append($backdrop);
            }
        });

        // ===================================================
        // 🔴 Close Modal
        // ===================================================
        function closeModal() {
            // Hide modal
              currentCartKey = null;
            $modal.removeClass("flex").addClass("hidden");

            // ✅ Remove body scroll only if *we* added it
            if ($body.attr("data-modal-scroll-lock") === "true") {
                $body.removeClass("overflow-hidden");
                $body.removeAttr("data-modal-scroll-lock");
            }

            // Remove custom backdrop
            $("#customModalBackdrop").remove();
        }

        // Close via any modalClose button
        $(document).on("click", ".modalClose", function() {
            closeModal();
        });
    $(document).on("click", ".saveMedalande", function() {
    const comment = $("#MeddelandeField").val().trim();
    if (!currentCartKey) return;

    $.ajax({
      type: "POST",
      url: ajax_url, // ✅ Woo AJAX endpoint
      data: {
        cart_key: currentCartKey,
         action: 'tusenrosor_update_cart_comment',
        comment: comment,
      },
      success: function (res) {
        if (res.success) {
          // Update the comment text in the cart UI
          $(".com_" + currentCartKey).text(comment);
        } else {
          //alert("❌ " + (res.data?.msg || "Något gick fel."));
           $(".medalandemessage").html('<div class="alert alert-danger eror_message">'+res.data.msg+'</div>');
        }
      },
      complete: function () {
        // Close modal always
      closeModal();
      },
    });

           
        });


        // Close when clicking custom backdrop
        $(document).on("click", "#customModalBackdrop", function() {
            closeModal();
        });

        // ✅ Close when clicking overlay area (outside white box)
        $modal.on("click", function(e) {
            if ($(e.target).is($modal)) {
                closeModal();
            }
        });
    });
</script>