<div class="border-t border-[#DEDEDE] flex-wrap flex space-x-4 justify-center md:justify-start">
    <?php
    $links = get_theme_option_repeater_values('checkout_page_footer_pages');
    ?>

    <?php
    if (!empty($links)) {
        foreach ($links as $key=> $text): 
        $footer_page_id = url_to_postid( $text['link'] );
        if( $footer_page_id){
        $footerpage = get_post( $footer_page_id );

        $title   = get_the_title( $footer_page_id );
        $content = apply_filters('the_content', $footerpage->post_content);
        ?>
            <a href="javascript:void(0)"
                class="pt-4 underline text-xs duration-400 leading-4.5 hover:opacity-65 block" data-modal-target="infomationModal<?php echo $key;?>" data-modal-toggle="infomationModal<?php echo $key;?>">
                <?php echo esc_html($text['page_name']); ?>
            </a>

            <div id="infomationModal<?php echo $key;?>" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full px-4">
    <div class="relative w-full max-w-[650px] h-auto max-h-9/10 duration-400 flex flex-col bg-white">
        <!-- Modal content -->
        <div class="flex items-center justify-between p-4 md:py-4.5 md:px-8 border-b border-[#EBEBEB]">
            <h3 class="font-normal uppercase text-base md:text-lg leading-[140%]">
              <?php echo $title;?>
            </h3>
            <button type="button" class="duration-400 hover:opacity-65 cursor-pointer bg-transparent text-sm w-6 h-6 ms-auto inline-flex justify-center items-center" data-modal-hide="infomationModal<?php echo $key;?>">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4.28516 4.28572L11.9994 12M11.9994 12L19.7137 19.7143M11.9994 12L19.7137 4.28572M11.9994 12L4.28516 19.7143" stroke="#303030" stroke-width="1.5" stroke-linecap="round" />
                </svg>
            </button>
        </div>
        <div class="overflow-y-auto grow p-4 md:py-6 md:px-8 text-sm leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400 [&_h1]:tracking-[18%] [&_h1]:uppercase [&_h1]:text-base [&_h2]:tracking-[18%] [&_h2]:uppercase [&_h2]:text-base [&_h3]:tracking-[18%] [&_h3]:uppercase [&_h3]:text-base [&>*]:mb-3 [&>*:last-child]:mb-0">
         <?php echo   $content;?>
        </div>
        <div class="flex items-center p-4 md:p-8 md:pt-6 border-t border-[#EBEBEB] ">
            <button
                data-modal-hide="infomationModal<?php echo $key;?>"
                class="noteSaveBtn text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-full border border-(--theme-dark)">
                <?php echo esc_html(__('Ok', 'tusenrosor')); ?>
            </button>
        </div>
    </div>
</div>
    <?php } endforeach;
    } ?>

</div>






