<?php

/**
 * Return all custom Tusenrosor shipping method settings.
 */
function tusenrosor_get_shipping_methods_config()
{
    return [
        // 🇸🇪 Sweden (Domestic)
        'SE' => [
            [
                'name'        => 'PostNord Express',
                'slug'        => 'postnord_express',
                'min_days'    => 1,
                'early_fee' => 0,
                'special_fee' => 0,
                'max_days'    => 1,
                'price'       => 49,
                'desc'        => __('1 arbetsdag', 'tusenrosor'),
            ],
            [
                'name'        => 'PostNord Home Delivery',
                'slug'        => 'postnord_home',
                'min_days'    => 1,
                'max_days'    => 2,
                'price'       => 179,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('1–2 arbetsdagar', 'tusenrosor'),
            ],
            [
                'name'        => 'PostNord Standard',
                'slug'        => 'postnord_standard',
                'min_days'    => 3,
                'max_days'    => 3,
                'price'       => 0,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('1–3 arbetsdagar', 'tusenrosor'),
            ],
        ],

        // 🇩🇰🇩🇪🇳🇴🇫🇮🇳🇱🇵🇱 UPS Zone 1
        'ZONE1' => [
            [
                'name'        => 'UPS Express',
                'slug'        => 'ups_express',
                'min_days'    => 1,
                'max_days'    => 1,
                'price'       => 399,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('1 arbetsdag', 'tusenrosor'),
            ],
            [
                'name'        => 'UPS Standard',
                'slug'        => 'ups_standard',
                'min_days'    => 2,
                'max_days'    => 2,
                'price'       => 199,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('2 arbetsdagar', 'tusenrosor'),
            ],
        ],

        // 🇪🇸🇬🇧 UPS Zone 2
        'ZONE2' => [
            [
                'name'        => 'UPS Express',
                'slug'        => 'ups_express',
                'min_days'    => 1,
                'max_days'    => 2,
                'price'       => 499,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('inom 2 arbetsdagar', 'tusenrosor'),
            ],
            [
                'name'        => 'UPS Standard',
                'slug'        => 'ups_standard',
                'min_days'    => 2,
                'max_days'    => 3,
                'price'       => 299,
                'early_fee' => 0,
                'special_fee' => 0,
                'desc'        => __('3 arbetsdagar', 'tusenrosor'),
            ],
        ],
    ];
}
add_action('wp_enqueue_scripts', function () {
    $google_api_key =   get_theme_option_data('google_api_key');
    if (is_checkout()) {
        wp_enqueue_script('wc-country-select');
        wp_enqueue_script('wc-address-i18n');
        // wp_enqueue_script(
        //     'country-maps',
        //     get_stylesheet_directory_uri() . '/js/country-switcher.js',
        //     array(),
        //     null,
        //     true
        // );
    }
    if (is_checkout() && $google_api_key) {
        $country = WC()->customer->get_shipping_country() ?: 'SE';
        wp_enqueue_script(
            'google-maps',
            'https://maps.googleapis.com/maps/api/js?key=' . $google_api_key . '&libraries=places',
            array(),
            null,
            true
        );

        wp_enqueue_script(
            'checkout-autocomplete',
            get_stylesheet_directory_uri() . '/js/checkout-autocomplete.js',
            array('jquery', 'google-maps'),
            '1.0',
            true
        );
    }
    if (is_checkout()) {
        $methods = tusenrosor_get_shipping_methods_config();

        // Map zone groups
        $country = WC()->customer->get_shipping_country() ?: 'SE';
        $zones = [
            'ZONE1' => ['DK', 'DE', 'NO', 'FI', 'NL', 'PL'],
            'ZONE2' => ['ES', 'GB'],
        ];
        $offset = get_option('gmt_offset'); // e.g. +6 for Bangladesh, +1 for Sweden
        $timezone_string = get_option('timezone_string'); // e.g. "Europe/Stockholm"
        wp_localize_script('checkout-autocomplete', 'tusenrosor_settings', [
            'currency' => get_woocommerce_currency_symbol(),
            'country'  => $country,
            'zones'    => $zones,
            'tz_offset' => $offset,
            'tz_string' => $timezone_string ?: 'UTC',
            'methods'  => $methods,
        ]);
    }
});
