<?php
// Add the Theme Options menu
add_action('admin_menu', function () {
    add_menu_page(
        'Theme Options',
        'Theme Options',
        'manage_options',
        'theme-options',
        'theme_options_html',
        'dashicons-admin-settings',
        60
    );
});

// Ensure acf_form_head() runs early (before output)
add_action('admin_init', function () {
    if (isset($_GET['page']) && $_GET['page'] === 'theme-options') {
        if (function_exists('acf_form_head')) {
            acf_form_head();
        }
    }
});

function acf_get_group_key_by_title($group_title)
{
    if (!function_exists('acf_get_field_groups')) return false;
    $groups = acf_get_field_groups();
    foreach ($groups as $group) {
        if ($group['title'] === $group_title) {
            return $group['key'];
        }
    }
    return false;
}

function theme_options_html()
{
    $group_key = acf_get_group_key_by_title('Theme Options');
    $options_page = get_page_by_path('theme-options', OBJECT, 'page');
    $post_id = $options_page ? $options_page->ID : 'options';
    ?>
    <div class="wrap">
        <h1>Theme Options</h1>
        <?php
        if ($group_key) {
            acf_form([
                'post_id' => $post_id,
                'field_groups' => [$group_key],
                'submit_value' => 'Save Options',
            ]);
        } else {
            echo '<p><strong>ACF field group "Theme Options" not found.</strong></p>';
        }
        ?>
    </div>
    <?php
}
function get_theme_option_data($key){
$options = array();
if (!empty(get_page_by_path('theme-options'))) {
	$page_id = get_page_by_path('theme-options')->ID;
	$options = get_field($key, $page_id);
    return $options;
}
else{
    return array();
}
}
function get_theme_option_repeater_values($field_name,$post_id='') {
    
    if (!empty(get_page_by_path('theme-options')) && !$post_id) {
	$post_id = get_page_by_path('theme-options')->ID;
	
    }
  
    if(!$post_id){
        return array();
    }
    $rows = get_field($field_name, $post_id);

    // If the repeater value is JSON (as in custom storage)
    if (is_string($rows)) {
        $rows = json_decode($rows, true);
    }

    if (!is_array($rows)) {
        return [];
    }

    $result = [];

    foreach ($rows as $row_index => $row) {
        $processed_row = [];

        foreach ($row as $field_key => $value) {
            $field_object = get_field_object($field_key, $post_id);

            if (!$field_object) continue;

            $field_name = $field_object['name'];
            $field_type = $field_object['type'];

            // === Convert ACF field value by type ===
            switch ($field_type) {
                case 'image':
                case 'file':
                    $value = ($value) ?: $value;
                    break;

                case 'user':
                    $user = get_userdata($value);
                    $value = $user ? $user->display_name : $value;
                    break;

                case 'page_link':
                case 'post_object':
                    $post = get_post($value);
                    $value = $post ? $post->post_title : $value;
                    break;

                case 'relationship':
                case 'taxonomy':
                    if (is_array($value)) {
                        $formatted = [];
                        foreach ($value as $id) {
                            if ($field_type === 'taxonomy') {
                                $term = get_term($id);
                                $formatted[] = $term ? $term->name : $id;
                            } else {
                                $post = get_post($id);
                                $formatted[] = $post ? $post->post_title : $id;
                            }
                        }
                        $value = $formatted;
                    }
                    break;
            }

            $processed_row[$field_name] = $value;
        }

        $result[] = $processed_row;
    }

    return $result;
}