<?php

function wp_get_menu_array($current_menu = 'primary-menu')
{
    $menu_array = wp_get_nav_menu_items(wp_get_nav_menu_name($current_menu));
    $menu = array();
    if (!empty($menu_array)) {
        foreach ($menu_array as $m) {
            if (empty($m->menu_item_parent)) {
                $menu[$m->ID] = array();
                $menu[$m->ID]['ID'] = $m->ID;
                $menu[$m->ID]['title'] = $m->title;
                $menu[$m->ID]['url'] = $m->url;
                $menu[$m->ID]['children'] = array();
            }
        }
    }

    return $menu;
}
function add_custom_menu_fields($item_id, $item, $depth, $args)
{
    // Get saved values
    $_mega_menu    = get_post_meta($item_id, '_mega_menu', true);

?>
    <p class="menu-field-description description description-wide">
        <label for="edit-menu-item-<?php echo esc_attr($item_id); ?>">
            <?php _e('Mega Menu:', 'textdomain'); ?>
        </label>
        <input type="checkbox" id="edit-menu-item-<?php echo esc_attr($item_id); ?>" value="1" name="mega_menu[<?php echo esc_attr($item_id); ?>]" <?php if ($_mega_menu) echo 'checked'; ?>>

    </p>
<?php
}
add_action('wp_nav_menu_item_custom_fields', 'add_custom_menu_fields', 10, 4);


// ----------------------
// Save custom fields
// ----------------------
function save_custom_menu_fields($menu_id, $menu_item_id, $args)
{
    if (isset($_POST['mega_menu'][$menu_item_id])) {
        $mega_menu = esc_url_raw($_POST['mega_menu'][$menu_item_id]);
        update_post_meta($menu_item_id, '_mega_menu', $mega_menu);
    } else {
        delete_post_meta($menu_item_id, '_mega_menu');
    }
}
add_action('wp_update_nav_menu_item', 'save_custom_menu_fields', 10, 3);



// Recursive function to get children
function populate_children_top_menu_1($menu_array, $menu_item)
{
    $children = array();

    foreach ($menu_array as $m) {
        if ((int) $m->menu_item_parent === (int) $menu_item->ID) {
            $children[$m->ID] = array(
                'ID'       => $m->ID,
                'title'    => $m->title,
                'url'      => $m->url,
                'children' => populate_children_top_menu_1($menu_array, $m)
            );
        }
    }

    return $children;
}

// Get menu as nested array
function wp_get_menu_top_menu_1_array($menu_identifier)
{
    // If passed a location (string)
    if (is_string($menu_identifier)) {
        $locations = get_nav_menu_locations();
        if (isset($locations[$menu_identifier])) {
            $menu_obj = wp_get_nav_menu_object($locations[$menu_identifier]);
        } else {
            $menu_obj = wp_get_nav_menu_object($menu_identifier); // maybe a menu slug/name
        }
    } elseif (is_numeric($menu_identifier)) {
        // If passed an ID
        $menu_obj = wp_get_nav_menu_object($menu_identifier);
    } else {
        return array();
    }

    if (!$menu_obj) {
        return array();
    }

    $menu_items = wp_get_nav_menu_items($menu_obj->term_id);
    if (!$menu_items) {
        return array();
    }

    $menu = array();
    global $wp;
    foreach ($menu_items as $m) {
        if (empty($m->menu_item_parent)) {

             $current_url = home_url(add_query_arg(array(), $wp->request));

            // Normalize URLs for comparison
            $menu_url    = trailingslashit($m->url);
            $current_url = trailingslashit($current_url);

            // ✅ Check if menu URL matches current URL
            $is_active = ($menu_url === $current_url);

            // (Optional) Also match for home page
            if (is_front_page() && ($menu_url === home_url('/') || $menu_url === home_url())) {
                $is_active = true;
            }

            // Build active class
            $active_class = $is_active ? 'active' : '';
            $menu[$m->ID] = array(
                'ID'       => $m->ID,
                'title'    => $m->title,
                'class'=>$active_class,
                'url'      => $m->url,
                'children' => populate_children_top_menu_1($menu_items, $m)
            );
        }
    }
    return $menu;
}
