<?php
// Custom Subscription Form

add_action('wp_ajax_custom_subscription_form', 'handle_custom_subscription_form');
add_action('wp_ajax_nopriv_custom_subscription_form', 'handle_custom_subscription_form');

function handle_custom_subscription_form()
{
    if (
        !isset($_POST['subscription_nonce']) ||
        !wp_verify_nonce($_POST['subscription_nonce'], 'subscription_form')
    ) {
        wp_send_json_error(['message' => __('Security check failed.', 'tusenrosor')]);
    }

    $email = sanitize_email($_POST['subscriber_email'] ?? '');
    $lang = sanitize_text_field($_POST['lang'] ?? 'sv'); // Swedish as default language

    if (empty($email)) {
        wp_send_json_error(['message' => __('Vänligen fyll i din e-postadress.', 'tusenrosor')]);
    }

    $get_subscribe_data = get_subscriber_information_fluentcrm();
    if (isset($get_subscribe_data["subscriber"]) && $get_subscribe_data["subscriber"]['status'] == "subscribed") {
        wp_send_json_error(['message' => __('Den här e-postadressen är redan prenumererad.', 'tusenrosor')]);
    }
    send_subscriber_information_fluentcrm("subscribe");
    wp_send_json_success(['message' => __('Tack! Du har framgångsrikt prenumererat.', 'tusenrosor')]);
}


function send_subscriber_information_fluentcrm($type)
{
    $crm_api_data = get_theme_option_data('crm_api_data');
    $api_username = $crm_api_data['username'];
    $api_password = $crm_api_data['password'];

    // API endpoint
    $url = site_url() . "/wp-json/fluent-crm/v2/subscribers";
    if ($type == "subscribe") {
        $data = [
            "email" => $_POST['subscriber_email'],
            "status" => "subscribed",
            "lists" => [10],
            "__force_update" => true,
        ];
    } else {
        $data = [
            "first_name" => $_POST['name'],
            "email" => $_POST['email'],
            "status" => "subscribed",
            "phone" => $_POST['phone'],
            "lists" => [7],
            "__force_update" => true,
            "custom_values" => [
                "message" => $_POST['message'],
            ],
        ];
    }
    // Subscriber data

    // Initialize cURL
    $ch = curl_init($url);

    // Set cURL options
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Basic " . base64_encode("$api_username:$api_password"),
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    // Execute request
    $response = curl_exec($ch);
}
function get_subscriber_information_fluentcrm()
{
    $crm_api_data = get_theme_option_data('crm_api_data');
    $api_username = $crm_api_data['username'];
    $api_password = $crm_api_data['password'];

    $url = site_url() . "/wp-json/fluent-crm/v2/subscribers/0?get_by_email=" . $_POST['subscriber_email'];
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Authorization: Basic " . base64_encode("$api_username:$api_password"),
        ],
    ]);

    $response = curl_exec($curl);

    curl_close($curl);
    return json_decode($response, true);
}
// Custom Subscription Form

// header search
function tusenrosor_ajax_search(WP_REST_Request $request)
{
    $keyword = sanitize_text_field($request->get_param('s'));
    $limit   = 12;

    if (empty($keyword)) {
        return rest_ensure_response([
            'keywords' => [],
            'products' => '',
        ]);
    }

    // Query WooCommerce products
    $args = [
        'post_type'      => 'product',
        'posts_per_page' => $limit,
        's'              => $keyword,
        'post_status'    => 'publish',
    ];

    $query = new WP_Query($args);

    ob_start();
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            global $product;
            $product = wc_get_product(get_the_ID());
            wc_get_template_part('content', 'product');
        }
    }
    wp_reset_postdata();
    $product_html = ob_get_clean();

    $titles = wp_list_pluck($query->posts, 'post_title');
    $keywords = array_unique(array_slice($titles, 0, 10));

    return rest_ensure_response([
        'keywords' => array_values($keywords),
        'products' => $product_html,
    ]);
}

//contact us
add_action('wp_ajax_custom_contact_form', 'handle_custom_contact_form');
add_action('wp_ajax_nopriv_custom_contact_form', 'handle_custom_contact_form');

function handle_custom_contact_form()
{
    if (
        !isset($_POST['sv_contact_nonce']) ||
        !wp_verify_nonce($_POST['sv_contact_nonce'], 'sv_contact_form')
    ) {
        wp_send_json_error(['message' => __('Security check failed.', 'tusenrosor')]);
    }

    $name = sanitize_text_field($_POST['name'] ?? '');
    $email = sanitize_email($_POST['email'] ?? '');
    $phone = sanitize_text_field($_POST['phone'] ?? '');
    $message = sanitize_textarea_field($_POST['message'] ?? '');
    $lang = sanitize_text_field($_POST['lang'] ?? 'sv');

    if (empty($name) || empty($email) || empty($message)) {
        wp_send_json_error(['message' => __('Vänligen fyll i alla obligatoriska fält.', 'tusenrosor')]);
    }

    send_subscriber_information_fluentcrm("contact");
    wp_send_json_success(['message' => __('Tack! Ditt meddelande har skickats', 'tusenrosor')]);
}
