<?php
if (!class_exists('ShopHelper')) {

   class ShopHelper
   {

      public static function init()
      {
         add_action('wp_ajax_filter_products', [__CLASS__, 'ajax_filter_products']);
         add_action('wp_ajax_nopriv_filter_products', [__CLASS__, 'ajax_filter_products']);
      }
      //render pagination
      public static function render_pagination($loop, $current_page = 1)
      {
         if ($loop->max_num_pages <= 1) return '';

         $base = get_pagenum_link(1);
         if (strpos($base, '?') || strpos($base, '&')) {
            // Fallback to query args if not using pretty permalinks
            $base = add_query_arg('paged', '%#%');
         } else {
            // Pretty permalinks
            $base = trailingslashit($base) . 'page/%#%/';
         }

         ob_start();
         echo '<nav class="woocommerce-pagination" aria-label="Product Pagination">';
         echo paginate_links([
            'base'      => $base,                // ✅ force correct URL pattern
            'format'    => '',
            'current'   => max(1, intval($current_page)),
            'total'     => $loop->max_num_pages,
            'type'      => 'list',
            'prev_text' => '←',
            'next_text' => '→',
         ]);
         echo '</nav>';
         return ob_get_clean();
      }

      // Render orderby dropdown options
      public static function render_orderby_filter()
      {

         $orderby_options = apply_filters(
            'woocommerce_catalog_orderby',
            [
               'menu_order' => __('Sortera efter: Bästsäljare', 'woocommerce'),
               'popularity' => __('Popularitet', 'woocommerce'),
               'rating'     => __('Bästa betyg', 'woocommerce'),
               'date'       => __('Sort by latest', 'woocommerce'),
               'discount-desc' => __('Högsta till lägsta rabatt', 'woocommerce'),
               'price'      => __('Lägsta till högsta pris: low to high', 'woocommerce'),
               'price-desc' => __('Högsta till lägsta pris: high to low', 'woocommerce'),
               'date' => __('Senaste', 'woocommerce'),
            ]
         );

         $current = isset($_GET['orderby']) ? wc_clean(wp_unslash($_GET['orderby'])) : 'menu_order';

         foreach ($orderby_options as $id => $name) {
            printf(
               '<option value="%s" %s>%s</option>',
               esc_attr($id),
               selected($current, $id, false),
               esc_html($name)
            );
         }
      }
      public static function get_total_products_count($args = [])
      {
         $filters = self::get_filters_from_url();
         
         // Base query setup
         $base_args = [
            'post_type'      => 'product',
            'fields'         => 'ids',
            'posts_per_page' => -1,
            'no_found_rows'  => true,
         ];

         // Start building safe normalized query
         $normalized = [];

         // ===========================
         // 🔹 Detect & normalize tax_query
         // ===========================
         $tax_query = [];
           $filterskeyPrepare = self::prepare_filter_tags($filters);
          $filters = !(empty($filterskeyPrepare)) ? $filterskeyPrepare : array();
 if (!empty($filters['product_cat'])) {
            $arraycat = array();
            foreach ($filters['product_cat'] as $cat) {
               $arraycat[] = $cat['value'];
            }
            $tax_query[] = [
               'taxonomy' => 'product_cat',
               'field' => 'slug',
               'terms' => (array) $arraycat,
            ];
         }
    
         // ✅ Color
         if (!empty($filters['pa_color'])) {
            $arraycolor = array();
            foreach ($filters['pa_color'] as $cat) {
              
               $arraycolor[] = $cat['value'];
            }
            $tax_query[] = [
               'taxonomy' => 'pa_color',
               'field' => 'slug',
               'terms' => (array) $arraycolor,
            ];
         }
         // Case 1: If 'tax_query' is explicitly defined
         if (isset($args['tax_query']) && is_array($args['tax_query'])) {
            $tax_query = $args['tax_query'];
         }

         // Case 2: If taxonomy arrays exist at any numeric index (like 2, 3, etc.)
         foreach ($args as $key => $value) {
            if (is_array($value) && isset($value['taxonomy']) && isset($value['terms'])) {
               $tax_query[] = $value;
            }
         }

         if (!empty($tax_query)) {
            $normalized['tax_query'] = $tax_query;
         }

         // ===========================
         // 🔹 Detect & normalize meta_query
         // ===========================
         if (isset($args['meta_query']) && is_array($args['meta_query'])) {
            $normalized['meta_query'] = $args['meta_query'];
         }

         // ===========================
         // 🔹 Detect & merge other supported args
         // ===========================
         $supported = ['post__in', 'post__not_in', 'author', 'orderby', 'order', 's'];
         foreach ($supported as $key) {
            if (isset($args[$key])) {
               $normalized[$key] = $args[$key];
            }
         }
         if ( isset($_GET['s']) && $_GET['s'] !== '' ) {
            $base_args['s'] = sanitize_text_field($_GET['s']);
         }
         // ===========================
         // ✅ Build & run query
         // ===========================
         $query_args = array_merge($base_args, $normalized);

         $query = new WP_Query($query_args);

         $total = (int) ($query->found_posts ?: count($query->posts));

         wp_reset_postdata();

         return $total;
      }

      // Handle AJAX product filtering
      protected static function build_query_args($filters = [],$post_per_page='36')
      {
        
         if($post_per_page=='all'){
            $post_per_page='-1';
           $args = [
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $post_per_page,
         
         ];
         }
         else{
            $args = [
            'post_type' => 'product',
            'post_status' => 'publish',
            'posts_per_page' => $post_per_page,
            'paged' => !empty($filters['page']) ? intval($filters['page']) : 1,
         ];
         }
         
         if (!empty($_GET)) {
            foreach ($_GET as $key => $value) {
               if (taxonomy_exists($key)) {
                  $values = is_array($value)
                     ? $value
                     : explode(',', $value);

                  $filters[$key] = array_map('sanitize_title', array_filter($values));
               }
            }
         }

         $term = get_queried_object();
         if (isset($term->term_id) && $term->term_id) {
            $currentterm = array($term->slug);
            $filters['product_cat'] = $currentterm;
         }
         $filterskeyPrepare = self::prepare_filter_tags($filters);
         // ✅ Sorting
         if (!empty($filters['orderby'])) {
            switch ($filters['orderby']) {
               case 'price':
                  $args['orderby']  = 'meta_value_num';
                  $args['order']    = 'ASC';
                  $args['meta_key'] = '_price';
                  break;

               case 'price-desc':
                  $args['orderby']  = 'meta_value_num';
                  $args['order']    = 'DESC';
                  $args['meta_key'] = '_price';
                  break;

               case 'rating':
                  $args['orderby']  = 'meta_value_num';
                  $args['meta_key'] = '_wc_average_rating';
                  $args['order']    = 'DESC';
                  break;

               case 'popularity':
                  $args['orderby']  = 'meta_value_num';
                  $args['meta_key'] = 'total_sales';
                  $args['order']    = 'DESC';
                  break;

               case 'date':
                  $args['orderby'] = 'date';
                  $args['order']   = 'DESC';
                  break;

               case 'discount-desc':
                  // Sort by discount amount (regular - sale)
                  global $wpdb;
                  $args['orderby'] = 'meta_value_num';
                  $args['order']   = 'DESC';
                  $args['meta_key'] = '_price'; // fallback
                  add_filter('posts_clauses', function ($clauses) use ($wpdb) {
                     $clauses['orderby'] = "CAST($wpdb->postmeta.meta_value AS DECIMAL(10,2)) ASC";
                     return $clauses;
                  });
                  break;

               default:
                  $args['orderby'] = 'menu_order title';
                  $args['order']   = 'ASC';
                  break;
            }
         }
        
         //print_r($args);
         $filters = !(empty($filterskeyPrepare)) ? $filterskeyPrepare : array();
         $meta_query = [];
         $tax_query = [];

         // ✅ Price
         if (isset($filters['price'][0]) && !empty($filters['price'][0])) {
            $prices = $filters['price'][0]['value'];
            //$min=isset($prices['min_price'])?
            $meta_query[] = [
               'key' => '_price',
               'value' => [
                  floatval($prices['min_price'] ?? 0),
                  floatval($prices['max_price'] ?? 999999),
               ],
               'compare' => 'BETWEEN',
               'type' => 'NUMERIC',
            ];
         }

         // ✅ On Sale
         if (!empty($filters['on_sale'])) {
            $args['post__in'] = wc_get_product_ids_on_sale();
         }

         // ✅ In Stock
         if (!empty($filters['in_stock'])) {
            $meta_query[] = [
               'key' => '_stock_status',
               'value' => 'instock',
            ];
         }

         // ✅ Category
         if (!empty($filters['product_cat'])) {
            $arraycat = array();
            foreach ($filters['product_cat'] as $cat) {
               $arraycat[] = $cat['value'];
            }
            $tax_query[] = [
               'taxonomy' => 'product_cat',
               'field' => 'slug',
               'terms' => (array) $arraycat,
            ];
         }

         // ✅ Color
         if (!empty($filters['pa_color'])) {
            $arraycolor = array();
            foreach ($filters['pa_color'] as $cat) {
               $arraycolor[] = $cat['value'];
            }
            $tax_query[] = [
               'taxonomy' => 'pa_color',
               'field' => 'slug',
               'terms' => (array) $arraycolor,
            ];
         }

         // ✅ Rating
       if (!empty($filters['rating'])) {

    $rating_or = ['relation' => 'OR'];

    foreach ($filters['rating'] as $r) {
        $rating = (int)$r['value'];

        switch ($rating) {
            case 5:
                $min = 4.5; $max = 5.1;
                break;
            case 4:
                $min = 3.5; $max = 4.5;
                break;
            case 3:
                $min = 2.5; $max = 3.5;
                break;
            case 2:
                $min = 1.5; $max = 2.5;
                break;
            case 1:
                $min = 0.5; $max = 1.5;
                break;
            default:
                continue 2;
        }

        $rating_or[] = [
            'key'     => '_wc_average_rating',
            'value'   => [$min, $max],
            'compare' => 'BETWEEN',
            'type'    => 'DECIMAL(3,2)',
        ];
    }

    $meta_query[] = $rating_or;
}
         if ( isset($_GET['s']) && $_GET['s'] !== '' ) {
            $args['s'] = sanitize_text_field($_GET['s']);
         }
         if ( isset($_POST['s']) && $_POST['s'] !== '' ) {
            $args['s'] = sanitize_text_field($_POST['s']);
         }
         if (!empty($tax_query)) $args['tax_query'] = $tax_query;
         if (!empty($meta_query)) $args['meta_query'] = $meta_query;
         //print_r($args);
         //print_r($filters['price']);

         return $args;
      }

      /**
       * Get available terms for a taxonomy based on current visible products
       */
      protected static function get_terms_for_results($taxonomy, $query_args = [])
      {
         // If taxonomy is product_cat, always return all visible categories


         // If no filters passed, just return all terms of that taxonomy

         return get_terms([
            'taxonomy'   => $taxonomy,
            'parent'=>0,
            'hide_empty' => true,
         ]);


         // // Ensure post type is product
         // if (empty($query_args['post_type'])) {
         //    $query_args['post_type'] = 'product';
         // }

         // // Run the query to get matching product IDs
         // $query = new WP_Query(array_merge($query_args, [
         //    'fields'         => 'ids',          // returns array of integers
         //    'posts_per_page' => -1,
         //    'no_found_rows'  => true,
         // ]));

         // $ids = (array) $query->posts; // safe cast to array of integers

         // // No results? return empty array
         // if (empty($ids)) {
         //    wp_reset_postdata();
         //    return [];
         // }

         // wp_reset_postdata();

         // // Get only terms from products that matched criteria
         // $terms = wp_get_object_terms($ids, $taxonomy, [
         //    'hide_empty' => true,
         // ]);

         return is_array($terms) ? $terms : [];
      }



      /**
       * Get dynamic min & max price
       */
      public static function get_price_range($query_args = [])
      {
         global $wpdb;

         // When filters are passed (filtered query)
         if (!empty($query_args)) {


            // ✅ WP_Query with 'fields' => 'ids' returns an array of integers directly
            $ids = self::get_filtered_product_ids($query_args);

            // ✅ Defensive check: ensure IDs are valid integers
            $ids = array_filter($ids, 'is_numeric');

            if (empty($ids)) {
               wp_reset_postdata();
               return [0, 0];
            }

            wp_reset_postdata();

            // ✅ Prepare placeholders safely
            $placeholders = implode(',', array_fill(0, count($ids), '%d'));
            $sql = "
            SELECT 
                MIN(CAST(meta_value AS DECIMAL(10,2))) AS min_price,
                MAX(CAST(meta_value AS DECIMAL(10,2))) AS max_price
            FROM {$wpdb->postmeta}
            WHERE meta_key = '_price'
              AND post_id IN ($placeholders)
        ";

            // ✅ Use $wpdb->prepare() correctly
            $prepared = $wpdb->prepare($sql, $ids);
            $row = $wpdb->get_row($prepared, ARRAY_A);

            return [
               isset($row['min_price']) ? (float) $row['min_price'] : 0,
               isset($row['max_price']) ? (float) $row['max_price'] : 0,
            ];
         }

         // When no query args (default shop)
         $prices = $wpdb->get_row("
        SELECT 
            MIN(CAST(meta_value AS DECIMAL(10,2))) AS min_price,
            MAX(CAST(meta_value AS DECIMAL(10,2))) AS max_price
        FROM {$wpdb->postmeta}
        WHERE meta_key = '_price'
    ");

         return [
            isset($prices->min_price) ? (float) $prices->min_price : 0,
            isset($prices->max_price) ? (float) $prices->max_price : 0,
         ];
      }


      /**
       * Generate full accordion HTML dynamically
       */
      public static function get_statusCategories()
      {
         $statusCategories = [
            ['label' => esc_html(__('Endast i lager', 'tusenrosor')), 'id' => '1', 'key' => 'in_stock'],
            ['label' => esc_html(__('På rea', 'tusenrosor')), 'id' => '2', 'key' => 'on_sale']
         ];
         return $statusCategories;
      }
      public static function get_filter_collection($args = array())
      {
         // Get filters from URL (like ?product_cat=rose)
         $filters = self::get_filters_from_url();
         $getAvailablecat = array();
         if (!empty($args)) {
            $filters = $args;
         }
         if (!empty($filters)) {

            $getFilteredCats = self::wps_get_related_unique_terms($filters, 'product_cat');
            if (!empty($getFilteredCats))
               foreach ($getFilteredCats as $cterm) {
                  $getAvailablecat[] = $cterm->term_id;
               }
         }


         // Load all visible product categories
         $collections = self::get_terms_for_results('product_cat', $filters);

         // Store selected term slugs
         $selected_terms = [];

         // 1️⃣ From URL (?product_cat=rose)
         if (!empty($filters['product_cat'])) {
            $selected_terms = array_map('sanitize_title', (array)$filters['product_cat']);
         }
         
         //  print_r($selected_terms);
         // 2️⃣ From $args (handle both 'terms' key or full tax_query format)


         $selected_terms = array_unique(array_filter($selected_terms));
?>

         <?php foreach ($collections as $i => $term): ?>
            <?php $is_checked = in_array($term->slug, $selected_terms, true) ? 'checked' : ''; ?>
            <label class="px-4 md:px-8 lg:px-0 flex items-center py-1.5 space-x-3 cursor-pointer <?php echo (!empty($getAvailablecat) && !in_array($term->term_id, $getAvailablecat)) ? 'opacity-50 pointer-events-none' : ''; ?>"
               for="collection<?php echo $i + 1; ?>">
               <input id="collection<?php echo $i + 1; ?>" type="checkbox" value="<?php echo esc_attr($term->slug); ?>"
                  data-filter="product_cat" <?php echo $is_checked; ?>>
               <span><?php echo esc_html($term->name); ?></span>
            </label>
         <?php endforeach; ?>

         <?php
      }


      public static function get_filter_farg($args = array())
      {
         $filters = self::get_filters_from_url();
         $colors      = self::get_terms_for_results('pa_color', $args);
         $getAvailablecolor = array();
         if (!empty($args)) {
            $filters = $args;
         }
         if (!empty($filters)) {

            $getFilteredColors = self::wps_get_related_unique_terms($filters, 'pa_color');
            if (!empty($getFilteredColors))
               foreach ($getFilteredColors as $fterm) {
                  $getAvailablecolor[] = $fterm->term_id;
               }
         }
         //print_r($getFilteredColors);
         // print_r($getAvailablecolor);

         foreach ($colors as $i => $term): ?>
            <div>
               <input id="color<?php echo $i + 1; ?>" type="checkbox" class="hidden peer"
                  value="<?php echo esc_attr($term->slug); ?>" data-filter="pa_color"
                  <?php echo (!empty($filters['pa_color']) && in_array($term->slug, $filters['pa_color'])) ? 'checked' : ''; ?>>
               <label for="color<?php echo $i + 1; ?>"
                  class="min-h-[78px] p-1 border border-[#EBEBEB] flex flex-col items-center justify-center space-y-1 cursor-pointer text-center duration-400 peer-checked:border-(--theme-color) hover:border-(--theme-color) <?php echo (!empty($getAvailablecolor) && !in_array($term->term_id, $getAvailablecolor)) ? 'opacity-50 pointer-events-none' : ''; ?>">
                  <?php
                  $image_id = get_term_meta($term->term_id, 'term_image_id', true);

                  ?>
                  <?php echo wp_get_attachment_image($image_id, 'full', false, [
                     'class' => 'max-w-9 w-full h-9 mb-1 mx-auto object-contain',
                     'alt' => 'Cat Image'
                  ]);
                  ?>

                  <span><?php echo esc_html($term->name); ?></span>
               </label>
            </div>
         <?php endforeach;
      }
    public static  function get_rating_counts() {
    global $wpdb;

    $rating_counts = [
        5 => 0,
        4 => 0,
        3 => 0,
        2 => 0,
        1 => 0,
    ];

    foreach ([5,4,3,2,1] as $rating) {

        // Define rating bucket ranges (WooCommerce style)
        switch ($rating) {
            case 5:
                $min = 4.5; $max = 5.1;
                break;
            case 4:
                $min = 3.5; $max = 4.5;
                break;
            case 3:
                $min = 2.5; $max = 3.5;
                break;
            case 2:
                $min = 1.5; $max = 2.5;
                break;
            case 1:
                $min = 0.5; $max = 1.5;
                break;
        }
// echo $sql = $wpdb->prepare("
//     SELECT COUNT(pm.post_id)
//     FROM {$wpdb->postmeta} pm
//     INNER JOIN {$wpdb->posts} p ON p.ID = pm.post_id
//     WHERE pm.meta_key = '_wc_average_rating'
//       AND pm.meta_value != '0'
//       AND CAST(pm.meta_value AS DECIMAL(3,2)) >= %f
//       AND CAST(pm.meta_value AS DECIMAL(3,2)) < %f
//       AND p.post_type = 'product'
//       AND p.post_status = 'publish'
// ", $min, $max);
        // Count products in this rating bucket
        $rating_counts[$rating] = (int) $wpdb->get_var($wpdb->prepare("
            SELECT COUNT(pm.post_id)
            FROM {$wpdb->postmeta} pm
            INNER JOIN {$wpdb->posts} p ON p.ID = pm.post_id
            WHERE pm.meta_key = '_wc_average_rating'
              AND pm.meta_value != '0'
              AND CAST(pm.meta_value AS DECIMAL(3,2)) >= %f
              AND CAST(pm.meta_value AS DECIMAL(3,2)) < %f
              AND p.post_type = 'product'
              AND p.post_status = 'publish'
        ", $min, $max));
    }

    return $rating_counts;
}

      public static function get_filter_rating($args = [])
      {
         // return '';
         global $wpdb;
         $ratings = [5, 4, 3, 2, 1];
         $theme_uri = get_template_directory_uri();

         // 🔹 Build rating counts from actual WooCommerce product ratings
         $rating_counts = [];
         $filters = self::get_filters_from_url();
         if (empty($args)) {
           $rating_counts=self::get_rating_counts();
         } else {
            $filters = $args;
          
            //print_r($filters);
            // print_r($rating_counts);
            $rating_counts = self::get_filtered_rating_counts($filters);
         }



         // 🔹 Output dynamic HTML (preserve your design 100%)
         foreach ($ratings as $r):
            $checked = (!empty($filters['rating']) && in_array((string) $r, (array) $filters['rating'])) ? 'checked' : '';
         ?>
            <label for="rating<?php echo esc_attr($r); ?>"
               class="px-4 md:px-8 lg:px-0 flex items-center py-1.5 space-x-3 cursor-pointer opacity-50 <?php if (!$rating_counts[$r]) echo 'pointer-events-none'; ?>">
               <input id="rating<?php echo esc_attr($r); ?>" type="checkbox" class="peer" value="<?php echo esc_attr($r); ?>"
                  data-filter="rating" <?php echo $checked; ?>>
               <div class="flex items-center space-x-1">
                  <?php
                  $full = $r;
                  $empty = 5 - $r;
                  for ($j = 0; $j < $full; $j++) {
                     echo '<img class="w-6 h-6 object-contain" src="' . esc_url($theme_uri . '/assets/images/starFull.svg') . '" alt="Full Star">';
                  }
                  for ($j = 0; $j < $empty; $j++) {
                     echo '<img class="w-6 h-6 object-contain" src="' . esc_url($theme_uri . '/assets/images/starBlank.svg') . '" alt="Empty Star">';
                  }
                  ?>
               </div>
               <span class="ml-auto">(<?php echo esc_html($rating_counts[$r] ?? 0); ?>)</span>
            </label>
         <?php
         endforeach;
      }
      public static function get_filter_price_range_min_max($args = array())
      {
         if (empty($args)) {
            $filters = self::get_filters_from_url();
         } else {
            $filters = $args;
         }
         [$minPrice, $maxPrice] = self::get_price_range($filters);
         $data['min'] = $minPrice;
         $data['max'] = $maxPrice;
         return $data;
      }
      public static function get_filter_price_range($args = array())
      {

         if (empty($args)) {
            $filters = self::get_filters_from_url();
         } else {
            $filters = $args;
         }
         [$minPrice, $maxPrice] = self::get_price_range($filters);
         //  print_r(self::get_price_range($filters));
         ?>



         <div class="relative mb-4.5">
            <div class="relative h-[3px] rounded-full bg-black/20 overflow-hidden">
               <div class="progressBar absolute inset-0 h-[3px] rounded-full bg-(--theme-color) overflow-hidden"></div>
            </div>
            <button
               class="thumbLeft absolute left-0 -top-2 cursor-pointer range-thumb h-5 w-5 bg-transparent border-0 flex justify-start items-center">
               <span class="rounded-full w-2.5 h-2.5 bg-(--theme-color) overflow-hidden inline-block"></span>
            </button>
            <button
               class="thumbRight absolute right-0 -top-2 cursor-pointer range-thumb h-5 w-5 bg-transparent border-0 flex justify-end items-center">
               <span class="rounded-full w-2.5 h-2.5 bg-(--theme-color) overflow-hidden inline-block"></span>
            </button>
         </div>
         <div class="space-x-3 flex items-center">
            <div class="relative w-full">
               <label for="minValue" class="cursor-pointer absolute inset-y-0 left-0 px-2 flex items-center lastest">Kr</label>
               <input id="defMinvalue" type="hidden" value="<?php echo  (int)($minPrice); ?>">
               <input id="defMaxvalue" type="hidden" value="<?php echo  (int)($maxPrice); ?>">
               <input value="<?php echo  floor($minPrice); ?>" id="minValue" name=""
                  class="focus:border-(--theme-color) w-full border border-[#3030301F] rounded-0 p-2 min-h-9 bg-transparent text-right outline-none shadow-none [-moz-appearance:textfield] [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none"
                  type="number">
            </div>
            <span><?php echo esc_html(__('till', 'tusenrosor')); ?></span>
            <div class="relative w-full">
               <label for="maxValue" class="cursor-pointer absolute inset-y-0 left-0 px-2 flex items-center">kr</label>
               <input value="<?php echo  ceil($maxPrice); ?>" id="maxValue" name=""
                  class="focus:border-(--theme-color) w-full border border-[#3030301F] rounded-0 p-2 min-h-9 bg-transparent text-right outline-none shadow-none [-moz-appearance:textfield] [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none"
                  type="number">
            </div>
         </div>

      <?php
      }


      public static function get_filters_from_url()
      {
         $filters = [];

         // Taxonomies (e.g. product_cat, pa_color, etc.)
         foreach ($_GET as $key => $value) {
            if (taxonomy_exists($key)) {
               $values = is_array($value)
                  ? $value
                  : explode(',', $value);

               $filters[$key] = array_map('sanitize_title', array_filter($values));
            }
         }
         $term = get_queried_object();
         if (isset($term->term_id) && $term->term_id) {
            $currentterm = array($term->slug);
            $filters['product_cat'] = $currentterm;
         }
         // Price range
         // if (isset($_GET['min_price']) || isset($_GET['max_price'])) {
         //    $filters['min_price'] = isset($_GET['min_price']) ? floatval($_GET['min_price']) : 0;
         //    $filters['max_price'] = isset($_GET['max_price']) ? floatval($_GET['max_price']) : 999999;
         // }

         // On Sale and In Stock — always arrays
         if (!empty($_GET['on_sale'])) {
            $filters['on_sale'] = ['on'];
         }
         if (!empty($_GET['in_stock'])) {
            $filters['in_stock'] = ['on'];
         }
         if ( isset($_GET['s']) && $_GET['s'] !== '' ) {
            $filters['s'] = sanitize_text_field($_GET['s']);
         }
         // Rating — array of ints
         if (!empty($_GET['rating'])) {
            $filters['rating'] = array_map('intval', explode(',', $_GET['rating']));
         }
         if (!empty($filters)) {
            $filters['action'] = 'filter_products';
         }



         return $filters;
        
      }
      public static function wps_get_related_unique_terms($filters,  $target_tax)
      {
         // Get term object for filter
         $args = self::build_query_args($filters,'all');
      
         $args['fields'] = 'ids';
         $args['posts_per_page'] = -1;
         $args['no_found_rows'] = true;

         $query = new WP_Query($args);
         $product_ids = (array) $query->posts;
         wp_reset_postdata();

        
         if (empty($product_ids)) return [];
         $child_terms = wp_get_object_terms($product_ids, $target_tax, [
               'orderby' => 'name',
               'order'   => 'ASC',
               'fields'  => 'ids',  // Get only term IDs
            ]);
         // Now get unique target terms (like categories or pa_color)
      if (empty($child_terms)) {
        return [];
    }
  

    // Now get parent categories of those child categories
        $root_parent_terms = [];
    foreach ($child_terms as $child_term_id) {
        // Get the parent term for each child term
          $current_term = get_term($child_term_id, $target_tax);
        
        // Traverse up the hierarchy to get the root parent term
        while ($current_term->parent != 0) {
            $current_term = get_term($current_term->parent, $target_tax);
        }

        // Now $current_term should be the root parent category
        if (!in_array($current_term->term_id, $root_parent_terms)) {
            $root_parent_terms[] = $current_term->term_id;
        }
    }


    // Remove duplicates using array_unique to ensure each root parent is only listed once
    $root_parent_terms = array_unique($root_parent_terms);

    // Now, get all root parent categories (if not already in the root_parent_terms array)
    $root_parent_categories = get_terms([
        'taxonomy'   => $target_tax,
        'include'    => $root_parent_terms,
        'orderby'    => 'name',
        'order'      => 'ASC',
        'hide_empty' => false, // Include even categories with no products
    ]);

         return $root_parent_categories;

         // Make sure we remove duplicates (wp_get_object_terms does this by default)
       
      }
      public static function render_active_filters()
      {
         $filters = self::get_filters_from_url();

         if (empty($filters)) return;
      ?>

         <a href="<?php echo esc_url(get_permalink(wc_get_page_id('shop'))); ?>"
            class="flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400">
            <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path
                  d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                  stroke="currentcolor" stroke-linecap="round"></path>
            </svg>
            <span><?php echo esc_html(__('Rensa filter', 'tusenrosor')) ?></span>
         </a>
         <?php
         foreach ($filters as $key => $val) {
          
            if (is_array($val) && $key !== 'price' && $key === 's') {
               
               foreach ($val as $slug) {
                  $term = get_term_by('slug', $slug, $key);
                  $label = $term ? $term->name : ucfirst($slug);
         ?>
                  <a href="#"
                     class="flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400 remove-filter"
                     data-type="<?php echo esc_attr($key); ?>" data-value="<?php echo esc_attr($slug); ?>">
                     <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path
                           d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                           stroke="currentcolor" stroke-linecap="round"></path>
                     </svg>
                     <span><?php echo esc_html($label); ?></span>
                  </a>
               <?php
               }
            } elseif ($key === 'price') {
               //print_r($val);
               // $prices=$val['']
               ?>
               <a href="#"
                  class="flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400 remove-price-filter"
                  data-type="<?php echo esc_attr($key); ?>" data-min="<?php echo esc_attr($slug); ?>">
                  <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path
                        d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                        stroke="currentcolor" stroke-linecap="round"></path>
                  </svg>
                  <span><?php echo esc_html($label); ?></span>
               </a>
         <?php
               // handled below once
            } elseif ($key === 's') {
               //print_r($val);
               // $prices=$val['']
               ?>
               <a href="#"
                  class="flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400 remove-filter"
                  data-type="<?php echo esc_attr($key); ?>" data-val="<?php echo esc_attr($val); ?>">
                  <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                     <path
                        d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                        stroke="currentcolor" stroke-linecap="round"></path>
                  </svg>
                  <input type="hidden" name="search" id="searchkey" value="<?php echo esc_html($val); ?>">
                  <span><?php echo esc_html($val); ?></span>
               </a>
         <?php
               // handled below once
            }
         }



         ?>

         <?php
      }

      /**
       * AJAX: Main handler for filters and products
       */
      public static function prepare_filter_tags($filters = [])
      {
         $output = [];

         foreach ($filters as $key => $values) {
            if (!is_array($values)) continue;
            $output[$key] = [];

            foreach ($values as $val) {
               switch ($key) {
                  case 'in_stock':
                     if ($val === 'on') {
                        $output[$key][] = [
                           'label' => __('Endast i lager', 'tusenrosor'),
                           'value' => 'on'
                        ];
                     }
                     break;

                  case 'on_sale':
                     if ($val === 'on') {
                        $output[$key][] = [
                           'label' => __('På rea', 'tusenrosor'),
                           'value' => 'on'
                        ];
                     }
                     break;

                  case 'product_cat':
                     $term = get_term_by('slug', $val, 'product_cat');
                     if ($term && !is_wp_error($term)) {
                        $output[$key][] = [
                           'label' => $term->name,
                           'value' => $val
                        ];
                     }
                     break;

                  case 'rating':
                     $output[$key][] = [
                        'label' => 'Rating ' . intval($val),
                        'value' => intval($val)
                     ];
                     break;

                  default:
                     // Handle attributes like pa_color, pa_size, etc.
                     if (strpos($key, 'pa_') === 0) {
                        $term = get_term_by('slug', $val, $key);
                        if ($term && !is_wp_error($term)) {
                           $output[$key][] = [
                              'label' => $term->name,
                              'value' => $val
                           ];
                        }
                     }
                     break;
               }
            }
         }
         if (isset($filters['min_price']) && isset($filters['max_price'])) {
            $min = floatval($filters['min_price']);
            $max = floatval($filters['max_price']);

            // only add if range is valid
            if ($min > 0 || $max > 0) {
               $output['price'] = [[
                  'label' => sprintf('%s kr - %s kr', number_format_i18n($min, 0), number_format_i18n($max, 0)),
                  'value' => [
                     'min_price' => $min,
                     'max_price' => $max
                  ],
               ]];
            }
         }
         return $output;
      }

      public static function ajax_filter_products()
      {


         $filters = $_POST;

         $query_args = self::build_query_args($filters);
         $loop = new WP_Query($query_args);

         // Products
         ob_start();
         if ($loop->have_posts()) :
            while ($loop->have_posts()) : $loop->the_post();
               wc_get_template_part('content', 'product');
            endwhile;
         else :
            echo '<div class="m-1.5 w-full flex items-center justify-center min-h-50">
   <div class="woocommerce-no-products-found">
	<div class="woocommerce-info" role="status">
		' . esc_html(__('Inga produkter hittades.', 'tusenrosor')) . '	</div>
</div></div>';
         endif;
         wp_reset_postdata();
         $products_html = ob_get_clean();

         // Accordion filters
         ob_start();
         self::get_filter_price_range($filters);
         $accordion_price_html = ob_get_clean();
         ob_start();
         self::get_filter_farg($filters);
         $accordion_farg_html = ob_get_clean();
         ob_start();
         self::get_filter_collection($filters);
         $accordion_collection_html = ob_get_clean();
         ob_start();
         self::get_filter_rating($filters);
         $accordion_rating_html = ob_get_clean();
         $current_page = !empty($_POST['page']) ? intval($_POST['page']) : 1;
         $pagination_html = self::render_pagination($loop, $current_page);
         //$pagination_html = self::render_pagination($loop);
         // Active filters
         ob_start();
         $filters = self::prepare_filter_tags($filters);
         if (!empty($filters) || isset($_POST['s']) && $_POST['s']) {
         ?>


            <a href="#"
               class="clear-all flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400">
               <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path
                     d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                     stroke="currentcolor" stroke-linecap="round" />
               </svg>
               <span><?php echo esc_html(__('Rensa filter', 'tusenrosor')) ?></span>
            </a>
            <?php
            foreach ($filters as $key => $values):



               if (is_array($values)) {
                  //if($key ==)
                  foreach ($values as $val): ?>
                     <?php if ($key !== 'price') { ?>
                        <a href="#"
                           class="remove-filter flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400"
                           data-type="<?php echo esc_attr($key); ?>" data-value="<?php echo esc_attr($val['value']); ?>">
                           <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path
                                 d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                                 stroke="currentcolor" stroke-linecap="round" />
                           </svg>
                           <span><?php echo esc_html($val['label']); ?></span>
                        </a>
                     <?php } else if ($key == 'price') {
                        $prices = $val['value'];
                     ?>
                        <a href="#"
                           class="remove-price-filter flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400"
                           data-type="<?php echo esc_attr($key); ?>" data-max="<?php echo esc_attr($prices['max_price']); ?>"
                           data-min="<?php echo esc_attr($prices['min_price']); ?>">
                           <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path
                                 d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                                 stroke="currentcolor" stroke-linecap="round" />
                           </svg>
                           <span><?php echo esc_html($val['label']); ?></span>
                        </a>
                     <?php } ?>
               <?php endforeach;
               } ?>

         <?php
            endforeach;
            if(isset($_POST['s']) && $_POST['s']){ ?>
<a href="#"
                           class="remove-filter flex items-center space-x-2 md:space-x-2.5 border border-[#EBEBEB] min-h-8 md:min-h-9 px-3 md:px-4 py-1 m-1 md:m-[5px] text-(--sub-text) hover:border-(--theme-color) hover:text-(--theme-color) duration-400"
                           data-type="<?php echo esc_attr($key); ?>" data-val="<?php echo esc_attr($_POST['s']); ?>">
                           <svg class="h-3 w-3 md:h-4 md:w-4" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path
                                 d="M2.85693 2.85712L7.99979 7.99997M7.99979 7.99997L13.1426 13.1428M7.99979 7.99997L13.1426 2.85712M7.99979 7.99997L2.85693 13.1428"
                                 stroke="currentcolor" stroke-linecap="round" />
                           </svg>
                            <input type="hidden" name="search" id="searchkey" value="<?php echo esc_html($_POST['s']); ?>">
                           <span><?php echo esc_html($_POST['s']); ?></span>
                        </a>
           <?php }
         }
         ?>

<?php
         $tags_html = ob_get_clean();

         wp_send_json_success([
            'products' => $products_html,
            'accordion_price' => $accordion_price_html,
            'accordion_collection' => $accordion_collection_html,
            'total_product' => $loop->found_posts,
            'accordion_farg' => $accordion_farg_html,
            'accordion_rating' => $accordion_rating_html,
            'pagination' => $pagination_html,
            'tags' => $tags_html,
         ]);
      }

      //prepare filterd data
      /**
       * Build filtered product IDs based on current filters (URL or AJAX)
       */
      protected static function get_filtered_product_ids($filters = [])
      {
         $args = self::build_query_args($filters,'all');
         $args['fields'] = 'ids';
         $args['posts_per_page'] = -1;
         $args['no_found_rows'] = true;

         $query = new WP_Query($args);
         $ids = (array) $query->posts;
         wp_reset_postdata();

         return array_map('intval', $ids);
      }

      /**
       * Get rating counts for products that match other filters (pa_color, cat, etc.)
       */
      protected static function get_filtered_rating_counts($filters = [])
      {
         global $wpdb;

         // Step 1: Get all filtered product IDs first
         $ids = self::get_filtered_product_ids($filters);

         if (empty($ids)) {
            return [5 => 0, 4 => 0, 3 => 0, 2 => 0, 1 => 0];
         }

         // Step 2: Prepare safe placeholders for SQL
         $placeholders = implode(',', array_fill(0, count($ids), '%d'));

         // Step 3: Query meta table for these products’ average ratings
         $sql = "
        SELECT 
            ROUND(CAST(meta_value AS DECIMAL(2,1))) AS rating,
            COUNT(post_id) AS product_count
        FROM {$wpdb->postmeta}
        WHERE meta_key = '_wc_average_rating'
          AND post_id IN ($placeholders)
        GROUP BY ROUND(CAST(meta_value AS DECIMAL(2,1)))
        ORDER BY rating DESC
    ";
         $prepared = $wpdb->prepare($sql, $ids);
         $rows = $wpdb->get_results($prepared, ARRAY_A);

         // Step 4: Prepare final counts for 5→1
         $counts = [5 => 0, 4 => 0, 3 => 0, 2 => 0, 1 => 0];
         foreach ($rows as $r) {
            $rating = intval($r['rating']);
            if (isset($counts[$rating])) {
               $counts[$rating] = intval($r['product_count']);
            }
         }

         return $counts;
      }

      /**
       * Get visible categories (collections) based on current filters
       */
      protected static function get_filtered_collections($filters = [])
      {
         $ids = self::get_filtered_product_ids($filters);
         if (empty($ids)) return [];

         $terms = wp_get_object_terms($ids, 'product_cat', ['hide_empty' => true]);
         return is_array($terms) ? $terms : [];
      }

      /**
       * Get visible colors based on current filters
       */
      protected static function get_filtered_colors($filters = [])
      {
         $ids = self::get_filtered_product_ids($filters);
         if (empty($ids)) return [];

         $terms = wp_get_object_terms($ids, 'pa_color', ['hide_empty' => true]);
         return is_array($terms) ? $terms : [];
      }

      /**
       * Get min/max price dynamically based on filtered products
       */
      protected static function get_filtered_price_range($filters = [])
      {
         global $wpdb;

         $ids = self::get_filtered_product_ids($filters);
         if (empty($ids)) return [0, 0];

         $placeholders = implode(',', array_fill(0, count($ids), '%d'));
         $sql = "
        SELECT 
            MIN(CAST(meta_value AS DECIMAL(10,2))) AS min_price,
            MAX(CAST(meta_value AS DECIMAL(10,2))) AS max_price
        FROM {$wpdb->postmeta}
        WHERE meta_key = '_price'
          AND post_id IN ($placeholders)
    ";
         $prepared = $wpdb->prepare($sql, $ids);
         $row = $wpdb->get_row($prepared, ARRAY_A);

         return [
            isset($row['min_price']) ? (float)$row['min_price'] : 0,
            isset($row['max_price']) ? (float)$row['max_price'] : 0,
         ];
      }

      //prepare filterd data




   }

   ShopHelper::init();
}
add_filter('loop_shop_per_page', function () {
   return 36; // show 3 products per page
}, 20);
add_action('woocommerce_product_query', function ($q) {
   if (is_admin()) return;

   $tax_query  = (array) $q->get('tax_query');
   $meta_query = (array) $q->get('meta_query');

   // =========================
   // 1) pa_farg attribute filter
   // =========================
   if (!empty($_GET['pa_color'])) {
      $terms = is_array($_GET['pa_color']) ? $_GET['pa_color'] : explode(',', $_GET['pa_color']);
      $terms = array_map('sanitize_title', array_map('urldecode', $terms));
      $terms = array_filter($terms);

      if (!empty($terms)) {
         $tax_query[] = [
            'taxonomy' => 'pa_color',
            'field'    => 'slug',
            'terms'    => $terms,
            'operator' => 'AND',
         ];
      }
   }

   // =========================
   // 2) In-stock filter
   // =========================
   if (!empty($_GET['in_stock'])) {
      $meta_query[] = [
         'key'   => '_stock_status',
         'value' => 'instock',
      ];
   }

   // =========================
   // 3) On-sale filter
   // =========================
   if (!empty($_GET['on_sale'])) {
      $on_sale_ids = wc_get_product_ids_on_sale();
      if (!empty($on_sale_ids)) {
         $post__in = (array) $q->get('post__in');
         $q->set('post__in', array_unique(array_merge([0], $post__in, $on_sale_ids)));
      }
   }

   // =========================
   // 4) Price range filter
   // =========================
   $min = isset($_GET['min_price']) ? (float) $_GET['min_price'] : null;
   $max = isset($_GET['max_price']) ? (float) $_GET['max_price'] : null;
   if ($min !== null || $max !== null) {
      $meta_query[] = [
         'key'     => '_price',
         'value'   => [$min ?? 0, $max ?? PHP_INT_MAX],
         'compare' => 'BETWEEN',
         'type'    => 'NUMERIC',
      ];
   }

   // =========================
   // 5) Rating filter
   // =========================
   if (!empty($_GET['rating'])) {
      $ratings = is_array($_GET['rating']) ? $_GET['rating'] : [$_GET['rating']];
      $ratings = array_map('intval', $ratings);

      $rating_or = ['relation' => 'OR'];
      foreach ($ratings as $r) {
         $rating_or[] = [
            'key'     => '_wc_average_rating',
            'value'   => $r,
            'compare' => '>=',
            'type'    => 'NUMERIC',
         ];
      }
      $meta_query[] = $rating_or;
   }

   // =========================
   // Apply tax & meta queries
   // =========================
   if (!empty($tax_query)) {
      if (!isset($tax_query['relation'])) $tax_query['relation'] = 'AND';
      $q->set('tax_query', $tax_query);
   }

   if (!empty($meta_query)) {
      if (!isset($meta_query['relation'])) $meta_query['relation'] = 'AND';
      $q->set('meta_query', $meta_query);
   }
});
