   jQuery(document).ready(function($) {
    const isCartPage = $('body').hasClass('woocommerce-cart');
  // Store in cookie (so PHP can read it on AJAX)
   // Optional: Also store in localStorage for debugging
  document.cookie = `wc_is_cart_page=${isCartPage ? '1' : '0'}; path=/; max-age=600`;
  localStorage.setItem('wc_is_cart_page', isCartPage ? '1' : '0');
   const isCheckoutPage = $('body').hasClass('woocommerce-checkout');
  document.cookie = `wc_is_checkout_page=${isCheckoutPage ? '1' : '0'}; path=/; max-age=600`;
  localStorage.setItem('wc_is_checkout_page', isCheckoutPage ? '1' : '0');
    $(document).on('click', '.orderNoteBtn', function(e) {
                $('#defaultShow').addClass('hidden');
                $('#orderNoteContainer').removeClass('hidden');
                 $('#cartdefaultShow').addClass('hidden');
                $('#cartorderNoteContainer').removeClass('hidden');
            });
        
               $(document).on('click', '.noteSaveBtn', function(e) {
                $('#orderNoteContainer').addClass('hidden');
                $('#defaultShow').removeClass('hidden');
                $('#cartorderNoteContainer').addClass('hidden');
                $('#cartdefaultShow').removeClass('hidden');
            });

            // ➕➖ Increment / decrement
            $(document).on('click', '.qty-inc, .qty-dec', function() {
                const wrapper = $(this).closest('.cartItem');
                const input = wrapper.find('.qty-input');
                const max = parseInt(input.attr('max')) || 9999;
                let qty = parseInt(input.val());
                qty = $(this).hasClass('qty-inc') ? Math.min(qty + 1, max) : Math.max(1, qty - 1);
                input.val(qty).trigger('change');
            });
            let updateTimer = null;
            let ajaxInProgress = false;

            // 🔹 Add loader overlay in minicart
            function showMiniCartLoader() {
              if ($('.miniCartLoader').length === 0) {
                $('.cartSection').append(`
                  <div class="miniCartLoader absolute inset-0 bg-white/60 flex items-center justify-center z-50">
                    <div class="loader w-8 h-8 border-4 border-(--theme-maroon) border-t-transparent rounded-full animate-spin"></div>
                  </div>
                `);
              }
            }

            function hideMiniCartLoader() {
              $('.miniCartLoader').remove();
            }
            // 🧮 Live quantity update
            $(document).on('change', '.qty-input', function () {
            const key = $(this).closest('.cartItem').data('key');
            const qty = $(this).val();

            if (!key || qty < 1) return;

            clearTimeout(updateTimer);
            updateTimer = setTimeout(() => {
              if (ajaxInProgress) return; // prevent overlapping requests
              ajaxInProgress = true;
              showMiniCartLoader();

              $.ajax({
                url: wc_cart_params.ajax_url,
                type: 'POST',
                data: {
                  action: 'woocommerce_update_cart_item',
                  cart_item_key: key,
                  quantity: qty
                },
                success: function () {
                  $(document.body).trigger('wc_fragment_refresh');
                },
                error: function () {
                  hideMiniCartLoader();
                  ajaxInProgress = false;
                }
              });
            }, 400); // debounce time (ms)
          });
        $(document.body).on('wc_fragments_refreshed', function () {
            ajaxInProgress = false;
            hideMiniCartLoader();
          });
            // ❌ Remove product instantly
            $(document).on('click', '.remove-main-cart-product', function (e) {
            e.preventDefault();
            showMiniCartLoader();
            const $btn = $(this);
            const key = $btn.data('cart_item_key');

            $.post(window.wc_cart_params.ajax_url, {
                action: 'custom_remove_cart_item',
                cart_item_key: key
            }, function (res) {
                if (res.success) {
                
                $(document.body).trigger('wc_fragment_refresh');
                } 
            });
            });
      
            // $(document).on('click', '.remove-main', function(e) {
            //     e.preventDefault();
            //     const url = $(this).attr('href');
            //     $.get(url, function() {
            //         $(document.body).trigger('wc_fragment_refresh');
            //     });
            // });

$(document).on('click', '.noteSaveBtn', function (e) {
  e.preventDefault();
  const note = $(this).closest('.orderNoteform').find('.orderNoteField').val().trim();

  $.post(wc_cart_params.ajax_url, {
    action: 'save_order_note_ajax',
    order_note: note
  }, function (res) {
    if (res.success) {
      // hide note area, show default
      $('#orderNoteContainer').addClass('hidden');
      $('#defaultShow').removeClass('hidden');
    } 
  });
});
//coupon
// 💸 Apply coupon
    $(document).on('input change', 'input[name="coupon_code"]', function () {
    const $couponInput = $(this);
    const $couponBtn = $('.couponBtn');
    const hasValue = $couponInput.val().trim().length > 0;
    $couponBtn.prop('disabled', !hasValue);
  });
$(document).on('click', '.couponBtn', function (e) {
  e.preventDefault();
  const $btn = $(this);
  $btn.addClass('tusenrosor_loading');
  const coupon = $btn.closest('.drawer-footer').find('input[name="coupon_code"]').val().trim();
  if (!coupon) return;

  $btn.prop('disabled', true).css('opacity', '0.6');

  $.post(window.wc_cart_params.ajax_url, {
    action: 'apply_coupon_code_ajax',
    coupon_code: coupon
  }, function (res) {
    $btn.prop('disabled', false).css('opacity', '1');
      $btn.removeClass('tusenrosor_loading');
    if (res.success) {
         $('.Woomessage').html('<p class="woo-success">'+res.data.message+'</p>');
      $(document.body).trigger('wc_fragment_refresh');
    } else {
        $('.Woomessage').html('<p class="woo-error">'+res.data.message+'</p>');
     
    }
  });
});
//remove coupon
 $(document).on('click', '.remove-coupon', function (e) {
    e.preventDefault();

    const $btn = $(this);
    const nonce = $btn.data('nonce');
    const couponCode = $btn.data('coupon'); // we’ll add this attribute below

    $.ajax({
      type: 'POST',
      url: wc_cart_params.ajax_url,
      data: {
        action: 'tusenrosor_remove_coupon',
        security: nonce,
        coupon_code: couponCode,
      },
      beforeSend: function () {
        $btn.text('...');
      },
      success: function (response) {
        if (response.success) {
          // Refresh Woo fragments (minicart + totals)
          $(document.body).trigger('wc_fragment_refresh');
        }
      },
      complete: function () {
        $btn.text('--');
      },
    });
  });
});