jQuery(function ($) {
    const $products = $('.woocommerce-products-area');
    const $accordion = $('#shopFiterAccordion');
    const $activeTags = $('.active-filter');
    const $rating_filter = $('#rating-filter');
    const $farg_filter = $('#farg-filter');
    const $collection_filter = $('#collection-filter');
    const $price_filter = $('#price-filter');
    const $totalproduct=$('#totalProduct');
     const $wrap = $('.priceRnageWrapper'),
        $bar = $wrap.find('.progressBar'),
        $left = $wrap.find('.thumbLeft'),
        $right = $wrap.find('.thumbRight'),
        $min = $wrap.find('#minValue'),
        $max = $wrap.find('#maxValue'),
        minLimit = 0,
        maxLimit = +$max.val() || 10000,
        gap = 0;
       let priceFilterActive = false;
       let permitPriceUpdate=false;
    function collectFilters() {
        const data = { action: 'filter_products' };
        $('[data-filter]').each(function () {
            const key = $(this).data('filter');
            if ($(this).is(':checkbox') && $(this).is(':checked')) {
                if (!data[key]) data[key] = [];
                data[key].push($(this).val() || true);
            } else if ($(this).is('input[type="number"]')) {
                data[key] = $(this).val();
            }
              else if ($(this).is('select')) {
            data[key] = $(this).val();
           }
       // Include price range from inputs (min/max)
       
       
        });
         const minVal = $('#minValue').val();
         const maxVal = $('#maxValue').val();
         if (priceFilterActive) {
          if (minVal || maxVal) {
            data.min_price = minVal;
            data.max_price = maxVal;
          }
         }
       const searchkey=$('#searchkey').val();
       if(searchkey){
         data['s'] = searchkey;
       }
       console.log(data);
        return data;
    }

    function updateUI(res) {
        $products.html(res.products);
        $accordion.html(res.accordion);
        $activeTags.html(res.tags);
        $rating_filter.html(res.accordion_rating);
        $farg_filter.html(res.accordion_farg);
      //  alert(permitPriceUpdate);
        if(res.accordion_price && permitPriceUpdate){
        $price_filter.html(res.accordion_price);
        initPriceSlider();
        }
        $collection_filter.html(res.accordion_collection);
        
        $totalproduct.html(res.total_product);
    }

    function loadProducts() {
        const data = collectFilters();
        $.ajax({
            url: ShopAjax.ajaxurl,
            method: 'POST',
            data,
            beforeSend: () => $products.addClass('loading'),
            success: (res) => {
                if (res.success) {
                    updateUI(res.data);
                     $('.ajax-woocommerce-pagination').html(res.data.pagination);
                }
                  permitPriceUpdate=false;
            },
            complete: () => $products.removeClass('loading'),
        });
    }
  $(document).on('change', '[data-filter]', function (e) {

     permitPriceUpdate=true;
     loadProducts();
  });
    $(document).on('change', 'select[data-filter="orderby"]', function (e) {

     
     loadProducts();
  });
   // $(document).on('change', '[data-filter], select[data-filter="orderby"]', loadProducts);
     $(document).on('priceFilterChanged', loadProducts);
   
    $(document).on('click', '.remove-filter', function (e) {
        e.preventDefault();
        permitPriceUpdate=true;
       
        const type = $(this).data('type');
        const val = $(this).data('value');
        $(`[data-filter="${type}"][value="${val}"]`).prop('checked', false);
        $(this).remove();
        loadProducts();
    });
    $(document).on('click', '.remove-price-filter', function (e) {
        e.preventDefault();
         reset_price_range();
         jQuery(this).remove();
       // priceRangeupdate();
       permitPriceUpdate=true;
         priceFilterActive = false;
        loadProducts();

    });
    function  reset_price_range(){
        const $min = $('#minValue');
        const $max = $('#maxValue');
      
       const defaultMax=parseFloat($('#defMaxvalue').val());
       const defaultMin=parseFloat($('#defMinvalue').val());
        // Animate reset (optional, looks smoother)
        $min.val(defaultMin);
        $max.val(defaultMax);
      //alert(defaultMax);
        // 🔹 Update progress bar & thumbs visually
        const $wrap = $('.priceRnageWrapper'),
              $bar = $wrap.find('.progressBar'),
              $left = $wrap.find('.thumbLeft'),
              $right = $wrap.find('.thumbRight'),
              maxLimit = defaultMax;

        const leftPct = (defaultMin / maxLimit) * 100;
        const rightPct = 100 - (defaultMax / maxLimit) * 100;

        $bar.css({ left: leftPct + '%', right: rightPct + '%' });
        $left.css('left', leftPct + '%');
        $right.css('right', rightPct + '%');
        
       // priceRangeupdate();
       priceFilterActive = false;
    }
    $(document).on('click', '.clear-all', function (e) {
         e.preventDefault();
         permitPriceUpdate=true;
        $('[data-filter]').prop('checked', false);
        $('#minValue').val($('#minValue').attr('data-min') || 0);
        $('#maxValue').val($('#maxValue').attr('data-max') || 10000);
        $('.active-filter').html('');
        reset_price_range();
        loadProducts();
    });


     //price range filter
         function priceRangeupdate() {
        const minVal = +$min.val(),
            maxVal = +$max.val();
        const leftPct = (minVal / maxLimit) * 100;
        const rightPct = 100 - (maxVal / maxLimit) * 100;
        $bar.css({
            left: leftPct + '%',
            right: rightPct + '%'
        });
        $left.css('left', leftPct + '%');
        $right.css('right', rightPct + '%');
    }

    function clampValues() {
        let minVal = +$min.val(),
            maxVal = +$max.val();
        if (maxVal - minVal < gap) {
            if (document.activeElement.id === 'minValue') minVal = maxVal - gap;
            else maxVal = minVal + gap;
        }
        $min.val(Math.max(minLimit, minVal));
        $max.val(Math.min(maxLimit, maxVal));
       priceRangeupdate();

        // 🔥 Trigger AJAX filter when changed
        triggerPriceFilter();
    }

    // ✅ Fire custom event to reuse AJAX system
    function triggerPriceFilter() {
          priceFilterActive = true;
        $(document).trigger('priceFilterChanged', {
            min: +$min.val(),
            max: +$max.val(),
        });
    }

    $min.add($max).on('input change', clampValues);

    // Drag logic
    function drag($el, isLeft) {
        $(document).on('mousemove touchmove', function (e) {
            const x = e.pageX || e.originalEvent.touches[0].pageX;
            const rect = $wrap[0].getBoundingClientRect();
            let percent = ((x - rect.left) / rect.width) * 100;
            percent = Math.max(0, Math.min(100, percent));
            const val = Math.round((percent / 100) * maxLimit);
            if (isLeft) $min.val(Math.min(val, +$max.val() - gap));
            else $max.val(Math.max(val, +$min.val() + gap));
            priceRangeupdate();
        }).one('mouseup touchend', function () {
            $(document).off('mousemove touchmove');
            triggerPriceFilter(); // 🔥 fire after drag release
        });
    }

    $left.on('mousedown touchstart', () => drag($left, true));
    $right.on('mousedown touchstart', () => drag($right, false));

    priceRangeupdate();
function initPriceSlider() {
    const $wrap = $('.priceRnageWrapper');
    const $bar = $wrap.find('.progressBar');
    const $left = $wrap.find('.thumbLeft');
    const $right = $wrap.find('.thumbRight');
    const $min = $wrap.find('#minValue');
    const $max = $wrap.find('#maxValue');
    const gap = 0;
    const minLimit = 0;
    const maxLimit = +$max.val() || 10000;

    function priceRangeupdate() {
        const minVal = +$min.val(),
              maxVal = +$max.val();
        const leftPct = (minVal / maxLimit) * 100;
        const rightPct = 100 - (maxVal / maxLimit) * 100;
        $bar.css({ left: leftPct + '%', right: rightPct + '%' });
        $left.css('left', leftPct + '%');
        $right.css('right', rightPct + '%');
    }

    function clampValues() {
        let minVal = +$min.val(),
            maxVal = +$max.val();
        if (maxVal - minVal < gap) {
            if (document.activeElement.id === 'minValue') minVal = maxVal - gap;
            else maxVal = minVal + gap;
        }
        $min.val(Math.max(minLimit, minVal));
        $max.val(Math.min(maxLimit, maxVal));
        priceRangeupdate();
        triggerPriceFilter();
    }

    function triggerPriceFilter() {
        priceFilterActive = true;
        $(document).trigger('priceFilterChanged', {
            min: +$min.val(),
            max: +$max.val(),
        });
    }

    function drag($el, isLeft) {
        $(document).on('mousemove touchmove', function (e) {
            const x = e.pageX || e.originalEvent.touches[0].pageX;
            const rect = $wrap[0].getBoundingClientRect();
            let percent = ((x - rect.left) / rect.width) * 100;
            percent = Math.max(0, Math.min(100, percent));
            const val = Math.round((percent / 100) * maxLimit);
            if (isLeft) $min.val(Math.min(val, +$max.val() - gap));
            else $max.val(Math.max(val, +$min.val() + gap));
            priceRangeupdate();
        }).one('mouseup touchend', function () {
            $(document).off('mousemove touchmove');
            triggerPriceFilter();
        });
    }

    // Attach fresh event listeners
    $min.add($max).off('input change').on('input change', clampValues);
    $left.off('mousedown touchstart').on('mousedown touchstart', () => drag($left, true));
    $right.off('mousedown touchstart').on('mousedown touchstart', () => drag($right, false));

    // Initialize visual state
    priceRangeupdate();
}



        //price range filter

        //pagination


    // Handle pagination clicks
    $(document).on('click', '.woocommerce-pagination a', function (e) {
        e.preventDefault();

       const href = $(this).attr('href');
       const match = href.match(/\/page\/(\d+)/); // Extract page number from /page/2/
        const page = match ? parseInt(match[1], 10) : 1;
        loadProductsWithPage(page);
    });

    // Separate pagination-aware loader
    function loadProductsWithPage(page = 1) {
        const data = collectFilters();
        data.page = page; // send page number
       //alert(page);
        $.ajax({
            url: ShopAjax.ajaxurl,
            method: 'POST',
            data,
            beforeSend: () => $products.addClass('loading'),
            success: (res) => {
                if (res.success) {
                    $products.html(res.data.products);
                   // $('.active-filter').html(res.data.tags);
                   // $('#totalProduct').html(res.data.total_product);
                    $('.ajax-woocommerce-pagination').html(res.data.pagination);
                }
            },
            complete: () => $products.removeClass('loading'),
        });
         }
        //pagination

});
