<?php

/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tusenrosor-wp-theme
 */

get_header();
$post_id = get_the_ID();
$thumbnail_id  = get_post_thumbnail_id($post_id);
$thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'full') : '';
if (!$thumbnail_url) {
	$thumbnail_url = get_template_directory_uri() . '/assets/images/contactUs/contactUsBanner.webp';
}
?>

<main id="primary" class="site-main">
	<section class="py-8 md:py-12">
		<div class="container">
			<div class="max-w-[1200px] mx-auto">
				<div class="bg-cover bg-no-repeat bg-center" style="background-image: url('<?php echo  $thumbnail_url; ?>');">
					<div class="bg-black/30 min-h-[250px] md:min-h-[400px] p-4 flex items-center justify-center">
						<div class="w-full max-w-[600px] mx-auto text-white">
							<div class="text-center mb-8">
								<h1 class="uppercase tracking-[18%] text-xl md:text-[32px] font-normal leading-[140%] lg:leading-[130%] text-shadow-[0_2px_3px_#3030304D]">
									<?php echo get_the_title(); ?>
								</h1>
							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</section>

	<section class="section-padding pt-0!">
		<div class="container">
			<div class="max-w-[1200px] mx-auto">
				<div class="sm:-m-4 lg:-m-6">
					<div class="flex flex-wrap justify-center">

						<?php if (have_posts()) : ?>
							<?php while (have_posts()) :
								the_post(); ?>
								<?php
								$post = get_post(get_the_ID());
								get_template_part('template-parts/blog-grid', null, ['post' => $post]);
								?>
							<?php endwhile; ?>
						<?php else : ?>
							<p class="text-center py-6"><?php esc_html_e('Inga inlägg hittades.', 'tusenrosor'); ?></p>
						<?php endif; ?>
					</div>
				</div>
				<div class="text-center mt-6 md:mt-9">
					<div class="tusenrosorPagination mx-auto">
						<?php
						$pagination = paginate_links([
							'total'   => $query->max_num_pages,
							'current' => $paged,
							'prev_text' => '←',
							'next_text' => '→',
							'type'   => 'array',
						]);

						if ($pagination) :
							echo '<ul class="page-numbers">';
							foreach ($pagination as $page_link) {
								echo '<li>' . $page_link . '</li>';
							}
							echo '</ul>';
						endif;
						?>
					</div>
				</div>
			</div>
		</div>
	</section>

</main><!-- #main -->

<?php

get_footer();
