jQuery(function ($) {
  function mediaUpload(button) {
    let file_frame;
    button.on("click", function (e) {
      e.preventDefault();
      if (file_frame) file_frame.close();

      file_frame = wp.media({
        title: "Choose Image",
        button: { text: "Use this image" },
        multiple: false,
      });

      file_frame.on("select", function () {
        const attachment = file_frame.state().get("selection").first().toJSON();
        button.siblings("#term-image-id").val(attachment.id);
        button
          .siblings("#term-image-wrapper")
          .html(
            `<img src="${attachment.sizes.thumbnail.url}" style="max-width:100px;height:auto;">`
          );
      });

      file_frame.open();
    });
  }

  function removeImage(button) {
    button.on("click", function () {
      button.siblings("#term-image-id").val("");
      button.siblings("#term-image-wrapper").html("");
    });
  }

  mediaUpload($(".upload_image_button"));
  removeImage($(".remove_image_button"));
});
