<div class="w-full [&>.cartItem:first-child]:pt-0">
    <?php
    $order_items = $order->get_items();

    if (empty($order_items)) :
    ?>
        <p class="text-center text-(--sub-text) py-10">
            <?php esc_html_e('Inga produkter i denna beställning.', 'tusenrosor'); ?>
        </p>
        <?php
    else :
        // 🎁 Build a lookup of gift items by their linked parent product
        $gift_map = [];
        foreach ($order_items as $item_id => $item) {
            $is_gift   = wc_get_order_item_meta($item_id, 'is_gift', true);
            $linked_to = wc_get_order_item_meta($item_id, 'linked_to', true);
            if ($is_gift && $linked_to) {
                $gift_map[intval($linked_to)] = [
                    'id'   => $item_id,
                    'data' => $item,
                ];
            }
        }

        foreach ($order_items as $item_id => $item) :
            // ❌ skip gift items themselves
            if (wc_get_order_item_meta($item_id, 'is_gift', true) === 'yes') continue;

            $product = $item->get_product();
            if (!$product) continue;

            $product_id   = $product->get_id();
            $product_name = $product->get_name();
            $product_link = $product->is_visible() ? $product->get_permalink() : '';
            $thumbnail    = $product->get_image('woocommerce_thumbnail');
            $quantity     = $item->get_quantity();
            $price        = wc_price($item->get_total());
            $thumbnail_id = $product->get_image_id();
            $thumbnail_url = wp_get_attachment_url($thumbnail_id);
            // $gift_comment  = $item->get_meta('comment', true);
            $gift_comment = wc_get_order_item_meta($item_id, __('Meddelande', 'tusenrosor'), true);
            // Attributes (color / box)
            $color_slug = $item->get_meta('attribute_pa_color', true);
            $box_slug   = $item->get_meta('attribute_pa_box', true);

            if (!$color_slug) $color_slug = $product->get_attribute('pa_color');
            if (!$box_slug)   $box_slug   = $product->get_attribute('pa_box');

            $color_term = $color_slug ? get_term_by('slug', $color_slug, 'pa_color') : false;
            $box_term   = $box_slug ? get_term_by('slug', $box_slug, 'pa_box') : false;

            $color_name = $color_term ? $color_term->name : '';
            $box_name   = $box_term ? $box_term->name : '';
        ?>
            <div class="cartItem flex space-x-4 md:space-x-6 w-full py-6 border-b border-[#EBEBEB]" data-id="<?php echo esc_attr($item_id); ?>">
                <!-- Product Image -->
                <div>
                    <div class="relative">
                        <div class="px-1 absolute z-10 -top-2.5 -right-2.5 w-auto min-w-5 h-5 bg-(--theme-color) rounded-full flex justify-center items-center text-[10px] font-normal leading-[165%] text-(--theme-white)">
                            <?php echo esc_html($quantity); ?>
                        </div>
                        <a href="<?php echo esc_url($product_link); ?>" class="w-[74px] h-[74px] min-w-[74px] md:w-[122px] md:min-w-[122px] md:h-[122px] border border-[#EBEBEB] inline-block duration-400 hover:opacity-65 in-[.sideDrawer]:border-0">

                            <img
                                class="w-full h-full object-cover object-center bg-(--theme-white)"
                                src="<?php echo esc_url($thumbnail_url); ?>"
                                alt="Cart Product Image" />
                        </a>
                    </div>
                </div>

                <!-- Product Info -->
                <div class="w-full font-normal leading-[165%] space-y-3">
                    <div class="text-sm space-y-2">
                        <div class="space-y-1">
                            <a href="<?php echo esc_url($product_link); ?>" class="inline-block duration-400 hover:opacity-65 w-full">
                                <h2>
                                    <?php echo esc_html($product_name); ?>
                                </h2>
                            </a>
                            <div class="text-(--sub-text) flex space-x-3">
                                <div>
                                    <?php echo wp_kses_post($price); ?>
                                </div>
                            </div>
                        </div>
                        <div class="text-[10px] text-(--sub-text) uppercase">
                            <?php echo $color_name; ?><?php if ($box_name) echo ' / ' . $box_name; ?>
                        </div>
                    </div>

                    <?php
                    // 🎁 Gift product display (same layout as cart)
                    if (isset($gift_map[$product_id])) :
                        $gift_item     = $gift_map[$product_id]['data'];
                        $gift_id       = $gift_map[$product_id]['id'];
                        $gift_product  = $gift_item->get_product();
                        $gift_name     = $gift_product ? $gift_product->get_name() : __('Gåva', 'tusenrosor');
                        $gift_img      = $gift_product && $gift_product->get_image_id()
                            ? wp_get_attachment_image_url($gift_product->get_image_id(), 'woocommerce_thumbnail')
                            : get_template_directory_uri() . '/assets/images/products-img/blog9.webp';

                    ?>
                        <div class="space-y-3">
                            <div class="relative w-full">
                                <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                                    <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect width="12" height="12" rx="6" fill="currentColor" />
                                        <path d="M6 3V9M3 6H9" stroke="white" />
                                    </svg>
                                </a>
                                <div class="flex items-stretch leading-0 w-full">
                                    <img class="w-11.5 min-w-11.5 min-h-11.5 object-cover object-center" src="<?php echo esc_url($gift_img); ?>" alt="<?php echo esc_attr($gift_name); ?>">
                                    <div class="w-full flex items-center justify-between space-x-3 ps-3 py-[5px] bg-(--theme-white)">
                                        <div class="w-full leading-[165%] flex flex-col">
                                            <p class="text-xs text-(--theme-color) line-clamp-1">
                                                <?php echo esc_html($gift_name); ?>
                                            </p>
                                            <div class="text-[10px] text-(--sub-text) leading-[165%]">
                                                <?php echo wc_price(0); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php if (!empty($gift_comment)) : ?>
                                <div class="relative w-full">
                                    <a href="#" class="absolute top-1/2 -translate-y-1/2 -left-[18px] w-3 min-w-3 h-3 flex justify-center items-center bg-(--theme-color) text-(--theme-color) rounded-full">
                                        <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <rect width="12" height="12" rx="6" fill="currentColor" />
                                            <path d="M6 3V9M3 6H9" stroke="white" />
                                        </svg>
                                    </a>
                                    <?php if ($gift_comment) { ?>
                                        <div class="leading-[165%] w-full text-xs text-(--theme-color) [&_strong]:font-bold [&_strong]:text-(--sub-text)">
                                            <strong><?php echo esc_html(__('Meddelande', 'woocommerce')); ?>:</strong> <?php echo esc_html($gift_comment); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
    <?php
        endforeach;
    endif;
    ?>
</div>