<?php
$order_id = $order->get_id();
 $status   = $order->get_status();

// Map Woo statuses → step numbers
$status_steps = [
    'processing'    => 1,
    'packaging'  => 2,
    'on-the-way' => 3,
    'completed'  => 4,
];
$base = get_template_directory_uri() . '/assets/images/order/';
$current_step = isset($status_steps[$status]) ? $status_steps[$status] : 1;
?>

<div class="p-4 md:p-6 border border-t-0 border-[#EBEBEB]">
    <div class="space-y-6 sm:space-y-7 text-base leading-[160%] font-medium ">

        <!-- Step 1 -->
        <?php
            $is_active = $current_step == 1;
            $is_done   = $current_step > 1;
        ?>
        <div class="flex items-start space-x-3 <?php echo $is_active || $is_done ? '' : 'opacity-30'; ?>">
            <div class="relative">
                <div class="absolute left-6 -bottom-5 w-0.5 h-4 <?php echo $is_done ? 'bg-(--theme-dark)' : 'bg-(--theme-dark)'; ?>"></div>
                <div class="flex justify-center items-center w-12 min-w-12 h-12 <?php echo $is_active ? 'bg-(--theme-dark)' : ($is_done ? 'bg-(--theme-dark)' : 'border border-dashed'); ?> rounded-full">
                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                         src="<?php echo step_icon(1, $current_step, $base); ?>" alt="Instance">
                </div>
            </div>
            <div>
                <h4 class="text-[#111116]">
                    <?php echo esc_html(__('Beställning mottagen', 'tusenrosor')); ?>
                </h4>
                <p class="text-sm font-normal leading-[165%] text-(--sub-text)">
                    <?php echo esc_html(__('Din beställning har lagts framgångsrikt och vi förbereder den för behandling.', 'tusenrosor')); ?>
                </p>
            </div>
        </div>

        <!-- Step 2 -->
        <?php
            $is_active = $current_step == 2;
            $is_done   = $current_step > 2;
        ?>
        <div class="flex items-start space-x-3 <?php echo $is_active || $is_done ? '' : 'opacity-30'; ?>">
            <div class="relative">
                <div class="absolute left-6 -bottom-5 w-0.5 h-4 <?php echo $is_done ? 'bg-(--theme-dark)' : 'bg-(--theme-dark) opacity-30'; ?>"></div>
                <div class="flex justify-center items-center w-12 min-w-12 h-12 <?php echo $is_active ? 'bg-(--theme-dark)' : ($is_done ? 'bg-(--theme-dark)' : 'border border-dashed'); ?> rounded-full">
                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                         src="<?php echo step_icon(2, $current_step, $base); ?>" alt="Instance">
                </div>
            </div>
            <div>
                <h4 class="text-[#111116]"><?php echo __('Packning','woocommerce');?></h4>
                <p class="text-sm font-normal leading-[165%] text-(--sub-text)">
                    <?php echo esc_html(__('Vårt team packar dina varor noggrant för att säkerställa att de anländer i perfekt skick.', 'tusenrosor')); ?>
                </p>
            </div>
        </div>

        <!-- Step 3 -->
        <?php
            $is_active = $current_step == 3;
            $is_done   = $current_step > 3;
        ?>
        <div class="flex items-center space-x-3 text-(--theme-dark) <?php echo $is_active || $is_done ? '' : 'opacity-30'; ?>">
            <div class="relative">
                <div class="absolute left-6 -bottom-5 w-0.5 h-4 bg-(--theme-dark)"></div>
                <div class="flex justify-center items-center w-12 min-w-12 h-12 <?php echo $is_active ? 'bg-(--theme-dark)' : ($is_done ? 'bg-(--theme-dark)' : 'border border-dashed'); ?> rounded-full">
                    <img class="w-6 min-w-6 h-6 object-contain object-center"
                         src="<?php echo step_icon(3, $current_step, $base); ?>" alt="Instance">
                </div>
            </div>
            <div>
                <h4 class="text-[#111116]">
                    <?php echo esc_html(__('På väg', 'tusenrosor')); ?>
                </h4>
            </div>
        </div>

        <!-- Step 4 -->
        <?php
            $is_active = $current_step == 4;
            $is_done   = $current_step > 4;
        ?>
        <div class="flex items-center space-x-3 text-(--theme-dark) <?php echo $is_active ? '' : 'opacity-30'; ?>">
            <div class="flex justify-center items-center w-12 min-w-12 h-12 <?php echo $is_active ? 'bg-(--theme-dark)' : 'border border-dashed'; ?> rounded-full">
                <img class="w-6 min-w-6 h-6 object-contain object-center"
                     src="<?php echo step_icon(4, $current_step, $base); ?>" alt="Instance">
            </div>
            <h4 class="text-[#111116]">
                <?php echo esc_html(__('Levererad', 'tusenrosor')); ?>
            </h4>
        </div>

    </div>
</div>
