<?php

/**
 * Lost password reset form.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-reset-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined('ABSPATH') || exit;

?>

<section class="resetPassSec sectionPadding">
    <div class="section_overlay">
        <div class="container">
            <div class="section_width">
                <div class="parent_col login-form">
                    <?php do_action('woocommerce_before_reset_password_form'); ?>
                    <h1>RESET YOUR PASSWORD</h1>
                    <!--    <p>Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.</p>-->
                    <form method="post" class="woocommerce-ResetPassword lost_reset_password">
                        <p><?php echo apply_filters('woocommerce_reset_password_message', esc_html__('Enter a new password below.', 'woocommerce')); ?></p><?php // @codingStandardsIgnoreLine
                                                                                                                                                            ?>
                        <hr>
                        <div class="inputGroup mb-3">
                            <label class="mb-2" for="password_1">
                                <?php esc_html_e('New password', 'woocommerce'); ?>&nbsp;<span class="required" aria-hidden="true">*</span>
                                <span class="screen-reader-text">
                                    <?php esc_html_e('Required', 'woocommerce'); ?>
                                </span>
                            </label>

                            <div class="position-relative">
                                <input type="password" class="m-0 woocommerce-Input woocommerce-Input--text input-text w-100" name="password_1" id="password_1" autocomplete="new-password" required aria-required="true" />
                                <button class="pass-show-btn" id="togglePasswordBtn1">
                                    <i class="fa fa-eye" style="display: none;"></i>
                                    <i class="fa fa-eye-slash"></i>
                                </button>
                            </div>
                        </div>


                        <div class="inputGroup mb-3">
                            <label class="mb-2" for="password_2">
                                <?php esc_html_e('Re-enter new password', 'woocommerce'); ?>&nbsp;<span class="required" aria-hidden="true">*</span>
                                <span class="screen-reader-text">
                                    <?php esc_html_e('Required', 'woocommerce'); ?>
                                </span>
                            </label>
                            <div class="position-relative">
                                <input type="password" class="m-0 woocommerce-Input woocommerce-Input--text input-text w-100" name="password_2" id="password_2" autocomplete="new-password" required aria-required="true" />
                                <button class="pass-show-btn" id="togglePasswordBtn2">
                                    <i class="fa fa-eye" style="display: none;"></i>
                                    <i class="fa fa-eye-slash"></i>
                                </button>
                            </div>
                        </div>

                        <input type="hidden" name="reset_key" value="<?php echo esc_attr($args['key']); ?>" />
                        <input type="hidden" name="reset_login" value="<?php echo esc_attr($args['login']); ?>" />

                        <div class="clear"></div>

                        <?php do_action('woocommerce_resetpassword_form'); ?>

                        <p class="woocommerce-form-row form-row">
                            <input type="hidden" name="wc_reset_password" value="true" />
                            <button type="submit" class="woocommerce-Button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" value="<?php esc_attr_e('Save', 'woocommerce'); ?>"><?php esc_html_e('Save', 'woocommerce'); ?></button>
                        </p>
                        <?php wp_nonce_field('reset_password', 'woocommerce-reset-password-nonce'); ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    jQuery(function($) {
        function setupPasswordToggle(buttonId, inputId) {
            $(`#${buttonId}`).on('click', function(e) {
                e.preventDefault();
                const $input = $(`#${inputId}`);
                const isPassword = $input.attr('type') === 'password';
                $input.attr('type', isPassword ? 'text' : 'password');
                $(`#${buttonId} .fa-eye`).toggle(isPassword);
                $(`#${buttonId} .fa-eye-slash`).toggle(!isPassword);
            });
        }
        setupPasswordToggle('togglePasswordBtn1', 'password_1');
        setupPasswordToggle('togglePasswordBtn2', 'password_2');
    });
</script>
<script>
    jQuery(function($) {
        $('form.woocommerce-form-login').on('submit', function(e) {
            var response = grecaptcha.getResponse();
            if (!response) {
                alert("Please confirm you're not a robot.");
                // Optional: e.preventDefault(); to enforce
                // e.preventDefault(); // Uncomment this line to actually block form submission
            }
        });
    });
</script>
<?php
do_action('woocommerce_after_reset_password_form');
