<?php

/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.2.0
 */

defined('ABSPATH') || exit;


?>
<section>
	<div class="flex flex-col lg:flex-row items-stretch lg:min-h-[768px]">
		<div class="w-full lg:w-[61.3%] px-4 py-8 md:p-12 flex items-center justify-center">
			<div class="max-w-[450px] mx-auto w-full space-y-6 md:space-y-9">
				<?php do_action('woocommerce_before_lost_password_form'); ?>

				<div class="space-y-3 md:space-y-5 text-center ">
					<h1
						class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">

						<?php esc_html_e('Återställ lösenord', 'woocommerce'); ?>
					</h1>
					<div class="text-sm leading-[165%]">
						<?php echo esc_html(__('Ange din e-postadress för att återställa ditt lösenord.', 'tusenrosor')); ?> <br>
						<?php echo esc_html(__('Vi skickar en länk till dig via e-post.', 'tusenrosor')); ?>
					</div>
				</div>

				<form
					class="w-full space-y-4 woocommerce-ResetPassword lost_reset_password"
					method="post">
					<div class="relative">
						<input
							class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg woocommerce-Input woocommerce-Input--text input-text"
							placeholder="<?php esc_attr_e('E-post', 'woocommerce'); ?>"
							type="text"
							name="user_login"
							id="user_login"
							autocomplete="username"
							required
							aria-required="true" />
						<label
							for="user_login"
							class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M2.5 5.83332L10 9.99999L17.5 5.83332M2.5 4.16666H17.5V15.8333H2.5V4.16666Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
							</svg>
						</label>
					</div>

					<div class="clear"></div>
					<?php do_action('woocommerce_lostpassword_form'); ?>



					<div>
						<input type="hidden" name="wc_reset_password" value="true" />
						<button type="submit" class="text-sm text-white bg-(--theme-dark) font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center cursor-pointer woocommerce-Button button<?php echo esc_attr(wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : ''); ?>" value="<?php esc_attr_e('Reset password', 'woocommerce'); ?>">
							<?php esc_html_e('Skicka återställningslänk', 'woocommerce'); ?>
						</button>
					</div>


					<?php wp_nonce_field('lost_password', 'woocommerce-lost-password-nonce'); ?>
				</form>

				<div class="text-center text-sm leading-[165%]">
					<a
						class="underline hover:opacity-65 duration-400"
						href="<?php echo esc_url(site_url('my-account')); ?>">
						<?php esc_html_e('Tillbaka till inloggning', 'woocommerce'); ?>
					</a>
				</div>
			</div>
		</div>

		<!-- Include banner img -->
		<?php require get_template_directory() . '/inc/common-sections/login-register-banner-img.php'; ?>
	</div>
</section>

<?php
do_action('woocommerce_after_lost_password_form');
