<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<main>

	<?php
	$base_url = get_template_directory_uri() . '/assets/images/products-img/';

	$gallar_images_ids = [];

	$gallar_images_ids = [];

	// ✅ Collect all image IDs
	$gallery_image_ids = $product->get_gallery_image_ids();
	$main_image_id     = $product->get_image_id();
	$mainslideritem = '';
	$navbtn = '';
	$modalsliderItem = '';
	$mobiledot = '';
	$main_image_id     = $product->get_image_id();
	if (!$main_image_id) {
		$main_image_id = get_placeholder_imageId();
	}
	if ($main_image_id) {
		$mainslideritem .= '<button class="mainSliderItem aspect-square border-0 outline-0 bg-transparent cursor-zoom-in duration-400 max-w-full" data-modal-target="shopModal" data-modal-toggle="shopModal">
								
     ' . wp_get_attachment_image(
			$main_image_id,
			'full',
			false,
			['class' => 'w-full h-full object-cover bg-(--bg2)',  'fetchpriority' => 'high', 'alt' => 'Product Image']
		) . '
	</button>';
		$navbtn .= '<button class="navBtn cursor-pointer w-15 min-w-15 h-15 border-0 outline-0 [&.active]:border-2 [&.active]:border-(--theme-color) active">
		' . wp_get_attachment_image(
			$main_image_id,
			'full',
			false,
			['class' => 'w-full h-full object-cover bg-(--bg2)', 'alt' => 'Product Image']
		) . '
		</button>';
		$mobiledot .= '<button class="sliderDotBtn active group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center"><span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span></button>';
		$modalsliderItem .= '<div class="modalSliderItem min-w-full max-h-screen flex items-center justify-center">	' . wp_get_attachment_image(
			$main_image_id,
			'full',
			false,
			['class' => 'w-auto m-auto h-auto max-h-screen object-cover bg-(--bg2)',  'alt' => 'Product Image']
		) . '
		</div>';
	}
	if ($main_image_id) $gallar_images_ids[] = $main_image_id;
	if (!empty($gallery_image_ids)) {
		$gallar_images_ids = array_merge($gallar_images_ids, $gallery_image_ids);
		$gallar_images_ids = array_unique(array_filter($gallar_images_ids));
		foreach ($gallar_images_ids as $index => $imageid) {
			if ($main_image_id !== $imageid) {
				$mainslideritem .= '<button class="mainSliderItem aspect-square border-0 outline-0 bg-transparent cursor-zoom-in duration-400 max-w-full" data-modal-target="shopModal" data-modal-toggle="shopModal">
								
     ' . wp_get_attachment_image(
					$imageid,
					'full',
					false,
					['class' => 'w-full h-full object-cover bg-(--bg2)',  'fetchpriority' => 'high', 'alt' => 'Product Image']
				) . '
	</button>';
				$navbtn .= '<button class="navBtn cursor-pointer w-15 min-w-15 h-15 border-0 outline-0 [&.active]:border-2 [&.active]:border-(--theme-color)">
		' . wp_get_attachment_image(
					$imageid,
					'full',
					false,
					['class' => 'w-full h-full object-cover bg-(--bg2)', 'alt' => 'Product Image']
				) . '
		</button>';
				$modalsliderItem .= '<div class="modalSliderItem min-w-full max-h-screen flex items-center justify-center">	' . wp_get_attachment_image(
					$imageid,
					'full',
					false,
					['class' => 'w-auto m-auto h-auto max-h-screen object-cover bg-(--bg2)',  'alt' => 'Product Image']
				) . '
		</div>';
				$mobiledot .= '<button class="sliderDotBtn group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center"><span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span></button>';
			}
		}
	}

	//matrix relation
	//  Current category, color, and box
	$cat_slugs = wp_get_post_terms($product->get_id(), 'product_cat', ['fields' => 'slugs']);
	$cat_slug  = $cat_slugs ? $cat_slugs[0] : '';

	$current_color = '';
	$current_color_name = '';
	$current_box   = '';
	$current_box_name = '';

	$color_terms = wc_get_product_terms($product->get_id(), 'pa_color');
	if (!empty($color_terms)) {
		$current_color = $color_terms[0]->slug;
		$current_color_name = $color_terms[0]->name;
	}

	$box_terms = wc_get_product_terms($product->get_id(), 'pa_box');
	if (!empty($box_terms)) {
		$current_box = $box_terms[0]->slug;
		$current_box_name = $box_terms[0]->name;
	}

	//  Get all products in same category
	$related_products = get_posts([
		'post_type'      => 'product',
		'post_status'    => 'publish',
		'numberposts'    => -1,
		'tax_query'      => [[
			'taxonomy' => 'product_cat',
			'field'    => 'slug',
			'terms'    => $cat_slug,
		]],
	]);
	// Build combination matrix
	$matrix = [];          // both color + box
$color_only = [];      // products with only color
$box_only = [];        // products with only box

foreach ($related_products as $p) {
    $color = wc_get_product_terms($p->ID, 'pa_color', ['fields' => 'slugs']);
    $box   = wc_get_product_terms($p->ID, 'pa_box',   ['fields' => 'slugs']);

    $color_slug = $color[0] ?? '';
    $box_slug   = $box[0] ?? '';
    $link = get_permalink($p->ID);

    if ($color_slug && $box_slug) {
        $matrix[$color_slug][$box_slug] = $link;
    }
    elseif ($color_slug && !$box_slug) {
        $color_only[$color_slug] = $link;
    }
    elseif ($box_slug && !$color_slug) {
        $box_only[$box_slug] = $link;
    }
}

// ==========================================
// COLORS AVAILABLE FOR CURRENT BOX
// ==========================================
$colors_for_box = [];

// from full matrix
foreach ($matrix as $color_slug => $boxes) {
    if ($current_box && isset($boxes[$current_box])) {
        $colors_for_box[$color_slug] = $boxes[$current_box];
    }
}

// include colors that exist alone (no box)
foreach ($color_only as $color_slug => $link) {
    $colors_for_box[$color_slug] = $link;
}

// reorder to put current color first
if ($current_color && isset($colors_for_box[$current_color])) {
    $colors_for_box = array_merge(
        [$current_color => $colors_for_box[$current_color]],
        array_diff_key($colors_for_box, [$current_color => ''])
    );
}

// ==========================================
// BOXES AVAILABLE FOR CURRENT COLOR
// ==========================================
$boxes_for_color = [];

// from full matrix
if (isset($matrix[$current_color])) {
    $boxes_for_color = $matrix[$current_color];
}

// include boxes that exist alone (no color)
foreach ($box_only as $box_slug => $link) {
    $boxes_for_color[$box_slug] = $link;
}

// reorder to put current box first
if ($current_box && isset($boxes_for_color[$current_box])) {
    $boxes_for_color = array_merge(
        [$current_box => $boxes_for_color[$current_box]],
        array_diff_key($boxes_for_color, [$current_box => ''])
    );
}
	// Build combination matrix
	/*$matrix = [];
	foreach ($related_products as $p) {
		 $color = wc_get_product_terms($p->ID, 'pa_color', ['fields' => 'slugs']);
		$box   = wc_get_product_terms($p->ID, 'pa_box',   ['fields' => 'slugs']);
		if (!empty($color) && !empty($box)) {
			$matrix[$color[0]][$box[0]] = get_permalink($p->ID);
		}
	}

	// Colors available for current box
	$colors_for_box = [];
	if (isset($matrix)) {
		foreach ($matrix as $color_slug => $boxes) {
			if (isset($boxes[$current_box])) {
				$colors_for_box[$color_slug] = $boxes[$current_box];
			}
		}
		if (!empty($current_color) && isset($colors_for_box[$current_color])) {
			$colors_for_box = array_merge(
				[$current_color => $colors_for_box[$current_color]],
				array_diff_key($colors_for_box, [$current_color => ''])
			);
		}
	}

	// Boxes available for current color
	$boxes_for_color = [];
	if (isset($matrix[$current_color])) {
		$boxes_for_color = $matrix[$current_color];
	}
	// ✅ Move current box to the beginning of the array
	if (!empty($current_box) && isset($boxes_for_color[$current_box])) {
		$boxes_for_color = array_merge(
			[$current_box => $boxes_for_color[$current_box]],
			array_diff_key($boxes_for_color, [$current_box => ''])
		);
	}*/
	?>

	<section class="lg:pt-15 pb-12 lg:pb-15">
		<div class="lg:max-w-[1440px] mx-auto lg:px-12">
			<div class="flex flex-col lg:flex-row lg:space-x-15 space-y-8 lg:space-y-0">
				<div class="relative lg:flex w-full">

					<?php if ($navbtn) { ?>
						<div class="hidden lg:block min-w-15 max-w-15 lg:mr-12">
							<div class="navSlider flex w-full min-w-15 max-w-15 flex-col space-y-3 sticky top-25">

								<?php echo $navbtn; ?>

							</div>
						</div>
					<?php } ?>



					<!-- just remove those class lg:max-h-screen lg:overflow-auto hide-scrollbar  -->
					<div class="mainSlider w-full lg:flex lg:flex-col lg:space-y-3 leading-0 aspect-square-not-desktop">

						<?php echo $mainslideritem; ?>

					</div>
					<?php if ($mobiledot) { ?>
						<div class="mobileDotBtns lg:hidden flex items-center justify-center mt-3">
							<?php echo $mobiledot; ?>
						</div>
					<?php } ?>
				</div>
				<div class="custom-add-to-cart w-full lg:min-w-auto lg:max-w-[40%] xl:max-w-[500px] xl:min-w-[500px] px-4 md:px-8 lg:px-0" data-product-id="<?php echo $product->get_id() ?>">
					<div class="">

						<div class="group w-full space-y-4 border-b border-[#EBEBEB] pb-6">
							<h1 class="text-base md:text-lg leading-[140%] tracking-[18%] uppercase text-(--theme-color)">
								<?php echo get_the_title(); ?>
							</h1>
							<?php if ($product->get_review_count()) { ?>
								<div class="flex items-center space-x-2">
									<div class="flex items-center space-x-0.5">
										<?php for ($i = 0; $i < 5; $i++): ?>
											<svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M6 0V8.635L2.292 11L3.48 6.87L0 4.202L4.443 4.015L6 0ZM6 0V8.635L9.708 11L8.52 6.87L12 4.202L7.557 4.015L6 0Z" fill="#1C1C1C" />
											</svg>
										<?php endfor; ?>
									</div>
									<span class="text-(--sub-text) text-xs font-normal leading-[165%]">
										(<?php echo esc_html($product->get_review_count()); ?>)
									</span>
								</div>
							<?php } ?>
							<?php
							if ($product->is_type('variable')) {
								// For variable products — get price range dynamically
								$regular_price = $product->get_variation_regular_price('min', true);
								$sale_price    = $product->get_variation_sale_price('min', true);
							} else {
								// For simple products
								$regular_price = $product->get_regular_price();
								$sale_price    = $product->get_sale_price();
							}
							?>
							<div class="flex items-center justify-between space-x-2 sm:space-x-4 leading-[160%] tracking-[18%] uppercase text-(--theme-color)">
								<div class="flex items-center space-x-2 sm:space-x-4">

									<?php
									if ($product->is_on_sale() && $sale_price) : ?>
										<div class="text-sm sm:text-lg tracking-[18%]">
											<?php echo wc_price($sale_price); ?>
										</div>
										<div class="text-(--sub-text) text-xs sm:text-sm line-through tracking-[18%]">
											<?php echo wc_price($regular_price); ?>
										</div>
									<?php else : ?>
										<div class="text-sm sm:text-lg tracking-[18%]">
											<?php echo wc_price($regular_price); ?>
										</div>
									<?php endif; ?>
								</div>
								<div class="flex items-center space-x-1 sm:space-x-2">
									<?php
									$payment_icons = [
										'payment1.svg',
										'payment2.svg',
										'payment3.svg',
									];
									?>
									<?php foreach ($payment_icons as $icon): ?>
										<img
											class="h-5.5 w-8 min-w-8 sm:w-9 sm:min-w-9 object-cover"
											src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/payment-card/' . $icon); ?>"
											alt="Payment Method Icon">
									<?php endforeach; ?>
								</div>

							</div>
						</div>
						<?php if ($product->is_type('simple') && !empty($colors_for_box) || $product->is_type('simple') && !empty($boxes_for_color)) { ?>
							<div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6 y">
								<?php if (!empty($colors_for_box)) { ?>
									<div class="space-y-2">
										<h3 class="text-base text-(--sub-text) leading-[165%] font-normal">
											<?php echo esc_html(__('Flower:', 'tusenrosor')) ?> <span class="text-(--theme-color)"><?php echo $current_color_name; ?></span>
										</h3>
										<div class="w-full">
											<div class="-m-[5px]">
												<div class="flex flex-wrap">
													<?php
													foreach ($colors_for_box as $color_slug => $link) {
														$term = get_term_by('slug', $color_slug, 'pa_color');
														$img_id  = get_term_meta($term->term_id, 'term_image_id', true);
														$img_url = $img_id ? wp_get_attachment_url($img_id) : wc_placeholder_img_src();
														$active  = ($color_slug === $current_color) ? 'active' : '';
													?>
														<a termid="<?php echo $term->term_id; ?>" href="<?php echo esc_url($link ?: '#'); ?>" title="<?php echo esc_attr($term->name); ?>"
															class="[&.active]:border-(--theme-color) hover:border-(--theme-color) m-[5px] cursor-pointer flex items-center justify-center h-13 min-h-13 w-13 min-w-13 border border-[#EBEBEB] rounded-full text-xs text-center duration-400 <?php echo esc_attr($active); ?>">
															<img class="h-9 w-9 object-contain" src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($term->name); ?>">
														</a>
													<?php } ?>

												</div>
											</div>
										</div>
									</div>
								<?php } ?>
								<?php if (!empty($boxes_for_color)) { ?>
									<div class="space-y-2">
										<h3 class="text-base text-(--sub-text) leading-[165%] font-normal">
											<?php echo esc_html(__('Box:', 'tusenrosor')) ?> <span class="text-(--theme-color)"><?php echo $current_box_name; ?></span>
										</h3>
										<div class="w-full">
											<div class="-m-[5px]">
												<div class="flex flex-wrap">
													<?php
													foreach ($boxes_for_color as $box_slug => $link) {
														$term = get_term_by('slug', $box_slug, 'pa_box');
														$img_id  = get_term_meta($term->term_id, 'term_image_id', true);
														$img_url = $img_id ? wp_get_attachment_url($img_id) : wc_placeholder_img_src();
														$active  = ($box_slug === $current_box) ? 'active' : '';
													?>
														<a title="<?php echo esc_attr($term->name); ?>" termid="<?php echo $term->term_id; ?>"
															href="<?php echo esc_url($link); ?>"
															class="<?= esc_attr($active); ?> [&.active]:border-(--theme-color) hover:border-(--theme-color) m-[5px] cursor-pointer flex items-center justify-center h-12 min-h-12 w-12 min-w-12 border border-[#EBEBEB] rounded-full text-xs text-center duration-400 bg-no-repeat bg-center bg-cover bg-white"
															style="background-image: url('<?= esc_url($img_url)  ?>')">
															<img
																class="h-[3px] max-w-7 object-contain"
																src="<?php echo get_template_directory_uri(); ?>/assets/images/tusenrosor-logo.svg" alt="Tusen Rosor">
														</a>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>

								<?php } ?>
							</div>
						<?php } ?>
						<?php
						$gift_product = get_field('gift_product');
						$gproduct = isset($gift_product['product']) ? $gift_product['product'] : '';
						$is_gift_product = wc_get_product($gproduct);
						$Halsningskort = get_theme_option_repeater_values('halsningskort', $product->get_id());
						if (!empty(array_filter($Halsningskort)) && $gproduct && $is_gift_product) {

						?>
							<div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6 r">
								<div class="space-y-4">
									<div class="flex items-center justify-between text-(--theme-color) font-normal leading-[165%]">
										<h3 class="text-base font-bold">
											<?php echo esc_html(__('Hälsningskort', 'tusenrosor')); ?>
										</h3>
										<span class="text-sm">
											<span class="paper_price">0</span> <?php echo get_woocommerce_currency_symbol(); ?>
										</span>
									</div>
									<div class="w-full space-y-4">
										<div class="relative w-full">
											<label
												class="text-(--sub-text) text-[10px] absolute left-4 top-1.5"
												for="cardType">
												<?php echo esc_html(__('Korttyp', 'tusenrosor')); ?>
											</label>
											<select
												id="cardType"
												class="appearance-none focus:border-(--theme-color) duration-400 px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] bg-no-repeat bg-position-[right_16px_center] bg-size-[10px_6px] cursor-pointer" name="paper_option"
												style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/selectArrow.svg')">
												<option selected><?php echo esc_html(__('Papper', 'tusenrosor')) ?></option>
												<?php foreach ($Halsningskort as $paper) { ?>
													<option value="<?php echo esc_html($paper['option']); ?>" data-price="<?php echo esc_html($paper['price']); ?>"><?php echo esc_html($paper['option']); ?></option>
												<?php } ?>

											</select>
										</div>
										<div class="w-full">
											<textarea
												class="gift-comment px-4 py-3 w-full border border-[#EBEBEB] min-h-29 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"
												name="halsningskort_message"
												id=""
												placeholder="Meddelande"></textarea>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>
						<?php
						if (!empty($gift_product) && $gproduct && $is_gift_product) {
							$giftproductid = $gift_product['product'];
							$giftProduct = wc_get_product($giftproductid);
							$gift_price    = ($giftProduct->get_sale_price()) ? $giftProduct->get_sale_price() : $giftProduct->get_regular_price();
							$image_id  = $giftProduct->get_image_id();
							$image_url = $image_id ? wp_get_attachment_url($image_id) : wc_placeholder_img_src();
						?>
							<div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6 s">
								<div class="space-y-4">
									<div class="flex items-center justify-between text-(--theme-color) font-normal leading-[165%]">
										<h3 class="text-base font-bold">
											<?php echo esc_html(__('Romantisk överraskning', 'tusenrosor')); ?>
										</h3>
										<span class="text-sm">
											<?php echo wc_price($gift_price); ?>
										</span>
									</div>
									<label class="flex items-start justify-between space-x-3 w-full p-4 bg-white border border-[#EBEBEB] cursor-pointer duration-400 has-checked:border-(--theme-color)">
										<div class="w-full flex items-start space-x-3">
											<div class="min-w-13 w-13 h-13 md:min-w-25 md:w-25 md:h-25">
												<img
													class="w-full h-full object-cover bg-(--bg2)"
													src="<?php echo $image_url; ?>"
													alt="">
											</div>
											<div class="text-(--theme-color) font-normal leading-[165%] space-y-0.5 text-sm 
											[&_h1]:text-base [&_h1]:text-black 
											[&_h2]:text-base [&_h2]:text-black 
											[&_h3]:text-base [&_h3]:text-black 
											[&_h4]:text-base [&_h4]:text-black 
											[&_h5]:text-base [&_h5]:text-black">
												<?php echo  $gift_product['short_description']; ?>
											</div>
										</div>
										<div class="min-w-6">
											<input name="gift_product"
												type="checkbox"
												class="peer tusenCheckbox w-6! h-6! gift-checkbox"
												value="<?php echo $giftproductid; ?>">
										</div>
									</label>


									<?php if (isset($gift_product['details_extra_product']) && $gift_product['details_extra_product']) { ?>
										<a
											class="underline text-sm text-(--theme-color) font-normal leading-[165%] inline-block duration-400 hover:opacity-65"
											href="javascript:void(0)" data-modal-target="extrainfomationModal1" data-modal-toggle="extrainfomationModal1">
											<?php echo esc_html(__('Så fungerar det', 'tusenrosor')) ?>
										</a>
										<div id="extrainfomationModal1" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full px-4">
											<div class="relative w-full max-w-[650px] h-auto max-h-9/10 duration-400 flex flex-col bg-white">
												<!-- Modal content -->
												<div class="flex items-center justify-between p-4 md:py-4.5 md:px-8 border-b border-[#EBEBEB]">
													<h3 class="font-normal uppercase text-base md:text-lg leading-[140%]">
														<?php echo esc_html(__('Så fungerar det', 'tusenrosor')) ?>
													</h3>
													<button type="button" class="duration-400 hover:opacity-65 cursor-pointer bg-transparent text-sm w-6 h-6 ms-auto inline-flex justify-center items-center" data-modal-hide="extrainfomationModal1">
														<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
															<path d="M4.28516 4.28572L11.9994 12M11.9994 12L19.7137 19.7143M11.9994 12L19.7137 4.28572M11.9994 12L4.28516 19.7143" stroke="#303030" stroke-width="1.5" stroke-linecap="round" />
														</svg>
													</button>
												</div>
												<div class="overflow-y-auto grow p-4 md:py-6 md:px-8 text-sm leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400 [&_h1]:tracking-[18%] [&_h1]:uppercase [&_h1]:text-base [&_h2]:tracking-[18%] [&_h2]:uppercase [&_h2]:text-base [&_h3]:tracking-[18%] [&_h3]:uppercase [&_h3]:text-base [&>*]:mb-3 [&>*:last-child]:mb-0">
													<?php echo   $gift_product['details_extra_product']; ?>
												</div>
												<div class="flex items-center p-4 md:p-8 md:pt-6 border-t border-[#EBEBEB] ">
													<button
														data-modal-hide="extrainfomationModal1"
														class="noteSaveBtn text-sm text-white bg-(--theme-dark) font-medium hover:opacity-65 tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center duration-400 cursor-pointer w-full border border-(--theme-dark)">
														<?php echo esc_html(__('Ok', 'tusenrosor')); ?>
													</button>
												</div>
											</div>
										</div>
									<?php } ?>
								</div>
							</div>
						<?php } ?>

						<div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6 d">
							<div class="md:space-y-8 space-y-6">
								<?php
								if ($product->is_type('variable')) {
									// Variable product form
									echo '<div class="variable-product-form">';
									woocommerce_template_single_price();
									woocommerce_template_single_add_to_cart();
									echo '</div>';
								} elseif ($product->is_type('simple')) {
									// Simple product custom layout (keep your button)
								?>
									<a
										class="add-to-cart text-sm text-white bg-(--theme-dark) font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center"
										href="#" data-product-id="<?php echo $product->get_id(); ?>">
										<?php echo esc_html(__('Lägg i varukorg', 'tusenrosor')); ?>
									</a>
								<?php
								} else {
									// Fallback for other product types
									do_action('woocommerce_single_product_summary');
								}
								?>

								<?php
								/**
								 * Hook: woocommerce_before_single_product_summary.
								 *
								 * @hooked woocommerce_show_product_sale_flash - 10
								 * @hooked woocommerce_show_product_images - 20
								 */
								//do_action('woocommerce_before_single_product_summary');
								?>
								<div class="space-y-5 text-sm text-(--theme-color) leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400">
									<?php the_content(); ?>
								</div>
								<?php

								//do_action('woocommerce_after_single_product_summary');
								?>

							</div>
						</div>

						<?php
						$faq = get_field('faqs');
						if (!empty($faq)) {
						?>
							<div class="group w-full space-y-4 border-b border-[#EBEBEB]">

								<div data-accordion="open">
									<?php if ($faq['title']) { ?>
										<div class="accordionItem">
											<h2 id="shopAccordionTitle1">
												<button type="button"
													class="flex items-center justify-between w-full font-normal py-6 text-xs text-(--theme-color)! leading-[165%] tracking-[18%] bg-transparent! cursor-pointer border-0 duration-400 hover:opacity-65"
													data-accordion-target="#shopAccordion1"
													aria-expanded="true"
													aria-controls="shopAccordion1">
													<div class="flex items-center space-x-4">
														<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
															<path d="M17.2923 11.0417C17.2923 15.0667 14.0256 18.3333 10.0007 18.3333C5.97565 18.3333 2.70898 15.0667 2.70898 11.0417C2.70898 7.01667 5.97565 3.75 10.0007 3.75C14.0256 3.75 17.2923 7.01667 17.2923 11.0417Z" stroke="#303030" stroke-linecap="round" stroke-linejoin="round" />
															<path d="M10 6.66504V10.8317" stroke="#303030" stroke-linecap="round" stroke-linejoin="round" />
															<path d="M7.5 1.66504H12.5" stroke="#303030" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
														</svg>
														<span class="uppercase">
															<?php echo $faq['title'] ?>
														</span>
													</div>

													<!-- Include accordion arrows -->
													<?php
													require get_template_directory() . '/inc/common-sections/accordian-arrow.php';
													?>
												</button>
											</h2>
											<div id="shopAccordion1" class="hidden pb-6" aria-labelledby="shopAccordionTitle1">
												<div
													class="space-y-8 w-full text-sm text-(--theme-color) leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400 [&_strong]:inline-block">
													<?php echo $faq['description']; ?>
												</div>
											</div>
										</div>
									<?php } ?>

								</div>

							</div>
						<?php } ?>


					</div>
				</div>
			</div>
		</div>
	</section>


	<div id="shopModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-full max-h-screen duration-400 bg-(--theme-white)">
		<div class="relative w-full max-w-full max-h-full h-full flex justify-center items-center">
			<!-- Modal body -->
			<div class="max-h-screen">
				<div class="modalSlider flex transition-transform ease-in-out w-full max-h-screen">

					<?php echo $modalsliderItem; ?>

				</div>
			</div>
			<!-- Modal footer -->
			<div class="absolute flex items-center justify-center w-max mx-auto bottom-0 left-1/2 -translate-x-1/2 md:space-x-4.5 space-x-3 pb-10">
				<button class="previewBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
					<svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M8.25 0.75L2.25 6.75L8.25 12.75" stroke="currentColor" stroke-width="0.75" stroke-linecap="square" />
					</svg>
				</button>

				<button type="button" class="text-white bg-(--theme-color) p-0 cursor-pointer rounded-full w-12.5 h-12.5 md:w-14 md:h-14 flex justify-center items-center" data-modal-hide="shopModal">
					<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1 1L15 15M1 15L15 1" stroke="currentColor" />
					</svg>
				</button>

				<button class="nextBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
					<svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M3.75 12.75L9.75 6.75L3.75 0.75" stroke="currentColor" stroke-width="0.75" stroke-linecap="square" />
					</svg>


				</button>
			</div>
		</div>
	</div>

	<section class="bg-(--theme-color) py-6 md:py-8 text-white">
		<div class="container">
			<div class="-m-4">
				<div class="flex justify-center flex-wrap">

					<?php
					$shop_icons = [
						['img' => get_template_directory_uri() . '/assets/images/products-img/' . 'shopDetailsIcon1.svg', 'text' => __('Fri frakt', 'tusenrosor')],
						['img' => get_template_directory_uri() . '/assets/images/products-img/' . 'shopDetailsIcon2.svg', 'text' => __('Varar i över tre år', 'tusenrosor')],
						['img' => get_template_directory_uri() . '/assets/images/products-img/' . 'shopDetailsIcon3.svg', 'text' => __('Välj leveransdatum', 'tusenrosor')],
						['img' => get_template_directory_uri() . '/assets/images/products-img/' . 'shopDetailsIcon4.svg', 'text' => __('1 års garanti', 'tusenrosor')],
					];
					$deliveryDetails = get_theme_option_repeater_values('delivery_banner_option');
					if (!empty($deliveryDetails)) {
						$shop_icons = array();
						foreach ($deliveryDetails as $shopicon) {
							$shop_icons[] = [
								'img' => wp_get_attachment_url($shopicon['icon']),
								'text' => $shopicon['title'],
								'link' => $shopicon['page_link'],

							];
						}
					}
					//print_r($shop_icons);
					//print_r($deliveryDetails);

					?>

					<?php foreach ($shop_icons as $icon): ?>
						<a href="<?php echo  $icon['link']; ?>"
							class="text-center hover:opacity-65 flex flex-col items-center justify-center
                  lg:w-[calc(25%-32px)] w-[calc(50%-32px)] duration-400 m-4">
							<img class="max-w-6 mb-3 mx-auto object-contain"
								src="<?php echo  $icon['img']; ?>"
								alt="<?php echo esc_attr($icon['text']); ?>">
							<h6 class="uppercase md:text-xs text-[10px] font-normal leading-[150%] tracking-[18%]">
								<?php echo esc_html($icon['text']); ?>
							</h6>
						</a>
					<?php endforeach; ?>

				</div>
			</div>
		</div>
	</section>
	<?php
	global $product;
	$product_id = $product->get_id();

	// Get all reviews
	$comments = get_comments([
		'post_id' => $product_id,
		'status'  => 'approve',
		'orderby' => 'comment_date_gmt',
		'order'   => 'ASC',
		'number'  => 12,
	]);
	//print_r($comments);
	$average = $product->get_average_rating();
	$rating_count = $product->get_rating_count();
	$review_count = $product->get_review_count();
	?>
	<section class="section-padding">
		<div class="container">
			<div class="mb-6 md:mb-9">
				<h2
					class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
					<?php echo esc_html(__('Kundrecensioner', 'tusenrosor')); ?>
				</h2>
			</div>
			<div class="space-y-9">
				<div
					class="p-6 md:p-8 lg:px-12 lg:py-8 border border-[#EBEBEB] flex flex-col lg:flex-row 
                lg:space-x-12 lg:space-y-0 md:space-y-8 space-y-3">
					<div class="lg:pr-12 lg:border-r lg:border-[#EBEBEB] space-x-5 flex items-center">
						<h5 class="font-bold text-5xl leading-[150%]">
							<?php echo esc_html($average); ?>
						</h5>
						<div class="flex flex-col space-y-2.5 text-nowrap">
							<div class="flex items-center space-x-1">
								<?php
								$total_stars = 5;
								for ($i = 1; $i <= (int)$total_stars; $i++):
									if ($i <= $average):
								?>
										<svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M10.9091 0V15.7L4.16727 20L6.32727 12.4909L0 7.64L8.07818 7.3L10.9091 0ZM10.9091 0V15.7L17.6509 20L15.4909 12.4909L21.8182 7.64L13.74 7.3L10.9091 0Z" fill="#303030" />
										</svg>
									<?php else: ?>
										<svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path
												d="M10.9091 1.23639L13.4979 7.15097L13.6061 7.39426L13.8713 7.40586L20.2735 7.68361L15.1493 11.6691L14.9369 11.8325L15.0103 12.0946L16.6687 18.0992L11.1005 14.5637L10.9091 14.4419L10.7178 14.5637L5.14958 18.0992L6.80799 12.0946L6.88136 11.8325L6.66895 11.6691L1.54478 7.68361L7.94699 7.40586L8.21215 7.39426L8.32033 7.15097L10.9091 1.23639Z"
												stroke="#303030"
												stroke-width="1.5"
												stroke-linejoin="round" />
										</svg>
								<?php endif;
								endfor; ?>
							</div>
							<div class="text-sm leading-[165%] font-normal">
								<?php echo esc_html(__('Baserat på', 'tusenrosor')); ?> <?php echo esc_html($review_count); ?> <?php echo esc_html(__('recensioner', 'tusenrosor')); ?>
							</div>
						</div>
					</div>
					<div class="w-full flex items-center">
						<div class="w-full">
							<div class="-m-1.5 md:-m-2.5">
								<div class="flex flex-wrap justify-center xl:flex-nowrap w-full">



									<?php for ($i = 5; $i >= 1; $i--) :
										$count = $product->get_rating_counts()[$i] ?? 0;
									?>
										<div class="m-1.5 md:m-2.5 h-10 flex items-center justify-center space-x-2.5 text-sm leading-[165%] font-normal md:w-full md:flex-1 min-w-35 border border-[#EBEBEB] hover:border-(--theme-color) duration-400">
											<svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M8.72727 0V12.56L3.33382 16L5.06182 9.99273L0 6.112L6.46255 5.84L8.72727 0ZM8.72727 0V12.56L14.1207 16L12.3927 9.99273L17.4545 6.112L10.992 5.84L8.72727 0Z" fill="#303030" />
											</svg>
											<strong><?php echo $i; ?>.0</strong>
											<span>(<?php echo $count; ?>)</span>
										</div>
									<?php endfor; ?>

								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="">
					<div class="border-b border-[#EBEBEB] w-full flex justify-between items-center pb-3 space-x-2">
						<div class="text-base font-bold leading-[165%]">
							<?php echo esc_html(__('Recensioner', 'tusenrosor')); ?> (<?php echo $review_count; ?>)
						</div>
						<div>
							<select
								id="review-sort"
								class="text-right appearance-none focus:border-(--theme-color) duration-400 p-0 pr-7 w-full border-0 text-sm font-normal leading-[165%] bg-no-repeat bg-position-[right_center] bg-size-[16px_16px] cursor-pointer outline-0"
								style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/arrow-down.svg')">
								<option value="desc"><?php echo esc_html(__('Senaste', 'tusenrosor')); ?></option>
								<option value="asc"><?php echo esc_html(__('Äldsta', 'tusenrosor')); ?></option>
							</select>
						</div>
					</div>
					<div>
						<div id="reviews-container"
							data-product-id="<?php echo esc_attr($product->get_id()); ?>">

						</div>
						<?php
						$current_user = wp_get_current_user();
						$can_review = wc_customer_bought_product($current_user->user_email, $current_user->ID, $product_id);
						?>

						<?php if ($can_review): ?>
							<div class="max-w-[486px]">
								<form class="mt-9 space-y-4 w-full" method="post" enctype="multipart/form-data">
									<div>
										<h3 class="text-base font-bold leading-[165%]">
											<?php echo esc_html(__('Lämna en recension', 'tusenrosor')); ?>
										</h3>
									</div>
									<div class="relative">
										<label
											class="text-(--sub-text) text-[10px] absolute left-4 top-1.5 cursor-pointer"
											for="short">
											<?php echo esc_html(__('kort kommentar:', 'tusenrosor')); ?>
										</label>
										<input
											class="px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)"
											name="comment_title"
											id="short"
											required />
									</div>
									<div class="relative">
										<label
											class="text-(--sub-text) text-[10px] absolute left-4 top-1.5 cursor-pointer"
											for="user_rating">
											<?php echo esc_html(__('Betyg:', 'tusenrosor')); ?>
										</label>
										<select
											name="rating" id="user_rating" required
											class="appearance-none focus:border-(--theme-color) duration-400 px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] bg-no-repeat bg-position-[right_16px_center] bg-size-[10px_6px] cursor-pointer outline-0"
											style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/selectArrow.svg')">
											<option value="">
												<?php echo esc_html(__('Välj...', 'tusenrosor')); ?>
											</option>
											<option value="5.00">
												5 <?php echo esc_html(__('stjärnor', 'tusenrosor')); ?>
											</option>
											<option value="4.00">
												4 <?php echo esc_html(__('stjärnor', 'tusenrosor')); ?>
											</option>
											<option value="3.00">
												3 <?php echo esc_html(__('stjärnor', 'tusenrosor')); ?>
											</option>
											<option value="2.00">
												2 <?php echo esc_html(__('stjärnor', 'tusenrosor')); ?>
											</option>
											<option value="1.00">
												1 <?php echo esc_html(__('stjärnor', 'tusenrosor')); ?>
											</option>
										</select>
									</div>


									<div class="relative">
										<textarea
											class="w-full border border-[#EBEBEB] min-h-29 px-4 py-[9.5px] lg:py-[11.5px] text-base lg:text-sm leading-[165%] font-normal outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"
											name="review" id="review" required placeholder="Din recension:"></textarea>
									</div>
									<div class="relative">
										<label
											class="text-(--sub-text) text-[10px] absolute left-4 top-1.5 cursor-pointer"
											for="review_images">
											<?php echo esc_html(__('Ladda upp bilder:', 'tusenrosor')); ?>
										</label>

										<input
											class="px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) cursor-pointer"
											type="file"
											name="review_images[]"
											id="review_images"
											multiple accept="image/*">
									</div>

									<div>
										<button
											class="w-full min-h-12 px-4 p-1 text-sm text-[#FFFFFF] bg-(--theme-dark) border border-(--theme-dark) duration-400 hover:opacity-65 cursor-pointer uppercase font-medium tracking-[18%]"
											type="submit"
											name="submit_review">
											<?php echo esc_html(__('Skick', 'tusenrosor')); ?>
										</button>
									</div>
								</form>
							</div>
						<?php endif; ?>

						<div class="text-center mt-6 md:mt-9" id="loadmorebtnsec">
							<button type="button" id="load-more-review" href="#" class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
								<?php echo esc_html(__('Visa mer', 'tusenrosor')); ?>
							</button>
						</div>
					</div>
				</div>

			</div>
		</div>
	</section>
	<?php
	$related_ids = wc_get_related_products($product->get_id(), 15);
	if ($product instanceof WC_Product && !empty($related_ids)) {


	?>
		<section class="bg-(--theme-white) section-padding">
			<div class="container">
				<div class="mb-6 md:mb-9">
					<h2
						class="uppercase text-center text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
						<?php echo esc_html(__('Du kanske också gillar', 'tusenrosor')); ?>
					</h2>
				</div>
				<div>
					<div class="-m-[3px]">
						<div class="relative">
							<?php if (count($related_ids) > 4) { ?>
								<div class="sliderBtns hidden md:block">
									<button class="
                                leftBtn z-10 absolute -left-4 top-1/2 -translate-y-1/2
                                h-8 w-8 min-w-8 p-0.5 bg-transparent border-0 outline-0 shadow-none cursor-pointer flex items-center justify-center">
										<div class="text-center border-[1.5px] rounded-full flex items-center justify-center h-full w-full bg-(--theme-white)">
											<svg width="7" height="11" viewBox="0 0 7 11" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M5.44333 10.1633L0.75 5.45667L5.44333 0.75" stroke="#303030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
											</svg>
										</div>
									</button>
									<button class="
                                rightBtn z-10 absolute -right-4 top-1/2 -translate-y-1/2
                                h-8 w-8 min-w-8 p-0.5 bg-transparent border-0 outline-0 shadow-none cursor-pointer flex items-center justify-center">
										<div class="text-center border-[1.5px] rounded-full flex items-center justify-center h-full w-full bg-(--theme-white)">
											<svg width="7" height="11" viewBox="0 0 7 11" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M0.75 10.1633L5.44333 5.45667L0.75 0.75" stroke="#303030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
											</svg>
										</div>
									</button>
								</div>
							<?php } ?>
							<div class="scrollSlider flex whitespace-nowrap overflow-x-auto hide-scrollbar">

								<?php foreach ($related_ids as $rproduct_id) :

									if (! $product || ! $product->is_visible()) {
										continue;
									}

									// Make the product available to wc_get_template_part()
									global $product;
									$product = wc_get_product($rproduct_id);

									// Load WooCommerce default content-product.php
									wc_get_template_part('content', 'product');
								?>
								<?php endforeach; ?>

							</div>
						</div>
					</div>
				</div>
			</div>
		</section>

	<?php } ?>
	<?php do_action('woocommerce_after_single_product'); ?>
</main>

<script>
	jQuery(document).ready(function($) {
		// ===================================================
		// 📌 Existing setup
		// ===================================================
		const $navBtns = $(".navSlider .navBtn");
		const $mainItems = $(".mainSlider .mainSliderItem");
		const $mainSlider = $(".mainSlider");
		const $modal = $("#shopModal");
		const $modalSlider = $(".modalSlider");
		const $modalItems = $(".modalSlider .modalSliderItem");
		const $previewBtn = $(".previewBtn");
		const $nextBtn = $(".nextBtn");
		const $dots = $(".sliderDotBtn");

		let modalIndex = 0;
		let isUserScrolling = false;
		let currentIndex = 0;
		let isMobile = false;
		let touchStartX = 0;

		// ===================================================
		// 🖱️ Desktop Nav → Scroll behavior
		// ===================================================

		$navBtns.on("click", function() {
			const index = $(this).index();

			isUserScrolling = false;

			$navBtns.removeClass("active");
			$(this).addClass("active");

			const $target = $mainItems.eq(index);

			$("html, body").stop().animate({
				scrollTop: $target.offset().top
			}, 400, function() {
				setTimeout(() => {
					isUserScrolling = true;
				}, 200);
			});
		});

		// 👇 Removed mouseenter/leave restriction — always true for body scroll
		isUserScrolling = true;

		$(window).on("scroll", function() {
			if (!isUserScrolling) return;

			const scrollTop = $(window).scrollTop();
			const windowHeight = $(window).height();
			const triggerPoint = scrollTop + windowHeight * 0.4;
			let targetIndex = null;

			$mainItems.each(function(i) {
				const itemTop = $(this).offset().top;
				const itemBottom = itemTop + $(this).outerHeight();

				if (triggerPoint >= itemTop && triggerPoint < itemBottom) {
					targetIndex = i;
					return false;
				}
			});

			if (targetIndex !== null) {
				const $currentActive = $navBtns.filter(".active");
				const $newActive = $navBtns.eq(targetIndex);
				if (!$currentActive.is($newActive)) {
					$navBtns.removeClass("active");
					$newActive.addClass("active");
				}
			}
		});



		// ===================================================
		// 🧭 Modal Logic
		// ===================================================
		$mainItems.on("click", function() {
			const index = $(this).index();
			modalIndex = index;
			openModal(index);
		});

		function openModal(index) {
			$modal.removeClass("hidden").addClass("flex");
			updateModalSlider(index);
		}

		function updateModalSlider(index) {
			modalIndex = Math.max(0, Math.min(index, $modalItems.length - 1));
			const offset = -modalIndex * 100;
			$modalSlider.css({
				transform: `translateX(${offset}%)`,
				transition: "transform 0.4s ease",
			});

			$previewBtn.prop("disabled", modalIndex === 0);
			$nextBtn.prop("disabled", modalIndex === $modalItems.length - 1);
			$previewBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === 0);
			$nextBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === $modalItems.length - 1);
		}

		$previewBtn.on("click", function() {
			if (modalIndex > 0) {
				modalIndex--;
				updateModalSlider(modalIndex);
			}
		});

		$nextBtn.on("click", function() {
			if (modalIndex < $modalItems.length - 1) {
				modalIndex++;
				updateModalSlider(modalIndex);
			}
		});

		let startXModal = 0;
		$modal.on("touchstart", function(e) {
			startXModal = e.originalEvent.touches[0].pageX;
		});
		$modal.on("touchend", function(e) {
			const endXModal = e.originalEvent.changedTouches[0].pageX;
			const diffModal = endXModal - startXModal;

			if (Math.abs(diffModal) > 50) {
				if (diffModal < 0 && modalIndex < $modalItems.length - 1) {
					modalIndex++;
				} else if (diffModal > 0 && modalIndex > 0) {
					modalIndex--;
				}
				updateModalSlider(modalIndex);
			}
		});

		// ===================================================
		// 📱 Mobile Mode (Position-based mainSlider)
		// ===================================================
		function activateSlide(index) {
			currentIndex = index;
			$mainItems.removeClass("active").hide().eq(index).show().addClass("active");
			$dots.removeClass("active").eq(index).addClass("active");

			// Disable swipe/dot at boundaries (visual only, logic below blocks)
			$dots.prop("disabled", false);
			if (index === 0) $dots.first().prop("disabled", true);
			if (index === $mainItems.length - 1) $dots.last().prop("disabled", true);
		}

		function initMobileSlider() {
			if (isMobile) return;
			isMobile = true;

			$mainSlider.addClass("relative overflow-hidden").removeClass("flex lg:flex-col");
			$mainItems.addClass("absolute inset-0 transition-transform duration-500 ease-in-out hidden");
			activateSlide(0);

			// Dot click
			$dots.off("click").on("click", function() {
				const index = $(this).index();
				activateSlide(index);
			});

			// Swipe
			$mainSlider.off("touchstart touchend");
			$mainSlider.on("touchstart", (e) => (touchStartX = e.originalEvent.touches[0].clientX));
			$mainSlider.on("touchend", (e) => {
				const diff = e.originalEvent.changedTouches[0].clientX - touchStartX;
				if (Math.abs(diff) > 50) {
					if (diff < 0) nextSlide();
					else prevSlide();
				}
			});
		}

		function destroyMobileSlider() {
			if (!isMobile) return;
			isMobile = false;

			$mainSlider.removeClass("relative overflow-hidden").addClass("flex lg:flex-col");
			$mainItems.removeClass("absolute inset-0 transition-transform duration-500 ease-in-out hidden active").show();
			$dots.removeClass("active");
		}

		function nextSlide() {
			if (currentIndex < $mainItems.length - 1) {
				activateSlide(currentIndex + 1);
			}
		}

		function prevSlide() {
			if (currentIndex > 0) {
				activateSlide(currentIndex - 1);
			}
		}

		function checkMode() {
			if (window.innerWidth < 1024) initMobileSlider();
			else destroyMobileSlider();
		}

		checkMode();
		$(window).on("resize", checkMode);

		// ===================================================
		// ❌ Close modal
		// ===================================================
		$modal.find("[data-modal-hide]").on("click", function() {
			$modal.addClass("hidden").removeClass("flex");
		});
	});
</script>

<script>
	jQuery(document).ready(function($) {
		$('.scrollSlider').each(function() {
			const slider = $(this);
			const leftBtn = slider.siblings('.sliderBtns').find('.leftBtn');
			const rightBtn = slider.siblings('.sliderBtns').find('.rightBtn');

			let isDown = false,
				startX, scrollLeft;

			// Helper: can scroll horizontally?
			function canScroll() {
				const el = slider[0];
				return el.scrollWidth > el.clientWidth;
			}

			// ====== 🖱️ Drag to scroll ======
			slider.on('mousedown', function(e) {
				if (!canScroll()) return;
				isDown = true;
				slider.addClass('dragging');
				startX = e.pageX - slider.offset().left;
				scrollLeft = slider.scrollLeft();
				e.preventDefault();
			});

			slider.on('mouseleave mouseup', function() {
				isDown = false;
				slider.removeClass('dragging');
			});

			slider.on('mousemove', function(e) {
				if (!isDown || !canScroll()) return;
				const x = e.pageX - slider.offset().left;
				const walk = (x - startX) * 1.5;
				slider.scrollLeft(scrollLeft - walk);
			});

			// ====== 🖱️ Scroll with wheel ======
			slider.on('wheel', function(e) {
				const el = slider[0];
				if (!canScroll()) return;
				const newScroll = el.scrollLeft + e.originalEvent.deltaY;
				if (newScroll >= 0 && newScroll <= el.scrollWidth - el.clientWidth) {
					e.preventDefault();
					el.scrollLeft = newScroll;
				}
			});

			// ====== ⬅️➡️ Left/Right Buttons ======
			const scrollAmount = 700; // adjust scroll distance per click

			leftBtn.on('click', function() {
				slider.animate({
					scrollLeft: slider.scrollLeft() - scrollAmount
				}, 300);
			});

			rightBtn.on('click', function() {
				slider.animate({
					scrollLeft: slider.scrollLeft() + scrollAmount
				}, 300);
			});
		});

		//paper select
		$('#cardType').on('change', function() {
			const selected = $(this).find(':selected');
			const value = selected.val();
			const price = parseFloat(selected.data('price'));
			if (price) {
				jQuery('.paper_price').text(parseFloat(price));
			} else {
				jQuery('.paper_price').text(0);
			}

		});
	});
</script>