  <?php
    $subtotal = WC()->cart->get_subtotal();
    $tip_percent = get_theme_option_repeater_values('tip_percent');
    ?>

  <div class="space-y-4">
      <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
          <?php echo __('LÄGG TILL DRICKS', 'tusenrosor'); ?>
      </h3>
      <div class="text-sm leading-[165%]">
          <label class="p-4 bg-white border border-[#EBEBEB] flex items-center space-x-3 cursor-pointer duration-400 hover:opacity-65" for="wctip-enable">
              <input type="checkbox" id="wctip-enable" name="wctip_enable" value="yes">
              <span>
                  <?php echo __('Visa ditt stöd genom att ge dricks till din florist som binder din bukett', 'tusenrosor'); ?>
              </span>
          </label>
          <div id="wctip-box" class="hidden p-4 text-sm leading-[165%] bg-(--theme-white) border border-[#EBEBEB] border-t-0 space-y-3">
              <!-- Percentage buttons -->
              <?php if (!empty($tip_percent)) { ?>
                  <div class="flex border border-[#EBEBEB]">
                      <?php foreach ($tip_percent as $percentval) {
                            $percent = $percentval['percent'];
                            if ($percent) {
                                $percentConvert = (float)$percent / 100;
                                if ($percentConvert > 0) {
                        ?>
                                  <button type="button"
                                      data-percent="5"
                                      class="wctip-percent-btn bg-white flex-1 border-r border-[#EBEBEB] last:border-r-0 p-3 text-center text-sm cursor-pointer min-h-15 flex items-center justify-center flex-col leading-[165%] hover:opacity-65 duration-400" data-amount="<?php echo round((float)(WC()->cart->get_subtotal() * $percentConvert)); ?>">
                                      <?php echo $percent; ?> %
                                      <span class="text-[10px] text-(--sub-text)">
                                          (<?php echo wc_price(WC()->cart->get_subtotal() * $percentConvert); ?>)
                                      </span>
                                  </button>
                      <?php }
                            }
                        } ?>
                  </div>
              <?php } ?>
              <!-- Custom input -->
              <div class="flex flex-col md:flex-row md:space-x-2 space-y-2 md:space-y-0">
                  <div class="flex bg-white w-full">
                      <div class="flex items-center px-2.5 w-full">
                          <label for="wctip-amount" class="text-(--sub-text) text-nowrap cursor-pointer">
                              <?php echo __('Anpassat tips', 'tusenrosor'); ?>
                          </label>
                          <input
                              id="wctip-amount"
                              name="wctip_amount"
                              type="number"
                              min="0"
                              class="w-full border-0 rounded-0 pr-0.5 min-h-12 outline-none shadow-none [-moz-appearance:textfield] [&::-webkit-inner-spin-button]:m-0 [&::-webkit-inner-spin-button]:appearance-none [&::-webkit-outer-spin-button]:m-0 [&::-webkit-outer-spin-button]:appearance-none bg-transparent text-right"
                              value="0">
                      </div>
                      <div class="flex">
                          <span class="min-w-8 flex items-center justify-center h-full text-[13px]">
                              <?php echo __('Kr', 'tusenrosor'); ?>
                          </span>
                          <a href="javascript:void(0)"
                              type="button"
                              class="wctip-minus bg-transparent w-9 min-w-9 flex items-center justify-center h-full cursor-pointer">
                              <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path d="M0 5H10" stroke="#303030" />
                              </svg>
                          </a>
                          <a href="javascript:void(0)"
                              type="button"
                              class="wctip-plus bg-transparent w-9 min-w-9 flex items-center justify-center h-full cursor-pointer">

                              <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                                  <path d="M5 0V10M0 5H10" stroke="#303030" />
                              </svg>

                          </a>
                      </div>
                  </div>
                  <button href="javascript:void(0)"
                      disabled
                      type="button"
                      id="wctip-update"
                      class="uppercase min-h-12 px-3 p-1 w-full md:w-auto md:min-w-37.5 text-white bg-(--theme-dark) flex items-center justify-center text-sm cursor-pointer hover:opacity-65 duration-400 disabled:opacity-30 disabled:cursor-default">
                      <?php echo __('UPPDATERA', 'tusenrosor'); ?>
                  </button>
              </div>
              <div>
                  <p>
                      <?php echo __('Tack, det uppskattas.', 'tusenrosor'); ?>
                  </p>
              </div>
          </div>
      </div>
  </div>

  <div id="remember-me-section" class="space-y-4">

      <h3 class="uppercase text-base md:text-lg leading-[140%] tracking-[18%]">
          <?php echo __('Kom ihåg mig', 'tusenrosor'); ?>
      </h3>

      <div class="">
          <div class="text-sm leading-[165%]">
              <label class="p-4 bg-white border border-[#EBEBEB] flex items-center space-x-3 cursor-pointer duration-400 hover:opacity-65" for="remember-enable">
                  <input type="checkbox" id="remember-enable">
                  <span>
                      <?php echo __('Spara min information för snabbare betalning med ett Shop-konto', 'tusenrosor'); ?>
                  </span>
              </label>

              <!-- Phone field (hidden until checked) -->
              <div id="remember-phone-wrapper" class="hidden p-4 text-sm leading-[165%] bg-(--theme-white) border border-[#EBEBEB] border-t-0">
                  <label class="flex flex-col w-full space-y-1">
                      <p>
                          <?php echo __('Mobilnummer', 'tusenrosor'); ?>
                      </p>
                      <input
                          type="text"
                          id="remember-phone"
                          name="remember_phone"
                          placeholder="+46"
                          class="bg-white px-4 py-1 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text)">
                  </label>
                  <p id="remember-error" class="text-red-600 hidden mt-3">
                      <?php echo __('Ange telefonnummer matchar inte förväntat mönster.', 'tusenrosor'); ?>
                  </p>
              </div>
          </div>
      </div>
  </div>

  <script>
      jQuery(function($) {

          // Save tip via custom AJAX
          function saveTip(value = 0) {
              let amount = value > 0 ? value : parseFloat($("#wctip-amount").val());
              if (amount > 0) {
                  $('.checkout_total').addClass('animate-pulse');
                  $.ajax({
                      type: "POST",
                      url: wc_checkout_params.ajax_url,
                      data: {
                          action: "save_tip_amount",
                          tip_enable: $("#wctip-enable").is(":checked") ? 1 : 0,
                          tip_amount: amount
                      },
                      success: function() {
                          $(document.body).trigger("wc_fragment_refresh");
                          $('.checkout_total').removeClass('animate-pulse');
                      }
                  });
              }

          }

          // 1️⃣ Checkbox ONLY opens/closes box — no saving here
          $(document).on("change", "#wctip-enable", function() {
              if ($(this).is(":checked")) {
                  $("#wctip-box").removeClass("hidden");
              } else {
                  $("#wctip-box").addClass("hidden");
              }
          });

          // 2️⃣ Percentage buttons — set amount + save
          $(document).on("click", ".wctip-percent-btn", function() {

              $(".wctip-percent-btn").removeClass("active text-white bg-(--theme-color)!");
              $(this).addClass("active text-white bg-(--theme-color)!");

              let btnamount = $(this).data("amount");


              saveTip(btnamount); // Apply immediately
          });

          // 3️⃣ Minus button — update amount only
          $(document).on("click", ".wctip-minus", function() {
              let v = parseInt($("#wctip-amount").val()) || 0;
              $("#wctip-amount").val(Math.max(0, v - 1));
          });

          // 3️⃣ Plus button — update amount only
          $(document).on("click", ".wctip-plus", function() {
              let v = parseInt($("#wctip-amount").val()) || 0;
              $("#wctip-amount").val(v + 1);
          });

          // 4️⃣ Uppdatera button — save custom amount
          $(document).on("click", "#wctip-update", function() {
              let amount = parseInt($("#wctip-amount").val()) || 0;
              saveTip(amount);
          });
          $(document).on("change", "#remember-enable", function() {
              if ($(this).is(":checked")) {
                  $("#remember-phone-wrapper").removeClass("hidden");
              } else {
                  $("#remember-phone-wrapper").addClass("hidden");
                  $("#remember-error").addClass("hidden");
              }
          });

          // Optional: live validation (but NO checkout errors)
          $(document).on("input", "#remember-phone", function() {
              let phone = $(this).val().trim();
              let isValid = /^(\+46)[0-9]{6,12}$/.test(phone);

              if (!isValid && phone.length > 0) {
                  $("#remember-error").removeClass("hidden");
                  $(this).addClass("border-red-500");
              } else {
                  $("#remember-error").addClass("hidden");
                  $(this).removeClass("border-red-500");
              }
          });
      });
  </script>