<?php

/**
 * Thankyou page template (custom)
 * Based on view-order.php layout (no top navigation)
 *
 * @package WooCommerce/Templates
 * @version 9.5.0
 */

defined('ABSPATH') || exit;

$order_id = absint(get_query_var('order-received'));
$order = wc_get_order($order_id);

if (!$order) {
	wc_print_notice(__('Din beställning hittades inte.', 'tusenrosor'), 'error');
	return;
}
$order_date = $order->get_date_created() ? wc_format_datetime($order->get_date_created(), get_option('date_format')) : '';
$order_total = $order->get_formatted_order_total();
$order_status = wc_get_order_status_name($order->get_status());
?>

<section class="section-padding pt-0!">
	<div class="container">
		<div class="max-w-[800px] mx-auto">
			<div class="space-y-6 md:space-y-8">

				<!-- ✅ Reuse order header -->
				<div class="">
					<div class="p-4 md:p-6 flex justify-between items-center font-normal leading-[140%] text-(--white) bg-(--theme-dark)">
						<div class="space-y-2">
							<h2 class="text-xl md:text-[28px] tracking-[18%] uppercase">
								<?php echo esc_html('#' . $order->get_order_number()); ?>
							</h2>
							<div class="flex items-center text-xs md:text-sm leading-[165%] space-x-2">
								<span>
									<?php echo esc_html(wc_get_order_status_name($order->get_status())); ?>
								</span>
								<svg width="4" height="4" viewBox="0 0 4 4" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M1.88969 3.77C0.859688 3.77 0.00968753 2.94 0.00968753 1.89C-0.000312418 0.840003 0.839688 3.21865e-06 1.88969 3.21865e-06C2.93969 3.21865e-06 3.77969 0.840003 3.77969 1.89C3.77969 2.94 2.91969 3.77 1.88969 3.77Z" fill="white" />
								</svg>
								<span>
									<?php echo esc_html(wc_format_datetime($order->get_date_created())); ?>
								</span>
							</div>
						</div>
						<h4 class="text-xl md:text-[28px] tracking-[18%] uppercase">
							<?php echo wp_kses_post($order->get_formatted_order_total()); ?>
						</h4>
					</div>

					<!-- Include your progress stepper if needed (optional) -->
					<?php include(get_template_directory() . '/woocommerce/myaccount/order-status.php');
					?>
				</div>

				<!-- ✅ Reuse order items section -->
				<div class="">
					<div class="p-4 md:p-6 border border-b-0 border-[#EBEBEB]">
						<h2 class="text-base md:text-lg font-normal leading-[140%] tracking-[18%] text-(--theme-color) uppercase">
							<?php esc_html_e('ORDERDETALJER', 'tusenrosor'); ?>
						</h2>
					</div>
					<div class="p-4 md:p-6 border border-[#EBEBEB] space-y-5">
						<div class="w-full [&>.cartItem:first-child]:pt-0">
							<?php require get_template_directory() . '/woocommerce/order/order-item.php'; ?>
						</div>
						<?php
						$method = $order->get_meta('_delivery_method');
						$date   = $order->get_meta('_delivery_date');
						$price  = $order->get_meta('_delivery_price');
						?>
						<!-- Totals -->
						<div class="border-t border-[#E0E0E0] pt-4 text-sm text-(--theme-color)">
							<div class="flex justify-between py-1"><span><?php esc_html_e('Delsumma', 'tusenrosor'); ?></span><span><?php echo wp_kses_post($order->get_subtotal_to_display()); ?></span></div>

							<?php
							if (!empty($order->get_fees())) {
								foreach ($order->get_fees() as $fee) {
							?>
									<div class="flex justify-between py-1"><span><?php esc_html_e($fee->get_name(), 'tusenrosor'); ?></span><span><?php echo wc_price($fee->get_total()); ?></span></div>

							<?php
								}
							}

							?>
							<div class="flex justify-between py-1 font-bold"><span><?php esc_html_e('Totalt', 'tusenrosor'); ?></span><span><?php echo wp_kses_post($order_total); ?></span></div>


						</div>
					</div>
				</div>


				<!-- ===== Customer Details ===== -->
				<div class="">
					<div class="p-4 md:p-6 border border-b-0 border-[#EBEBEB]">
						<h2 class="text-base md:text-lg font-normal leading-[140%] tracking-[18%] text-(--theme-color) uppercase">
							<?php esc_html_e('BESTÄLLNINGSDETALJER', 'tusenrosor'); ?>
						</h2>
					</div>

					<div class="p-4 md:p-6 border border-[#EBEBEB] space-y-3 md:space-y-[13px] text-sm font-normal leading-[165%] text-(--theme-color)">
						<div class="flex justify-between space-x-3 w-full">
							<div class="w-full space-y-[18px]">

								<!-- Kontaktinformation -->
								<div class="space-y-1.5">
									<span class="text-xs text-[#787878]"><?php esc_html_e('Kontaktinformation', 'tusenrosor'); ?></span>
									<p><?php echo esc_html($order->get_billing_email()); ?></p>
								</div>

								<!-- Leveransadress -->
								<div class="space-y-1.5">
									<span class="text-xs text-[#787878]"><?php esc_html_e('Leveransadress', 'tusenrosor'); ?></span>
									<?php

									$shipping_address1 = $order->get_shipping_address_1();
									$shipping_address2 = $order->get_shipping_address_2();
									if ($shipping_address1 || $shipping_address2) :
										$shipping_name = trim($order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name());
									?>
										<p><?php echo esc_html($shipping_name); ?></p>
										<p><?php echo esc_html($shipping_address1); ?></p>
										<p><?php echo esc_html($shipping_address2); ?></p>
									<?php else : ?>
										<p><?php echo esc_html__('Ingen leveransadress tillgänglig.', 'tusenrosor'); ?></p>
									<?php endif; ?>
								</div>
							</div>

							<div class="w-full space-y-[18px]">

								<!-- Betalningsmetod -->
								<div class="space-y-1.5">
									<span class="text-xs text-[#787878]"><?php esc_html_e('Betalningsmetod', 'tusenrosor'); ?></span>
									<?php
									$payment_method = $order->get_payment_method(); // e.g. 'stripe', 'paypal', 'cod'
									$payment_title = $order->get_payment_method_title();

									// Choose logo based on method slug
									$theme_uri = get_template_directory_uri() . '/assets/images/payment-card/';
									$logo = '';

									if (strpos(strtolower($payment_method), 'visa') !== false) {
										$logo = $theme_uri . 'visa.png';
									} elseif (strpos(strtolower($payment_method), 'master') !== false) {
										$logo = $theme_uri . 'mastercard.png';
									} elseif (strpos(strtolower($payment_method), 'paypal') !== false) {
										$logo = $theme_uri . 'paypal.png';
									} elseif (strpos(strtolower($payment_method), 'stripe') !== false) {
										$logo = $theme_uri . 'visa.png'; // stripe uses Visa/MasterCard UI
									}
									?>
									<p class="flex space-x-1.5">
										<?php if ($logo): ?>
											<img class="w-[38px] min-w-[38px] h-6 object-cover object-center bg-[#F7F4F4]" src="<?php echo esc_url($logo); ?>" alt="payment-logo">
										<?php endif; ?>
										<span>
											<?php echo esc_html($payment_title); ?>
										</span>
									</p>
								</div>

								<!-- Faktureringsadress -->
								<div class="space-y-1.5">
									<span class="text-xs text-[#787878]"><?php esc_html_e('Faktureringsadress', 'tusenrosor'); ?></span>
									<?php
									$billing_address1 = $order->get_billing_address_1();
									$billing_address2 = $order->get_billing_address_2();
									$billing_name = trim($order->get_billing_first_name() . ' ' . $order->get_billing_last_name());
									?>
									<p><?php echo esc_html($billing_name); ?></p>
									<p><?php echo esc_html($billing_address1); ?></p>
									<p><?php echo esc_html($billing_address2); ?></p>
								</div>
							</div>
						</div>

						<!-- Leveranssätt -->
						<div class="space-y-1.5">
							<span class="text-xs text-[#787878]"><?php esc_html_e('Leveranssätt', 'tusenrosor'); ?></span>
							<?php
							$shipping_method = $order->get_shipping_method();
							$shipping_total  = $order->get_shipping_total();
							$delivery_text   = $shipping_total > 0 ? wc_price($shipping_total) : __('GRATIS', 'tusenrosor');
							?>
							<p>
								<?php echo esc_html($shipping_method ? $shipping_method : __('Ej angivet', 'tusenrosor')); ?>
								– <?php echo esc_html($delivery_text); ?>
							</p>
							<p class="text-[#787878]">
								<?php esc_html_e('Leveranstid: ' . $order->get_meta('_delivery_leveranstid') . '', 'tusenrosor'); ?>
							</p>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</section>