<?php

/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if (! defined('ABSPATH')) {
	exit;
}



// Stop if checkout registration is disabled
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
	echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
	return;
}
$cart           = WC()->cart;
$cart_total     = $cart->get_total(); // formatted
?>

<section class="flex lg:flex-row flex-col-reverse items-stretch overflow-hidden">
	<div class="lg:min-h-screen px-4 py-8 lg:px-8 lg:py-12 w-full lg:w-[51.3%]">
		<div class="max-w-[486px] lg:mr-0 mx-auto">
			<div class="hidden lg:block w-full lg:mb-12">
				<?php
				require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
				?>
			</div>
			<div class="md:space-y-12 space-y-8">
				<div id="checkoutStep1" class="space-y-5 formstep">
					<?php require get_template_directory() . '/woocommerce/checkout/checkout-step-1.php';
					?>
				</div>
				<div id="checkoutStep2" class="md:space-y-8 space-y-6 hidden formstep">
					<?php require get_template_directory() . '/woocommerce/checkout/checkout-step-2.php';
					?>
				</div>
				<!-- ✅ Step 3: Betalning -->
				<div id="checkoutStep3" class="space-y-5 formstep hidden">
					<?php require get_template_directory() . '/woocommerce/checkout/checkout-step-3.php';
					?>
				</div>

				<!-- Include small footer -->
				<?php
				require get_template_directory() . '/inc/common-sections/checkout-small-footer.php';
				?>
			</div>
		</div>
	</div>
	<div id="dinOrder"
		data-accordion="collapse"
		data-active-classes="border-b border-[#EBEBEB]"
		class="w-full lg:w-[48.7%] bg-(--bg2) lg:min-h-screen lg:fixed lg:right-0 lg:top-0 lg:bottom-0">
		<h2 id="dinOrderHeading-1" class="lg:hidden">
			<button type="button"
				class="w-full p-4 md:py-6 rtl:text-right cursor-pointer bg-(--bg2) text-(--theme-dark)!"
				data-accordion-target="#dinOrderBody-1" aria-expanded="false" aria-controls="dinOrderBody-1">
				<div class="flex items-center justify-between max-w-[486px] mx-auto">
					<div class="flex items-center justify-between space-x-2 text-(--theme-dark)">
						<span class="font-medium text-sm leading-[165%]">
							<?php echo esc_html(__('Din order', 'woocommerce')); ?>
						</span>
						<svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0 duration-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
							<path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5" />
						</svg>
					</div>
					<div class="text-lg leading-[140%] tracking-[18%] font-normal">
						<?php echo $cart_total; ?>
					</div>
				</div>

			</button>
		</h2>
		<div
			id="dinOrderBody-1" aria-labelledby="dinOrderHeading-1"
			class="w-full hidden lg:block">
			<div class="flex flex-col lg:max-h-screen px-4 py-8 lg:px-8 lg:py-12">
				<div class="max-w-[486px] lg:max-w-[450px] mx-auto lg:ml-0 w-full [&>.cartItem:first-child]:pt-0 lg:overflow-y-auto lg:grow pt-3">
					<!-- Include product single cart -->

					<?php wc_get_template('cart/cart-items.php', ['checkoutpage' => 'true']) ?>


				</div>
				<div class="max-w-[486px] lg:max-w-[450px] mx-auto lg:ml-0 w-full pt-5">
					<!-- Include subtotal-totalt-part -->
					<?php
					require get_template_directory() . '/woocommerce/checkout/cart-total.php';
					?>
				</div>
			</div>
		</div>
	</div>
	<div class="px-4 py-8 lg:px-8 lg:py-12 w-full lg:hidden">
		<?php
		require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
		?>
	</div>
</section>

<!-- <script>
	jQuery(function($) {
		const prefix = "step1_";

		//Only apply inside Step 1 container
		$("#checkoutStep1 [id^='billing_']").each(function() {
			const originalId = $(this).attr("id");
			const newId = prefix + originalId;

			// Update id attribute
			$(this).attr("id", newId);

			// Update any label[for] referencing it
			$(`label[for='${originalId}']`).attr("for", newId);
		});
		let isSyncing = false; // 🚫 prevents infinite recursion

		function switchStep(current) {
			$('.formstep').hide();
			$(`#checkoutStep${current}`).fadeIn(300);
			$('.btn-step').removeClass('active');
			$(`.btn-step-${current}`).addClass('active');
		}

		$('.goToStep1').on('click', function(e) {
			e.preventDefault();
			switchStep('1');
		});
		$('.goToStep2').on('click', function(e) {
			e.preventDefault();
			switchStep('2');
		});
		$('.goToStep3').on('click', function(e) {
			e.preventDefault();
			switchStep('3');
		});


		function syncBillingFields(sourceSelector, targetSelector) {
			$(document).on('input change', `${sourceSelector} [name^="billing_"]`, function() {
				if (isSyncing) return;
				isSyncing = true;

				const name = $(this).attr('name');
				const value = $(this).val();
				const $target = $(`${targetSelector} [name="${name}"]`);

				if ($target.length) {
					$target.val(value);

					// 🔹 Special handling for select2/Chosen dropdowns like billing_country
					if ($target.is('select')) {
						// Update select2 UI
						$target.trigger('change.select2');
					} else {
						$target.trigger('input');
					}
				}

				setTimeout(() => (isSyncing = false), 100);
			});
		}

		// Step 1 ➜ Step 3
		syncBillingFields('.billingform', 'form.woocommerce-checkout');
		// Step 3 ➜ Step 1
		syncBillingFields('form.woocommerce-checkout', '.billingform');

		// Prefill Step 1 on page load
		$('.billingform [name^="billing_"]').each(function() {
			const name = $(this).attr('name');
			const val = $(this).val();
			const $real = $(`form.woocommerce-checkout [name="${name}"]`);
			if ($real.length) {
				$real.val(val);
				if ($real.is('select')) {
					$real.trigger('change.select2');
				}
			}
		});
		//state
		const step1Country = $('#checkoutStep1 select[name="billing_country"]');
		const step1State = $('#checkoutStep1 [name="billing_state"]');
		const wcStates = wc_country_select_params.countries; // from WooCommerce global

		// Helper to rebuild state options
		function buildStateOptions(countryCode) {
			const wcStates = window.wc_country_select_params.countries;
			const states = wcStates[countryCode];
			console.log(states);
			if (states) {
				let html = '';
				$.each(states, function(code, name) {
					html += `<option value="${code}">${name}</option>`;
				});
				step1State.replaceWith(`<select name="billing_state" id="step1_billing_state" class="input-text">${html}</select>`);
			} else {
				// country has no states
				step1State.replaceWith(`<input type="text" name="billing_state" id="step1_billing_state" class="input-text" />`);
			}
		}

		// Initial load
		const initialCountry = step1Country.val();
		alert(initialCountry);
		if (initialCountry) buildStateOptions(initialCountry);

		// When country changes in Step 1
		step1Country.on('change', function() {
			buildStateOptions($(this).val());
		});
		//state
	});
</script> -->