<?php

/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_cart'); ?>

<div class="max-w-[800px] mx-auto cartSection">
	<?php do_action('woocommerce_before_cart_table'); ?>
	<div>
		<?php wc_get_template('cart/cart-items.php', ['wrapper_id' => 'PagecartItems']) ?>
	</div>
	<?php do_action('woocommerce_before_cart_collaterals'); ?>
	<div class="pt-4 md:pt-6">
		<?php wc_get_template('cart/cart-total.php', ['wrapper_id' => 'PagecartItemTotalBtn']) ?>
	</div>

	<?php do_action('woocommerce_after_cart_table'); ?>



	<?php do_action('woocommerce_after_cart'); ?>
</div>