<?php

/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

get_header('shop');

$shop_page_id = wc_get_page_id('shop');
$banner_bottom_section = get_theme_option_repeater_values('shop_banner_bottom_section');
$args_query = array();
if (is_shop()) {
    // WooCommerce Shop page
    $title = get_the_title(wc_get_page_id('shop'));
} elseif (is_product_category() || is_product_tag()) {
    // Product category or tag archive
    $term = get_queried_object();
    $title = $term->name;
    // $args_query[] = [
    //     'taxonomy' => 'product_cat',
    //     'field' => 'slug',
    //     'terms' => (array) $term,
    // ];
} elseif (is_tax()) {
    // Any custom taxonomy related to products
    $term = get_queried_object();
    $title = $term->name;
} else {
    // Fallback (e.g., search or other)
    $title = post_type_archive_title('', false);
}
global $wp_query;
$cat_id = '';


$priceData = ShopHelper::get_filter_price_range_min_max($args_query);

$min = isset($priceData['min']) ? $priceData['min'] : '0';
$max = isset($priceData['max']) ? $priceData['max'] : '0';
$pa_color = isset($_GET['pa_color']) ? $_GET['pa_color'] : '';
if ($pa_color) {
    $paterm = get_term_by('slug', $pa_color, 'pa_color');
    // $args_query[] = [
    //     'taxonomy' => 'pa_color',
    //     'field' => 'slug',
    //     'terms' => (array) $paterm,
    // ];
}
// echo '<pre style="background:#000;color:#0f0;padding:10px;">';
// echo "IS_MAIN_QUERY: " . ($wp_query->is_main_query() ? 'true' : 'false') . "\n";
// echo "Post Type: " . esc_html($wp_query->query_vars['post_type'] ?? 'undefined') . "\n";
// echo "Posts per page: " . esc_html($wp_query->query_vars['posts_per_page'] ?? 'undefined') . "\n";
// echo "Paged: " . esc_html(get_query_var('paged')) . "\n";
// echo "Found posts: " . esc_html($wp_query->found_posts) . "\n";
// echo "Max pages: " . esc_html($wp_query->max_num_pages) . "\n";
// echo '</pre>';
?>
<main>
    <section class="bg-cover bg-no-repeat bg-center"
        style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/shopBanner.webp');">
        <div class="bg-black/50 min-h-[250px] md:min-h-[400px] p-4 flex items-center justify-center">
            <div class="max-w-[1000px] mx-auto">
                <div class="w-full text-white text-center [&>*+*]:mt-3 md:[&>*+*]:mt-5 font-normal tracking-[18%]">
                    <h1 class="text-xl md:text-[28px] leading-[140%] text-shadow-[0_2px_3px_#3030304D] uppercase">
                        <?php echo $title; ?>
                    </h1>
                    <?php if (get_field('subtitle', $shop_page_id)) { ?>
                        <p class="hidden md:block text-sm font-medium tracking-[18%] text-shadow-[0_2px_3px_#3030304D]">
                            <?php echo get_field('subtitle', $shop_page_id); ?>
                        </p>
                    <?php } ?>
                    <?php if (get_field('subtitle', $shop_page_id)) { ?>
                        <p class="md:hidden text-sm font-medium tracking-[18%] text-shadow-[0_2px_3px_#3030304D]">
                            <?php echo get_field('subtitle', $shop_page_id); ?>
                        </p>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
    <!-- require grid slider section -->
    <?php
    if (!empty($banner_bottom_section)) {
        require get_template_directory() . '/inc/common-sections/second-grid-slider-section.php';
    }

    ?>
    <section class="border-y border-[#EBEBEB]">
        <div
            class="flex flex-wrap md:flex-nowrap items-stretch text-(--sub-text) uppercase text-[10px] md:text-xs font-normal leading-[130%] md:leading-[165%] tracking-[18%]">
            <div
                class="space-x-1 md:flex-1 border-b md:border-b-0 md:border-r border-[#EBEBEB] min-h-[45px] md:min-h-14 justify-center lg:justify-center md:justify-left flex items-center px-8 w-full md:w-auto">
                <span id="totalProduct"><?php echo ShopHelper::get_total_products_count($args_query); ?>
                </span> <span> <?php echo esc_html(__('produkter', 'tusenrosor')) ?></span>
            </div>

            <form class="w-1/2 md:w-full md:max-w-[315px] lg:max-w-[347px] px-8 md:px-12">
                <select name="orderby" class="min-h-[45px]! md:min-h-14! block h-full p-0! w-full bg-transparent! border-0!
                    appearance-none focus:outline-none focus:ring-0! peer uppercase bg-none!
                    cursor-pointer text-[10px]! md:text-xs! text-(--sub-text)!" data-filter="orderby">
                    <?php ShopHelper::render_orderby_filter(); ?>
                </select>
            </form>
            <button
                class="lg:hidden w-1/2 md:w-auto md:min-w-[130px] flex items-center justify-center  border-l border-[#EBEBEB] px-8 text-(--sub-text) uppercase text-[10px] md:text-xs font-normal leading-[130%] md:leading-[165%] tracking-[18%] cursor-pointer"
                type="button" data-drawer-target="shopFilterDrawer" data-drawer-show="shopFilterDrawer"
                data-drawer-placement="right" aria-controls="shopFilterDrawer">

                <?php echo esc_html(__('Filtrera', 'tusenrosor')) ?>
            </button>
        </div>
    </section>



    <section class="section-padding">
        <div class="container">
            <div class="lg:flex lg:space-x-12">
                <div class="w-full lg:min-w-60 lg:w-60">
                    <div class="w-full">
                        <div id="shopFilterDrawer" class="sideDrawer fixed top-0 right-0 z-40 bottom-0 transition-transform translate-x-full bg-(--theme-white) w-[94%] max-w-[350px] md:max-w-[514px] duration-400 flex flex-col
                            
                            lg:static lg:translate-none lg:transform-none lg:w-full lg:h-auto lg:bg-transparent"
                            tabindex="-1" aria-labelledby="drawer-right-label">
                            <div
                                class="lg:hidden drawer-header px-4 py-5 md:px-8 md:py-4.5 border-b border-[#EBEBEB] flex justify-between items-center">
                                <h5
                                    class="uppercase text-base md:text-lg text-(--theme-color) mb-0! font-normal leading-[140%]">
                                    <?php echo esc_html(__('Filtrera', 'tusenrosor')) ?>
                                </h5>
                                <button
                                    class="hover:opacity-65 duration-400 bg-transparent p-0 border-0 h-6 w-6 flex items-center justify-center cursor-pointer relative"
                                    type="button" data-drawer-hide="shopFilterDrawer" aria-controls="shopFilterDrawer">
                                    <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                        fill="none" viewBox="0 0 14 14">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                    </svg>
                                    <span class="sr-only"><?php echo esc_html(__('Close
                                        menu', 'tusenrosor')) ?></span>
                                </button>
                            </div>
                            <div class="drawer-body overflow-y-auto grow p-0 lg:overflow-hidden">

                                <div id="shopFiterAccordion" class="lg:-mt-6.5" data-accordion="open"
                                    data-active-classes="border-0" data-inactive-classes="border-b">

                                    <div class="accordionItem">
                                        <h2 id="filterHeading-1">
                                            <button type="button"
                                                class="flex items-center justify-between w-full font-normal border-[#EBEBEB] gap-3 uppercase text-xs leading-[165%] tracking-[18%] cursor-pointer py-6.5 px-4 md:px-8 lg:px-0 hover:opacity-65 text-(--theme-color) border-0"
                                                data-accordion-target="#filterBody-1" aria-expanded="true"
                                                aria-controls="filterBody-1" fdprocessedid="vjdx5">
                                                <span><?php echo esc_html(__('Status', 'tusenrosor')) ?></span>
                                                <div class="relative h-4 w-4">
                                                    <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/plusIcon.svg"
                                                        alt="Arrow">
                                                    <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/minusIcon.svg"
                                                        alt="Arrow">
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="filterBody-1" class="" aria-labelledby="filterHeading-1">
                                            <div
                                                class="pb-4.5 border-b border-[#EBEBEB] text-sm leading-[165%] text-black">
                                                <div class="flex flex-col">


                                                    <?php
                                                    $statusCategories = ShopHelper::get_statusCategories();

                                                    foreach ($statusCategories as $s): ?>
                                                        <label for="status<?php echo $s['id']; ?>"
                                                            class="px-4 md:px-8 lg:px-0 flex items-center py-1.5 space-x-3 cursor-pointer">
                                                            <input id="status<?php echo $s['id']; ?>" type="checkbox"
                                                                class="sr-only peer"
                                                                data-filter="<?php echo esc_attr($s['key']); ?>"
                                                                <?php echo !empty($filters[$s['key']]) ? 'checked' : ''; ?>>
                                                            <div class="relative w-9 h-4 bg-[#30303033] rounded-full transition-colors
                                            peer-focus:outline-none
                                            after:content-[''] after:absolute after:top-1/2 after:left-[3px]
                                            after:-translate-y-1/2 after:bg-white after:rounded-full after:h-2.5 after:w-2.5
                                            after:transition-all after:duration-300
                                            after:shadow-[0px_1px_1px_0px_#00000033]
                                            peer-checked:after:left-[calc(100%-3px)] peer-checked:after:-translate-x-full
                                            peer-checked:bg-(--theme-color)"></div>
                                                            <span><?php echo esc_html($s['label']); ?></span>
                                                        </label>
                                                    <?php endforeach; ?>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordionItem">
                                        <h2 id="filterHeading-2">
                                            <button type="button"
                                                class="flex items-center justify-between w-full font-normal border-[#EBEBEB] gap-3 uppercase text-xs leading-[165%] tracking-[18%] cursor-pointer py-6.5 px-4 md:px-8 lg:px-0 hover:opacity-65 text-(--theme-color) border-0"
                                                data-accordion-target="#filterBody-2" aria-expanded="true"
                                                aria-controls="filterBody-2" fdprocessedid="8g6lz9">
                                                <span><?php echo esc_html(__('KOLLEKTION', 'tusenrosor')) ?></span>
                                                <div class="relative h-4 w-4">
                                                    <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/plusIcon.svg"
                                                        alt="Arrow">
                                                    <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/minusIcon.svg"
                                                        alt="Arrow">
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="filterBody-2" class="" aria-labelledby="filterHeading-2">
                                            <div
                                                class="pb-4.5 border-b border-[#EBEBEB] text-sm leading-[165%] text-black">
                                                <div class="flex flex-col" id="collection-filter">

                                                    <?php ShopHelper::get_filter_collection($args_query) ?>


                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordionItem">
                                        <h2 id="filterHeading-3">
                                            <button type="button"
                                                class="flex items-center justify-between w-full font-normal border-[#EBEBEB] gap-3 uppercase text-xs leading-[165%] tracking-[18%] cursor-pointer py-6.5 px-4 md:px-8 lg:px-0 hover:opacity-65 text-(--theme-color) border-0"
                                                data-accordion-target="#filterBody-3" aria-expanded="true"
                                                aria-controls="filterBody-3" fdprocessedid="0facz5">
                                                <span><?php echo esc_html(__('FÄRG', 'tusenrosor')) ?></span>
                                                <div class="relative h-4 w-4">
                                                    <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/plusIcon.svg"
                                                        alt="Arrow">
                                                    <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/minusIcon.svg"
                                                        alt="Arrow">
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="filterBody-3" class="" aria-labelledby="filterHeading-3">
                                            <div
                                                class="px-4 md:px-8 lg:px-0 pb-6 border-b border-[#EBEBEB] text-xs leading-[165%] text-(--theme-color)">
                                                <div class="grid grid-cols-4 lg:grid-cols-3 md:grid-cols-6 gap-3"
                                                    id="farg-filter">

                                                    <?php ShopHelper::get_filter_farg($args_query) ?>





                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordionItem">
                                        <h2 id="filterHeading-4">
                                            <button type="button"
                                                class="flex items-center justify-between w-full font-normal border-[#EBEBEB] gap-3 uppercase text-xs leading-[165%] tracking-[18%] cursor-pointer py-6.5 px-4 md:px-8 lg:px-0 hover:opacity-65 text-(--theme-color) border-0"
                                                data-accordion-target="#filterBody-4" aria-expanded="true"
                                                aria-controls="filterBody-4" fdprocessedid="mim4df">
                                                <span><?php echo esc_html(__('Gradering', 'tusenrosor')) ?></span>
                                                <div class="relative h-4 w-4">
                                                    <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/plusIcon.svg"
                                                        alt="Arrow">
                                                    <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/minusIcon.svg"
                                                        alt="Arrow">
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="filterBody-4" class="" aria-labelledby="filterHeading-4">
                                            <div
                                                class="pb-4.5 border-b border-[#EBEBEB] text-sm leading-[165%] text-(--sub-text)">
                                                <div class="flex flex-col" id="rating-filter">
                                                    <?php ShopHelper::get_filter_rating($args_query); ?>


                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="accordionItem">
                                        <h2 id="filterHeading-5">
                                            <button type="button"
                                                class="flex items-center justify-between w-full font-normal border-[#EBEBEB] gap-3 uppercase text-xs leading-[165%] tracking-[18%] cursor-pointer py-6.5 px-4 md:px-8 lg:px-0 hover:opacity-65 text-(--theme-color) border-0"
                                                data-accordion-target="#filterBody-5" aria-expanded="true"
                                                aria-controls="filterBody-5" fdprocessedid="06qdqd">
                                                <span> <?php echo esc_html(__('PRIS', 'tusenrosor')) ?></span>
                                                <div class="relative h-4 w-4">
                                                    <img class="plusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/plusIcon.svg"
                                                        alt="Arrow">
                                                    <img class="minusIcon transition-transform duration-400 absolute top-0 bottom-0 left-0 right-0 h-4 w-4 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/minusIcon.svg"
                                                        alt="Arrow">
                                                </div>
                                            </button>
                                        </h2>
                                        <div id="filterBody-5" class="" aria-labelledby="filterHeading-5">
                                            <div
                                                class="px-4 md:px-8 lg:px-0 pb-6 border-b border-[#EBEBEB] text-sm leading-[165%] text-(--sub-text)">
                                                <div class="priceRnageWrapper" id="price-filter">
                                                    <?php ShopHelper::get_filter_price_range($args_query) ?>

                                                </div>

                                            </div>

                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
                <div class="w-full">
                    <div class="pb-3">
                        <div class="-m-1 md:-m-[5px]">
                            <div class="flex flex-wrap text-xs md:text-sm leading-[165%] active-filter">
                                <?php
                                if (class_exists('ShopHelper')) {
                                    ShopHelper::render_active_filters();
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="-m-1.5">
                        <div class="flex flex-wrap woocommerce-products-area">
                            <?php
                            if (woocommerce_product_loop()) {

                                /**
                                 * Hook: woocommerce_before_shop_loop.
                                 *
                                 * @hooked woocommerce_output_all_notices - 10
                                 * @hooked woocommerce_result_count - 20
                                 * @hooked woocommerce_catalog_ordering - 30
                                 */
                                //do_action('woocommerce_before_shop_loop');

                            ?>

                                <?php
                                if (wc_get_loop_prop('total')) {
                                    while (have_posts()) {
                                        the_post();

                                        /**
                                         * Hook: woocommerce_shop_loop.
                                         */

                                        do_action('woocommerce_shop_loop');
                                        wc_get_template_part('content', 'product');
                                    }
                                }
                                /**
                                 * Hook: woocommerce_after_shop_loop.
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                            } else {
                                ?>
                                <div class="m-1.5 w-full flex items-center justify-center min-h-50">
                                    <?php
                                    /**
                                     * Hook: woocommerce_no_products_found.
                                     *
                                     * @hooked wc_no_products_found - 10
                                     */
                                    do_action('woocommerce_no_products_found');
                                    ?>
                                </div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>

                    <div class="text-center mt-6 md:mt-9">
                        <div class="tusenrosorPagination mx-auto ajax-woocommerce-pagination">
                            <?php do_action('woocommerce_after_shop_loop'); ?>
                        </div>
                    </div>
                </div>
            </div>
    </section>
    <?php $faqs = get_theme_option_repeater_values('faq', $shop_page_id);
    if (!empty($faqs)) {
    ?>
        <section class="section-padding border-t border-[#EBEBEB]">
            <div class="container">
                <div class="max-w-[800px] mx-auto">
                    <div class="mb-6 md:mb-9">
                        <h2 class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                            <?php echo esc_html(__('Vanliga frågor', 'tusenrosor')); ?>
                        </h2>
                    </div>

                    <div class="">

                        <div data-accordion="collapse" data-active-classes="border-b" data-inactive-classes="border-b">
                            <?php

                            // Sample array for demonstration (replace with actual data source)


                            foreach ($faqs as $index => $accordionItem) {
                                $isFirst = $index === 0 ? 'true' : 'false';  // Only the first item should have aria-expanded="true"
                                $expandedClass = $isFirst === 'true' ? 'true' : 'false';  // For aria-expanded and CSS active class
                            ?>
                                <div class="accordion-item">
                                    <h2 id="tusenrosorFaq-heading-<?php echo $index + 1; ?>">
                                        <button type="button"
                                            class="flex items-center justify-between gap-4 text-start w-full py-6 border-b border-[#EBEBEB] cursor-pointer outline-0"
                                            data-accordion-target="#tusenrosorFaq-body-<?php echo $index + 1; ?>" aria-expanded="<?php echo $expandedClass; ?>" aria-controls="tusenrosorFaq-body-<?php echo $index + 1; ?>">
                                            <span class="text-base font-semibold leading-[165%]">
                                                <?php echo esc_html($accordionItem['title']); ?>
                                            </span>

                                            <!-- Include accordion arrows -->
                                            <?php
                                            require get_template_directory() . '/inc/common-sections/accordian-arrow.php';
                                            ?>
                                        </button>
                                    </h2>
                                    <div
                                        id="tusenrosorFaq-body-<?php echo $index + 1; ?>"
                                        class="hidden pb-6 border-b border-[#EBEBEB]"
                                        aria-labelledby="tusenrosorFaq-heading-<?php echo $index + 1; ?>">
                                        <div class="text-sm font-normal leading-[165%]">
                                            <?php echo esc_html($accordionItem['description']); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                        </div>

                    </div>
                </div>
            </div>
        </section>
    <?php  } ?>
    <?php
    /**
     * Hook: woocommerce_before_main_content.
     *
     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
     * @hooked woocommerce_breadcrumb - 20
     * @hooked WC_Structured_Data::generate_website_data() - 30
     */
    //do_action('woocommerce_before_main_content');

    /**
     * Hook: woocommerce_shop_loop_header.
     *
     * @since 8.6.0
     *
     * @hooked woocommerce_product_taxonomy_archive_header - 10
     */
    //do_action('woocommerce_shop_loop_header'); 
    ?>

</main>
<?php
/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action('woocommerce_after_main_content');



get_footer('shop');
?>