<?php
if (empty($collection)) return;

$term = get_term($collection, 'product_cat');

$image_id = get_term_meta($term->term_id, 'thumbnail_id', true);
$title = $term->name;
?>
<a
    href="<?php echo get_category_link($term->term_id); ?>"
    class="w-[calc(50%-8px)] md:w-[calc(50%-32px)] lg:w-[calc(25%-32px)] m-1 md:m-4 relative group cursor-pointer 

in-[.noGapCollections]:m-0! in-[.noGapCollections]:md:m-0! in-[.noGapCollections]:md:w-1/2 in-[.noGapCollections]:w-1/2 in-[.noGapCollections]:lg:w-full in-[.noGapCollections]:lg:flex-1 [.noGapCollections_&:last-child:nth-child(odd)]:w-full [.noGapCollections_&:last-child:nth-child(odd)]:lg:w-full 

in-[.kollektionGrid]:w-[calc(50%-8px)] in-[.kollektionGrid]:lg:w-[calc(33.333333%-24px)] in-[.kollektionGrid]:m-1 in-[.kollektionGrid]:lg:m-3 [.kollektionGrid_&:last-child:nth-child(odd)]:w-full [.kollektionGrid_&:last-child:nth-child(odd)]:lg:w-[calc(33.333333%-24px)]
">



    <?php
    $noimg_url = wp_get_attachment_url(get_placeholder_imageId());
    if ($image_id) {
        echo wp_get_attachment_image($image_id, 'full', false, [
            'class' => 'w-full min-h-[200px] md:min-h-[450px] max-h-[200px] md:max-h-[450px] aspect-[0.853] object-cover object-center md:[.kollektionGrid_&]:min-h-[300px] md:[.kollektionGrid_&]:max-h-[300px]',
            'alt' => 'Collection Image'
        ]);
    } else {
        echo '<img src="' . $noimg_url . '" class="w-full min-h-[200px] md:min-h-[450px] max-h-[200px] md:max-h-[450px] aspect-[0.853] object-cover object-center md:in-[.kollektionGrid]:min-h-[300px] md:in-[.kollektionGrid]:max-h-[300px]" alt="Collection Image">';
    }




    ?>
    <div class="absolute inset-0 p-3 md:p-6 flex flex-col justify-end uppercase font-normal tracking-[18%] w-full bg-black/20 

    in-[.kollektionGrid]:bg-black/30 in-[.kollektionGrid]:group-hover:bg-black/50 in-[.kollektionGrid]:justify-center in-[.kollektionGrid]:items-center duration-400">

        <div class="in-[.kollektionGrid]:flex in-[.kollektionGrid]:justify-center in-[.kollektionGrid]:items-center in-[.kollektionGrid]:w-full in-[.kollektionGrid]:h-full border in-[.kollektionGrid]:group-hover:border-white border-transparent duration-400 in-[.kollektionGrid]:text-center">

            <h3 class="text-sm md:text-xl text-white leading-[140%] transform transition-transform duration-400 group-hover:-translate-y-12 md:group-hover:-translate-y-14 text-shadow-[0_2px_3px_#3030304D] in-[.kollektionGrid]:transform-none! in-[.kollektionGrid]:translate-none!">
                <?php echo esc_html($title); ?>
            </h3>
        </div>

        <div class="in-[.kollektionGrid]:hidden absolute bottom-3 md:bottom-6 left-3 md:left-6 transform translate-y-6 opacity-0 group-hover:translate-y-0 group-hover:opacity-100 duration-400">
            <span class="hover:opacity-65 duration-400 px-3 md:px-6 py-2 inline-block bg-white text-xs md:text-sm text-center leading-[21.45px] shadow-[0px_2px_3px_0px_#3030304D]">
                <?php echo esc_html(__('Handla nu', 'tusenrosor')); ?>
            </span>
        </div>

    </div>

</a>