<?php

/**
 * Blog Grid Item Template
 * Usage: get_template_part('template-parts/grid-blog', null, ['post' => $post]);
 */

if (!isset($args['post'])) return;
$post = $args['post'];
$post_id = $post->ID;

// 🔹 Dynamic fields
$title       = get_the_title($post_id);
$excerpt     = wp_trim_words(get_the_excerpt($post_id), 25);
$date        = get_the_date('M j, Y', $post_id);
$permalink   = get_permalink($post_id);
$thumbnail_id  = (get_post_thumbnail_id($post_id)) ? get_post_thumbnail_id($post_id) : get_placeholder_imageId();
$thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'medium_large') : get_template_directory_uri() . '/assets/images/placeholder.webp';
?>

<a class="w-full sm:w-[calc(50%-32px)] lg:w-[calc(33.3333%-48px)] 
    in-[.homeBlogs]:w-full! lg:in-[.homeBlogs]:w-[calc(33.3333%-48px)]! 
    in-[.homeBlogs]:py-3 lg:in-[.homeBlogs]:py-0 mb-8 last:mb-0 sm:m-4! 
    lg:m-6! lg:in-[.homeBlogs]:m-6! sm:in-[.homeBlogs]:m-0! in-[.homeBlogs]:m-0! flex flex-col 
    hover:opacity-65 duration-400 space-y-5 in-[.homeBlogs]:lg:space-y-5 in-[.homeBlogs]:space-y-0 
    in-[.homeBlogs]:border-b in-[.homeBlogs]:border-[#F4F4F4] 
    in-[.homeBlogs]:last:border-b in-[.homeBlogs]:first:border-t in-[.homeBlogs]:lg:border-0! 
    in-[.homeBlogs]:flex-row in-[.homeBlogs]:lg:flex-col in-[.homeBlogs]:items-start"
    href="<?php echo esc_url($permalink); ?>">

    <div class="aspect-square overflow-hidden in-[.homeBlogs]:mr-4.5 in-[.homeBlogs]:lg:mr-0 
        in-[.homeBlogs]:lg:max-w-full in-[.homeBlogs]:md:max-w-25 
        in-[.homeBlogs]:max-w-20 in-[.homeBlogs]:md:min-w-25 in-[.homeBlogs]:min-w-20">
        <img class="w-full h-full object-cover object-center"
            src="<?php echo esc_url($thumbnail_url); ?>"
            alt="<?php echo esc_attr($title); ?>" />
    </div>

    <div class="space-y-4 in-[.homeBlogs]:space-y-2 in-[.homeBlogs]:lg:space-y-4">
        <p class="text-xs in-[.homeBlogs]:text-[10px] in-[.homeBlogs]:md:text-xs 
           font-normal uppercase leading-[165%] tracking-[18%] text-(--sub-text)">
            <?php echo esc_html($date); ?>
        </p>

        <h3 class="line-clamp-2 text-lg in-[.homeBlogs]:text-xs in-[.homeBlogs]:md:text-lg 
            font-normal tracking-[18%] leading-[140%] uppercase">
            <?php echo esc_html($title); ?>
        </h3>

        <p class="in-[.homeBlogs]:hidden in-[.homeBlogs]:lg:[display:-webkit-box] 
            line-clamp-3 text-sm font-normal leading-[165%]">
            <?php echo esc_html($excerpt); ?>
        </p>

        <span class="in-[.homeBlogs]:hidden in-[.homeBlogs]:lg:inline-block 
            text-sm font-normal leading-[165%] underline">
            <?php echo esc_html(__('Läs mer', 'tusenrosor')); ?>
        </span>
    </div>
</a>