<?php
get_header();
$post_id = get_the_ID();
$thumbnail_id  = get_post_thumbnail_id($post_id);
$thumbnail_url = $thumbnail_id ? wp_get_attachment_image_url($thumbnail_id, 'full') : '';
if (!$thumbnail_url) {
	$thumbnail_url = get_template_directory_uri() . '/assets/images/contactUs/contactUsBanner.webp';
}
$date        = get_the_date('M j, Y', $post_id);
$year = get_the_date('Y', $post_id);
?>
<main>
	<section>
		<div class="bg-cover bg-no-repeat bg-center" style="background-image: url('<?php echo $thumbnail_url; ?>');">
			<div class="min-h-[250px] md:min-h-[400px] p-4 flex items-center justify-center">
				<!-- There is no content, just images. -->
			</div>
		</div>
	</section>

	<section class="section-padding">
		<div class="container">
			<div class="max-w-[1200px] mx-auto">
				<div class="flex flex-wrap space-y-8 md:space-y-12 lg:space-y-0 lg:space-x-[4%]">
					<div class="w-full lg:w-[66.84%]">
						<div class="border-b border-[#E4E9EE] mb-6 md:mb-8 pb-6 md:pb-8">
							<div class="flex items-center text-xs font-normal uppercase leading-[165%] tracking-[18%] text-(--sub-text) mb-5 space-x-4">
								<span><?php echo $date; ?></span>
								<svg width="5" height="5" viewBox="0 0 5 5" fill="none" xmlns="http://www.w3.org/2000/svg">
									<rect x="0.199219" y="0.200012" width="4" height="4" rx="2" fill="#787878" />
								</svg>
								<span><?php echo $year; ?></span>
							</div>
							<h1 class="uppercase text-xl md:text-[28px] font-normal tracking-[18%] leading-[140%]">
								<?php echo get_the_title(); ?>
							</h1>
						</div>
						<div class="text-(--theme-color) text-sm font-normal leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400 *:mb-5 [&>*:last-child]:mb-0 [&_h2]:mt-8 [&_h2:first-child]:mt-0 
						[&_h1]:mt-8 [&_h1:first-child]:mt-0 
						[&_h2]:text-lg [&_h2]:uppercase md:[&_h2]:text-2xl 
						[&_h3]:text-lg [&_h3]:uppercase md:[&_h3]:text-2xl 
						[&_h4]:text-lg [&_h4]:uppercase md:[&_h4]:text-2xl 
						[&_img]:w-full [&_img]:aspect-7/4 [&_img]:object-cover [&_img]:object-center [&_ul]:space-y-2.5 [&_ul]:pl-8 [&_li]:list-disc">

							<?php the_content(); ?>

						</div>
					</div>

					<div class="w-full lg:w-[29.16%]">
						<div class="w-full p-4 md:p-6 border border-[#ebebeb] space-y-4">
							<h2 class="text-base font-bold leading-[27.03px]">
								<?php echo esc_html(__('Senaste inlägg', 'tusenrosor')); ?>
							</h2>
							<div class="flex flex-col space-y-4">


								<?php echo get_latest_blog_posts(5, '', 'vertical'); ?>


							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>


	<section class="hidden lg:block homeBlogs section-padding bg-(--theme-white)">
		<div class="container">
			<div class="max-w-[1200px] mx-auto">
				<div class="text-center mb-6 md:mb-9">
					<h2 class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
						<?php echo esc_html(__('Senaste inlägg', 'tusenrosor')); ?>
					</h2>
				</div>
				<div class="lg:-m-6">
					<div class="flex flex-wrap justify-center">
						<?php echo get_latest_blog_posts(3); ?>
					</div>
				</div>
			</div>
		</div>
	</section>

</main>
<?php
get_footer();
