<?php
/*
Template Name: Product Detail Page (Single Product)
Description: A custom product detail page template
*/
get_header();




?>
<main>

    <?php
    $base_url = get_template_directory_uri() . '/assets/images/products-img/';
    $images = [
        [
            'file' => 'product-1.webp',
            'alt'  => 'Product Image 1',
        ],
        [
            'file' => 'product-2.webp',
            'alt'  => 'Product Image 2',
        ],
        [
            'file' => 'product-3.webp',
            'alt'  => 'Product Image 3',
        ],
        [
            'file' => 'product-4.webp',
            'alt'  => 'Product Image 4',
        ],
        [
            'file' => 'product-5.webp',
            'alt'  => 'Product Image 5',
        ],
    ];
    ?>

    <section class="lg:pt-15 pb-12 lg:pb-15">
        <div class="lg:max-w-[1440px] mx-auto lg:px-12">
            <div class="flex flex-col lg:flex-row lg:space-x-15 space-y-8 lg:space-y-0">
                <div class="relative lg:flex w-full">
                    <div class="hidden lg:block min-w-15 max-w-15 lg:mr-12">
                        <div class="navSlider flex w-full min-w-15 max-w-15 flex-col space-y-3 sticky top-25">

                            <?php foreach ($images as $index => $image): ?>
                                <button
                                    class="navBtn cursor-pointer w-15 min-w-15 h-15 border-0 outline-0 [&.active]:border-2 [&.active]:border-(--theme-color) <?php echo $index === 0 ? 'active' : ''; ?>">
                                    <img
                                        src="<?= esc_url($base_url . $image['file']); ?>"
                                        alt="<?= esc_attr($image['alt']); ?>"
                                        class="w-full h-full object-cover bg-(--bg2)">
                                </button>
                            <?php endforeach; ?>

                        </div>
                    </div>



                    <!-- just remove those class lg:max-h-screen lg:overflow-auto hide-scrollbar  -->
                    <div class="mainSlider w-full lg:flex lg:flex-col lg:space-y-3 leading-0 aspect-square-not-desktop">

                        <?php foreach ($images as $index => $image): ?>
                            <button class="mainSliderItem aspect-square border-0 outline-0 bg-transparent cursor-zoom-in duration-400 max-w-full" data-modal-target="shopModal" data-modal-toggle="shopModal">
                                <img src="<?= esc_url($base_url . $image['file']); ?>"
                                    alt="<?= esc_attr($image['alt']); ?>"
                                    class="w-full h-full object-cover bg-(--bg2)">
                            </button>
                        <?php endforeach; ?>

                    </div>

                    <div class="mobileDotBtns lg:hidden flex items-center justify-center mt-3">
                        <button class="sliderDotBtn group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center active">
                            <span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span>
                        </button>
                        <button class="sliderDotBtn group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center">
                            <span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span>
                        </button>
                        <button class="sliderDotBtn group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center">
                            <span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span>
                        </button>
                        <button class="sliderDotBtn group cursor-pointer h-4.5 w-4.5 bg-transparent border-0 outline-0 flex items-center justify-center">
                            <span class="rounded-full h-1.5 w-1.5 bg-[#787878] opacity-40 group-[.active]:opacity-100 group-[.active]:bg-(--theme-color)"></span>
                        </button>
                    </div>
                </div>
                <div class="w-full lg:min-w-auto lg:max-w-[40%] xl:max-w-[500px] xl:min-w-[500px] px-4 md:px-8 lg:px-0">
                    <div class="">

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB] pb-6">
                            <h1 class="text-base md:text-lg leading-[140%] tracking-[18%] uppercase text-(--theme-color)">
                                Röda evighetsrosor | Classic box
                            </h1>
                            <div class="flex items-center space-x-2">
                                <div class="flex items-center space-x-0.5">
                                    <?php for ($i = 0; $i < 5; $i++): ?>
                                        <svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6 0V8.635L2.292 11L3.48 6.87L0 4.202L4.443 4.015L6 0ZM6 0V8.635L9.708 11L8.52 6.87L12 4.202L7.557 4.015L6 0Z" fill="#1C1C1C" />
                                        </svg>
                                    <?php endfor; ?>
                                </div>
                                <span class="text-(--sub-text) text-xs font-normal leading-[165%]">
                                    (20)
                                </span>
                            </div>
                            <div class="flex items-center justify-between space-x-2 sm:space-x-4 leading-[160%] tracking-[18%] uppercase text-(--theme-color)">
                                <div class="flex items-center space-x-2 sm:space-x-4">
                                    <div class="text-sm sm:text-lg tracking-[18%]">
                                        1,919 kr
                                    </div>
                                    <div class="text-(--sub-text) text-xs sm:text-sm line-through tracking-[18%]">
                                        2,499 kr
                                    </div>
                                </div>
                                <div class="flex items-center space-x-1 sm:space-x-2">
                                    <?php
                                    $payment_icons = [
                                        'payment1.svg',
                                        'payment2.svg',
                                        'payment3.svg',
                                    ];
                                    ?>
                                    <?php foreach ($payment_icons as $icon): ?>
                                        <img
                                            class="h-5.5 w-8 min-w-8 sm:w-9 sm:min-w-9 object-cover"
                                            src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/payment-card/' . $icon); ?>"
                                            alt="Payment Method Icon">
                                    <?php endforeach; ?>
                                </div>

                            </div>
                        </div>

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6">
                            <div class="space-y-2">
                                <h3 class="text-base text-(--sub-text) leading-[165%] font-normal">
                                    Flower: <span class="text-(--theme-color)">Röd</span>
                                </h3>
                                <div class="w-full">
                                    <div class="-m-[5px]">
                                        <div class="flex flex-wrap">
                                            <?php
                                            $categories = [
                                                ['img' => 'blue.webp',   'class' => 'active'],
                                                ['img' => 'red.webp',    'class' => ''],
                                                ['img' => 'gold.webp',  'class' => ''],
                                                ['img' => 'gift4.webp', 'class' => ''],
                                                ['img' => 'pink.webp',   'class' => ''],
                                                ['img' => 'gift4.webp', 'class' => ''],
                                                ['img' => 'pink.webp',   'class' => ''],
                                                ['img' => 'black.webp',  'class' => ''],
                                                ['img' => 'blue.webp',   'class' => ''],
                                                ['img' => 'black.webp',  'class' => ''],
                                                ['img' => 'red.webp',    'class' => ''],
                                                ['img' => 'gold.webp',  'class' => ''],
                                            ];
                                            ?>
                                            <?php foreach ($categories as $category): ?>
                                                <a
                                                    href="#"
                                                    class="<?= esc_attr($category['class']); ?> [&.active]:border-(--theme-color) hover:border-(--theme-color) m-[5px] cursor-pointer flex items-center justify-center h-13 min-h-13 w-13 min-w-13 border border-[#EBEBEB] rounded-full text-xs text-center duration-400">
                                                    <img
                                                        class="h-9 w-9 max-w-9 min-w-9 object-contain"
                                                        src="<?= esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $category['img']); ?>"
                                                        alt="Product Category Icon">
                                                </a>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="space-y-2">
                                <h3 class="text-base text-(--sub-text) leading-[165%] font-normal">
                                    Box: <span class="text-(--theme-color)">Guld</span>
                                </h3>
                                <div class="w-full">
                                    <div class="-m-[5px]">
                                        <div class="flex flex-wrap">
                                            <?php
                                            $boxes = [
                                                ['img' => 'boxColor1.png',   'class' => 'active'],
                                                ['img' => 'boxColor2.png',    'class' => ''],
                                                ['img' => 'boxColor3.png',  'class' => ''],
                                                ['img' => 'boxColor4.png', 'class' => ''],
                                                ['img' => 'boxColor5.png',   'class' => ''],
                                                ['img' => '',   'class' => ''],
                                            ];
                                            ?>
                                            <?php foreach ($boxes as $category): ?>
                                                <a
                                                    href="#"
                                                    class="<?= esc_attr($category['class']); ?> [&.active]:border-(--theme-color) hover:border-(--theme-color) m-[5px] cursor-pointer flex items-center justify-center h-12 min-h-12 w-12 min-w-12 border border-[#EBEBEB] rounded-full text-xs text-center duration-400 bg-no-repeat bg-center bg-cover bg-white"
                                                    style="background-image: url('<?= esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $category['img']); ?>')">
                                                    <img
                                                        class="h-[3px] max-w-7 object-contain"
                                                        src="<?php echo get_template_directory_uri(); ?>/assets/images/tusenrosor-logo.svg" alt="Tusen Rosor">
                                                </a>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6">
                            <div class="space-y-4">
                                <div class="flex items-center justify-between text-(--theme-color) font-normal leading-[165%]">
                                    <h3 class="text-base font-bold">
                                        <?php echo esc_html(__('Hälsningskort', 'tusenrosor')); ?>
                                    </h3>
                                    <span class="text-sm">
                                        0 kr
                                    </span>
                                </div>
                                <div class="">
                                    <form class="w-full space-y-4">
                                        <div class="relative w-full">
                                            <label
                                                class="text-(--sub-text) text-[10px] absolute left-4 top-1.5"
                                                for="cardType">
                                                <?php echo esc_html(__('Korttyp', 'tusenrosor')); ?>
                                            </label>
                                            <select
                                                id="cardType"
                                                class="appearance-none focus:border-(--theme-color) duration-400 px-4 pb-1.5 pt-5 w-full border border-[#EBEBEB] min-h-12 h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] bg-no-repeat bg-position-[right_16px_center] bg-size-[10px_6px] cursor-pointer"
                                                style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/selectArrow.svg')">
                                                <option selected>Papper</option>
                                                <option value="1">Option 1</option>
                                                <option value="2">Option 2</option>
                                                <option value="3">Option 3</option>
                                            </select>
                                        </div>
                                        <div>
                                            <textarea
                                                class="px-4 py-3 w-full border border-[#EBEBEB] min-h-29 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) resize-none"
                                                name=""
                                                id=""
                                                placeholder="Meddelande"></textarea>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6">
                            <div class="space-y-4">
                                <div class="flex items-center justify-between text-(--theme-color) font-normal leading-[165%]">
                                    <h3 class="text-base font-bold">
                                        <?php echo esc_html(__('Romantisk överraskning', 'tusenrosor')); ?>
                                    </h3>
                                    <span class="text-sm">
                                        200 kr
                                    </span>
                                </div>
                                <label class="flex items-start justify-between space-x-3 w-full p-4 bg-white border border-[#EBEBEB] cursor-pointer duration-400 has-checked:border-(--theme-color)">
                                    <div class="w-full flex items-start space-x-3">
                                        <div class="min-w-13 w-13 h-13 md:min-w-25 md:w-25 md:h-25">
                                            <img
                                                class="w-full h-full object-cover bg-(--bg2)"
                                                src="<?php echo get_template_directory_uri(); ?>/assets/images/products-img/blog3.webp"
                                                alt="">
                                        </div>
                                        <div class="text-(--theme-color) font-normal leading-[165%] space-y-0.5">
                                            <h3 class="text-base text-dark">
                                                Gör gåvan speciell med en present överraskning.
                                            </h3>
                                            <p class="text-sm">
                                                En presenlåda med fjärrilar som kompletterar rosorna perfekt.
                                            </p>
                                        </div>
                                    </div>
                                    <div class="min-w-6">
                                        <input
                                            type="checkbox"
                                            class="peer tusenCheckbox w-6! h-6!"
                                            required>
                                    </div>
                                </label>
                                <a
                                    class="underline text-sm text-(--theme-color) font-normal leading-[165%] inline-block duration-400 hover:opacity-65"
                                    href="#">
                                    Så fungerar det
                                </a>
                            </div>
                        </div>

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB] py-6">
                            <div class="md:space-y-8 space-y-6">
                                <a
                                    class="text-sm text-white bg-(--theme-dark) font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center"
                                    href="#">
                                    <?php echo esc_html(__('Lägg i varukorg', 'tusenrosor')); ?>
                                </a>
                                <div class="space-y-5 text-sm text-(--theme-color) leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400">
                                    <p>
                                        Alla älskar ett original. Tusen rosor Classic-kollektion var vår allra första kollektion, designad av <a href="#">Lotte feruchi</a> som har satt kvalitetsstandarden för evighetsrosor sedan dess.
                                    </p>
                                    <p>
                                        Vår Classic-kollektion förenar elegansen och lyxen i en rund ask fylld med röda evighetsrosor.
                                    </p>
                                    <p>
                                        Med Classic-kollektionen lägger du till tidlös lyx till ditt hem.
                                    </p>
                                    <p>
                                        Rosbox storlek: 21 cm Ø
                                    </p>
                                    <p>
                                        Antal evighetsrosor: 17-20
                                    </p>
                                </div>
                            </div>
                        </div>

                        <div class="group w-full space-y-4 border-b border-[#EBEBEB]">

                            <div data-accordion="open">
                                <div class="accordionItem">
                                    <h2 id="shopAccordionTitle1">
                                        <button type="button"
                                            class="flex items-center justify-between w-full font-normal py-6 text-xs text-(--theme-color)! leading-[165%] tracking-[18%] bg-transparent! cursor-pointer border-0 duration-400 hover:opacity-65"
                                            data-accordion-target="#shopAccordion1"
                                            aria-expanded="true"
                                            aria-controls="shopAccordion1">
                                            <div class="flex items-center space-x-4">
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M17.2923 11.0417C17.2923 15.0667 14.0256 18.3333 10.0007 18.3333C5.97565 18.3333 2.70898 15.0667 2.70898 11.0417C2.70898 7.01667 5.97565 3.75 10.0007 3.75C14.0256 3.75 17.2923 7.01667 17.2923 11.0417Z" stroke="#303030" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M10 6.66504V10.8317" stroke="#303030" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M7.5 1.66504H12.5" stroke="#303030" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                                <span class="uppercase">
                                                    Hur håller de sig färska så länge?
                                                </span>
                                            </div>

                                            <!-- Include accordion arrows -->
                                            <?php
                                            require get_template_directory() . '/inc/common-sections/accordian-arrow.php';
                                            ?>
                                        </button>
                                    </h2>
                                    <div id="shopAccordion1" class="hidden pb-6" aria-labelledby="shopAccordionTitle1">
                                        <div
                                            class="space-y-8 w-full text-sm text-(--theme-color) leading-[165%] [&_a]:underline [&_a]:hover:opacity-65 [&_a]:duration-400 [&_strong]:inline-block">
                                            <div class="space-y-5">
                                                <strong>
                                                    Vi presenterar en notabel kombination, rosor och hållbarhet.
                                                </strong>
                                                <p>
                                                    Lyft dina rosor till en helt annan nivå. Överraska med rosor som varar år efter år. Låt din kärlek påminnas om elegansen och beundran varje dag.
                                                </p>
                                            </div>
                                            <div class="space-y-5">
                                                <p>
                                                    Hur ser behandlingsprocessen ut?
                                                </p>
                                                <p>
                                                    Den unika konserveringstekniken innefattar följande 3 grundläggande steg:
                                                </p>
                                                <ol>
                                                    <li>
                                                        Rosorna skördas vid den idealiska tidpunkten när det gäller naturlig skönhet från en av våra 7000.0m2 fält som befinner sig vid foten av vulkanen Cayambe.
                                                    </li>
                                                    <li>
                                                        De nyskördade rosorna går in i en egen process för att absorbera en specifik blandning av 100 % växtbaserad och biologiskt nedbrytbar nektar.
                                                    </li>
                                                    <li>
                                                        Den biologiskt nedbrytbara nektarn ersätter vätskan i rosen och bildar effektivt en stillbild av rosen, vilket skapar en unik och 100 % naturlig produkt. Rosorna som bevaras förblir vackra och oförändrade utan behov av vattning och solsken, och de blir i stort sett underhållsfria.
                                                    </li>
                                                </ol>
                                            </div>
                                            <div class="space-y-5">
                                                <p>
                                                    Vår gård vid vulkanen Cayambe
                                                </p>
                                                <p>
                                                    Våra rosor odlas i Ecuador vid foten av vulkanen Cayambe, några kilometer från huvudstaden Quito. Cayambe. Cayambe är en av de bästa platserna i världen för att odla färska rosor av högsta kvalitet på grund av sin höga höjd (2850m) och direkt exponering för solen på ekvatorn. Den här gården producerar historiskt färska rosor av överlägsen kvalitet. Vi lägger stor vikt vid att varje ros som kommer med ditt Tusen rosor ® arrangemang är så estetiskt tilltalande som möjligt.
                                                </p>
                                                <a href="#">
                                                    Ta mig till vanliga frågor och svar
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>


    <div id="shopModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-full max-h-screen duration-400 bg-(--theme-white)">
        <div class="relative w-full max-w-full max-h-full h-full flex justify-center items-center">
            <!-- Modal body -->
            <div class="max-h-screen">
                <div class="modalSlider flex transition-transform ease-in-out w-full max-h-screen">

                    <?php foreach ($images as $index => $image): ?>
                        <div class="modalSliderItem min-w-full max-h-screen">
                            <img src="<?= esc_url($base_url . $image['file']); ?>"
                                alt="<?= esc_attr($image['alt']); ?>"
                                class="w-auto m-auto h-auto max-h-screen object-cover bg-(--bg2)">
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>
            <!-- Modal footer -->
            <div class="absolute flex items-center justify-center w-max mx-auto bottom-0 left-1/2 -translate-x-1/2 md:space-x-4.5 space-x-3 pb-10">
                <button class="previewBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
                    <svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.25 0.75L2.25 6.75L8.25 12.75" stroke="currentColor" stroke-width="0.75" stroke-linecap="square" />
                    </svg>
                </button>

                <button type="button" class="text-white bg-(--theme-color) p-0 cursor-pointer rounded-full w-12.5 h-12.5 md:w-14 md:h-14 flex justify-center items-center" data-modal-hide="shopModal">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1 1L15 15M1 15L15 1" stroke="currentColor" />
                    </svg>
                </button>

                <button class="nextBtn cursor-pointer text-white bg-(--theme-color) p-0 rounded-full w-11 h-11 flex justify-center items-center">
                    <svg width="12" height="14" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.75 12.75L9.75 6.75L3.75 0.75" stroke="currentColor" stroke-width="0.75" stroke-linecap="square" />
                    </svg>


                </button>
            </div>
        </div>
    </div>

    <section class="bg-(--theme-color) py-6 md:py-8 text-white">
        <div class="container">
            <div class="-m-4">
                <div class="flex justify-center flex-wrap">

                    <?php
                    $shop_icons = [
                        ['img' => 'shopDetailsIcon1.svg', 'text' => __('Fri frakt', 'tusenrosor')],
                        ['img' => 'shopDetailsIcon2.svg', 'text' => __('Varar i över tre år', 'tusenrosor')],
                        ['img' => 'shopDetailsIcon3.svg', 'text' => __('Välj leveransdatum', 'tusenrosor')],
                        ['img' => 'shopDetailsIcon4.svg', 'text' => __('1 års garanti', 'tusenrosor')],
                    ];
                    ?>

                    <?php foreach ($shop_icons as $icon): ?>
                        <a href="#"
                            class="text-center hover:opacity-65 flex flex-col items-center justify-center
                  lg:w-[calc(25%-32px)] w-[calc(50%-32px)] duration-400 m-4">
                            <img class="max-w-6 mb-3 mx-auto object-contain"
                                src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $icon['img']); ?>"
                                alt="<?php echo esc_attr($icon['text']); ?>">
                            <h6 class="uppercase md:text-xs text-[10px] font-normal leading-[150%] tracking-[18%]">
                                <?php echo esc_html($icon['text']); ?>
                            </h6>
                        </a>
                    <?php endforeach; ?>

                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <div class="mb-6 md:mb-9">
                <h2
                    class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                    <?php echo esc_html(__('Kundrecensioner', 'tusenrosor')); ?>
                </h2>
            </div>
            <div class="space-y-9">
                <div
                    class="p-6 md:p-8 lg:px-12 lg:py-8 border border-[#EBEBEB] flex flex-col lg:flex-row 
                lg:space-x-12 lg:space-y-0 md:space-y-8 space-y-3">
                    <div class="lg:pr-12 lg:border-r lg:border-[#EBEBEB] space-x-5 flex items-center">
                        <h5 class="font-bold text-5xl leading-[150%]">
                            5.0
                        </h5>
                        <div class="flex flex-col space-y-2.5 text-nowrap">
                            <div class="flex items-center space-x-1">
                                <?php for ($i = 0; $i < 5; $i++): ?>
                                    <svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M10.9091 0V15.7L4.16727 20L6.32727 12.4909L0 7.64L8.07818 7.3L10.9091 0ZM10.9091 0V15.7L17.6509 20L15.4909 12.4909L21.8182 7.64L13.74 7.3L10.9091 0Z" fill="#303030" />
                                    </svg>
                                <?php endfor; ?>
                            </div>
                            <div class="text-sm leading-[165%] font-normal">
                                Baserat på 20 recensioner
                            </div>
                        </div>
                    </div>
                    <div class="w-full flex items-center">
                        <div class="w-full">
                            <div class="-m-1.5 md:-m-2.5">
                                <div class="flex flex-wrap justify-center xl:flex-nowrap w-full">

                                    <?php
                                    $ratings = [
                                        [
                                            'rating' => '5.0',
                                            'count'  => '(20)',
                                        ],
                                        [
                                            'rating' => '4.0',
                                            'count'  => '(12)',
                                        ],
                                        [
                                            'rating' => '3.0',
                                            'count'  => '(15)',
                                        ],
                                        [
                                            'rating' => '2.0',
                                            'count'  => '(5)',
                                        ],
                                        [
                                            'rating' => '1.0',
                                            'count'  => '(0)',
                                        ],
                                    ];
                                    ?>

                                    <?php foreach ($ratings as $rate): ?>
                                        <div class="m-1.5 md:m-2.5 h-10 flex items-center justify-center space-x-2.5 text-sm leading-[165%] font-normal md:w-full md:flex-1 min-w-35 border border-[#EBEBEB] hover:border-(--theme-color) duration-400">
                                            <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.72727 0V12.56L3.33382 16L5.06182 9.99273L0 6.112L6.46255 5.84L8.72727 0ZM8.72727 0V12.56L14.1207 16L12.3927 9.99273L17.4545 6.112L10.992 5.84L8.72727 0Z" fill="#303030" />
                                            </svg>
                                            <strong><?= esc_html($rate['rating']); ?></strong>
                                            <span><?= esc_html($rate['count']); ?></span>
                                        </div>
                                    <?php endforeach; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="">
                    <div class="border-b border-[#EBEBEB] w-full flex justify-between items-center pb-3 space-x-2">
                        <div class="text-base font-bold leading-[165%]">
                            Recensioner (20)
                        </div>
                        <div>
                            <select
                                id=""
                                class="text-right appearance-none focus:border-(--theme-color) duration-400 p-0 pr-7 w-full border-0 text-sm font-normal leading-[165%] bg-no-repeat bg-position-[right_center] bg-size-[16px_16px] cursor-pointer outline-0"
                                style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/arrow-down.svg')">
                                <option selected>Senaste</option>
                                <option value="1">Option 1</option>
                                <option value="2">Option 2</option>
                                <option value="3">Option 3</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <div>
                            <?php
                            $reviews = [
                                [
                                    'user_name' => 'Anna Karlsson',
                                    'user_img'  => 'blue.webp',
                                    'title'     => '“Otroligt vackra rosor!”',
                                    'text'      => 'Rosorna ser helt naturliga ut och färgen är fantastisk. Min partner blev rörd till tårar när hon öppnade asken. En gåva som verkligen håller sitt löfte om både lyx och hållbarhet. Rekommenderar varmt till alla som vill ge något unikt och minnesvärt.',
                                    'images'    => ['blog5.webp', 'blog6.webp', 'blog7.webp'],
                                ],
                                [
                                    'user_name' => 'Lisa Bergström',
                                    'user_img'  => 'pink.webp',
                                    'title'     => '“Underbara rosor!”',
                                    'text'      => 'Jag älskar dessa rosor! De ser helt fantastiska ut och håller sig vackra länge. Perfekt presentidé.',
                                    'images'    => ['blog6.webp', 'blog7.webp'],
                                ],
                            ];
                            ?>

                            <?php foreach ($reviews as $review): ?>
                                <div
                                    class="w-full py-6 flex flex-col items-start lg:flex-row border-b border-[#EBEBEB] space-y-4 lg:space-y-0 lg:space-x-4">

                                    <!-- User Info -->
                                    <div class="w-full lg:w-[250px] min-w-[250px] flex items-center space-x-3">
                                        <div class="h-15 w-15 rounded-full overflow-hidden">
                                            <img
                                                class="h-full w-full object-cover bg-(--bg2)"
                                                src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $review['user_img']); ?>"
                                                alt="<?php echo esc_attr($review['user_name']); ?>">
                                        </div>
                                        <div class="flex flex-col items-center">
                                            <h5 class="text-base font-bold leading-[165%]">
                                                <?php echo esc_html($review['user_name']); ?>
                                            </h5>
                                            <p class="text-xs text-(--sub-text) leading-[165%]">
                                                2 månad sedan
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Review Content -->
                                    <div class="w-full">
                                        <div class="space-y-3">

                                            <!-- Fixed Stars + Verified -->
                                            <div class="space-y-3 md:space-y-0 md:space-x-3 flex flex-col md:flex-row md:justify-between">
                                                <div class="flex items-center space-x-3">
                                                    <div class="flex items-center space-x-0.5">
                                                        <?php for ($i = 0; $i < 5; $i++): ?>
                                                            <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path d="M8.72727 0V12.56L3.33382 16L5.06182 9.99273L0 6.112L6.46255 5.84L8.72727 0ZM8.72727 0V12.56L14.1207 16L12.3927 9.99273L17.4545 6.112L10.992 5.84L8.72727 0Z" fill="#303030" />
                                                            </svg>
                                                        <?php endfor; ?>
                                                    </div>

                                                    <svg width="4" height="4" viewBox="0 0 4 4" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <rect width="4" height="4" rx="2" fill="#787878" />
                                                    </svg>

                                                    <p class="text-xs text-(--sub-text) leading-[165%]">
                                                        Verifierat köp
                                                    </p>
                                                </div>

                                                <div>
                                                    <a class="underline text-sm text-(--sub-text) leading-[165%] hover:opacity-65 duration-400" href="#">
                                                        Röda evighetsrosor | Classic box
                                                    </a>
                                                </div>
                                            </div>

                                            <!-- Dynamic Title + Text -->
                                            <div class="space-y-2">
                                                <h4 class="text-sm leading-[165%] font-bold">
                                                    <?php echo esc_html($review['title']); ?>
                                                </h4>
                                                <div class="text-sm text-(--sub-text) leading-[165%]">
                                                    <?php echo esc_html($review['text']); ?>
                                                </div>
                                            </div>

                                            <!-- Dynamic Product Images -->
                                            <?php if (!empty($review['images'])): ?>
                                                <div>
                                                    <div class="-m-[5px]">
                                                        <div class="flex flex-wrap">
                                                            <?php foreach ($review['images'] as $img): ?>
                                                                <div class="h-20 w-20 min-w-20 m-[5px]">
                                                                    <img
                                                                        class="h-full w-full object-cover bg-(--bg2)"
                                                                        src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/products-img/' . $img); ?>"
                                                                        alt="Product Image">
                                                                </div>
                                                            <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </div>
                        <div class="text-center mt-6 md:mt-9">
                            <a href="#" class="inline-block uppercase text-center text-sm bg-(--theme-dark) text-white font-medium tracking-[18%] leading-[165%] px-7 py-3 duration-400 hover:opacity-65">
                                <?php echo esc_html(__('Visa mer', 'tusenrosor')); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="bg-(--theme-white) section-padding">
        <div class="container">
            <div class="mb-6 md:mb-9">
                <h2
                    class="uppercase text-center text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">
                    <?php echo esc_html(__('Du kanske också gillar', 'tusenrosor')); ?>
                </h2>
            </div>
            <div>
                <div class="-m-[3px]">
                    <div class="relative">
                        <div class="sliderBtns hidden md:block">
                            <button class="
                                leftBtn absolute -left-4 top-1/2 -translate-y-1/2
                                h-8 w-8 min-w-8 p-0.5 bg-transparent border-0 outline-0 shadow-none cursor-pointer flex items-center justify-center">
                                <div class="text-center border-[1.5px] rounded-full flex items-center justify-center h-full w-full">
                                    <svg width="7" height="11" viewBox="0 0 7 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5.44333 10.1633L0.75 5.45667L5.44333 0.75" stroke="#303030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </button>
                            <button class="
                                rightBtn absolute -right-4 top-1/2 -translate-y-1/2
                                h-8 w-8 min-w-8 p-0.5 bg-transparent border-0 outline-0 shadow-none cursor-pointer flex items-center justify-center">
                                <div class="text-center border-[1.5px] rounded-full flex items-center justify-center h-full w-full">
                                    <svg width="7" height="11" viewBox="0 0 7 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0.75 10.1633L5.44333 5.45667L0.75 0.75" stroke="#303030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </button>
                        </div>
                        <div class="scrollSlider flex whitespace-nowrap overflow-x-auto hide-scrollbar">

                            <?php for ($i = 0; $i < 10; $i++): ?>
                                <div class="min-w-37.5 w-37.5 md:min-w-[227px] md:w-[227px] lg:min-w-[327px] lg:w-[327px]
                                bg-red-300 min-h-50 m-[3px]
                                ">
                                </div>
                            <?php endfor; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<script>
    jQuery(document).ready(function($) {
        // ===================================================
        // 📌 Existing setup
        // ===================================================
        const $navBtns = $(".navSlider .navBtn");
        const $mainItems = $(".mainSlider .mainSliderItem");
        const $mainSlider = $(".mainSlider");
        const $modal = $("#shopModal");
        const $modalSlider = $(".modalSlider");
        const $modalItems = $(".modalSlider .modalSliderItem");
        const $previewBtn = $(".previewBtn");
        const $nextBtn = $(".nextBtn");
        const $dots = $(".sliderDotBtn");

        let modalIndex = 0;
        let isUserScrolling = false;
        let currentIndex = 0;
        let isMobile = false;
        let touchStartX = 0;

        // ===================================================
        // 🖱️ Desktop Nav → Scroll behavior
        // ===================================================
        $navBtns.on("click", function() {
            const index = $(this).index();

            isUserScrolling = false;

            $navBtns.removeClass("active");
            $(this).addClass("active");

            const $target = $mainItems.eq(index);

            $("html, body").stop().animate({
                scrollTop: $target.offset().top
            }, 400, function() {
                setTimeout(() => {
                    isUserScrolling = true;
                }, 200);
            });
        });

        $mainSlider.on("mouseenter", function() {
            isUserScrolling = true;
        });
        $mainSlider.on("mouseleave", function() {
            isUserScrolling = false;
        });


        $(window).on("scroll", function() {
            if (!isUserScrolling) return;

            const scrollTop = $(window).scrollTop();
            const windowHeight = $(window).height();
            const triggerPoint = scrollTop + windowHeight * 0.4; // middle of viewport
            let targetIndex = null;

            $mainItems.each(function(i) {
                const itemTop = $(this).offset().top;
                const itemBottom = itemTop + $(this).outerHeight();

                if (triggerPoint >= itemTop && triggerPoint < itemBottom) {
                    targetIndex = i;
                    return false; // stop loop
                }
            });

            if (targetIndex !== null) {
                const $currentActive = $navBtns.filter(".active");
                const $newActive = $navBtns.eq(targetIndex);
                if (!$currentActive.is($newActive)) {
                    $navBtns.removeClass("active");
                    $newActive.addClass("active");
                }
            }
        });


        // ===================================================
        // 🧭 Modal Logic
        // ===================================================
        $mainItems.on("click", function() {
            const index = $(this).index();
            modalIndex = index;
            openModal(index);
        });

        function openModal(index) {
            $modal.removeClass("hidden").addClass("flex");
            updateModalSlider(index);
        }

        function updateModalSlider(index) {
            modalIndex = Math.max(0, Math.min(index, $modalItems.length - 1));
            const offset = -modalIndex * 100;
            $modalSlider.css({
                transform: `translateX(${offset}%)`,
                transition: "transform 0.4s ease",
            });

            $previewBtn.prop("disabled", modalIndex === 0);
            $nextBtn.prop("disabled", modalIndex === $modalItems.length - 1);
            $previewBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === 0);
            $nextBtn.toggleClass("opacity-40 pointer-events-none", modalIndex === $modalItems.length - 1);
        }

        $previewBtn.on("click", function() {
            if (modalIndex > 0) {
                modalIndex--;
                updateModalSlider(modalIndex);
            }
        });

        $nextBtn.on("click", function() {
            if (modalIndex < $modalItems.length - 1) {
                modalIndex++;
                updateModalSlider(modalIndex);
            }
        });

        let startXModal = 0;
        $modal.on("touchstart", function(e) {
            startXModal = e.originalEvent.touches[0].pageX;
        });
        $modal.on("touchend", function(e) {
            const endXModal = e.originalEvent.changedTouches[0].pageX;
            const diffModal = endXModal - startXModal;

            if (Math.abs(diffModal) > 50) {
                if (diffModal < 0 && modalIndex < $modalItems.length - 1) {
                    modalIndex++;
                } else if (diffModal > 0 && modalIndex > 0) {
                    modalIndex--;
                }
                updateModalSlider(modalIndex);
            }
        });

        // ===================================================
        // 📱 Mobile Mode (Position-based mainSlider)
        // ===================================================
        function activateSlide(index) {
            currentIndex = index;
            $mainItems.removeClass("active").hide().eq(index).show().addClass("active");
            $dots.removeClass("active").eq(index).addClass("active");

            // Disable swipe/dot at boundaries (visual only, logic below blocks)
            $dots.prop("disabled", false);
            if (index === 0) $dots.first().prop("disabled", true);
            if (index === $mainItems.length - 1) $dots.last().prop("disabled", true);
        }

        function initMobileSlider() {
            if (isMobile) return;
            isMobile = true;

            $mainSlider.addClass("relative overflow-hidden").removeClass("flex lg:flex-col");
            $mainItems.addClass("absolute inset-0 transition-transform duration-500 ease-in-out hidden");
            activateSlide(0);

            // Dot click
            $dots.off("click").on("click", function() {
                const index = $(this).index();
                activateSlide(index);
            });

            // Swipe
            $mainSlider.off("touchstart touchend");
            $mainSlider.on("touchstart", (e) => (touchStartX = e.originalEvent.touches[0].clientX));
            $mainSlider.on("touchend", (e) => {
                const diff = e.originalEvent.changedTouches[0].clientX - touchStartX;
                if (Math.abs(diff) > 50) {
                    if (diff < 0) nextSlide();
                    else prevSlide();
                }
            });
        }

        function destroyMobileSlider() {
            if (!isMobile) return;
            isMobile = false;

            $mainSlider.removeClass("relative overflow-hidden").addClass("flex lg:flex-col");
            $mainItems.removeClass("absolute inset-0 transition-transform duration-500 ease-in-out hidden active").show();
            $dots.removeClass("active");
        }

        function nextSlide() {
            if (currentIndex < $mainItems.length - 1) {
                activateSlide(currentIndex + 1);
            }
        }

        function prevSlide() {
            if (currentIndex > 0) {
                activateSlide(currentIndex - 1);
            }
        }

        function checkMode() {
            if (window.innerWidth < 1024) initMobileSlider();
            else destroyMobileSlider();
        }

        checkMode();
        $(window).on("resize", checkMode);

        // ===================================================
        // ❌ Close modal
        // ===================================================
        $modal.find("[data-modal-hide]").on("click", function() {
            $modal.addClass("hidden").removeClass("flex");
        });
    });
</script>

<script>
    jQuery(document).ready(function($) {
        $('.scrollSlider').each(function() {
            const slider = $(this);
            const leftBtn = slider.siblings('.sliderBtns').find('.leftBtn');
            const rightBtn = slider.siblings('.sliderBtns').find('.rightBtn');

            let isDown = false,
                startX, scrollLeft;

            // Helper: can scroll horizontally?
            function canScroll() {
                const el = slider[0];
                return el.scrollWidth > el.clientWidth;
            }

            // ====== 🖱️ Drag to scroll ======
            slider.on('mousedown', function(e) {
                if (!canScroll()) return;
                isDown = true;
                slider.addClass('dragging');
                startX = e.pageX - slider.offset().left;
                scrollLeft = slider.scrollLeft();
                e.preventDefault();
            });

            slider.on('mouseleave mouseup', function() {
                isDown = false;
                slider.removeClass('dragging');
            });

            slider.on('mousemove', function(e) {
                if (!isDown || !canScroll()) return;
                const x = e.pageX - slider.offset().left;
                const walk = (x - startX) * 1.5;
                slider.scrollLeft(scrollLeft - walk);
            });

            // ====== 🖱️ Scroll with wheel ======
            slider.on('wheel', function(e) {
                const el = slider[0];
                if (!canScroll()) return;
                const newScroll = el.scrollLeft + e.originalEvent.deltaY;
                if (newScroll >= 0 && newScroll <= el.scrollWidth - el.clientWidth) {
                    e.preventDefault();
                    el.scrollLeft = newScroll;
                }
            });

            // ====== ⬅️➡️ Left/Right Buttons ======
            const scrollAmount = 700; // adjust scroll distance per click

            leftBtn.on('click', function() {
                slider.animate({
                    scrollLeft: slider.scrollLeft() - scrollAmount
                }, 300);
            });

            rightBtn.on('click', function() {
                slider.animate({
                    scrollLeft: slider.scrollLeft() + scrollAmount
                }, 300);
            });
        });
    });
</script>

<?php
get_footer();
