<?php

/**
 * The template for displaying all pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package tusenrosor-wp-theme
 */

if (is_checkout() && !is_order_received_page()) {
	get_header('checkout');
} else {
	get_header();
}
?>

<main id="site-main" class="w-full">
	<?php if (is_account_page()) : ?>

		<?php
		while (have_posts()) :
			the_post();

			get_template_part('template-parts/content', 'page');

			if (comments_open() || get_comments_number()) :
				comments_template();
			endif;
		endwhile;
		?>

	<?php else : ?>

		<?php if (is_checkout() && !is_order_received_page()) : ?>
			<section class="flex-col-reverse items-stretch overflow-hidden">
				<div class="full-width">
				<?php else : ?>
					<section class="section-padding">
						<div class="container">
						<?php endif; ?>

						<div>
							<?php
							while (have_posts()) :
								the_post();

								get_template_part('template-parts/content', 'page');

								if (comments_open() || get_comments_number()) :
									comments_template();
								endif;
							endwhile;
							?>
						</div>

						</div>
					</section>

				<?php endif; ?>
</main>

<?php
if (is_checkout() && !is_order_received_page()) {
	get_footer('checkout');
} else {
	get_footer();
}
?>