<?php

/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package ftf_styling
 */

get_header();


if (is_user_logged_in()) {
    wp_redirect(get_permalink(wc_get_page_id('myaccount')));
    exit;
}
?>

<main id="primary" class="site-main">
    <section>
        <div class="login-form flex flex-col lg:flex-row items-stretch lg:min-h-[768px]">
            <div class="w-full lg:w-[61.3%] px-4 py-8 md:p-12 flex items-center justify-center">
                <div class="max-w-[450px] mx-auto w-full space-y-6 md:space-y-9">

                    <?php wc_print_notices(); ?>

                    <div class="space-y-3 md:space-y-5 text-center ">
                        <h1
                            class="uppercase text-lg md:text-[28px] font-normal tracking-[18%] leading-[140%]">

                            <?php esc_html_e('Registrera dig', 'woocommerce'); ?>
                        </h1>
                        <div class="text-sm leading-[165%]">
                            <?php echo esc_html(__('Registrera dig och börja shoppa redan idag!', 'tusenrosor')); ?>
                        </div>
                    </div>

                    <form
                        method="post"
                        class="w-full woocommerce-form woocommerce-form-register register space-y-4">
                        <?php do_action('woocommerce_login_form_start'); ?>

                        <div class="relative">
                            <input
                                class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg"
                                type="text"
                                name="username"
                                id="userName"
                                placeholder="<?php esc_attr_e('Fullständigt namn', 'woocommerce'); ?>"
                                autocomplete="username" required
                                value="<?php echo isset($_POST['username']) ? esc_attr($_POST['username']) : ''; ?>"
                                required>

                            <label
                                for="userName"
                                class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.1221 11.75C15.0497 11.75 16.5808 13.3472 16.5811 15.2773V16.667C16.5809 17.0809 16.245 17.4168 15.8311 17.417H4.16406C3.75004 17.4169 3.41424 17.081 3.41406 16.667V15.2773C3.41429 13.3474 4.94468 11.7503 6.87207 11.75H13.1221ZM6.87207 13.25C5.80866 13.2503 4.91429 14.1398 4.91406 15.2773V15.917H15.0811V15.2773C15.0808 14.1396 14.1857 13.25 13.1221 13.25H6.87207ZM9.99707 1.74902C12.2518 1.74925 14.0807 3.57733 14.0811 5.83203C14.0811 8.08705 12.252 9.91578 9.99707 9.91602C7.74206 9.91584 5.91406 8.08709 5.91406 5.83203C5.91444 3.57729 7.74229 1.7492 9.99707 1.74902ZM9.99707 3.24902C8.57072 3.2492 7.41444 4.40572 7.41406 5.83203C7.41406 7.25866 8.57048 8.41584 9.99707 8.41602C11.4236 8.41578 12.5811 7.25862 12.5811 5.83203C12.5807 4.40576 11.4234 3.24925 9.99707 3.24902Z" fill="#303030" fill-opacity="0.6" />
                                </svg>
                            </label>
                        </div>

                        <div class="relative">
                            <input
                                class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg"
                                type="text"
                                name="email"
                                id="reg_email"
                                placeholder="<?php esc_attr_e('E-post', 'woocommerce'); ?>"
                                autocomplete="email" required
                                value="<?php echo isset($_POST['email']) ? esc_attr($_POST['email']) : ''; ?>" />
                            <label
                                for="reg_email"
                                class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">
                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M2.5 5.83332L10 9.99999L17.5 5.83332M2.5 4.16666H17.5V15.8333H2.5V4.16666Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                </svg>
                            </label>
                        </div>

                        <div class="relative">
                            <input
                                class="w-full px-4 py-1 border border-[#EBEBEB] min-h-12 text-base md:text-sm font-normal text-(--theme-color) leading-[165%] outline-0 focus:border-(--theme-color) duration-400 placeholder:text-(--sub-text) bg-white no-autofill-bg"
                                type="password"
                                placeholder="<?php esc_attr_e('Lösenord', 'woocommerce'); ?>"
                                name="password"
                                id="password"
                                autocomplete="current-password"
                                required />
                            <button
                                id="togglePassword"
                                class="absolute right-4 top-1/2 -translate-y-1/2
                                h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer">

                                <svg class="eyeOpen" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18.3307 9.99999C18.3307 9.99999 14.5998 15.8333 9.9974 15.8333C5.39502 15.8333 1.66406 9.99999 1.66406 9.99999C1.66406 9.99999 5.39502 4.16666 9.9974 4.16666C14.5998 4.16666 18.3307 9.99999 18.3307 9.99999Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                    <path d="M13.3307 9.99999C13.3307 11.8409 11.8383 13.3333 9.9974 13.3333C8.15645 13.3333 6.66406 11.8409 6.66406 9.99999C6.66406 8.15904 8.15645 6.66666 9.9974 6.66666C11.8383 6.66666 13.3307 8.15904 13.3307 9.99999Z" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                </svg>

                                <svg class="eyeClose hidden" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M1.66602 10C1.66602 10 5.39698 15.8333 9.99935 15.8333C11.6938 15.8333 13.2343 15.2372 14.5306 14.247" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                    <path d="M18.3327 10C18.3327 10 14.6017 4.16666 9.99935 4.16666C8.49577 4.16666 7.09489 4.56203 5.86893 5.263" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                    <path d="M7.5 9.16667C7.5 7.78996 8.62262 6.66667 10 6.66667C10.5455 6.66667 11.0536 6.84701 11.4574 7.16256" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                    <path d="M12.5 10.8333C12.5 12.21 11.3774 13.3333 10 13.3333C9.45452 13.3333 8.94643 13.153 8.54263 12.8375" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                    <path d="M3.33203 3.33333L16.6654 16.6667" stroke="#303030" stroke-opacity="0.6" stroke-width="1.5" stroke-linecap="round" />
                                </svg>
                            </button>
                        </div>

                        <div class="flex items-center space-x-3 cursor-pointer">
                            <input
                                class="tusenCheckbox form-check-input woocommerce-form__input woocommerce-form__input-checkbox"
                                type="checkbox" value="1" id="terms_conditions" name="terms_conditions"
                                required />
                            <div class="">
                                <label for="terms_conditions" class="text-sm leading-[165%] duration-400 hover:opacity-65 cursor-pointer">
                                    <?php esc_html_e('Jag godkänner shops', 'woocommerce'); ?>
                                </label>
                                <a
                                    class="text-sm leading-[165%] inline-block underline duration-400 hover:opacity-65 cursor-pointer"
                                    href="<?php echo esc_url(site_url('privacy-policy')); ?>">
                                    <?php esc_html_e('användarvillkor', 'woocommerce'); ?>
                                </a>
                            </div>
                        </div>


                        <div class="hidden">
                            <?php do_action('woocommerce_register_form'); ?>
                        </div>

                        <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>

                        <div class="g-recaptcha" data-sitekey="6Lc7s4IrAAAAAF98uHuWfqSvT0WsbPufvI-JUcBF"></div>

                        <button
                            type="submit"
                            type="submit"
                            class="woocommerce-Button button text-sm text-white bg-(--theme-dark) font-medium leading-[165%] duration-400 hover:opacity-65 w-full tracking-[18%] uppercase min-h-12 p-2 flex items-center justify-center cursor-pointer"
                            name="register"
                            value="<?php esc_attr_e('Register', 'woocommerce'); ?>">
                            <?php esc_html_e('Registrera', 'woocommerce') ?>
                        </button>

                        <?php do_action('woocommerce_register_form_end'); ?>
                    </form>
                    <div class="text-center text-sm leading-[165%]">
                        <?php esc_html_e("Har du redan ett konto?", 'woocommerce'); ?>
                        <a
                            class="underline hover:opacity-65 duration-400"
                            href="<?php echo site_url('my-account'); ?>">
                            <?php esc_html_e('Logga in', 'woocommerce'); ?>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Right side banner img -->
            <?php require get_template_directory() . '/inc/common-sections/login-register-banner-img.php'; ?>
        </div>
    </section>
</main>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');

        togglePassword.addEventListener('click', function(e) {
            e.preventDefault();

            const isPassword = passwordInput.getAttribute('type') === 'password';
            passwordInput.setAttribute('type', isPassword ? 'text' : 'password');

            // Find both icons inside the button
            const eye = this.querySelector('.eyeClose');
            const eyeSlash = this.querySelector('.eyeOpen');

            if (isPassword) {
                eye.style.display = 'inline';
                eyeSlash.style.display = 'none';
            } else {
                eye.style.display = 'none';
                eyeSlash.style.display = 'inline';
            }
        });
    })
    jQuery(function($) {
        $('form.woocommerce-form-login').on('submit', function(e) {
            var response = grecaptcha.getResponse();
            if (!response) {
                alert("Please confirm you're not a robot.");
                // Optional: e.preventDefault(); to enforce
                // e.preventDefault(); // Uncomment this line to actually block form submission
            }
        });
    });
</script>
<?php

get_footer();
