<?php
/*
Template Name: Page Checkout Shipping
Description: A custom checkout shipping page template
*/
get_header('checkout');
?>

<main>
    <section class="flex lg:flex-row flex-col-reverse items-stretch overflow-hidden">
        <div class="lg:min-h-screen px-4 py-8 lg:px-8 lg:py-12 w-full lg:w-[51.3%]">
            <div class="max-w-[486px] lg:mr-0 mx-auto">
                <div class="hidden lg:block w-full lg:mb-12">
                    <?php
                    require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
                    ?>
                </div>
                <div class="md:space-y-12 space-y-8">
                    <div class="md:space-y-8 space-y-6">

                    </div>

                    <!-- Include small footer -->
                    <?php
                    require get_template_directory() . '/inc/common-sections/checkout-small-footer.php';
                    ?>
                </div>
            </div>
        </div>
        <div id="dinOrder"
            data-accordion="collapse"
            data-active-classes="border-b border-[#EBEBEB]"
            class="w-full lg:w-[48.7%] bg-(--bg2) lg:min-h-screen">
            <h2 id="dinOrderHeading-1" class="lg:hidden">
                <button type="button"
                    class="w-full p-4 md:py-6 rtl:text-right cursor-pointer bg-(--bg2) text-(--theme-dark)!"
                    data-accordion-target="#dinOrderBody-1" aria-expanded="false" aria-controls="dinOrderBody-1">
                    <div class="flex items-center justify-between max-w-[486px] mx-auto">
                        <div class="flex items-center justify-between space-x-2 text-(--theme-dark)">
                            <span class="font-medium text-sm leading-[165%]">
                                Din order
                            </span>
                            <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0 duration-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5" />
                            </svg>
                        </div>
                        <div class="text-lg leading-[140%] tracking-[18%] font-normal">
                            3780 kr
                        </div>
                    </div>

                </button>
            </h2>
            <div
                id="dinOrderBody-1" aria-labelledby="dinOrderHeading-1"
                class="w-full px-4 py-8 lg:px-8 lg:py-12 hidden lg:block">
                <div class="max-w-[486px] lg:max-w-[450px] mx-auto lg:ml-0 w-full">
                    <div class="[&>.cartItem:first-child]:pt-0">
                        <!-- Include product single cart -->

                        <?php
                        $cart_products = [
                            [
                                'img'       => 'product-1.webp',
                                'title'     => __('Rosor är utan tvekan en av världens mest älskade blommor | Classic box', 'tusenrosor'),
                                'price'     => __('1,919 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                            [
                                'img'       => 'product-2.webp',
                                'title'     => __('Evighetsrosor i hjärtformad ask | Limited edition', 'tusenrosor'),
                                'price'     => __('1,299 kr', 'tusenrosor'),
                                'optional'  => false,
                            ],
                            [
                                'img'       => 'product-3.webp',
                                'title'     => __('Vita rosor i svart box | Classic box', 'tusenrosor'),
                                'price'     => __('1,599 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                            [
                                'img'       => 'product-4.webp',
                                'title'     => __('24k guld evighetsrosor | Classic box', 'tusenrosor'),
                                'price'     => __('2,369 kr', 'tusenrosor'),
                                'optional'  => true,
                            ],
                        ];
                        ?>

                        <?php foreach ($cart_products as $product): ?>
                            <?php require get_template_directory() . '/inc/tusenrosor-loops/small-product-loop.php'; ?>
                        <?php endforeach; ?>
                    </div>
                    <div class="pt-5">
                        <!-- Include subtotal-totalt-part -->
                        <?php
                        require get_template_directory() . '/inc/common-sections/subtotal-totalt-part.php';
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="px-4 py-8 lg:px-8 lg:py-12 w-full lg:hidden">
            <?php
            require get_template_directory() . '/inc/common-sections/checkout-logo-nav.php';
            ?>
        </div>
    </section>
</main>
<?php
get_footer('checkout');
