jQuery(function ($) {
  const $country = $('select#billing_country, select#shipping_country, select#step1_billing_country');
  const $billingState = $('select#billing_state, input#billing_state, select#step1_billing_state, input#step1_billing_state');
  const $shippingState = $('select#shipping_state, input#shipping_state, select#shipping_state, input#shipping_state');

  function updateStateDropdown($countrySelect, $target) {
    const country = $countrySelect.val();

    // Fetch states for this country from Woo’s built-in API
    $.ajax({
      url: wc_checkout_params.ajax_url,
      method: 'POST',
      data: {
        action: 'get_country_states',
        country: country,
      },
      success: function (response) {
        if (response.success && response.data.states) {
          const states = response.data.states;

          // Rebuild select
          let options = '<option value="">Select State / Region</option>';
          $.each(states, function (code, name) {
            options += `<option value="${code}">${name}</option>`;
          });

          const $newSelect = $('<select>', {
            id: $target.attr('id'),
            name: $target.attr('name'),
            class: $target.attr('class'),
          }).html(options);
          console.log($target);
          console.log('droptarge');
          $target.replaceWith($newSelect);
          //alert($newSelect);
        } else {
          // No states available: show text input fallback
          const $input = $('<input>', {
            type: 'text',
            id: $target.attr('id'),
            name: $target.attr('name'),
            class: $target.attr('class'),
            placeholder: 'Enter state / region',
          });
          $target.replaceWith($input);
        }
      },
    });
  }

  // On country change
  $country.on('change', function () {
    if($(this).attr('id') === 'billing_country'){
     const $target =$('#billing_state');
      updateStateDropdown($(this), $target);
      
    }
     if($(this).attr('id') === 'step1_billing_country'){
         
       const $target2 =$('#step1_billing_state');
      updateStateDropdown($(this), $target2);
    }
    
  });

  // Run on page load
  $country.trigger('change');
});
