jQuery(document).ready(function ($) {
  /* ============================================================
     STEP 1 BILLING FORM & STATE HANDLING
  ============================================================ */
  const prefix = "step1_";
  let wcStates = wc_country_select_params.countries;

  if (typeof wcStates === "string") {
    try {
      wcStates = JSON.parse(wcStates);
    } catch (e) {
      console.error("❌ Failed to parse wcStates:", e);
    }
  }
  const COOKIE = "tusenrosor_shipping_info";
  const settings = tusenrosor_settings || {};
  const methodsConfig = settings.methods || {};
  const countryConfig = settings.country || {};
  const zones = settings.zones || {};
  const currency = settings.currency || "kr";
  const today = getSwedenAdjustedToday();
  // Prefix billing field IDs in Step1
  $("#checkoutStep1 [id^='billing_']").each(function () {
    const originalId = $(this).attr("id");
    const newId = prefix + originalId;
    $(this).attr("id", newId);
    $(`label[for='${originalId}']`).attr("for", newId);
  });

  let isSyncing = false;
  function switchStep(current) {
    $(".formstep").hide();
    $(`#checkoutStep${current}`).fadeIn(300);
    $(".btn-step").removeClass("active");
    $(`.btn-step-${current}`).addClass("active");
  }

  $(".goToStep1").on("click", (e) => { e.preventDefault(); switchStep("1"); syncBillingFields(".billingform", "form.woocommerce-checkout"); });
  $(".goToStep2").on("click", (e) => { e.preventDefault(); switchStep("2"); syncBillingFields(".billingform", "form.woocommerce-checkout");});
  $(".goToStep3").on("click", (e) => { e.preventDefault(); switchStep("3");syncBillingFields("form.woocommerce-checkout", ".billingform"); });
//billing_email
  function syncBillingFields(sourceSelector, targetSelector) {
  
      $('.billing_email').text($(`${targetSelector} [name="billing_email"]`).val());
      $('.billing_address').text($(`${targetSelector} [name="billing_address_1"]`).val());
    $(document).on("input change", `${sourceSelector} [name^="billing_"]`, function () {
      $('.billing_email').text($(`${targetSelector} [name="billing_email"]`).val());
      $('.billing_address').text($(`${targetSelector} [name="billing_address_1"]`).val());
      if (isSyncing) return;
      isSyncing = true;
      const name = $(this).attr("name");
      const value = $(this).val();
      const $target = $(`${targetSelector} [name="${name}"]`);
      if ($target.length) {
        $target.val(value);
        if ($target.is("select")) $target.trigger("change.select2");
        else $target.trigger("input");
      }
      setTimeout(() => (isSyncing = false), 100);
    });
  }

  syncBillingFields(".billingform", "form.woocommerce-checkout");
  syncBillingFields("form.woocommerce-checkout", ".billingform");

  $(".billingform [name^='billing_']").each(function () {
    const name = $(this).attr("name");
    const val = $(this).val();
    const $real = $(`form.woocommerce-checkout [name="${name}"]`);
    if ($real.length) {
      $real.val(val);
      if ($real.is("select")) $real.trigger("change.select2");
    }
  });

  // === STATE DROPDOWN HANDLING ===
  const step1Country = $('#checkoutStep1 select[name="billing_country"]');
  const step1State = $('#checkoutStep1 [name="billing_state"]');
const newSelect = $("#billing_country, #billing_state, #shipping_state, #shipping_country");

    // ✅ Reinitialize selectWoo (WooCommerce’s custom Select2)
    if ($.fn.selectWoo) {
      //alert('sd');
      newSelect.selectWoo({
        placeholder: wc_country_select_params.i18n_select_state_text,
        width: "100%",
      });
    }
function buildStateOptions(countryCode) {
  const states = wcStates[countryCode];
  const $state = $("#step1_billing_state, #billing_state, #shipping_state");

  if (!states) {
    console.warn("No states found for country:", countryCode);
    return;
  }

  // 1️⃣ Safely destroy SelectWoo if initialized on each element
  $state.each(function () {
    const $el = $(this);
    if ($el.hasClass("select2-hidden-accessible") && $.fn.selectWoo) {
      try {
        $el.selectWoo("destroy");
      } catch (err) {
        console.warn("SelectWoo destroy failed:", err);
      }
    }
  });

  // 2️⃣ Empty and rebuild options
  $state.each(function () {
    const $el = $(this);
    $el.empty();
    $el.append('<option value="">Select state / region</option>');
    $.each(states, (code, name) => {
      $el.append(`<option value="${code}">${name}</option>`);
    });

    // 3️⃣ Re-init SelectWoo safely
    if ($.fn.selectWoo) {
      try {
        $el.selectWoo({
          placeholder: wc_country_select_params.i18n_select_state_text || "Select state / region",
          width: "100%",
        });
      } catch (err) {
        console.warn("SelectWoo reinit failed:", err);
      }
    }
  });
}


 

  /* ============================================================
     GOOGLE AUTOCOMPLETE FOR ADDRESS
  ============================================================ */
  const addressField = document.getElementById("step1_billing_address_1");
  if (addressField && typeof google !== "undefined") {
    const autocomplete = new google.maps.places.Autocomplete(addressField, {
      types: ["address"],
      componentRestrictions: { country: [settings.country] },
    });
    //alert('yes');
    let isProgrammaticChange = false;
    autocomplete.addListener("place_changed", function () {
      const place = autocomplete.getPlace();
      if (!place.address_components) return;
      const streetParts = [];
      let postalCode = "";
      let city = "";
      for (const comp of place.address_components) {
        const types = comp.types;
        if (types.includes("street_number")) streetParts.push(comp.long_name);
        if (types.includes("route")) streetParts.push(comp.long_name);
        if (types.includes("postal_code")) postalCode = comp.long_name;
        if (types.includes("locality")) city = comp.long_name;
      }
      isProgrammaticChange = true;
      $("#step1_billing_address_1_field").val(streetParts.join(" "));
      $("#step1_billing_postcode").val(postalCode);
      $("#step1_billing_city").val(city);
      $("#step1_billing_address_1, #step1_billing_postcode, #step1_billing_city").trigger("change");
      setTimeout(() => { isProgrammaticChange = false; }, 300);
    });
    $("#step1_billing_address_1").on("input change", function () {
      if (isProgrammaticChange) return false;
    });
      step1Country.on("change", function () {
    autocomplete.setComponentRestrictions({ country: $(this).val() });
    buildStateOptions($(this).val());
  });
  }
 const initialCountry = step1Country.val();
  if (initialCountry) buildStateOptions(initialCountry);
   step1Country.on("change", function () {
  //alert('yes state');
    buildStateOptions($(this).val());
  });
  /* ============================================================
     SHIPPING CALCULATION + COUNTRY-AWARE LOGIC
  ============================================================ */
 /* ============================================================
   SHIPPING LOGIC — full fix: country + date + cookie + default
============================================================ */


// detect current billing country first
let country = $("#checkoutStep1 select[name='billing_country']").val() || countryConfig;
console.log("🌍 Initial billing country:", country);

// Utils
const fmt = (d) => d.toISOString().split("T")[0];
function getSwedenAdjustedToday() {
    const tz = tusenrosor_settings?.tz_string || "UTC";
    const now = new Date();
    const swedenNow = convertToTimezoneDate(now, tz);

    // If after 3 PM, return the next day, but if it's weekend, return Monday
    if (swedenNow.getHours() >= 15) {
        let next = new Date(swedenNow);
        next.setDate(next.getDate() + 1); // Always move to the next day
        // If next day is Saturday (6) or Sunday (0), move to Monday
        if (next.getDay() === 0) next.setDate(next.getDate() + 1); // Sunday
        if (next.getDay() === 6) next.setDate(next.getDate() + 2); // Saturday
        return next;
    }
//alert(swedenNow.getDay());
    // Before 3 PM, if it's weekend (Saturday or Sunday), move to Monday
    if (swedenNow.getDay() === 0 || swedenNow.getDay() === 6 || swedenNow.getDay() === 5) {
        let next = new Date(swedenNow);
        // Skip Saturday and Sunday to get to Monday
        if (next.getDay() === 0) next.setDate(next.getDate() + 1); // Sunday
        if (next.getDay() === 6) next.setDate(next.getDate() + 2); // Saturday
         if (next.getDay() === 5) next.setDate(next.getDate() + 3); // Friday
        return next;
    }

    // Otherwise, return the next day if before 3 PM
    let next = new Date(swedenNow);
    next.setDate(next.getDate() + 1); // Always move to the next day
    
    return next;
}


function getBusinessDaysDiff(start, end) {
  const s = new Date();
  const e = new Date(end);
  console.log('start'+s);console.log('end'+e);
  let count = 0;
  while (s < e) {
    const day = s.getDay();
    if (day !== 0 && day !== 6) count++;
    s.setDate(s.getDate() + 1);
  }
  return count;
}
function getZoneKey(code) {
  console.log(zones);
  if (zones.ZONE1?.includes(code)) return "ZONE1";
  if (zones.ZONE2?.includes(code)) return "ZONE2";
  if (code === "SE") return "SE";
  return "ZONE2"; // 🌍 all other countries
}

// Build available shipping methods for current country..final code
// function getMethodsByCountry(currentCountry, diff) {
//   const zone = getZoneKey(currentCountry);

//   const list = methodsConfig[zone] || [];
//   const available = [];

//   list.forEach((m) => {
//     const slug = (m.slug || "").toLowerCase();

//     if (zone === "SE") {
//       if (slug.includes("express") && diff === m.max_days) available.push(m);
//       else if (slug.includes("home") && diff >= m.min_days && diff <= m.max_days) available.push(m);
//       else if (slug.includes("standard") && diff >= m.max_days) available.push(m);
//     } else if (zone === "ZONE1") {
//       if (slug.includes("express") && diff <= m.max_days) available.push(m);
//       else if (slug.includes("standard") && diff >= m.max_days) available.push(m);
//     } else if (zone === "ZONE2") {
//       if (slug.includes("express") && diff <= m.max_days) available.push(m);
//       else if (slug.includes("standard") && diff >= m.max_days) available.push(m);
//     } else {
//       if (slug.includes("express")) available.push(m); // fallback
//     }
//   });

//   if (available.some((m) => (m.slug || "").includes("express"))) {
//     return available.filter((m) => (m.slug || "").includes("express"));
//   }
//   return available.length ? available : list.slice(0, 1);
// }
function getMethodsByCountry(currentCountry, diff) {
  const zone = getZoneKey(currentCountry);
  const list = methodsConfig[zone] || [];
  const available = [];

  // 🇸🇪 SWEDEN — dynamic version
  if (zone === "SE") {
    let express = null;
    let home = null;
    let standard = null;

    // Identify methods dynamically
    list.forEach((m) => {
      const slug = (m.slug || "").toLowerCase();
      if (slug.includes("express")) express = m;
      if (slug.includes("home")) home = m;
      if (slug.includes("standard")) standard = m;
    });

    // Helper for range check (dynamic, no hardcoding)
    const inRange = (m) =>
      diff >= parseInt(m.min_days || 1) &&
      diff <= parseInt(m.max_days || 1);

    // === EXPRESS ===
    if (express && inRange(express)) {
      available.push(express);
      if (home && inRange(home)) available.push(home); // dynamic check
      return available; // stop if express applies
    }

    // === STANDARD ===
    if (standard && inRange(standard)) {
      available.push(standard);
      if (home && inRange(home)) available.push(home);
      return available;
    }

    // === HOME ONLY (if no express/standard match) ===
    if (home && inRange(home)) {
      available.push(home);
    }

    // fallback
    if (!available.length && list.length) {
      available.push(list[list.length - 1]);
    }

    console.log(`🟩 Zone: ${zone}, Diff: ${diff}, Available:`, available);
    return available;
  }

  // 🌍 Other zones: purely min/max based
  list.forEach((m) => {
    const min = parseInt(m.min_days || 1);
    const max = parseInt(m.max_days || 1);
    if (diff >= min && diff <= max) available.push(m);
  });

  // fallback for other zones
  if (!available.length && list.length) {
    const fallback = list.reduce((a, b) =>
      (a.max_days || 0) > (b.max_days || 0) ? a : b
    );
    available.push(fallback);
  }

  console.log(`🟩 Zone: ${zone}, Diff: ${diff}, Available:`, available);
  return available;
}



// Render shipping section (replace HTML inside container)
function renderShippingOptions(selected, fromCookie = false) {
  //alert(selected);
  const diff = getBusinessDaysDiff(today, selected);

  // ✅ Detect country from billing form if not set
  if (!country || country === "") {
    country = $("#checkoutStep1 select[name='billing_country']").val() || countryConfig;
  }

  // ✅ Determine zone & get proper methods (ZONE3 fallback for other countries)
  const zone = getZoneKey(country);
  const methods = getMethodsByCountry(country, diff);

  const $container = $(".delivery-options-section .flex.flex-col");

  // ✅ Handle no method case (rare)
  if (!methods.length) {
    console.warn(`⚠️ No shipping methods available for ${country} (${zone}) and diff ${diff}.`);
    $container.html(
      '<p class="text-sm text-(--sub-text)">Inga leveransalternativ tillgängliga för detta datum.</p>'
    );
    return;
  }

  // ✅ Generate full shipping option list dynamically
  $container.html(generateDeliveryHTML(methods, selected, fromCookie));

  // ✅ Save selected data
  $(".tusenrosor-datepicker").data("selected-date", date_fmt(selected));
  saveSelectedMethodData(true);
}
function convertToTimezoneDate(date, tz = "Europe/Stockholm") {
  // Get components in target timezone
  const parts = new Intl.DateTimeFormat("en-CA", {
    timeZone: tz,
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
  }).formatToParts(date);

  const y = parts.find(p => p.type === "year").value;
  const m = parts.find(p => p.type === "month").value;
  const d = parts.find(p => p.type === "day").value;

  return new Date(`${y}-${m}-${d}T00:00:00Z`);
}
// 🔁 Restore shipping data from cookie on page load

function restoreFromCookie() {
  const match = document.cookie.match(/tusenrosor_shipping_info=([^;]+)/);
  if (!match) return;

  try {
    const saved = JSON.parse(decodeURIComponent(match[1]));
    console.log("🧠 Restoring shipping info from cookie:", saved);

    if (!saved.selectedDate) return;

    // 🗓 Create Date object from cookie
    let selected = new Date(saved.selectedDate);

    // 🕒 Convert to Sweden timezone & apply 3PM cutoff logic
    const tz = tusenrosor_settings?.tz_string || "Europe/Stockholm";
    // const swedenNow = new Date(
    //   selected.toLocaleString("en-US", { timeZone: tz })
    // );
    const swedenNow = convertToTimezoneDate(selected, tz);

    // Apply cutoff: if it's after 3PM, push to next business day
    if (swedenNow.getHours() >= 15) {
      let next = new Date(swedenNow);
      next.setDate(next.getDate() + 1);
      while (next.getDay() === 0 || next.getDay() === 6) {
        next.setDate(next.getDate() + 1);
      }
      selected = next;
    } else {
      selected = swedenNow;
    }

    // 🚫 Weekend safeguard (if cookie stored weekend date)
    const day = selected.getDay();
    if (day === 0) selected.setDate(selected.getDate() + 1); // Sunday → Monday
    else if (day === 6) selected.setDate(selected.getDate() + 2); // Saturday → Monday

    // 🧠 Update datepicker + data attributes
    const formattedDate = date_fmt(selected);
    $(".tusenrosor-datepicker").data("selected-date", formattedDate);

    if (dpEl?.datepicker) {
      dpEl.datepicker.setDate(selected);
    }

    // 🌍 Restore saved country if available
    if (saved.country) {
      country = saved.country;
      $("#checkoutStep1 select[name='billing_country']")
        .val(country)
        .trigger("change");
    }

    // 🚀 Render valid shipping options with corrected date
    renderShippingOptions(selected, true);

    // 💤 Sync session silently (don’t trigger fragment refresh)
    saveSelectedMethodData(false);
  } catch (err) {
    console.warn("❌ Cookie parse failed:", err);
  }
}

// function restoreFromCookie() {
//   const match = document.cookie.match(/tusenrosor_shipping_info=([^;]+)/);

//   if (!match) return;

//   try {
//     const saved = JSON.parse(decodeURIComponent(match[1]));
//     console.log("🧠 Restoring shipping info from cookie:", saved);

//     if (saved.selectedDate) {
//       const selected = new Date(saved.selectedDate);
//       $(".tusenrosor-datepicker").data("selected-date", saved.selectedDate);
    
//       // ✅ Set the visual date on Flowbite datepicker (if available)
//       if (dpEl?.datepicker) {
//         dpEl.datepicker.setDate(selected);
//       }

//       // ✅ Restore country if it was saved
//       if (saved.country) {
//         country = saved.country;
//         $("#checkoutStep1 select[name='billing_country']").val(country).trigger("change");
//       }

//       // ✅ Re-render options using saved data & reapply checked method
//       renderShippingOptions(selected, true);

//       // ✅ Sync session silently (without refreshing fragments)
//       saveSelectedMethodData(false);
//     }
//   } catch (err) {
//     console.warn("❌ Cookie parse failed:", err);
//   }
// }

function renderShippingOptions(selected, fromCookie = false) {
  const diff = getBusinessDaysDiff(today, selected);
//alert(diff);
  // ✅ Detect country from billing form if not set
  if (!country || country === "") {
    country = $("#checkoutStep1 select[name='billing_country']").val() || countryConfig;
  }

  // ✅ Determine zone & get proper methods (ZONE3 fallback for other countries)
  const zone = getZoneKey(country);
  const methods = getMethodsByCountry(country, diff);
  const $container = $(".delivery-options-section .flex.flex-col");

  if (!methods.length) {
    console.warn(`⚠️ No shipping methods for ${country} (${zone}) diff ${diff}`);
    $container.html(
      '<p class="text-sm text-(--sub-text)">Inga leveransalternativ tillgängliga för valt datum.</p>'
    );
    return;
  }

  // ✅ Build HTML dynamically (with dynamic range calc)
  $container.html(generateDeliveryHTML(methods, selected, fromCookie, diff));

  $(".tusenrosor-datepicker").data("selected-date", date_fmt(selected));
  saveSelectedMethodData(true);
}

/**
 * Builds the delivery-item HTML dynamically based on selected date and methods.
 */
function date_fmt(date) {
  if (!(date instanceof Date) || isNaN(date.getTime())) return "";

  const y = date.getFullYear();
  const m = String(date.getMonth() + 1).padStart(2, "0");
  const d = String(date.getDate()).padStart(2, "0");

  const formatted = `${y}-${m}-${d}`;
  console.log("✅ Formatted date (local calendar):", formatted);
  return formatted;
}
function generateDeliveryHTML(methods, selected, fromCookie, diff) {
  console.log('calender selected'+selected);
  const cookie = getCookieData();
  const lowest = methods.reduce((a, b) => (a.price < b.price ? a : b), methods[0]);
  let html = "";

  methods.forEach((m, i) => {
    const id = "delivery_method_" + (i + 1);
    const minDays = parseInt(m.min_days || 1);
    const earlyFee = parseFloat(m.early_fee || 0);
    const specialFee = parseFloat(m.special_fee || 0);
const methodslug=m.slug;
    // === business-day range ===
    const minRange = Math.max(diff - 1, 1);
    const maxRange = diff;

    // === fee calculation ===
    let price = parseFloat(m.price || 0);
    if (diff < minDays) price += earlyFee;
    if (selected.getDay() === 6) price += specialFee;

    // === checked logic ===
    let checked = "";
    if (fromCookie && cookie.method === m.name) checked = "checked";
    else if (!fromCookie && m.name === lowest.name) checked = "checked";
    else if (i === 0 && methods.length === 1) checked = "checked";
  //alert('current before method prepare'+selected);
    html += `
      <label class="delivery-item w-full border border-[#EBEBEB] px-4 py-3.5 flex justify-between cursor-pointer duration-400 has-[input:checked]:border-(--theme-color) has-[input:checked]:bg-(--theme-white) text-sm leading-[165%] space-x-3"
        for="${id}"
        data-method="${m.name}"
        data-price="${price}"
        data-min-days="${minDays}"
        data-early-fee="${earlyFee}"
        data-leveranstid="${minRange} till ${maxRange} arbetsdagar"
        data-special-fee="${specialFee}"
        data-selectedDate="${date_fmt(selected)}"
        data-businessDays="${diff}">
        <div class="flex items-start space-x-3">
          <input class="mt-0.5 tusenRadio delivery-radio" type="radio" name="deliveryOptions" id="${id}" ${checked}>
          <div class="flex flex-col">
            <h5 class="method-name">${m.name}</h5>
            <div class="delivery-range text-(--sub-text)">${minRange} till ${maxRange} arbetsdagar</div>
          </div>
        </div>
        <div class="text-end">
          <p class="delivery-price uppercase mb-[7px]">${price > 0 ? `${price.toFixed(2)} ${currency}` : "GRATIS"}</p>
          <div class="flex items-center space-x-2 justify-end">
            <div class="delivery-date text-(--sub-text) text-[10px]">${date_fmt(selected)}</div>
              <div for="telefon" class="h-5 w-5 min-w-5 bg-transparent border-0 outline-0 shadow-none flex items-center justify-center cursor-pointer group relative">
                <div div class="absolute left-1/2 -translate-x-1/2 z-10 invisible inline-block px-3 py-1.5 text-[10px] font-normal text-white transition-opacity duration-400 bg-[#121212] rounded-sm opacity-0 tooltip leading-[160%] max-w-[148px] min-w-[148px] w-full text-center group-hover:visible group-hover:opacity-100 bottom-7" >
                  ${m.desc}
                  <div class="tooltip-arrow -bottom-1.5 absolute left-1/2 -translate-x-1/2">
                      <svg width="12" height="6" viewBox="0 0 12 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M6 0H12L7.41421 4.58579C6.63317 5.36683 5.36684 5.36684 4.58579 4.58579L0 0H6Z" fill="#121212" />
                      </svg>
                  </div>
                </div>
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <mask id="mask0_6077_37090" style="mask-type:luminance" maskUnits="userSpaceOnUse" x="0" y="0" width="20" height="20">
                        <path d="M0 0H20V20H0V0Z" fill="white" />
                        <path d="M19.25 0.75V19.25H0.75V0.75H19.25Z" stroke="white" stroke-width="1.5" />
                    </mask>
                    <g mask="url(#mask0_6077_37090)">
                        <path d="M10.0017 17.8572C14.3411 17.8572 17.8588 14.3394 17.8588 10C17.8588 5.66065 14.3411 2.14288 10.0017 2.14288C5.66229 2.14288 2.14453 5.66065 2.14453 10C2.14453 14.3394 5.66229 17.8572 10.0017 17.8572Z" stroke="#787878" stroke-width="1.5" />
                        <path d="M9.98828 14.6286H10.0169V14.6572H9.98828V14.6286Z" stroke="#787878" stroke-width="1.5" stroke-linejoin="round" />
                        <path d="M7.85938 7.50003C7.8595 7.13693 7.95189 6.77982 8.12787 6.46222C8.30384 6.14461 8.55764 5.87694 8.86543 5.68431C9.17322 5.49169 9.52491 5.38043 9.88748 5.36099C10.2501 5.34154 10.6116 5.41455 10.9383 5.57315C11.2649 5.73176 11.5458 5.97076 11.7548 6.26772C11.9637 6.56468 12.0938 6.90986 12.1327 7.27086C12.1717 7.63186 12.1183 7.99684 11.9775 8.33154C11.8367 8.66624 11.6132 8.95967 11.3279 9.18431C10.7079 9.67145 10.0022 10.2829 10.0022 11.0715" stroke="#787878" stroke-width="1.5" stroke-linecap="round" />
                    </g>
                </svg>
              </div>
            </div>
        </div>
      </label>`;
  });
//alert(html);
  return html;
}



// Save cookie + Woo session
function saveSelectedMethodData(triggerRefresh = true) {
  const $checked = $("input[name='deliveryOptions']:checked").closest(".delivery-item");
  if (!$checked.length) return;

  const data = {
    method: $checked.data("method"),
    leveranstid: $checked.data("leveranstid"),
    price: parseFloat($checked.data("price")) || 0,
    selectedDate: $checked.data("selecteddate"),
    country,
  };
  document.cookie = COOKIE + "=" + encodeURIComponent(JSON.stringify(data)) + "; path=/; max-age=7200;";
console.log('cookie');console.log(data);
  if (!triggerRefresh) return;
 $('.checkout_total').addClass('animate-pulse');
  $.post({
    url: wc_checkout_params.ajax_url,
    data: { action: "tusenrosor_sync_shipping", data: JSON.stringify(data) },
    success: function (res) {
      if (res.success) {
     
     $(document.body).trigger("update_checkout");
     //   setTimeout(() => {
      
      $(document.body).trigger("wc_fragment_refresh");
      $('.checkout_total').removeClass('animate-pulse');
         $('.checkout_total').removeClass('animate-pulse');
   // }, 1800); // add slight delay to ensure session commit
      }
    else {
    $('.checkout_total').removeClass('animate-pulse');
  }
    },
    error: function () {
  $('.checkout_total').removeClass('animate-pulse');
},
  });
}
function getCookieData() {
  const match = document.cookie.match(/tusenrosor_shipping_info=([^;]+)/);
  if (!match) return {};

  try {
    const cookieData = JSON.parse(decodeURIComponent(match[1])) || {};
    const selectedDate = new Date(cookieData.selectedDate);
    const currentDate = new Date(); // Get current date

    // Check if selectedDate is a valid date
    if (selectedDate instanceof Date && !isNaN(selectedDate)) {
      // Check if the current date is equal to the selectedDate (ignoring time part)
      if (selectedDate.toDateString() === currentDate.toDateString()) {
        // If current date is the same as selectedDate, move to the next day
        selectedDate.setDate(selectedDate.getDate() + 1);

        // If next day is Saturday (6) or Sunday (0), move to Monday
        if (selectedDate.getDay() === 6) { // Saturday
          selectedDate.setDate(selectedDate.getDate() + 2); // Move to Monday
        } else if (selectedDate.getDay() === 0) { // Sunday
          selectedDate.setDate(selectedDate.getDate() + 1); // Move to Monday
        }
      }

      // Update the cookie with the adjusted selectedDate (if needed)
      cookieData.selectedDate = selectedDate.toISOString(); // Store as ISO string

      // Update the cookie with the new selectedDate
      document.cookie = `tusenrosor_shipping_info=${encodeURIComponent(JSON.stringify(cookieData))}; path=/; max-age=7200;`;

      return cookieData;
    }

    return cookieData;
  } catch {
    return {};
  }
}

// function getCookieData() {
//   const match = document.cookie.match(/tusenrosor_shipping_info=([^;]+)/);
//   if (!match) return {};
//   try {
//     return JSON.parse(decodeURIComponent(match[1])) || {};
//   } catch {
//     return {};
//   }
// }

/* ============================
   INIT SEQUENCE
============================ */
const dpEl = document.querySelector(".tusenrosor-datepicker");
let initialDate = getSwedenAdjustedToday();
const saved = getCookieData();
console.log('save');console.log(saved);
// Step 1 — Use cookie date if available

if (saved.selectedDate) {
  initialDate = new Date(saved.selectedDate);
  
  country = saved.country || country;
}

// Step 2 — Initialize datepicker after restoring
if (dpEl && !dpEl.datepicker && window.Datepicker) {
  
  const dp = new Datepicker(dpEl, {
    minDate: new Date(today.getFullYear(), today.getMonth(), today.getDate()),
    format: "yyyy-mm-dd",
    autohide: true,
    daysOfWeekDisabled: [0, 6], // 0 = Sunday, 6 = Saturday

    // 🎨 Gray-out visually disabled weekends
 
  });

  dp.setDate(initialDate);
}
  restoreFromCookie();
function disableWeekends() {
  setTimeout(() => {
    $(".datepicker .datepicker-cell.day").each(function () {
      const $cell = $(this);
      const ts = parseInt($cell.attr("data-date"), 10);
      if (!ts) return; // skip empty cells

      const date = new Date(ts);
      const day = date.getDay();

      if (day === 0 || day === 6) {
        $cell
          .addClass(
            "bg-gray-100 text-gray-400 opacity-60 cursor-not-allowed pointer-events-none"
          )
          .attr("title", "Ingen leverans på helgen")
          .attr("aria-disabled", "true");
      }
    });
  }, 25); // wait for Flowbite to render days
}
//Tou
// === Unselect previous default when changing month ===
function clearSelectionOnMonthChange() {
  setTimeout(() => {
    $(".datepicker-cell.active").removeClass("active bg-blue-500 text-white");
  }, 10);
}

// === Hook events ===
disableWeekends();
dpEl.addEventListener("show", () => {
  disableWeekends();
  clearSelectionOnMonthChange();
});
dpEl.addEventListener("changeMonth", () => {
  disableWeekends();
  clearSelectionOnMonthChange();
});
// Run once now

 $(".tusenrosor-datepicker").data("selected-date", date_fmt(initialDate));
renderShippingOptions(initialDate, !!saved.selectedDate);

dpEl.addEventListener("changeDate", (e) => {
  // Use `let` for a mutable date variable

  let selected = new Date(e.detail.date);

  // 🔹 Convert to Sweden timezone using your site’s tz setting
  const tz = tusenrosor_settings?.tz_string || "Europe/Stockholm";
  const swedenNow = convertToTimezoneDate(selected, tz);

  // 🔹 Apply the same 3 PM cutoff logic used in getSwedenAdjustedToday()
  if (swedenNow.getHours() >= 15) {
    let next = new Date(swedenNow);
    next.setDate(next.getDate() + 1);
    while (next.getDay() === 0 || next.getDay() === 6) {
      next.setDate(next.getDate() + 1);
    }
    selected = next;  // Modify selected with next available date
  }
  if (selected.getDay() === 0 || selected.getDay() === 6) {
    console.warn("Weekend selected — blocked.");
    disableWeekends();

    // Remove highlight
    $(".datepicker .datepicker-cell.active").removeClass(
      "active bg-blue-500 text-white"
    );

    // ✅ Abort any shipping or calculation logic
    e.stopImmediatePropagation();
    e.preventDefault();
    return false;
  }

  // Update the selected date and render the shipping options
  $(".tusenrosor-datepicker").data("selected-date", date_fmt(selected));
  renderShippingOptions(selected, false);
});


$(document)
  .off('change', '.delivery-radio')
  .on('change', '.delivery-radio', function () {
    console.log('🟢 Radio changed');
    saveSelectedMethodData(true);
  });
// $(document).off('click', '.delivery-item').on('click', '.delivery-item', function (e) {
//  console.log('options change');
//   saveSelectedMethodData(true);
// });
// Step 3 — When country changes
$(document).on("change", "#billing_country, #shipping_country,#step1_billing_country", function () {
  country = $(this).val() || countryConfig;
  const dateStr = $(".tusenrosor-datepicker").data("selected-date");
  const selected = dateStr ? new Date(dateStr) : getSwedenAdjustedToday();
  renderShippingOptions(selected, false);
});


});
